/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   metric.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"

/********************************************************
* Function:	MetricChangePopupTriggerContent
* Purpose: 	This function is called to change the content
of the popup trigger
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void MetricChangePopupTriggerContent()
{
	ObjectID control_id;
	ObjectID count_id;
	
	ControlGetPushedPushButton(FORM_METRIC, 1, &control_id);
	ControlPopupDeleteAllItems(POPUP_TRIGGER_FIRST);
	ControlPopupDeleteAllItems(POPUP_TRIGGER_SECOND);
	
	switch(control_id)
	{
	case PUSHBUTTON_METRIC_LENGTH:
		for (count_id = POPUP_TRIGGER_FIRST; count_id<= POPUP_TRIGGER_SECOND; count_id++)
		{
			ControlPopupInsertItem(count_id, 0, CALSTR4);
			ControlPopupInsertItem(count_id, 1, CALSTR5);
			ControlPopupInsertItem(count_id, 2, CALSTR6);
			ControlPopupInsertItem(count_id, 3, CALSTR7);
			ControlPopupInsertItem(count_id, 4, CALSTR8);
			ControlPopupInsertItem(count_id, 5, CALSTR9);
			ControlPopupInsertItem(count_id, 6,	CALSTR10);
		}
		break;
	case PUSHBUTTON_METRIC_AREA:
		for (count_id = POPUP_TRIGGER_FIRST; count_id<= POPUP_TRIGGER_SECOND; count_id++)
		{
			ControlPopupInsertItem(count_id, 0, CALSTR11);
			ControlPopupInsertItem(count_id, 1, CALSTR12);
			ControlPopupInsertItem(count_id, 2, CALSTR13);
			ControlPopupInsertItem(count_id, 3, CALSTR14);
			ControlPopupInsertItem(count_id, 4, CALSTR15);
			ControlPopupInsertItem(count_id, 5, CALSTR16);
			ControlPopupInsertItem(count_id, 6, CALSTR17);
			ControlPopupInsertItem(count_id, 7, CALSTR18);
			ControlPopupInsertItem(count_id, 8, CALSTR19);
		}
		break;
	case PUSHBUTTON_METRIC_VOLUME:
		for (count_id = POPUP_TRIGGER_FIRST; count_id<= POPUP_TRIGGER_SECOND; count_id++)
		{
			ControlPopupInsertItem(count_id, 0, CALSTR20);
			ControlPopupInsertItem(count_id, 1, CALSTR21);
			ControlPopupInsertItem(count_id, 2, CALSTR22);
			ControlPopupInsertItem(count_id, 3, CALSTR23);
			ControlPopupInsertItem(count_id, 4, CALSTR24);
		}
		break;
	case PUSHBUTTON_METRIC_WEIGHT:
		for (count_id = POPUP_TRIGGER_FIRST; count_id<= POPUP_TRIGGER_SECOND; count_id++)
		{
			ControlPopupInsertItem(count_id, 0, CALSTR25);
			ControlPopupInsertItem(count_id, 1, CALSTR26);
			ControlPopupInsertItem(count_id, 2, CALSTR27);
			ControlPopupInsertItem(count_id, 3, CALSTR28);
			ControlPopupInsertItem(count_id, 4, CALSTR29);
			ControlPopupInsertItem(count_id, 5, CALSTR30);
			ControlPopupInsertItem(count_id, 6, CALSTR31);
		}
		break;
	case PUSHBUTTON_METRIC_CAPACITY:
		for (count_id = POPUP_TRIGGER_FIRST; count_id<= POPUP_TRIGGER_SECOND; count_id++)
		{
			ControlPopupInsertItem(count_id, 0, CALSTR32);
			ControlPopupInsertItem(count_id, 1, CALSTR33);
			ControlPopupInsertItem(count_id, 2, CALSTR34);
			ControlPopupInsertItem(count_id, 3, CALSTR35);
			ControlPopupInsertItem(count_id, 4, CALSTR36);
		}
		break;
	case PUSHBUTTON_METRIC_VELOCITY:
		for (count_id = POPUP_TRIGGER_FIRST; count_id<= POPUP_TRIGGER_SECOND; count_id++)
		{
			ControlPopupInsertItem(count_id, 1, CALSTR37);
			ControlPopupInsertItem(count_id, 2, CALSTR38);
			ControlPopupInsertItem(count_id, 3, CALSTR39);
		}
		break;
	case PUSHBUTTON_METRIC_TEMPERATURE:
		for (count_id = POPUP_TRIGGER_FIRST; count_id<= POPUP_TRIGGER_SECOND; count_id++)
		{
			ControlPopupInsertItem(count_id, 0, CALSTR40);
			ControlPopupInsertItem(count_id, 1, CALSTR41);
			ControlPopupInsertItem(count_id, 2, CALSTR42);
		}
		break;
	}
	ControlPopupSetSelectedItem(POPUP_TRIGGER_FIRST, 0);
	ControlPopupSetSelectedItem(POPUP_TRIGGER_SECOND, 1);
}

/********************************************************
* Function:	MetricSetConversionTable
* Purpose: 	This function is called to set up the conversion table
for each category of units
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void MetricSetConversionTable()
{
	Length[CM][CM]			=	1;
	Length[CM][FOOT]		=	0.0328083989501312335958005249343832;
	Length[CM][INCH]		=	0.393700787401574803149606299212598;
	Length[CM][KM]			=	1e-5;
    Length[CM][M]           =   1e-2;
	Length[CM][MILE]		=	6.21371192237333969617434184363318e-6;
	Length[CM][YARD]		=	0.0109361329833770778652668416447944;
	
	Length[FOOT][CM]		=	30.48;
	Length[FOOT][FOOT]		=	1;
	Length[FOOT][INCH]		=	12;
	Length[FOOT][KM]		=	0.0003048;
	Length[FOOT][M]			=	0.3048;
	Length[FOOT][MILE]		=	1.89393939393939393939393939393939e-4;
    Length[FOOT][YARD]      =   0.3333333333333333333333333333333;
	
	Length[INCH][CM]		=	2.54;
    Length[INCH][FOOT]      =   0.0833333333333333333333333333333333;
	Length[INCH][INCH]		=	1;
	Length[INCH][KM]		=	2.54e-05;
	Length[INCH][M]			=	0.0254;
	Length[INCH][MILE]		=	1.578282828282828282828282828e-05;
    Length[INCH][YARD]      =   0.02777777777777777777777777778;
	
	Length[KM][CM]			=	1e5;
	Length[KM][FOOT]		=	3280.83989501312335958005249343832;
	Length[KM][INCH]		=	39370.0787401574803149606299212598;
	Length[KM][KM]			=	1;
	Length[KM][M]			=	1000;
	Length[KM][MILE]		=	0.621118012422360248447204968944099;
	Length[KM][YARD]		=	1093.61329833770778652668416447944;
	
	Length[M][CM]			=	100;
	Length[M][FOOT]			=	3.28083989501312335958005249343832;
	Length[M][INCH]			=	39.3700787401574803149606299212598;
	Length[M][KM]			=	1e-3;
	Length[M][M]			=	1;
	Length[M][MILE]			=	6.21118012422360248447204968944099e-4;
	Length[M][YARD]			=	1.09361329833770778652668416447944;
	
	Length[MILE][CM]		=	160934.4;
	Length[MILE][FOOT]		=	5280;
	Length[MILE][INCH]		=	63360;
	Length[MILE][KM]		=	1.61;
	Length[MILE][M]			=	1610;
	Length[MILE][MILE]		=	1;
	Length[MILE][YARD]		=	1760;
	
	Length[YARD][CM]		=	91.44;
	Length[YARD][FOOT]		=	3;
	Length[YARD][INCH]		=	36;
	Length[YARD][KM]		=	0.0009144;
	Length[YARD][M]			=	0.9144;
    Length[YARD][MILE]      =   5.68181818181818181818181818181818e-4;
	Length[YARD][YARD]		=	1;
	
	Area[ACRES][ACRES]		=	1;
	Area[ACRES][CM2]		=	40468730;
	Area[ACRES][FOOT2]		=	43560;
	Area[ACRES][INCH2]		=	6272665.7;
	Area[ACRES][HA]			=	0.404687298731301271604383200507543;
	Area[ACRES][KM2]		=	0.004046873;
	Area[ACRES][M2]			=	4046.873;
	Area[ACRES][MILE2]		=	0.0015625;
	Area[ACRES][YARD2]		=	4840.0196;
	
	Area[CM2][ACRES]		=	2.47104369225325331434912832698234e-8;
	Area[CM2][CM2]			=	1;
	Area[CM2][FOOT2]		=	0.00107639104167097223083335055556486;
	Area[CM2][INCH2]		=	0.155000310000620001240002480004489;
	Area[CM2][HA]			=	1e-08;
	Area[CM2][KM2]			=	1e-10;
	Area[CM2][M2]			=	1e-4;
	Area[CM2][MILE2]		=	3.8610215854244584726288113937311e-11;
	Area[CM2][YARD2]		=	1.19599004630108025648150061714847e-4;
	
	Area[FOOT2][ACRES]		=	2.29568411386593204775022956841139e-5;
	Area[FOOT2][CM2]		=	929.0304;
	Area[FOOT2][FOOT2]		=	1;
	Area[FOOT2][INCH2]		=	144;
	Area[FOOT2][HA]			=	9.29030435966112685817700073672114e-6;
	Area[FOOT2][KM2]		=	0.00000009290304;
	Area[FOOT2][M2]			=	0.09290304;
	Area[FOOT2][MILE2]		=	0.0000000358700645087236;
    Area[FOOT2][YARD2]      =   0.11111111111111111111111111111111111111;
	
	Area[INCH2][ACRES]		=	1.59421854730756654224375451731789e-7;
	Area[INCH2][CM2]		=	6.4516;
	Area[INCH2][FOOT2]		=	0.00694444444444444444444444444444;
	Area[INCH2][INCH2]		=	1;
	Area[INCH2][HA]			=	6.4516000000258064000001032256e-8;
	Area[INCH2][KM2]		=	6.4516000000258064000001032256e-10;
	Area[INCH2][M2]			=	0.00064516000000258064000001032256;
	Area[INCH2][MILE2]		=	2.4909768101517468199069102038232e-10;
	Area[INCH2][YARD2]		=	7.71604938271604938271604938271605e-4;
	
	Area[HA][ACRES]			=	2.4710437;
	Area[HA][CM2]			=	1e8;
	Area[HA][FOOT2]			=	107639.1;
	Area[HA][INCH2]			=	15500031;
	Area[HA][HA]			=	1;
	Area[HA][KM2]			=	0.01;
	Area[HA][M2]			=	10000;
	Area[HA][MILE2]			=	0.00386100386100386100386100386100386;
	Area[HA][YARD2]			=	11959.9;
	
	Area[KM2][ACRES]		=	247.10437;
	Area[KM2][CM2]			=	1e+10;
	Area[KM2][FOOT2]		=	10763910;
	Area[KM2][INCH2]		=	1.5500031e+09;
	Area[KM2][HA]			=	100;
	Area[KM2][KM2]			=	1;
	Area[KM2][M2]			=	1000000;
	Area[KM2][MILE2]		=	2.59;
	Area[KM2][YARD2]		=	1.195989e6;
	
	Area[M2][ACRES]			=	247.10437e-6;
	Area[M2][CM2]			=	1e+4;
	Area[M2][FOOT2]			=	10763910e-6;
	Area[M2][INCH2]			=	1.5500031e+3;
	Area[M2][HA]			=	100e-6;
	Area[M2][KM2]			=	1e-6;
	Area[M2][M2]			=	1000000e-6;
	Area[M2][MILE2]			=	2.59e-6;
	Area[M2][YARD2]			=	1.195989;
	
	Area[MILE2][ACRES]		=	640;
	Area[MILE2][CM2]		=	2.589988e+10;
	Area[MILE2][FOOT2]		=	27878399;
	Area[MILE2][INCH2]		=	4.0144894e+9;
	Area[MILE2][HA]			=	259;
	Area[MILE2][KM2]		=	2.59;
	Area[MILE2][M2]			=	2.589988e+6;
	Area[MILE2][MILE2]		=	1;
	Area[MILE2][YARD2]		=	3097600;
	
	Area[YARD2][ACRES]		=	2.06610733559839303130094762426169e-4;
	Area[YARD2][CM2]		=	8361.274;
	Area[YARD2][FOOT2]		=	9;
	Area[YARD2][INCH2]		=	1296;
	Area[YARD2][HA]			=	8.36127392369501417235930066304902e-5;
	Area[YARD2][KM2]		=	8.36128091479102232545617058350871e-7;
	Area[YARD2][M2]			=	0.836128091479102232545617058350871;
	Area[YARD2][MILE2]		=	3.22830578512396694214876033057851e-7;
	Area[YARD2][YARD2]		=	1;
	
	Volume[CM3][CM3]		=	1;
	Volume[CM3][FOOT3]		=	3.53146667214885902504380103540026e-5;
	Volume[CM3][INCH3]		=	0.0610237440947322839527568818914383;
	Volume[CM3][M3]			=	1e-06;
	Volume[CM3][YARD3]		=   1.30795061931439223149770408690025e-6;
	
	Volume[FOOT3][CM3]		=	28316.846592;
	Volume[FOOT3][FOOT3]	=	1;
	Volume[FOOT3][INCH3]	=	1728;
	Volume[FOOT3][M3]		=	0.02831685;
	Volume[FOOT3][YARD3]	=   0.037037039;
	
	Volume[INCH3][CM3]		=	16.3870640000000000000000000000747;
	Volume[INCH3][FOOT3]	=	0.0005787037037037037037037037037037037;
	Volume[INCH3][INCH3]	=	1;
	Volume[INCH3][M3]		=	0.000016387064;
	Volume[INCH3][YARD3]	=   2.14334705075445816186556927297668e-5;
	
	Volume[M3][CM3]			=	1000000;
	Volume[M3][FOOT3]		=	35.3146667214885902504380103539923;
	Volume[M3][INCH3]		=	61023.7440947322839527568818917165;
	Volume[M3][M3]			=	1;
	Volume[M3][YARD3]		=   1.093613298337707786526684164479;
	
	Volume[YARD3][CM3]		=	764554.857984000000000000000166612;
	Volume[YARD3][FOOT3]	=	27;
	Volume[YARD3][INCH3]	=	46656;
	Volume[YARD3][M3]		=	0.764554857984;
	Volume[YARD3][YARD3]	=   1;
	
	Capacity[FlOZ] 			= 0.0375;
	Capacity[GALLON] 		= 4.55;
	Capacity[GILLS] 		= 0.15;
	Capacity[LITRE] 		= 1;
	Capacity[PINT] 			= 0.57;
	
	Weight[G][G]			=	1;
	Weight[G][GRAIN]		=	15.625;
	Weight[G][KG]			=	1e-3;
	Weight[G][LB]			=	0.00222222222222222222222222222222222;
	Weight[G][OZ]			=	0.0352739658378695653400833594360681;
	Weight[G][STONE]		=	1.57480314960629921259842519685039e-4;
	Weight[G][TONNE]		=	1.10231099500101963767037594316485e-6;	
	
	Weight[GRAIN][G]		=	0.064;
	Weight[GRAIN][GRAIN]	=	1;
	Weight[GRAIN][KG]		=	6.4e-5;
	Weight[GRAIN][LB]		=	1.42222222222222222222222222222222e-4;
	Weight[GRAIN][OZ]		=	0.00225753381362365218176533500390836;
	Weight[GRAIN][STONE]	=	1.00787401574803149606299212598425e-5;
    Weight[GRAIN][TONNE]    =   6.471111111111111111111111111e-8; 
	
	Weight[KG][G]			=	1000;
	Weight[KG][GRAIN]		=	15625;
	Weight[KG][KG]			=	1;
	Weight[KG][LB]			=	2.22222222222222222222222222222222;
	Weight[KG][OZ]			=	35.273369;
	Weight[KG][STONE]		=	0.157480314960629921259842519685039;
	Weight[KG][TONNE]		=	0.00110231099500101963767037594316485;	
	
	Weight[LB][G]			=	450;
	Weight[LB][GRAIN]		=	7031.25;
	Weight[LB][KG]			=	0.45;
	Weight[LB][LB]			=	1;
	Weight[LB][OZ]			=	16;
	Weight[LB][STONE]		=	0.0714285714285714285714285714285714;
	Weight[LB][TONNE]		=	0.00049603994775045883695166917442423;	
	
	Weight[OZ][G]			=	28.34952;
	Weight[OZ][GRAIN]		=	442.96125;
	Weight[OZ][KG]			=	0.0283499996838975035245428357013474;
	Weight[OZ][LB]			=	0.0625;
	Weight[OZ][OZ]			=	1;
	Weight[OZ][STONE]		=	0.00446428571428571428571428571428571;
	Weight[OZ][TONNE]		=	3.124999888888888888e-05;	
	
	Weight[STONE][G]			=	6350;
	Weight[STONE][GRAIN]		=	99218.75;
	Weight[STONE][KG]			=	6.35;
	Weight[STONE][LB]			=	14;
	Weight[STONE][OZ]			=	224;
	Weight[STONE][STONE]		=	1;
	Weight[STONE][TONNE]		=	0.00699967481825647469920688723909852;	
	
	Weight[TONNE][G]			=	907185;
	Weight[TONNE][GRAIN]		=	15453296.7;
	Weight[TONNE][KG]			=	907.185;
	Weight[TONNE][LB]			=	2015.96666666666666666666666666647;
	Weight[TONNE][OZ]			=	32000.0011377778182412024266774986;
	Weight[TONNE][STONE]		=	142.863779527559055118110236222447;
	Weight[TONNE][TONNE]		=	1;	
	
	Velocity[0]					=   1;
	Velocity[1]					=   1.85;
	Velocity[2]					=	1.61;
}

/********************************************************
* Function:	MetricConversion
* Purpose: 	This function is called in order to convert the
the values in a textbox (with flashing insertion pt)
to values and displaying in other textbox
* Scope:		application/internal
* Input:		source_id		textbox id of the input value
result_id		textbox id of the result
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
BOOLEAN MetricConversion(ObjectID source_id, ObjectID result_id)
{
	BYTE 			object_type;
	Textbox 		*textbox_ptr, *textbox_ptr1;
    double 			source = 0, result = 0, temp = 0;
	ObjectID 		pushbutton;
	SHORT 			first_selected_item, second_selected_item;
	BYTE 			*result_text, *temp_text, *source_text, *add_zero;
	WORD 			i, j;
	BOOLEAN 		found_decimal = FALSE;
    double 			max_range = 999999999999.0, min_range = -99999999999.0;
    ObjectID 		active_form;
	
	FormGetObjectPointer(source_id, &object_type, (void**)&textbox_ptr);
	FormGetObjectPointer(result_id, &object_type, (void**)&textbox_ptr1);
	
	ControlGetPushedPushButton(FORM_METRIC, 1, &pushbutton);
	
    if (source_id == TEXTBOX_METRIC_0)	
	{
		ControlPopupGetSelectedItem(POPUP_TRIGGER_FIRST, &first_selected_item);
		ControlPopupGetSelectedItem(POPUP_TRIGGER_SECOND, &second_selected_item);
	}
	else
	{	
		ControlPopupGetSelectedItem(POPUP_TRIGGER_SECOND, &first_selected_item);
		ControlPopupGetSelectedItem(POPUP_TRIGGER_FIRST, &second_selected_item);
	}
	
	
    if (textbox_ptr->textbox_string[0] == '-' && pushbutton == PUSHBUTTON_METRIC_TEMPERATURE && first_selected_item == 2)
    {
        TextboxSetInsertPointOn(source_id);
        TextboxSetInsertPointPositionByCharPos(source_id, 0);
        TextboxSetInsertPointOff(result_id);
        TextboxSetText(source_id, (BYTE*)(""));
        TextboxSetText(result_id, (BYTE*)(""));
        textbox_ptr->textbox_attr.textbox_highlight = FALSE;
        textbox_ptr1->textbox_attr.textbox_highlight = FALSE;
        textbox_ptr->textbox_highlight_length = 0;
        textbox_ptr1->textbox_highlight_length = 0;
    }        
	
	
	if (strlen(textbox_ptr->textbox_string) == 1 && textbox_ptr->textbox_string[0] == '-')
		TextboxSetText(result_id, (BYTE*)(""));
	else if (strlen(textbox_ptr->textbox_string) == 0)
		TextboxSetText(result_id, (BYTE*)(""));
	else 
	{
		source = atod((char*)(textbox_ptr->textbox_string));
		//		ControlGetPushedPushButton(FORM_METRIC, 1, &pushbutton);
		/*	    if (source_id == TEXTBOX_METRIC_0)	
		{
		ControlPopupGetSelectedItem(POPUP_TRIGGER_FIRST, &first_selected_item);
		ControlPopupGetSelectedItem(POPUP_TRIGGER_SECOND, &second_selected_item);
		}
		else
		{	
		ControlPopupGetSelectedItem(POPUP_TRIGGER_SECOND, &first_selected_item);
		ControlPopupGetSelectedItem(POPUP_TRIGGER_FIRST, &second_selected_item);
		}
		*/		
		
		switch (pushbutton)
		{
		case PUSHBUTTON_METRIC_LENGTH:
			//temp = source * Length[first_selected_item];
			//result = temp / Length[second_selected_item];
			result = source * Length[first_selected_item][second_selected_item];
			break;
		case PUSHBUTTON_METRIC_AREA:
			//temp = source * Area[first_selected_item];
			//result = temp / Area[second_selected_item];
			result = source * Area[first_selected_item][second_selected_item];
			break;
		case PUSHBUTTON_METRIC_VOLUME:
			//temp = source * Volume[first_selected_item];
			//result = temp / Volume[second_selected_item];
			result = source * Volume[first_selected_item][second_selected_item];
			break;
		case PUSHBUTTON_METRIC_WEIGHT:
			//temp = source * Weight[first_selected_item];
			//result = temp / Weight[second_selected_item];
			result = source * Weight[first_selected_item][second_selected_item];
			break;
		case PUSHBUTTON_METRIC_CAPACITY:
			temp = source * Capacity[first_selected_item];
			result = temp / Capacity[second_selected_item];
			break;
		case PUSHBUTTON_METRIC_VELOCITY:
			temp = source * Velocity[first_selected_item];
			result = temp / Velocity[second_selected_item];
			break;
		case PUSHBUTTON_METRIC_TEMPERATURE:
			if (first_selected_item == 0)
			{
				if (second_selected_item == 0)
					result = source;
				else if (second_selected_item == 1)
					result = (source * (double)9/(double)5) + (double)32;
				else if (second_selected_item == 2)
					result = source + 273;
			}
			else if (first_selected_item == 1)
			{
				if (second_selected_item == 1)
				{
					result = source;
					break;
				}
				//					if (second_selected_item == 0)
				result = ((double)5/(double)9) * (source  - (double)32);
				if (second_selected_item == 2)
					result += (double)273;
			}
			else
			{
				if (second_selected_item == 2)
				{
					result = source;
					break;
				}
				result = source - 273;
				if (second_selected_item == 1)
					result = (result * (double)9/(double)5) + (double)32;                                    
			}									
			break;
		default: break;
		}
		
		/* OVERFLOW */
        if (result > max_range || result < min_range ||
            (pushbutton == PUSHBUTTON_METRIC_TEMPERATURE && second_selected_item == 2 && result < 0))
		{
			enter_form_id = FORM_METRIC;
            FormGetActiveFormID(&active_form);
            if (active_form != FORM_METRIC_OVERFLOW)
            {
                FormInitAllFormObjects(FORM_METRIC_OVERFLOW);
                FormPopupForm(FORM_METRIC_OVERFLOW);
            }
            return FALSE;
		}
		
		temp_text = (BYTE*)qmalloc(100*sizeof(BYTE));
		dtoa(result, (char*)(temp_text), 20);
		//        if (result < 0)
		//			CalculatorChopDisplay(temp_text, 11, &result_text);
		/*else*/ CalculatorChopDisplay(temp_text, 12, &result_text);
		//------------ remove all unwanted zeros -------------
		j = 0;
		while (result_text[j] != 0)
		{
			if (result_text[j] == '.')
			{
				found_decimal = TRUE;
				break;
			}
			j++;
		}
		
		
		if (found_decimal == TRUE)
		{
			i = strlen(result_text) - 1;
			while (result_text[i] == '0' && i >= 0)
			{
				result_text[i] = '\0';
				i--;
			}
		}
		MetricAddZeroBehindDecimal(result_text, 2, 12, &add_zero);
		TextboxSetText(result_id, add_zero);
		qfree(add_zero);
		qfree(temp_text); 
		qfree(result_text);
		
		temp_text = (BYTE*)qmalloc(100*sizeof(BYTE));
		//		dtoa(source, (char*)(temp_text), 20);
		strcpy(temp_text, textbox_ptr->textbox_string);
		CalculatorChopDisplay(temp_text, 12, &source_text);
		//------------ remove all unwanted zeros -------------
		/*		i = strlen(source_text) - 1;
		while (source_text[i] == '0' && i >= 0)
		{
		source_text[i] = '\0';
		i--;
		}*/
		//		if (strlen(source_text) == 0)
		//			strcpy(source_text, (BYTE*)("0"));
		//		MetricAddZeroBehindDecimal(source_text, 2, 12, &add_zero);
		//		TextboxSetText(source_id, addr_zero);
		TextboxSetText(source_id, source_text);
		//		qfree(add_zero);
		qfree(temp_text); 
		qfree(source_text);
		
	}	
	//	TextboxSetInsertPointOff(TEXTBOX_METRIC_0);
	//	TextboxSetInsertPointOff(TEXTBOX_METRIC_1);
	TextboxDrawTextbox(TEXTBOX_METRIC_0);
	TextboxDrawTextbox(TEXTBOX_METRIC_1);
    return TRUE;
}

/********************************************************
* Function:	MetricExchangeSetKeypadPos
* Purpose: 	This function is called to set the position of the keypad
when the keypad is in FORM_METRIC and FORM_EXCHANGE
* Scope:		application/internal
* Input:		active_form_id		The current active form
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void MetricExchangeSetKeypadPos(ObjectID active_form_id)
{
	Bitmap				*ptr;
	Control				*control_ptr;
	String				*string_ptr;
	Textbox				*textbox_ptr;
	BYTE				object_type;
	ObjectID			i;
	
	switch(active_form_id)
	{
	case FORM_METRIC:
		for (i = BITMAP_METRIC_BACKGROUND; i <= BITMAP_METRIC_ENTER; i++)
			BitmapInitBitmap(i);
		break;
	case FORM_LOAN:
		for (i = BITMAP_METRIC_BACKGROUND; i <= BITMAP_METRIC_ENTER; i++)
			BitmapInitBitmap(i);
		FormGetObjectPointer(BITMAP_METRIC_BACKGROUND, &object_type, (void**)&ptr); 
		ptr->bounds.ycoord -= 26;
		for (i = BITMAP_METRIC_LEFT; i <= BITMAP_METRIC_ENTER; i++)
		{
			FormGetObjectPointer(i, &object_type, (void**)&ptr);
			ptr->bounds.ycoord -= 26;
		}
		break;
	case FORM_EXCHANGE:
		for (i = BITMAP_METRIC_BACKGROUND; i <= BITMAP_METRIC_ENTER; i++)
			BitmapInitBitmap(i);		
		FormGetObjectPointer(BITMAP_METRIC_BACKGROUND, &object_type, (void**)&ptr);
		if (ptr->bounds.ycoord == 19)
			return;
		ptr->bounds.ycoord -= 26;
		for (i = BITMAP_METRIC_LEFT; i <= BITMAP_METRIC_ENTER; i++)
		{
			FormGetObjectPointer(i, &object_type, (void**)&ptr);
			ptr->bounds.ycoord -= 26;
		}
		break;
	default: break;
	}
}

/********************************************************
* Function:	MetricAddZeroBehindDecimal
* Purpose: 	Thsi function is called to add two zeros after 
the decimal point if the decimal is the rightmost character
* Scope:		application/internal
* Input:		input_string
num_of_zeros
* Output:		output_string
* Return:		None
* Comment: 	None
*********************************************************/
void MetricAddZeroBehindDecimal(BYTE *input_string, USHORT num_of_zeros, USHORT total_num_chars, BYTE **output_string)
{
	WORD length_of_input, i, num_of_zeros_needed;
	WORD decimal_place, j, k;
	BYTE found = 0;
	
	length_of_input = strlen(input_string);
	*output_string = (BYTE*)qmalloc(50*sizeof(BYTE));
	
	for (i = strlen(input_string) - 1; i >= 0; i--)
	{
		if (input_string[i] == '.')
		{
			found = 1;
			break;
		}
	}
	if (found == 0)
	{
		if (length_of_input < total_num_chars)
		{
			input_string[length_of_input] = '.';
			input_string[length_of_input + 1] = 0;
			length_of_input ++;
		}
	}
	
	strcpy(*output_string, input_string);
	num_of_zeros_needed = num_of_zeros;
	if (num_of_zeros > (total_num_chars - length_of_input))
		num_of_zeros = total_num_chars - length_of_input;
	
	if (num_of_zeros == 0)
		return;
	
	for (i = strlen(input_string) - 1; i >= 0; i--)
	{
		if (input_string[i] == '.')
		{
			if ((strlen(input_string) - 1 - i) >= num_of_zeros)
				return;
			else
			{
				num_of_zeros_needed = num_of_zeros - (strlen(input_string) - 1 - i);
				break;
			}
		}
	}
	
	
	//	if (input_string[length_of_input - 1] != '.')
	//		return;
	
	
	
	
	
	strcpy(*output_string, input_string);
	for (i = length_of_input; i < (length_of_input + num_of_zeros_needed); i++)
		(*output_string)[i] = '0';
	(*output_string)[length_of_input + num_of_zeros_needed] = '\0';
}
