/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   aplaunch.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"
#include "appfunc.h"

//#define DEBUG
//#define DEBUG_TT

BOOLEAN     false_restore   	= FALSE;
BOOLEAN 	entry_low_memory 	= FALSE;
BOOLEAN     entry_old_edit      = FALSE;
ObjectID	low_memory_form_id	= 0;
WORD        launch_cmd          = LAUNCH_CMD_NORMAL_LAUNCH;

extern 		BOOLEAN     draw_scrollbar;
extern      DatabaseID pb_dbid;
extern      DatabaseID email_dbid;
extern      DatabaseID emess_dbid;
extern      DatabaseID sys_dbid;


/********************************************************
* Function:	EmailAppLaunch
* Purpose: 	This function is called to launch the 
Email application
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailAppLaunch(WORD cmd, void *cmd_ptr)
{
	
	UWORD num_rec, count;
	UWORD byte_read;
	USHORT field_num;
	RecordID rec_id;
	BYTE *buffer;
    BYTE *prepare_string, *email1, *email2; 
    
	if (cmd == LAUNCH_CMD_GOTO_REC && DataRecordInfo(((GotoRec*)cmd_ptr)->dbid, ((GotoRec*)cmd_ptr)->rec_id, NULL, NULL, NULL, NULL, NULL) != TRUE)
	{
		if (((GotoRec*)cmd_ptr)->find_string != NULL)
			pfree(((GotoRec*)cmd_ptr)->find_string);
		pfree(cmd_ptr); 
		cmd = LAUNCH_CMD_NORMAL_LAUNCH;
	}		
	
	switch(cmd)
	{
	case LAUNCH_CMD_NORMAL_LAUNCH:
		UIApplicationInit();
		EmailAppRestore(FALSE);
		EventLoop();
		if (entry_low_memory == FALSE || (entry_low_memory == TRUE && entry_old_edit == FALSE))
			EmailAppSave();
		UIDeleteAllAppObjects();
		DataCloseDB(sys_dbid);
		DataCloseDB(pb_dbid);
		DataCloseDB(email_dbid);
		DataCloseDB(emess_dbid);
		return TRUE;
	case LAUNCH_CMD_FIND:
		app_id = SysGetActiveAppID();
		EmailDatabaseChecking();
		
		/* email_dbid */
		DataTotalRecord(email_dbid, &num_rec);
		for (count = 0; count < num_rec; count++)
		{
			DataOpenRecord(email_dbid, count, &rec_id, NULL);
			for (field_num = 0; field_num < 4; field_num++)
			{
				DataGetField(email_dbid, rec_id, field_num, &buffer, &byte_read);
				if (GlobalFindSearchText((BYTE*)cmd_ptr, buffer) >= 0)
				{
					EmailPrepareFindText(email_dbid, rec_id, &prepare_string);
#ifdef PR31700
					GlobalFindAddItem(app_id, email_dbid, rec_id, field_num, prepare_string, FALSE);
#endif
					qfree(buffer);
					pfree(prepare_string);
					break;
				}
				qfree(buffer);
			}
			DataCloseRecord(email_dbid, rec_id);
		}
		
		DataTotalRecord(emess_dbid, &num_rec);
		for (count = 0; count < num_rec; count++)
		{
			DataOpenRecord(emess_dbid, count, &rec_id, NULL);
			for (field_num = 2; field_num < 8; field_num++)
			{
				DataGetField(emess_dbid, rec_id, field_num, &buffer, &byte_read);
				if (GlobalFindSearchText((BYTE*)cmd_ptr, buffer) >= 0)
				{
					EmailPrepareFindText(emess_dbid, rec_id, &prepare_string);
#ifdef PR31700                 
					GlobalFindAddItem(app_id, emess_dbid, rec_id, field_num, prepare_string, FALSE);
#endif
					qfree(buffer);
					pfree(prepare_string);
					break;
				}
				qfree(buffer);
			}
			DataCloseRecord(emess_dbid, rec_id);
		}
		pfree(cmd_ptr);
		return TRUE;
	case LAUNCH_CMD_GOTO_REC:
		
		EmailGotoItem(((GotoRec*)cmd_ptr)->dbid, ((GotoRec*)cmd_ptr)->rec_id,
			((GotoRec*)cmd_ptr)->field_num, ((GotoRec*)cmd_ptr)->find_string);
		if (((GotoRec*)cmd_ptr)->find_string != NULL)
			pfree(((GotoRec*)cmd_ptr)->find_string);
		pfree(cmd_ptr);
		
		EventLoop();
		
		if ((entry_low_memory == FALSE || (entry_low_memory == TRUE && entry_old_edit == FALSE)) &&
			(gf_entry == FALSE || (gf_entry && entry_old_edit == FALSE)))
			EmailAppSave();
		UIDeleteAllAppObjects();
		return TRUE;
	case LAUNCH_CMD_ALARM_HIT:
		pfree(cmd_ptr);
		DataCloseDB(sys_dbid);
		DataCloseDB(pb_dbid);
		DataCloseDB(email_dbid);
		DataCloseDB(emess_dbid);
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}


/********************************************************
* Function:	EmailGotoItem
* Purpose: 	This function is called to init all related variables
and goto the specific form to display the required 
record
* Scope:		application/internal
* Input:		dbid
rec_id
field_num
search_string
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EmailGotoItem(DatabaseID dbid, RecordID rec_id, USHORT field_num, BYTE *search_string)
{
    BYTE            *buffer, object_type, *buffer1, buffer2[200];
	UWORD			byte_read, rec_num ,count;
	UBYTE			cat;
	Attribute		secret;
	USHORT			item_num;
	Control			*control_ptr;
	DatabaseID		list_dbid;
	RecordID		list_rec_id;
	EvtType			evt;
	WORD			highlight_char_pos, line_num, total_num_lines, num_lines, max_num_lines;
	BOOLEAN			found;
    Field           *field_ptr, *addr, *addr1, *addr2;
	Scrollbar		*scroll_ptr;
    Textbox         *textbox_ptr;
    BYTE            application_status;
    
	
    gf_entry = TRUE;
	EmailDatabaseChecking();
	
    DataGetField(emess_dbid, EMAIL_STATUS, 4, &buffer, &byte_read);
    font_size = *buffer;
    qfree(buffer);
	
	DataRecIDtoNum(dbid, rec_id, &rec_num);
	DataOpenRecord(dbid, rec_num, &rec_id, NULL);
	
	pressed_object = 0;
	name_list_in_action = 0;
	edit_cate_in_action = 0;
	new_name_in_action = 0;
	dial_in_action = 0;
	rf_action = 0;
	edit_table_font_size = SMALL_FONT;
	mail_list_table_font_size = SMALL_FONT;
	
    temp_from = (BYTE*)qmalloc(sizeof(BYTE));
    strcpy(temp_from, (BYTE*)(""));
    temp_to = (BYTE*)qmalloc(sizeof(BYTE));
    strcpy(temp_to, (BYTE*)(""));
    temp_cc = (BYTE*)qmalloc(sizeof(BYTE));
    strcpy(temp_cc, (BYTE*)(""));
    temp_bcc = (BYTE*)qmalloc(sizeof(BYTE));
    strcpy(temp_bcc, (BYTE*)(""));
	
	char_start = 'A';
	char_start_email_box = 'A';
	save_first_letter = 'A';
	current_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
	current_email_box = (BYTE*)qmalloc(30*sizeof(BYTE));
	temp_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
	SetVEEmailNameStatus(VIEW, FALSE, FALSE, 0, 0, FALSE);
	SetEmailMessTop(0,FALSE);
    SetEditEntryStatus(VIEW, 0, 0, FALSE); 
	SetMailListEntryStatus(VIEW, 0, 0, FALSE);
	SetDelEntryStatus(0,0);
	SetMailListInsertPt(FALSE, 0, 0);
	SetDialInsertPt(FALSE, 0, 0);
	
	list_email_name.list_id = LIST_NAME;
	list_find.list_id = LIST_FIND_RESULT_NAME;
	list_email_mess.list_id = LIST_EMAIL_MESS_NAME;
	list_email_name.record_id_block = list_find.record_id_block = list_email_mess.record_id_block = 0;
	list_email_name.num_items_display = list_find.num_items_display = list_email_mess.num_items_display = 0;
	list_email_name.total_num_items = list_find.total_num_items = list_email_mess.total_num_items = 0;
	list_email_name.record_id_block = list_find.record_id_block = list_email_mess.record_id_block = 0;
	
    FormInitAllFormObjects(FORM_EMAIL_NAME_LIST);
	FormInitAllFormObjects(FORM_EMAIL_MESS_LIST);
	FormInitAllFormObjects(FORM_VE_EMAIL_NAME);
	FormInitAllFormObjects(FORM_MAIL_LIST);
	FormInitAllFormObjects(FORM_EDIT);
	
    if (MemoryLow)
		entry_low_memory = TRUE;
    else entry_low_memory = FALSE;
	
    DataGetField(emess_dbid, EMAIL_STATUS, 0, &buffer, &byte_read);
    application_status  = *buffer;
    qfree(buffer);
	
	if (application_status != RESTART)
	{
		DataGetField(emess_dbid, EMAIL_MESS_EDIT, 5, &buffer, &byte_read);
		edit_entry_status = *(EditEntryStatus*)buffer;
		qfree(buffer);
		
		DataGetField(emess_dbid, EMAIL_NAME_EDIT, 6, &buffer, &byte_read);
		ve_email_name_status = *(VEEmailNameStatus*)buffer;
		qfree(buffer);
		
		DataGetField(emess_dbid, EMAIL_MESS_TO, 3, &buffer, &byte_read);
		mail_list_entry_status = *(MailListEntryStatus*)buffer;
		qfree(buffer);
    }
    
    if (application_status == EDIT_EMAIL_MESS)   
    {
        if (edit_entry_status.status == EDIT)
            entry_old_edit = TRUE;
        else entry_old_edit = FALSE;
    }                    
    else if (application_status == EDIT_EMAIL_TO)
    {
        if (mail_list_entry_status.status == EDIT)
            entry_old_edit = TRUE;
        else entry_old_edit = FALSE;
    }
    else if (application_status == EDIT_EMAIL_NAME)    
    {
        if (ve_email_name_status.status == EDIT)
            entry_old_edit = TRUE;
        else entry_old_edit = FALSE;    
    }        
	else entry_old_edit = FALSE;    	
	
	
	if (dbid == pb_dbid || dbid == email_dbid)
	{
		strcpy(current_email_box, EMINBOX);
        DataRecordInfo(dbid, rec_id, NULL, &cat, &secret, NULL, NULL);
		if (dbid == pb_dbid)
		{
			DataGetField(dbid, rec_id, 26, &buffer, &byte_read);
			cat = *(UBYTE*)buffer;
			qfree(buffer);
		}
		DataCategoryName(dbid, cat, current_cate);
		strcpy(temp_cate, current_cate);
		DataGetField(dbid, rec_id, 2, &buffer, &byte_read);
		char_start = buffer[0];
		qfree(buffer);
		name_list_in_action = ADDRESS_LIST;
		SetVEEmailNameStatus(VIEW, FALSE, FALSE, rec_id, dbid, FALSE);
		
		DataGetField(dbid, rec_id, 0, &buffer, &byte_read);
		TextboxSetText(TEXTBOX_FIRST_NAME, buffer);
        DataGetField(dbid, rec_id, 1, &buffer1, &byte_read);
        TextboxSetText(TEXTBOX_LAST_NAME, buffer1);
        PhonebookPrepareFirstLastName(buffer, buffer1, buffer2);
        StringSetText(STRING_VE_NAME, buffer2);
        qfree(buffer); qfree(buffer1);
		
		
		if (dbid == pb_dbid)
		{
			DataGetField(dbid, rec_id, 8, &buffer, &byte_read);
			FieldSetText(FIELD_C_EMAIL, buffer);
			qfree(buffer);
			DataGetField(dbid, rec_id, 22, &buffer, &byte_read);
			FieldSetText(FIELD_H_EMAIL, buffer);
			qfree(buffer);
			if (secret == ATTR_SET)
			{
				FormGetObjectPointer(CHECKBOX_VE_C, &object_type, (void**)&control_ptr);
				((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = TRUE;
				FormGetObjectPointer(CHECKBOX_VE_H, &object_type, (void**)&control_ptr);
				((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = FALSE;
			}
			else
			{
				FormGetObjectPointer(CHECKBOX_VE_C, &object_type, (void**)&control_ptr);
				((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = FALSE;
				FormGetObjectPointer(CHECKBOX_VE_H, &object_type, (void**)&control_ptr);
				((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = TRUE;
			}			
		}
		else if (dbid == email_dbid)
		{
			DataGetField(dbid, rec_id, 3, &buffer, &byte_read);
			FieldSetText(FIELD_C_EMAIL, buffer);
            if (field_num == 3)
            {
                FormGetObjectPointer(FIELD_C_EMAIL, &object_type, (void**)&field_ptr);
                field_ptr->field_highlight_start_char = GlobalFindSearchText(search_string, buffer);
                field_ptr->field_highlight_length = strlen(search_string);
                if (field_ptr->field_highlight_length > 0)
                {
                    FormSetFormActiveObject(FORM_VE_EMAIL_NAME, FIELD_C_EMAIL);
                    field_ptr->field_attr.field_highlight = TRUE;
                }
                else field_ptr->field_attr.field_highlight = FALSE;
            }
			
			qfree(buffer);
		}
		EmailCateNameToPopupTrigger(email_dbid);
		ControlPopupDeleteItem(POPUP_TRIGGER_CATE, 0);
		if (dbid == email_dbid)
		{
			if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate,
				&item_num) == TRUE) 
				ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
			else
				ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
		}
		else if (dbid == pb_dbid)
		{
			if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate,
				&item_num) == TRUE) 
				ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
			else
				ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
		}
		StringSetText(STRING_CATE, current_cate);
		save_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
		strcpy (save_cate, current_cate);
		EmailSetupViewEditEmailNameScreen();
		EmailCateNameToPopupTriggerEmailBox();
		if (ControlPopupFindItemNum(POPUP_TRIGGER_EMAIL_BOX, current_email_box,
			&item_num) == TRUE) 
			ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, (SHORT)item_num);
		else
			ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, 0);
		draw_scrollbar = FALSE;
		EmailRecordToList(current_cate, char_start,NULL);
		draw_scrollbar = TRUE;		
		FormPopupForm(FORM_VE_EMAIL_NAME);
	}
	else
	{
		DataRecordInfo(dbid, rec_id, NULL, &cat, &secret, NULL, NULL);
		DataCategoryName(dbid, cat, current_email_box);
		strcpy(current_cate, EMUNFILED);
		strcpy(temp_cate, current_cate);
		EmailCateNameToPopupTriggerEmailBox();
		if (ControlPopupFindItemNum(POPUP_TRIGGER_EMAIL_BOX, current_email_box,
			&item_num) == TRUE) 
			ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, (SHORT)item_num);
		else
			ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, 0);
		
        draw_scrollbar = FALSE;
		EmailRecordToList(current_cate, char_start, NULL);
		EmailRecordToEmailMessageList(current_email_box, 'A');
		draw_scrollbar = TRUE;		
		
		for (count = 0;	count < list_email_mess.total_num_items; count++)
		{
			ListDisplayGetRecordID(&list_email_mess, (USHORT)count, &list_rec_id, &list_dbid);
			if (list_rec_id == rec_id)
			{
				if (((USHORT)count) > (list_email_mess.total_num_items - list_email_mess.max_num_items_display))
					list_email_mess.top_item_num = (list_email_mess.total_num_items - list_email_mess.max_num_items_display);
				break;
			}
		}		
		evt.eventType = EVT_LIST_SELECT;
		evt.eventType = LIST_EMAIL_MESS_NAME;
		evt.para1	  = (WORD)(count - list_email_mess.top_item_num);
		
        draw_scrollbar = FALSE;
		EmailMessListSelectedItemAction(&list_email_mess, &evt);
        draw_scrollbar = TRUE;
		
		if (search_string == NULL)
		{
			if (field_num == 3 || field_num == 4 || field_num == 5)
				FormPopupForm(FORM_MAIL_LIST);
			else FormPopupForm(FORM_EDIT);
			return;
		}
		
		if(field_num == 3 || field_num == 4 || field_num == 5)
			FormSetFormActiveObject(FORM_MAIL_LIST, (ObjectID)(FIELD_MAIL_LIST_TO + field_num - 3));
		else 
		{
			if (field_num == 2)
				FormSetFormActiveObject(FORM_EDIT, FIELD_EDIT_1);
			else if (field_num == 6)
			{
				if (cat == INBOX)
					FormSetFormActiveObject(FORM_EDIT, FIELD_EDIT_2);
				else FormSetFormActiveObject(FORM_EDIT, FIELD_EDIT_1);
			}
			else if (field_num == 7)
			{
				if (cat == INBOX)
					FormSetFormActiveObject(FORM_EDIT, FIELD_EDIT_4);
				else FormSetFormActiveObject(FORM_EDIT, FIELD_EDIT_2);
			}
		}						
		
		
        draw_scrollbar = FALSE;
        EmailChangeFontSize(FORM_EDIT, font_size);
		EmailSetEditTable(FORM_EDIT, TABLE_EDIT);
		EmailEditTableSetScrollbar(TABLE_EDIT, SCROLLBAR_EDIT);
		
        EmailChangeFontSize(FORM_MAIL_LIST, font_size);
		EmailSetEditTable(FORM_MAIL_LIST, TABLE_MAIL_LIST);
		EmailEditTableSetScrollbar(TABLE_MAIL_LIST, SCROLLBAR_MAIL_LIST);
        draw_scrollbar = TRUE;
		
		DataOpenRecord(dbid, rec_num, &rec_id, NULL);
		if (field_num == 3 || field_num == 4 || field_num == 5)
		{
            FormGetObjectPointer(FIELD_MAIL_LIST_TO, &object_type, (void**)&addr);
            FormGetObjectPointer(FIELD_MAIL_LIST_CC, &object_type, (void**)&addr1);
            FormGetObjectPointer(FIELD_MAIL_LIST_BCC, &object_type, (void**)&addr2);
			FormGetObjectPointer((ObjectID)(FIELD_MAIL_LIST_TO + field_num - 3), &object_type, (void**)&field_ptr);
			highlight_char_pos = GlobalFindSearchText(search_string, field_ptr->field_string);
			for (line_num = 0; line_num < field_ptr->field_total_num_lines; line_num++)
			{
				if ((highlight_char_pos >= field_ptr->field_lineinfo[line_num].start) &&
					(highlight_char_pos <= (field_ptr->field_lineinfo[line_num].start +
					field_ptr->field_lineinfo[line_num].length -1)))
				{
					found = TRUE;
					FieldGetMaxNumLinesDisplay(field_ptr->identification.ui_object_id, &max_num_lines);
					
                    if (field_ptr->field_total_num_lines <= max_num_lines)
						line_num = 0;
                    else if (line_num > (field_ptr->field_total_num_lines - max_num_lines))
						line_num = (field_ptr->field_total_num_lines - max_num_lines);
					
					field_ptr->field_top_line_num = line_num;
					break;
				}
			}
			if (!found)
				field_ptr->field_top_line_num = 0;
			FormGetObjectPointer(SCROLLBAR_MAIL_LIST, &object_type, (void**)&scroll_ptr);
			evt.para1 = scroll_ptr->scrollbar_value;
			total_num_lines = 0;
			for (count = FIELD_MAIL_LIST_TO; count < field_ptr->identification.ui_object_id; count++)
			{
				FieldGetTotalNumOfLines((ObjectID)(count), &num_lines);
				total_num_lines += num_lines;
			}
			evt.para2 =	total_num_lines + field_ptr->field_top_line_num;
            if (scroll_ptr->scrollbar_attr.scrollbar_visible == TRUE)
            {
                draw_scrollbar = FALSE;
                EmailScrollbarSetEditTable(TABLE_MAIL_LIST, SCROLLBAR_MAIL_LIST, &evt);
                draw_scrollbar = TRUE;
            }
			
			field_ptr->field_highlight_start_char = highlight_char_pos;
			field_ptr->field_highlight_end_char = highlight_char_pos + strlen(search_string) - 1;
			field_ptr->field_highlight_length = strlen(search_string);
			field_ptr->field_attr.field_highlight = TRUE;
			FormSetFormActiveObject(FORM_MAIL_LIST, field_ptr->identification.ui_object_id);
			FormPopupForm(FORM_MAIL_LIST);
		}
		else
		{
			if (field_num == 2)
				FormGetObjectPointer((ObjectID)(FIELD_EDIT_1), &object_type, (void**)&field_ptr);
			else if (field_num == 6)
			{
				if (cat == INBOX)
					FormGetObjectPointer((ObjectID)(FIELD_EDIT_2), &object_type, (void**)&field_ptr);
				else FormGetObjectPointer((ObjectID)(FIELD_EDIT_1), &object_type, (void**)&field_ptr);
			}
			else if (field_num == 7)
			{
				if (cat == INBOX)
					FormGetObjectPointer((ObjectID)(FIELD_EDIT_4), &object_type, (void**)&field_ptr);
				else FormGetObjectPointer((ObjectID)(FIELD_EDIT_2), &object_type, (void**)&field_ptr);
			}
			
			
			highlight_char_pos = GlobalFindSearchText(search_string, field_ptr->field_string);
#ifdef DEBUG_TT
            printf("\n EMail 1 highlight = %ld", highlight_char_pos);
			printf("\n EMail 2 line_num = %ld", field_ptr->field_total_num_lines);            
#endif
			
			for (line_num = 0; line_num < field_ptr->field_total_num_lines; line_num++)
			{
#ifdef DEBUG_TT
				printf("\n EMail 3 start length = %ld %ld", field_ptr->field_lineinfo[line_num].start, field_ptr->field_lineinfo[line_num].length);
#endif				
				if ((highlight_char_pos >= field_ptr->field_lineinfo[line_num].start) &&
					(highlight_char_pos <= (field_ptr->field_lineinfo[line_num].start +
					field_ptr->field_lineinfo[line_num].length -1)))
				{
#ifdef DEBUG_TT
					printf("\n EMail 4 FOUND = TRUE !!!!!");
					printf("\n Email 5 line_num = %ld", line_num);
					printf("\n Email 6 total_num_lines = %ld", field_ptr->field_total_num_lines);
					printf("\n email 7 num_lines_displayed = %ld", field_ptr->field_num_lines_displayed);	            	
#endif				
					
					found = TRUE;
					
					FieldGetMaxNumLinesDisplay(field_ptr->identification.ui_object_id, &max_num_lines);
					
#ifdef DEBUG_TT
					printf("\n email 7a max_num_lines = %ld", max_num_lines);	            	
#endif				
					
                    if (field_ptr->field_total_num_lines <= max_num_lines)
						line_num = 0;
                    else if (line_num > (field_ptr->field_total_num_lines - max_num_lines))
						line_num = (field_ptr->field_total_num_lines - max_num_lines);
					
					field_ptr->field_top_line_num = line_num;
#ifdef DEBUG_TT
					printf("\n EMail 7b top_line_num = %ld", field_ptr->field_top_line_num);
#endif					
					break;
				}
			}
#ifdef DEBUG_TT
            printf("\n EMail 8a found = %ld", found);
#endif
			if (!found)
				field_ptr->field_top_line_num = 0;
			
			FormGetObjectPointer(SCROLLBAR_EDIT, &object_type, (void**)&scroll_ptr);
			evt.para1 = scroll_ptr->scrollbar_value;
			total_num_lines = 0;
			for (count = FIELD_EDIT_0; count < field_ptr->identification.ui_object_id; count++)
			{
				FieldGetTotalNumOfLines((ObjectID)(count), &num_lines);
				total_num_lines += num_lines;
			}
			evt.para2 =	total_num_lines + field_ptr->field_top_line_num;
			
#ifdef DEBUG_TT
            printf("\n EMail 8b top_line_num = %ld", field_ptr->field_top_line_num);
#endif
			
			
			if (scroll_ptr->scrollbar_attr.scrollbar_visible == TRUE)
            {
                draw_scrollbar = FALSE;
				EmailScrollbarSetEditTable(TABLE_EDIT, SCROLLBAR_EDIT, &evt);
                draw_scrollbar = TRUE;
            }
            
#ifdef DEBUG_TT
            printf("\n EMail 9 top_line_num = %ld", field_ptr->field_top_line_num);
#endif
            
			field_ptr->field_highlight_start_char = highlight_char_pos;
			field_ptr->field_highlight_end_char = highlight_char_pos + strlen(search_string) - 1;
			field_ptr->field_highlight_length = strlen(search_string);
			field_ptr->field_attr.field_highlight = TRUE;
			FormSetFormActiveObject(FORM_EDIT, field_ptr->identification.ui_object_id);
			FormPopupForm(FORM_EDIT);
			launch_cmd = LAUNCH_CMD_GOTO_REC;
		}
	}
	DataCloseRecord(dbid, rec_id);
}

/********************************************************
* Function:	EmailPrepareFindText
* Purpose: 	This function is called to prepare the find text to 
be displayed in Global Find
* Scope:		application/internal
* Input:		dbid
rec_id
prepare_string
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EmailPrepareFindText(DatabaseID dbid, RecordID rec_id, BYTE **prepare_string)
{
	/* pb_dbid and email_dbid */
	SHORT			string_name_width, string_email_width;
	ObjectBounds	name_bounds, email_bounds;
	BYTE			*name, *email, *buffer;
	UWORD			byte_read, name_num_chars;
	Attribute		secret;
	
	/* emess_dbid */
	SHORT			string_subject_width;
	ObjectBounds	subject_bounds;
	BYTE			*addr, *subject;
	BYTE			**ename, **eaddr;
	USHORT			num_items;
	UBYTE			cat;
	
	
	name_bounds.xcoord	= 0;
	name_bounds.ycoord	= 0;
	name_bounds.width	= 67;
	name_bounds.height	= 9;
	
	email_bounds.xcoord	= 0;
	email_bounds.ycoord	= 0;
	email_bounds.width	= 67;
	email_bounds.height	= 9;
	
	subject_bounds.xcoord	= 0;
	subject_bounds.ycoord	= 0;
	subject_bounds.width	= 67;
	subject_bounds.height	= 9;
	
	*prepare_string = (BYTE*)pmalloc(200*sizeof(BYTE));
	
	if (dbid == pb_dbid)
	{
		DataRecordInfo(pb_dbid, rec_id, NULL, NULL, &secret, NULL, NULL);
		if (secret == ATTR_SET)
			DataGetField(dbid, rec_id, 8, &email, &byte_read);
		else if (secret == ATTR_CLR)
			DataGetField(dbid, rec_id, 22, &email, &byte_read);
		StrChopString(&email_bounds, email, SMALL_FONT, TRUE, 0);
		string_email_width = StrGetWidth(email, SMALL_FONT);
	}
	else if (dbid == email_dbid)
	{
		DataGetField(dbid, rec_id, 3, &email, &byte_read);
		StrChopString(&email_bounds, email, SMALL_FONT, TRUE, 0);
		string_email_width = StrGetWidth(email, SMALL_FONT);
	}
	
	if (dbid == pb_dbid)
	{
		DataGetField(dbid, rec_id, 2, &name, &byte_read);
		StrChopString(&name_bounds, name, SMALL_FONT, TRUE, 0);
		string_name_width = StrGetWidth(name, SMALL_FONT);
		strcpy(*prepare_string, name);
		name_num_chars = strlen(name);
		(*prepare_string)[name_num_chars] = 11;
		(*prepare_string)[name_num_chars + 1] = 139 - string_email_width - string_name_width;
		sprintf((char*)(*prepare_string + name_num_chars + 2), "%s", email);
		qfree(name);
		qfree(email);
	}
	else if (dbid == email_dbid)
	{
		DataGetField(dbid, rec_id, 2, &name, &byte_read);
		StrChopString(&name_bounds, name, SMALL_FONT, TRUE, 0);
		string_name_width = StrGetWidth(name, SMALL_FONT);
		strcpy(*prepare_string, name);
		name_num_chars = strlen(name);
		(*prepare_string)[name_num_chars] = 11;
		(*prepare_string)[name_num_chars + 1] = 139 - string_email_width - string_name_width;
		sprintf((char*)(*prepare_string + name_num_chars + 2), "%s", email);
		qfree(name);
		qfree(email);
	}
	else if (dbid == emess_dbid)
	{
		DataRecordInfo(emess_dbid, rec_id, NULL, &cat, NULL, NULL, NULL);
		if (cat == INBOX)
			DataGetField(dbid, rec_id, 2, &addr, &byte_read);
		else DataGetField(dbid, rec_id, 3, &addr, &byte_read);
		EmailMessageGetNameEmail(addr, &ename, &eaddr, &num_items, FALSE);
		if (num_items == 0)
		{
			name = (BYTE*)pmalloc(50 * sizeof(BYTE));
			strcpy(name, EMNONAME);
		}
		else
		{
			if (strlen(ename[0]) != 0)
			{
				name = (BYTE*)pmalloc((strlen(ename[0]) + 10)*sizeof(BYTE));
				strcpy(name, ename[0]);
			}
			else
			{
				name = (BYTE*)pmalloc((strlen(eaddr[0]) + 10)*sizeof(BYTE));
				strcpy(name, eaddr[0]);
			}
			qfree(ename[0]);
			qfree(eaddr[0]);
			qfree(ename);
			qfree(eaddr);
		}
		StrChopString(&name_bounds, name, SMALL_FONT, TRUE, 0);
		string_name_width = StrGetWidth(name, SMALL_FONT);
		DataGetField(dbid, rec_id, 6, &buffer, &byte_read);
        subject = (BYTE*)pmalloc((strlen(buffer) + 10)*sizeof(BYTE));
		strcpy(subject, buffer);
		qfree(buffer);
		StrChopString(&subject_bounds, subject, SMALL_FONT, TRUE, 0);
		string_subject_width = StrGetWidth(subject, SMALL_FONT);
		strcpy(*prepare_string, name);
		name_num_chars = strlen(name);
		(*prepare_string)[name_num_chars] = 11;
		(*prepare_string)[name_num_chars + 1] = 139 - string_subject_width - string_name_width;
		sprintf((char*)(*prepare_string + name_num_chars + 2), "%s", subject);
        pfree(subject);
        pfree(name);
        qfree(addr);
	}
}
