/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   app.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"

//#define DEBUG

extern BOOLEAN		false_restore;
extern BOOLEAN 		entry_low_memory;
extern BOOLEAN 		entry_old_edit;
extern ObjectID		low_memory_form_id;
extern WORD			launch_cmd; 	


/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
ObjectID        pressed_object = 0;
BYTE            name_list_in_action = 0;
BYTE            edit_cate_in_action = 0;
BYTE            new_name_in_action = 0;
BYTE            dial_in_action = 0;

BYTE            *current_cate = NULL;
BYTE            char_start = EMCHARA;

BYTE            *current_email_box = NULL;
BYTE            char_start_email_box = EMCHARA;

BYTE            *save_cate = NULL;
BYTE            save_first_letter = EMCHARA;

BYTE            *temp_cate = NULL;

BYTE            app_status;

BYTE            edit_table_font_size = SMALL_FONT;
BYTE            mail_list_table_font_size = SMALL_FONT;

ListDisplay     list_email_name = {LIST_NAME,0,0,0,0,0};
ListDisplay     list_find = {LIST_FIND_RESULT_NAME,0,0,0,0,0};
ListDisplay     list_email_mess = {LIST_EMAIL_MESS_NAME,0,0,0,0,0};
VEEmailNameStatus ve_email_name_status = {VIEW, FALSE, FALSE, 0, 0, FALSE};
EmailMessTop email_mess_top = {0,FALSE};
EditEntryStatus edit_entry_status = {VIEW, 0, 0, FALSE};
MailListEntryStatus mail_list_entry_status = {VIEW, 0, 0, FALSE};
DelEntryStatus del_entry_status = {0,0};
MailListInsertPt mail_list_insert_pt = {FALSE, 0, 0};
DialInsertPt dial_insert_pt = {FALSE, 0, 0};

BOOLEAN			rf_action = 0;
BYTE			*own_email = NULL;

BYTE			addr_edit_dirty = 0;
BYTE			emess_edit_dirty = 0;

BYTE    email_mail_list_first_in = 0;
BYTE    email_dial_first_in = 0;

BYTE    *temp_from;
BYTE    *temp_to;
BYTE    *temp_cc;
BYTE    *temp_bcc;

BYTE    find_string[120];
BYTE    font_size = SMALL_FONT;
BOOLEAN     draw_scrollbar = TRUE;

BOOLEAN     view_to_edit = FALSE;

BOOLEAN      gf_entry = FALSE;
ObjectID     gf_in_form_id, gf_in_pressed_object;



/*****************************************************************
***************** Application Event Handle Function **************
*****************************************************************/
/********************************************************
* Function:	EmailEmailNameList
* Purpose: 	This function is the event handler for the EMAIL NAME LIST
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailEmailNameList(EvtType* Event)
{
	
    USHORT      item_num;
    USHORT      popup_total_num_items;
    BYTE        object_type;
    Control     *control_ptr;
    Textbox     *textbox_ptr;
    List        *list_ptr;
    ObjectID    pushed_button;
	
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
            if (Event->para1 == 9)
            {
                ControlGetPushedPushButton(FORM_EMAIL_NAME_LIST, 1, &pushed_button);                        
                pushed_button ++;
                if (pushed_button == 11)
                    pushed_button = 2;
                FormSetControlGroupSelection(FORM_EMAIL_NAME_LIST, pushed_button);
                Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = pushed_button;
                Event->evtPBP       = NULL;              
            }    	        
			else if (Event->para1 == LLETTER_NEW_EMAIL_NAME || Event->para1 == SLETTER_NEW_EMAIL_NAME)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_NEW_EMAIL_NAME_RECORD;
                Event->evtPBP     = NULL;
            }
            else if (Event->para1 == LLETTER_FIND || Event->para1 == SLETTER_FIND)
            {
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_EMAIL_NAME_LIST_FIND;
                Event->evtPBP       = NULL;
            }            	            
            else if (Event->para1 == LLETTER_CATE)
            {
                ControlPopupPopupTrigger(POPUP_TRIGGER_CATE);
                return TRUE;
            }            	                       
            else if (Event->para2 == 0x215 || Event->para2 == 0x21c)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_EMAIL_NAME_LIST, SCROLLBAR_UP_ARROW);            
                return TRUE;            
            }
            else if (Event->para2 == 0x216 || Event->para2 == 0x21d)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_EMAIL_NAME_LIST, SCROLLBAR_DOWN_ARROW);            
                return TRUE;            
            }                    
        }       
    }                    
	
	
	switch (Event->eventType)
	{
	case EVT_MENU_SELECT_ITEM:
		MenuItemSelectedAction1((USHORT)(Event->para1));
		return TRUE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			if (name_list_in_action == ADDRESS_LIST)
			{
				EmailCateNameToPopupTriggerEmailBox();
				if (ControlPopupFindItemNum(POPUP_TRIGGER_EMAIL_BOX, current_email_box,
					&item_num) == TRUE) 
					ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, (SHORT)item_num);
				else
					ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, 0);
				FormPopupForm(FORM_EMAIL_MESS_LIST);
				return TRUE;
			}
			else if (name_list_in_action == MAIL_LIST)
			{
				FormSetFormActiveObject(FORM_MAIL_LIST, mail_list_insert_pt.field_id);
				FieldSetInsertPointOn(mail_list_insert_pt.field_id);
				EmailChangeFontSize(FORM_MAIL_LIST, font_size);
				FormPopupForm(FORM_MAIL_LIST);
				return TRUE;
			}
		}
		break;
	case EVT_LIST_SELECT:
		EmailListSelectedItemAction(&list_email_name, Event);
		if (name_list_in_action != MAIL_LIST)
		{
			emess_edit_dirty = 0;
			addr_edit_dirty = 0;
			FormPopupForm(FORM_VE_EMAIL_NAME);
		}
		else 
		{
			emess_edit_dirty = 1;
			EmailChangeFontSize(FORM_MAIL_LIST, font_size);
			FormPopupForm(FORM_MAIL_LIST);
			name_list_in_action = 0;
		}
		return TRUE;
#ifdef PR31700
	case EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{
			if (Event->para2 == IO_UP_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_EMAIL_NAME_LIST, SCROLLBAR_UP_ARROW);
			else if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_EMAIL_NAME_LIST, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		return FALSE;
#endif
	case EVT_SCROLLBAR_REPEAT:
		EmailScrollbarSetAddressList(Event);
		return TRUE;
	case EVT_SCROLLBAR_SELECT:
		ScrollbarDrawScrollbar(SCROLLBAR_EMAIL_NAME_LIST);
		return TRUE;
	case EVT_CONTROL_POPUP_SELECT:
		if (EmailPopupCateActions((SHORT)(Event->para1)) == TRUE)
		{
			ControlPopupGetTotalItems (POPUP_TRIGGER_CATE, &popup_total_num_items);
			if (popup_total_num_items == ((USHORT)(Event->para1) + 1))
				edit_cate_in_action = FROM_POPUP;
			return TRUE;
		}
		break;
	case EVT_CONTROL_SELECT:
		switch (Event->eventID)
		{	
		case BUTTON_NEW_EMAIL_NAME_RECORD:			
			if (MemoryLow || (entry_low_memory && entry_old_edit))
			{
				low_memory_form_id = FORM_EMAIL_NAME_LIST;
				FormPopupForm(FORM_EM_LOW_MEMORY);
				return TRUE;
			}	       
			else if (gf_entry && entry_old_edit)
			{         	
				gf_in_form_id = FORM_EMAIL_NAME_LIST;
				FormPopupForm(FORM_EM_DISCARD_CHANGES);
				return TRUE;
			}	                						    
			
			addr_edit_dirty = 0;
			emess_edit_dirty = 0;
			new_name_in_action = ADDRESS_LIST;
			FormInitAllFormObjects(FORM_VE_EMAIL_NAME);
			EmailCateNameToPopupTrigger(email_dbid);
			ControlPopupDeleteItem(POPUP_TRIGGER_CATE, 0);
			if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate,
				&item_num) == TRUE) 
				ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
			else
				ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
			SetVEEmailNameStatus(EDIT, TRUE, FALSE, 0, email_dbid,TRUE);
			if (temp_cate)
				qfree(temp_cate);
			temp_cate = (BYTE*)qmalloc(30 * sizeof(BYTE));
			strcpy(temp_cate, current_cate);
			EmailSetupViewEditEmailNameScreen();
			FormSetFormActiveObject(FORM_VE_EMAIL_NAME, TEXTBOX_LAST_NAME);
			TextboxSetInsertPointOn(TEXTBOX_LAST_NAME);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_LAST_NAME, 0);
			FormPopupForm(FORM_VE_EMAIL_NAME);
			return TRUE;
		case BUTTON_EMAIL_NAME_LIST_FIND:
			FormPopupForm(FORM_FIND_BACKGROUND);
			FormPopupForm(FORM_FIND_INPUT);
			FormInitAllFormObjects(FORM_FIND_INPUT);
			FormGetObjectPointer(TEXTBOX_FIND_INPUT, &object_type, (void**)&textbox_ptr);
			TextboxSetText(TEXTBOX_FIND_INPUT, find_string);
			TextboxSetInsertPointOff(TEXTBOX_FIND_INPUT);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_FIND_INPUT, 0);
			TextboxSetLeftCharPos(TEXTBOX_FIND_INPUT, 0);
			TextboxSetRightCharPos(TEXTBOX_FIND_INPUT, -1);
			textbox_ptr->textbox_attr.textbox_highlight = TRUE;
			TextboxSetHighlightSelection(TEXTBOX_FIND_INPUT, 0, strlen(find_string));
			return TRUE;
		case BUTTON_EMAIL_NAME_LIST_ZOOMIN:
			EmailChangeListFont();
			return TRUE;
		case PUSHBUTTON_ABC:
			char_start = 32;
			EmailSetAddressListTopItemNum(32,0, FALSE);
			ListDrawList(LIST_NAME);
			ListDrawList(LIST_EMAIL);
			return TRUE;
		case PUSHBUTTON_DEF:
			char_start = 'D';
			EmailSetAddressListTopItemNum('D',0, FALSE);
			ListDrawList(LIST_NAME);
			ListDrawList(LIST_EMAIL);
			return TRUE;
		case PUSHBUTTON_GHI:
			char_start = 'G';
			EmailSetAddressListTopItemNum('G',0, FALSE);
			ListDrawList(LIST_NAME);
			ListDrawList(LIST_EMAIL);
			return TRUE;
		case PUSHBUTTON_JKL:
			char_start = 'J';
			EmailSetAddressListTopItemNum('J',0, FALSE);
			ListDrawList(LIST_NAME);
			ListDrawList(LIST_EMAIL);
			return TRUE;
		case PUSHBUTTON_MNO:
			char_start = 'M';
			EmailSetAddressListTopItemNum('M',0, FALSE);
			ListDrawList(LIST_NAME);
			ListDrawList(LIST_EMAIL);
			return TRUE;
		case PUSHBUTTON_PQR:
			char_start = 'P';
			EmailSetAddressListTopItemNum('P',0, FALSE);
			ListDrawList(LIST_NAME);
			ListDrawList(LIST_EMAIL);
			return TRUE;
		case PUSHBUTTON_STU:
			char_start = 'S';
			EmailSetAddressListTopItemNum('S',0, FALSE);
			ListDrawList(LIST_NAME);
			ListDrawList(LIST_EMAIL);
			return TRUE;
		case PUSHBUTTON_VWX:
			char_start = 'V';
			EmailSetAddressListTopItemNum('V',0, FALSE);
			ListDrawList(LIST_NAME);
			ListDrawList(LIST_EMAIL);
			return TRUE;
		case PUSHBUTTON_YZ:
			char_start = 'Y';
			EmailSetAddressListTopItemNum('Y',0, FALSE);
			ListDrawList(LIST_NAME);
			ListDrawList(LIST_EMAIL);
			return TRUE;
		default: return FALSE;
			}
			break;
		case EVT_FORM_OPEN:
			app_status = EMAIL_NAME_LIST;
            FormGetObjectPointer(BUTTON_EMAIL_NAME_LIST_FIND, &object_type, (void**)&control_ptr);                
            if (name_list_in_action == ADDRESS_LIST)
                control_ptr->control_attr.control_visible = TRUE;
            else if(name_list_in_action == MAIL_LIST)
                control_ptr->control_attr.control_visible = FALSE;
            FormGetObjectPointer(BUTTON_EMAIL_NAME_LIST_ZOOMIN, &object_type, (void**)&control_ptr);
            if (name_list_in_action == ADDRESS_LIST)
                control_ptr->bounds.xcoord = APP_XCOORD1;
            else if(name_list_in_action == MAIL_LIST)
                control_ptr->bounds.xcoord = APP_XCOORD2;
            FormGetObjectPointer(LIST_NAME, &object_type, (void**)&list_ptr);
            if (list_ptr->list_text_font == SMALL_FONT)
			{
				MenuDeleteItem(MENU_EMAIL_NAME_LIST, 0);
                MenuInsertItem(MENU_EMAIL_NAME_LIST, 0, EMLFONT);
                ControlSetLabel(BUTTON_EMAIL_NAME_LIST_ZOOMIN, EMLFONT);
			}
            else
			{			
				MenuDeleteItem(MENU_EMAIL_NAME_LIST, 0);
				MenuInsertItem(MENU_EMAIL_NAME_LIST, 0, EMSFONT);
				ControlSetLabel(BUTTON_EMAIL_NAME_LIST_ZOOMIN, EMSFONT);
			}
			FormDrawForm(FORM_EMAIL_NAME_LIST);
			return TRUE;
		default:
			return FALSE;
	}
	return FALSE;
}
/********************************************************
* Function:	EmailEditCate
* Purpose: 	This function is the event handler for the EDIT CATEGORIES
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailEditCate(EvtType* Event)
{
	SHORT selected_cate;
	USHORT num_items;
	BYTE *list_string;
	USHORT item_num;
	BYTE	object_type;
	List	*list_ptr;
	
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_CATE_NEW || Event->para1 == SLETTER_CATE_NEW)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_CATE_NEW;
                Event->evtPBP       = NULL;
            }
            else if (Event->para1 == LLETTER_CATE_DEL || Event->para1 == SLETTER_CATE_DEL)
            {
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_CATE_DEL;
                Event->evtPBP       = NULL;
            }            	            
            else if (Event->para1 == LLETTER_CATE_RENAME || Event->para1 == SLETTER_CATE_RENAME)
            {
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_CATE_RENAME;
                Event->evtPBP       = NULL;
            }            	                        
            else if (Event->para2 == 0x215 || Event->para2 == 0x21c)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_CATE, SCROLLBAR_UP_ARROW);            
                return TRUE;            
            }
            else if (Event->para2 == 0x216 || Event->para2 == 0x21d)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_CATE, SCROLLBAR_DOWN_ARROW);            
                return TRUE;            
            }                                
        }       
    }                    
	
	
	switch (Event->eventType)
	{
	case EVT_MENU_SELECT_ITEM:
		MenuItemSelectedAction1((USHORT)(Event->para1));
		return TRUE;
#ifdef PR31700
	case EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{
			if (Event->para2 == IO_UP_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_CATE, SCROLLBAR_UP_ARROW);
			else if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_CATE, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		return FALSE;
#endif
	case EVT_SCROLLBAR_SELECT:
		ScrollbarDrawScrollbar(SCROLLBAR_CATE);
		return TRUE;
	case EVT_SCROLLBAR_REPEAT:
		EmailScrollbarSetEditCate(Event);
		return TRUE;
	case EVT_LIST_SELECT:
		ListSetHighlightedItem((ObjectID)(Event->eventID), (SHORT)(Event->para1));
		ListDrawList((ObjectID)(Event->eventID));
		return TRUE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			if (edit_cate_in_action == FROM_POPUP)
			{	
				ControlInitControl(POPUP_TRIGGER_CATE);
				EmailCateNameToPopupTrigger(email_dbid);
				if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate,
					&item_num) == TRUE) 
				{
					ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
					EmailRecordToList(current_cate, char_start, NULL);
				}
				else
				{
					ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
					EmailRecordToList(EMALL, EMCHARA,NULL);
				}
				EmailChangeFontSize(FORM_EMAIL_NAME_LIST, font_size);
				FormPopupForm(FORM_EMAIL_NAME_LIST);
				return TRUE;
			}
			else if (edit_cate_in_action == FROM_EDIT)
			{
				ControlInitControl(POPUP_TRIGGER_CATE);
				EmailCateNameToPopupTrigger(email_dbid);
				ControlPopupDeleteItem(POPUP_TRIGGER_CATE, 0);
				ControlInitControl(POPUP_TRIGGER_CATE);
				EmailCateNameToPopupTrigger(email_dbid);
				ControlPopupDeleteItem(POPUP_TRIGGER_CATE, 0);
				if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, temp_cate,
					&item_num) == TRUE) 
					ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
				else
					ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
				FormPopupForm(FORM_VE_EMAIL_NAME);
				return TRUE;
			}
		}
		return FALSE;
		break;
	case EVT_CONTROL_SELECT:
		switch (Event->eventID)
		{	
		case BUTTON_CATE_NEW:				
			if (MemoryLow || (entry_low_memory && entry_old_edit))
			{
				low_memory_form_id = FORM_EDIT_CATE;
				FormPopupForm(FORM_EM_LOW_MEMORY);
				return TRUE;
			}						
			ListGetNumOfItems(LIST_CATE,&num_items);
			if (num_items == 255)
				FormPopupForm(FORM_CATE_FULL);
			else
			{				
				TextboxSetText(TEXTBOX_INPUT_CATE,(BYTE*)(""));
				TextboxSetLeftCharPos(TEXTBOX_INPUT_CATE, 0);
				TextboxSetRightCharPos(TEXTBOX_INPUT_CATE, -1);
				TextboxSetInsertPointPositionByCharPos(TEXTBOX_INPUT_CATE,0);
				FormSetFormActiveObject(FORM_INPUT_CATE,TEXTBOX_INPUT_CATE);
				FormPopupForm(FORM_INPUT_CATE);
				pressed_object = BUTTON_CATE_NEW;
			}
			break;
		case BUTTON_CATE_DEL:
			ListGetNumOfItems(LIST_CATE,&num_items);
			if (num_items == 0) return TRUE;
			ListGetSelectedItem(LIST_CATE, &selected_cate);
			if (selected_cate != -1)
			{
				if (DeleteCateCheck(selected_cate) == TRUE) return TRUE;
			}
			else
			{
				FormPopupForm(FORM_NO_CATE);
				return TRUE;
			}
			break;
		case BUTTON_CATE_RENAME:
			if (MemoryLow || (entry_low_memory && entry_old_edit))
			{
				low_memory_form_id = FORM_EDIT_CATE;
				FormPopupForm(FORM_EM_LOW_MEMORY);
				return TRUE;
			}						
			
			ListGetSelectedItem(LIST_CATE, &selected_cate);
			if (selected_cate != -1)
			{
				FormPopupForm(FORM_INPUT_CATE);
				TextboxInitTextbox(TEXTBOX_INPUT_CATE);
				ListGetListItem(LIST_CATE,(USHORT)selected_cate, &list_string);
				TextboxSetText(TEXTBOX_INPUT_CATE, list_string);
				TextboxSetInsertPointPositionByCharPos(TEXTBOX_INPUT_CATE,strlen(list_string));
				TextboxSetInsertPointOn(TEXTBOX_INPUT_CATE);
				FormSetFormActiveObject(FORM_INPUT_CATE,TEXTBOX_INPUT_CATE);
				pressed_object = BUTTON_CATE_RENAME;
				return TRUE;
			}
			else
			{
				FormPopupForm(FORM_NO_CATE);
				return TRUE;
			}
			break;
		case BUTTON_CATE_ZOOMIN:
			EmailChangeListFont();
			break;
		default: return FALSE;
		}
		break;
		case EVT_FORM_OPEN:
			if (FormCheckObjectExists(SCROLLBAR_CATE) == FALSE)
				ScrollbarInitScrollbar(SCROLLBAR_CATE);
			EmailEditCateSetScrollbar();
			app_status = EDIT_CATE;
            FormGetObjectPointer(LIST_CATE, &object_type, (void**)&list_ptr);
            if (list_ptr->list_text_font == SMALL_FONT)
			{
				MenuDeleteItem(MENU_EDIT_CATE, 0);
                MenuInsertItem(MENU_EDIT_CATE, 0, EMLFONT);
                ControlSetLabel(BUTTON_CATE_ZOOMIN, EMLFONT);
			}
            else
			{			
				MenuDeleteItem(MENU_EDIT_CATE, 0);
				MenuInsertItem(MENU_EDIT_CATE, 0, EMSFONT);
				ControlSetLabel(BUTTON_CATE_ZOOMIN, EMSFONT);
			}
			FormDrawForm(FORM_EDIT_CATE);
			return TRUE;
		default:
			return FALSE;
	}
	return FALSE;
}
/********************************************************
* Function:	EmailInputCate
* Purpose: 	This function is the event handler for the INPUT CATEGORIES
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailInputCate(EvtType *Event)
{
	ObjectID tempID;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
            if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;
            }
        }       
    }                    
	
	
	switch (Event->eventType)
	{
	case EVT_MENU_SELECT_ITEM:
		MenuItemSelectedAction((USHORT)(Event->para1));
		return TRUE;
	case EVT_INLAY_SELECT:
		switch (Event->para1)
		{
		case INLAY_OK:
			if (InputCatCheckCharIn() == TRUE) return TRUE;
			break;
		case INLAY_EXIT:
			FormPopupForm(FORM_EDIT_CATE);
			return TRUE;
		default: return FALSE;
		}
		break;
		case EVT_KEY:
			if (Event->eventID == SOFT_KEY && (Event->para2 & 0x300) == 0)
			{
				FormGetActiveObject(FORM_INPUT_CATE,&tempID);
				if (tempID == TEXTBOX_INPUT_CATE) 
				{
					if ((BYTE)(Event->para1) == 13 && (InputCatCheckCharIn() == TRUE)) return TRUE;
					else TextboxAddKeyInChar(TEXTBOX_INPUT_CATE, (BYTE)(Event->para1));
					return TRUE;
				}
			}
			break;
		case EVT_BITMAP_SELECT:
			EmailEditCateSetScrollbar();
			FormPopupForm(FORM_EDIT_CATE);
			return TRUE;
		case EVT_FORM_OPEN:
			FormDrawForm(FORM_INPUT_CATE);
			return TRUE;
		default:
			return FALSE;
	}
	return FALSE;
}
/********************************************************
* Function:	EmailNoCate
* Purpose: 	This function is the event handler for the NO CATEGORY SELECTED
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailNoCate(EvtType* Event)
{
    
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_X || Event->para1 == LLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;
            }
        }       
    }                    	
    
    
	switch (Event->eventType)
	{
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_EXIT || Event->para1 == INLAY_OK)
		{
			EmailChangeFontSize(FORM_EDIT_CATE, font_size);
			FormPopupForm(FORM_EDIT_CATE);
			return TRUE;
		}
		break;
	case EVT_BITMAP_SELECT:
		FormPopupForm(FORM_EDIT_CATE);
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_NO_CATE);
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}
/********************************************************
* Function:	EmailNameExists
* Purpose: 	This function is the event handler for the CATEGORY ALREADY EXISTS
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailNameExists(EvtType *Event)
{
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;
            }
        }       
    }                    
	
	
	switch (Event->eventType)
	{
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_EXIT || Event->para1 == INLAY_OK)
		{
			TextboxSetInsertPointOn(TEXTBOX_INPUT_CATE);
			TextboxDrawTextbox(TEXTBOX_INPUT_CATE);
			FormSetFormActiveObject(FORM_INPUT_CATE,TEXTBOX_INPUT_CATE);
			EmailChangeFontSize(FORM_EDIT_CATE, font_size);
			FormPopupForm(FORM_EDIT_CATE);
			FormPopupForm(FORM_INPUT_CATE);
			return TRUE;
		}
		break;
	case EVT_BITMAP_SELECT:
		TextboxSetInsertPointOn(TEXTBOX_INPUT_CATE);
		TextboxDrawTextbox(TEXTBOX_INPUT_CATE);
		FormSetFormActiveObject(FORM_INPUT_CATE,TEXTBOX_INPUT_CATE);
		EmailChangeFontSize(FORM_EDIT_CATE, font_size);
		FormPopupForm(FORM_EDIT_CATE);
		FormPopupForm(FORM_INPUT_CATE);
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_CATE_NAME_EXISTS);
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}
/********************************************************
* Function:	EmailEraseCate
* Purpose: 	This function is the event handler for the ERASE CATEGORY
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailEraseCate(EvtType *Event)
{
    SHORT selected_item;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_ERASE_CATE_YES;
                Event->evtPBP       = NULL;
            }
            else if (Event->para1 == LLETTER_NO	|| Event->para1 == SLETTER_NO)
            {
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_ERASE_CATE_NO;
                Event->evtPBP       = NULL;
            }            	            
        }       
    }                    
	
    switch (Event->eventType)
	{
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_ERASE_CATE_YES)
		{	
			ListGetSelectedItem(LIST_CATE,&selected_item);
			DeleteCate(selected_item);
			EmailChangeFontSize(FORM_EDIT_CATE, font_size);
			FormPopupForm(FORM_EDIT_CATE);
			return TRUE;
		}
		else if (Event->eventID == BUTTON_ERASE_CATE_NO)
		{
			EmailChangeFontSize(FORM_EDIT_CATE, font_size);
			FormPopupForm(FORM_EDIT_CATE);
		}
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_ERASE_CATE);
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}
/********************************************************
* Function:	EmailRemoveCate
* Purpose: 	This function is the event handler for the REMOVE CATEGORY
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailRemoveCate(EvtType *Event)
{
	SHORT selected_item;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_REMOVE_CATE_YES;
                Event->evtPBP       = NULL;
            }
            else if (Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
            {
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_REMOVE_CATE_NO;
                Event->evtPBP       = NULL;
            }            	            
        }       
    }                    
	
	
	
	switch (Event->eventType)
	{
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_REMOVE_CATE_YES)
		{	
			ListGetSelectedItem(LIST_CATE,&selected_item);
			DeleteCate(selected_item);
			EmailChangeFontSize(FORM_EDIT_CATE, font_size);
			FormPopupForm(FORM_EDIT_CATE);
			return TRUE;
		}
		else if (Event->eventID == BUTTON_REMOVE_CATE_NO)
		{
			EmailChangeFontSize(FORM_EDIT_CATE, font_size);
			FormPopupForm(FORM_EDIT_CATE);
		}
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_REMOVE_CATE);
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailCateFull
* Purpose: 	This function is the event handler for the CATEGORY FULL
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailCateFull(EvtType *Event)
{
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;
            }
        }       
    }                    
	
	
	switch (Event->eventType)
	{
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_EXIT || Event->para1 == INLAY_OK)
		{
			EmailChangeFontSize(FORM_EDIT_CATE, font_size);
			FormPopupForm(FORM_EDIT_CATE);
			return TRUE;
		}
		break;
	case EVT_BITMAP_SELECT:
		EmailChangeFontSize(FORM_EDIT_CATE, font_size);
		FormPopupForm(FORM_EDIT_CATE);
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_CATE_FULL);
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailFindBackground
* Purpose: 	This function is called to handle the event occured in the 
FIND BACKGROUND screen of phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailFindBackground(EvtType *Event)
{
	switch (Event->eventType)
	{
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_EXIT || Event->para1 == INLAY_OK)
		{
			EmailChangeFontSize(FORM_EMAIL_NAME_LIST, font_size);
			FormPopupForm(FORM_EMAIL_NAME_LIST);
			return TRUE;
		}
		break;
	case EVT_FORM_OPEN:
		app_status = FIND;
		FormDrawForm(FORM_FIND_BACKGROUND);
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailFindInput
* Purpose: 	This function is called to handle the event occured in the 
FIND INPUT screen of phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailFindInput(EvtType *Event)
{
	ObjectID tempID;
    BYTE *textbox_string;
    BYTE    object_type;
    Textbox *textbox_ptr;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;
            }
        }            
    }                    
	
	
	switch (Event->eventType)
	{
	case EVT_MENU_SELECT_ITEM:
		MenuItemSelectedAction((USHORT)(Event->para1));
		return TRUE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_EXIT)
		{
			EmailChangeFontSize(FORM_EMAIL_NAME_LIST, font_size);
			FormPopupForm(FORM_EMAIL_NAME_LIST);
			return TRUE;
		}
		else if (Event->para1 == INLAY_OK)
		{
			if (InputFindCharInCheck() == TRUE) return TRUE;
			break;
		}
		break;
	case EVT_KEY:
		if (Event->eventID == SOFT_KEY && (Event->para2 & 0x300) == 0)
		{
			FormGetActiveObject(FORM_FIND_INPUT,&tempID);
			if (tempID == TEXTBOX_FIND_INPUT) 
			{
				if ((BYTE)(Event->para1) == 13 && (InputFindCharInCheck() == TRUE)) return TRUE;
				else TextboxAddKeyInChar(TEXTBOX_FIND_INPUT, (BYTE)(Event->para1));
				return TRUE;
			}
		}
		break;
	case EVT_BITMAP_SELECT:
		EmailChangeFontSize(FORM_EMAIL_NAME_LIST, font_size);
		FormPopupForm(FORM_EMAIL_NAME_LIST);
		return TRUE;
	case EVT_FORM_OPEN:
		FormSetFormActiveObject(FORM_FIND_INPUT, TEXTBOX_FIND_INPUT);
		TextboxGetTextPointer(TEXTBOX_FIND_INPUT, &textbox_string);
		FormGetObjectPointer(TEXTBOX_FIND_INPUT, &object_type, (void**)&textbox_ptr);
		if (strlen(textbox_string) == 0)
		{
			TextboxSetInsertPointOn(TEXTBOX_FIND_INPUT);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_FIND_INPUT, 0);
			textbox_ptr->textbox_attr.textbox_highlight = FALSE;
		}
		else
		{
			TextboxSetInsertPointOff(TEXTBOX_FIND_INPUT);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_FIND_INPUT, 0);
			TextboxSetLeftCharPos(TEXTBOX_FIND_INPUT, 0);
			TextboxSetRightCharPos(TEXTBOX_FIND_INPUT, -1);
			textbox_ptr->textbox_attr.textbox_highlight = TRUE;
			TextboxSetHighlightSelection(TEXTBOX_FIND_INPUT, 0, strlen(textbox_string));
		}
		FormDrawForm(FORM_FIND_INPUT);
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailNameNotFound
* Purpose: 	This function is called to handle the event occured in the 
NOT FOUND screen of phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailNameNotFound(EvtType *Event)
{
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
            if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;
            }
        }
    }                    
	
	
	switch (Event->eventType)
	{
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_EXIT || Event->para1 == INLAY_OK)
		{
			FormPopupForm(FORM_FIND_BACKGROUND);
			FormPopupForm(FORM_FIND_INPUT);
			return TRUE;
		}
		break;
	case EVT_BITMAP_SELECT:
		FormPopupForm(FORM_FIND_BACKGROUND);
		FormPopupForm(FORM_FIND_INPUT);
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_NOT_FOUND);
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailFindResult
* Purpose: 	This function is called to handle the event occured in the 
FIND RESULT screen of phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailFindResult(EvtType *Event)
{
    BYTE object_type;
    Textbox *textbox_ptr;
    List    *list_ptr;
	
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_FIND_RESULT_NEW || Event->para1 == SLETTER_FIND_RESULT_NEW)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_FIND_RESULT_NEW;
                Event->evtPBP       = NULL;
            }
            else if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
            {
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;
            }            	            
            else if (Event->para2 == 0x215 || Event->para2 == 0x21c)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_FIND_RESULT, SCROLLBAR_UP_ARROW);            
                return TRUE;            
            }
            else if (Event->para2 == 0x216 || Event->para2 == 0x21d)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_FIND_RESULT, SCROLLBAR_DOWN_ARROW);            
                return TRUE;            
            }                                
        }       
    }                    
	
	
	switch(Event->eventType)
	{
	case EVT_MENU_SELECT_ITEM:
		MenuItemSelectedAction1((USHORT)(Event->para1));
		return TRUE;
	case EVT_LIST_SELECT:
		EmailListSelectedItemAction(&list_find, Event);
		addr_edit_dirty = 0;
		emess_edit_dirty = 0;
		FormPopupForm(FORM_VE_EMAIL_NAME);
		return TRUE;
#ifdef PR31700
	case EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{
			if (Event->para2 == IO_UP_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_FIND_RESULT, SCROLLBAR_UP_ARROW);
			else if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_FIND_RESULT, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		return FALSE;
#endif
	case EVT_SCROLLBAR_SELECT:
		//EmailScrollbarSetFindResult(Event);
		ScrollbarDrawScrollbar(SCROLLBAR_FIND_RESULT);
		return TRUE;
	case EVT_SCROLLBAR_REPEAT:
		EmailScrollbarSetFindResult(Event);
		return TRUE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			EmailChangeFontSize(FORM_EMAIL_NAME_LIST, font_size);
			FormPopupForm(FORM_EMAIL_NAME_LIST);
			return TRUE;
		}
		break;
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_FIND_RESULT_NEW)
		{
			FormEraseForm(FORM_FIND_RESULT);
			TextboxSetText(TEXTBOX_FIND_INPUT, (BYTE *)(""));
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_FIND_INPUT, 0);
			TextboxSetInsertPointOn(TEXTBOX_FIND_INPUT);
			FormPopupForm(FORM_FIND_INPUT);
		}
		else if (Event->eventID == BUTTON_FIND_RESULT_ZOOMIN)
			EmailChangeListFont();
		return TRUE;
	case EVT_BITMAP_SELECT:
		FormEraseForm(FORM_FIND_RESULT);
		FormGetObjectPointer(TEXTBOX_FIND_INPUT, &object_type, (void**)&textbox_ptr);
		TextboxSetInsertPointOff(TEXTBOX_FIND_INPUT);
		TextboxSetInsertPointPositionByCharPos(TEXTBOX_FIND_INPUT, 0);
		TextboxSetLeftCharPos(TEXTBOX_FIND_INPUT, 0);
		TextboxSetRightCharPos(TEXTBOX_FIND_INPUT, -1);
		textbox_ptr->textbox_attr.textbox_highlight = TRUE;
		TextboxSetHighlightSelection(TEXTBOX_FIND_INPUT, 0, strlen(textbox_ptr->textbox_string));
		FormPopupForm(FORM_FIND_INPUT);
		return TRUE;
	case EVT_FORM_OPEN:
		app_status = FIND;
		FormGetObjectPointer(LIST_FIND_RESULT_NAME, &object_type, (void**)&list_ptr);
		if (list_ptr->list_text_font == SMALL_FONT)
		{
			MenuDeleteItem(MENU_FIND_RESULT, 0);
			MenuInsertItem(MENU_FIND_RESULT, 0, EMLFONT);
			ControlSetLabel(BUTTON_FIND_RESULT_ZOOMIN, EMLFONT);
		}
		else
		{			
			MenuDeleteItem(MENU_FIND_RESULT, 0);
			MenuInsertItem(MENU_FIND_RESULT, 0, EMSFONT);
			ControlSetLabel(BUTTON_FIND_RESULT_ZOOMIN, EMSFONT);
		}
		FormDrawForm(FORM_FIND_RESULT);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailVEEmailName
* Purpose: 	This function is called to handle the event occured in the 
View Edit New Email Name screen of phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailVEEmailName(EvtType *Event)
{
	void            *addr;
	BYTE            object_type;
	USHORT          item_num;
	ObjectID        tempID;
	ObjectBounds    bounds;
	SHORT           xcoord, ycoord;
	UBYTE           cate[256], num_cate;
	USHORT          popup_total_num_items;
	BYTE            *cate_name;
	USHORT          i;
	BYTE            *whole_name;
	Textbox         *textbox_ptr, *textbox_ptr1;
	BYTE            *item_text;
    List            *list_ptr;
    Control         *control_ptr;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_EMAIL_NAME_DEL || Event->para1 == SLETTER_EMAIL_NAME_DEL)
			{
				if (FormGetObjectPointer(BUTTON_VE_DEL, &object_type, (void**)&control_ptr) == TRUE)
				{
					if (control_ptr->control_attr.control_visible)
					{
						Event->eventType    = EVT_CONTROL_SELECT;
                        Event->eventID      = BUTTON_VE_DEL;
                        Event->evtPBP       = NULL;
                    }                        
                }                    
            }
			else if (Event->para1 == LLETTER_VE_COMPANY || Event->para1 == SLETTER_VE_COMPANY)
			{
				if (FormGetObjectPointer(CHECKBOX_VE_C, &object_type, (void**)&control_ptr) == TRUE)
				{
					if (control_ptr->control_attr.control_visible)
					{
						FormSetControlGroupSelection(FORM_VE_EMAIL_NAME, CHECKBOX_VE_C);
						Event->eventType    = EVT_CONTROL_SELECT;
                        Event->eventID      = CHECKBOX_VE_C;
                        Event->evtPBP       = NULL;
                    }                        
                }                    
            }
			else if (Event->para1 == LLETTER_CATE)
			{
                ControlPopupPopupTrigger(POPUP_TRIGGER_CATE);
                return TRUE;
            }
			else if (Event->para1 == LLETTER_VE_HOME || Event->para1 == SLETTER_VE_HOME)
			{
				if (FormGetObjectPointer(CHECKBOX_VE_H, &object_type, (void**)&control_ptr) == TRUE)
				{
					if (control_ptr->control_attr.control_visible)
					{
						FormSetControlGroupSelection(FORM_VE_EMAIL_NAME, CHECKBOX_VE_H);
						Event->eventType    = EVT_CONTROL_SELECT;
                        Event->eventID      = CHECKBOX_VE_H;
                        Event->evtPBP       = NULL;
                    }                        
                }                    
            }
			
        }       
    }                    
	
	
	switch(Event->eventType)
	{
	case EVT_FIELD_MODIFIED:
	case EVT_TEXTBOX_MODIFIED:
		addr_edit_dirty = 1;
		break;		
	case EVT_FORM_OPEN:
		app_status = VE_EMAIL_NAME;
		FormDrawForm(FORM_VE_EMAIL_NAME);
#ifdef DEBUG
		printf("\n === inside emailveemailname ===== ");
#endif
	case EVT_MENU_SELECT_ITEM:
		MenuItemSelectedAction((USHORT)(Event->para1));
		return TRUE;
	case EVT_CONTROL_POPUP_SELECT:
		ControlPopupGetTotalItems (POPUP_TRIGGER_CATE, &popup_total_num_items);
		if (popup_total_num_items == ((USHORT)(Event->para1) + 1))
		{		
			ListInitList(LIST_CATE);
			num_cate = DataCategorySort(email_dbid,cate);
			ListDeleteAllItems(LIST_CATE);
			cate_name = (BYTE*)qmalloc(30*sizeof(BYTE));
			for (i = 0; i < num_cate; i++)
			{
				DataCategoryName(email_dbid,cate[i],cate_name);
				ListInsertItem(LIST_CATE,i,cate_name);
			}
			qfree(cate_name);
			ScrollbarInitScrollbar(SCROLLBAR_CATE);
			EmailEditCateSetScrollbar();
			edit_cate_in_action = FROM_EDIT;
			EmailChangeFontSize(FORM_EDIT_CATE, font_size);
			FormPopupForm(FORM_EDIT_CATE);                 
		}
		else
		{
			if (temp_cate != NULL)
				qfree(temp_cate);
			temp_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
			ControlPopupGetPopupItem(POPUP_TRIGGER_CATE, (USHORT)(Event->para1), &item_text);
			strcpy(temp_cate, item_text);
		}
		addr_edit_dirty = 1;
		break;
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_VE_DEL)
		{
			FormInitAllFormObjects(FORM_ADD_ERASE);
			EmailVEEmailNameDelSetupScreen();
			FormPopupForm(FORM_ADD_ERASE);
			return TRUE;
		}
		else if (Event->eventID == CHECKBOX_VE_C ||
			Event->eventID == CHECKBOX_VE_H)
			addr_edit_dirty = 1;                
		break;
	case PEN_EVENT:
		bounds.xcoord = 3;
		bounds.ycoord = 18;
		bounds.width = 157;
		bounds.height = 122;
		xcoord = (SHORT)Event->para1;
		ycoord = (SHORT)Event->para2;
		if (Event->eventID == PEN_DOWN && ve_email_name_status.status == VIEW &&
			xcoord >= bounds.xcoord && (xcoord < bounds.xcoord + bounds.width) &&
			(ycoord >= bounds.ycoord) && (ycoord < bounds.ycoord + bounds.height))
		{
			if (MemoryLow || (entry_low_memory && entry_old_edit))
			{
				view_to_edit = TRUE;
				low_memory_form_id = FORM_VE_EMAIL_NAME;
				FormPopupForm(FORM_EM_LOW_MEMORY);
				return TRUE;
			}			
			else if (gf_entry && entry_old_edit)
			{         	
				gf_in_form_id = FORM_VE_EMAIL_NAME;
				FormPopupForm(FORM_EM_DISCARD_CHANGES);
				return TRUE;
			}	                						    
			SetVEEmailNameStatus(EDIT, ve_email_name_status.company, ve_email_name_status.home, 
				ve_email_name_status.rec_id, ve_email_name_status.dbid, FALSE);
			EmailSetupViewEditEmailNameScreen();
			FormDrawForm(FORM_VE_EMAIL_NAME);
			return TRUE;
		}
		break;
	case EVT_FIELD_CHANGED:
		if (ve_email_name_status.status == EDIT && ve_email_name_status.dbid == pb_dbid)
		{
			EmailSetupViewEditEmailNameScreen();
			EmailVEEmailNameDrawObjects();
		}
		return TRUE;
	case EVT_KEY:
		if (Event->eventID == SOFT_KEY && ve_email_name_status.status == EDIT && (Event->para2 & 0x300) == 0)
		{
			FormGetActiveObject(FORM_VE_EMAIL_NAME,&tempID);
			if (tempID == TEXTBOX_LAST_NAME || tempID == TEXTBOX_FIRST_NAME)
			{
				if ((BYTE)(Event->para1) != 13)
					TextboxAddKeyInChar(tempID, (BYTE)(Event->para1));
				return TRUE;
			}
			else if  (tempID == FIELD_C_EMAIL || tempID == FIELD_H_EMAIL)
			{
				FieldAddKeyInChar(tempID, (BYTE)(Event->para1));
				return TRUE;
			}
		}
		break;	
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			if (ve_email_name_status.status == VIEW)
			{
				ListSetSelectedItem(LIST_NAME, -1);
				ListSetSelectedItem(LIST_EMAIL, -1);
				FormGetObjectPointer(POPUP_TRIGGER_CATE, &object_type, (void **)&addr);
				((Control*)addr)->control_attr.control_enable = TRUE;
				((Control*)addr)->control_attr.control_visible = TRUE;
				EmailCateNameToPopupTrigger(email_dbid);
				if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate, &item_num) == TRUE)
					ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
				else
					ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
				EmailChangeFontSize(FORM_EMAIL_NAME_LIST, font_size);
				FormPopupForm(FORM_EMAIL_NAME_LIST);
				return TRUE;
			}
			else if (ve_email_name_status.status == EDIT &&
				Event->para1 == INLAY_EXIT)
			{
				if (addr_edit_dirty == 1)
				{
					if (EmailVEEmailNameCheckRecordEmpty())
					{
						if (ve_email_name_status.new_record)
						{
							if (new_name_in_action == MAIL_LIST)
							{
								new_name_in_action = ADDRESS_LIST;
								FormSetFormActiveObject(FORM_MAIL_LIST, mail_list_insert_pt.field_id);
								FieldSetInsertPointPositionByCharPos(mail_list_insert_pt.field_id, mail_list_insert_pt.insert_pt_char_pos);
								FieldSetInsertPointOn(mail_list_insert_pt.field_id);
								EmailChangeFontSize(FORM_MAIL_LIST, font_size);
								FormPopupForm(FORM_MAIL_LIST);
								return TRUE;
							}
							else
							{
								whole_name = (BYTE*)qmalloc(200*sizeof(BYTE));
								if (ListGetListItem(LIST_NAME, 0, &item_text) == TRUE)
									strcpy(whole_name, item_text);                   
								else strcpy(whole_name, (BYTE*)(""));                            
								ListSetSelectedItem(LIST_NAME, -1);
								ListSetSelectedItem(LIST_EMAIL, -1);
								FormGetObjectPointer(POPUP_TRIGGER_CATE, &object_type, (void **)&addr);
								((Control*)addr)->control_attr.control_enable = TRUE;
								EmailCateNameToPopupTrigger(email_dbid);
								if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate, &item_num) == TRUE) 
									ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
								else
									ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
								if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate,
									&item_num) == TRUE) 
								{
									ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
									EmailRecordToList(current_cate, char_start, whole_name);
								}
								else
								{
									ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
									EmailRecordToList(EMALL, EMCHARA, NULL);
								}
								EmailChangeFontSize(FORM_EMAIL_NAME_LIST, font_size);
								FormPopupForm(FORM_EMAIL_NAME_LIST);
								return TRUE;
							}
						}
						else
						{
							FormInitAllFormObjects(FORM_ADD_ERASE);
							EmailVEEmailNameDelSetupScreen();
							FormPopupForm(FORM_ADD_ERASE);
							return TRUE;
						}
					}					
					else
					{
						FormPopupForm(FORM_SAVE_CHANGES);
						return TRUE;
					}
				}
				else
				{
					if (new_name_in_action == MAIL_LIST)
					{
						new_name_in_action = ADDRESS_LIST;
						FormSetFormActiveObject(FORM_MAIL_LIST, mail_list_insert_pt.field_id);
						FieldSetInsertPointPositionByCharPos(mail_list_insert_pt.field_id, mail_list_insert_pt.insert_pt_char_pos);
						FieldSetInsertPointOn(mail_list_insert_pt.field_id);
						EmailChangeFontSize(FORM_MAIL_LIST, font_size);
						FormPopupForm(FORM_MAIL_LIST);
						return TRUE;
					}
					else
					{
						whole_name = (BYTE*)qmalloc(200*sizeof(BYTE));
						FormGetObjectPointer(LIST_NAME, &object_type, (void**)&list_ptr);
						if (ListGetListItem(LIST_NAME, 0, &item_text) == TRUE &&
							list_ptr->list_attr.list_drawn)
							strcpy(whole_name, item_text);                   
						else strcpy(whole_name, (BYTE*)(""));                            
						ListSetSelectedItem(LIST_NAME, -1);
						ListSetSelectedItem(LIST_EMAIL, -1);
						FormGetObjectPointer(POPUP_TRIGGER_CATE, &object_type, (void **)&addr);
						((Control*)addr)->control_attr.control_enable = TRUE;
						EmailCateNameToPopupTrigger(email_dbid);
						if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate, &item_num) == TRUE) 
							ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
						else
							ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
						if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate,
							&item_num) == TRUE) 
						{
							ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
							EmailRecordToList(current_cate, char_start, whole_name);
						}
						else
						{
							ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
							EmailRecordToList(EMALL, EMCHARA, NULL);
						}
						EmailChangeFontSize(FORM_EMAIL_NAME_LIST, font_size);
						FormPopupForm(FORM_EMAIL_NAME_LIST);
						return TRUE;
					}
				}
				}
				else if (ve_email_name_status.status == EDIT &&
					Event->para1 == INLAY_OK)
				{
					if (EmailVEEmailNameCheckRecordEmpty())
					{
						if (!ve_email_name_status.new_record)
							EmailVEEmailNameDeleteRecord(TRUE);
						whole_name = (BYTE*)qmalloc(200*sizeof(BYTE));
						
						if (ListGetListItem(LIST_NAME, 0, &item_text) == TRUE)
							strcpy(whole_name, item_text);						
						else strcpy(whole_name, (BYTE*)(""));
					}							
					else
					{
						FormGetObjectPointer(TEXTBOX_LAST_NAME, &object_type, (void**)&textbox_ptr);
						FormGetObjectPointer(TEXTBOX_FIRST_NAME, &object_type, (void**)&textbox_ptr1);
						whole_name = (BYTE*)qmalloc(200*sizeof(BYTE));
						EmailCombineFirstLastName(textbox_ptr1->textbox_string, textbox_ptr->textbox_string, &whole_name);	
						if (strlen(whole_name) == 0)
						{
							qfree(whole_name);
							return FALSE;
						}
						EmailVEEmailNameSaveRecord();
						qfree(current_cate);
						current_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
						strcpy(current_cate, save_cate);
						char_start = save_first_letter;
					}
					if (new_name_in_action == MAIL_LIST)
					{
						new_name_in_action = ADDRESS_LIST;
						FormSetFormActiveObject(FORM_MAIL_LIST, mail_list_insert_pt.field_id);
						FieldSetInsertPointPositionByCharPos(mail_list_insert_pt.field_id, mail_list_insert_pt.insert_pt_char_pos);
						FieldSetInsertPointOn(mail_list_insert_pt.field_id);
                        EmailChangeFontSize(FORM_MAIL_LIST, font_size);
						FormPopupForm(FORM_MAIL_LIST);
						return TRUE;
					}
					ListSetSelectedItem(LIST_NAME, -1);
					ListSetSelectedItem(LIST_EMAIL, -1);
					FormGetObjectPointer(POPUP_TRIGGER_CATE, &object_type, (void **)&addr);
					((Control*)addr)->control_attr.control_enable = TRUE;
					EmailCateNameToPopupTrigger(email_dbid);
					if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate, &item_num) == TRUE) 
						ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
					else
						ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
					if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate,
						&item_num) == TRUE) 
					{
						ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
						EmailRecordToList(current_cate, char_start, whole_name);
					}
					else
					{
						ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
						EmailRecordToList(EMALL, EMCHARA, NULL);
					}
					qfree(whole_name);
                    EmailChangeFontSize(FORM_EMAIL_NAME_LIST, font_size);
					FormPopupForm(FORM_EMAIL_NAME_LIST);
					return TRUE;
				}
			}
			break;
		default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailSaveChanges
* Purpose: 	This function is the event handler for the SAVE CHANGES
page of the Email application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailSaveChanges(EvtType *Event)
{
	BYTE object_type;
	USHORT item_num;
	void *addr;
	Textbox *textbox_ptr, *textbox_ptr1;
	BYTE *whole_name = NULL;
	
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_YES	|| Event->para1 == SLETTER_YES)
			{
                Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_SAVE_CHANGES_YES;
                Event->evtPBP       = NULL;
            }
			else if (Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_SAVE_CHANGES_NO;
                Event->evtPBP       = NULL;
            }
			else if (Event->para1 == LLETTER_X || Event->para1 == LLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = BITMAP_SAVE_CHANGES;
                Event->evtPBP       = NULL;
				
            }
        }       
    }                    
	
	
	switch(Event->eventType)
	{
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_SAVE_CHANGES_YES)
		{
			FormGetObjectPointer(TEXTBOX_LAST_NAME, &object_type, (void**)&textbox_ptr);
			FormGetObjectPointer(TEXTBOX_FIRST_NAME, &object_type, (void**)&textbox_ptr1);
			whole_name = (BYTE*)qmalloc(200*sizeof(BYTE));
			EmailCombineFirstLastName(textbox_ptr1->textbox_string, textbox_ptr->textbox_string, &whole_name);	
			if (strlen(whole_name) == 0)
			{
				qfree(whole_name);
				return FALSE;
			}
			EmailVEEmailNameSaveRecord();
		}
		if (new_name_in_action == MAIL_LIST)
		{
			new_name_in_action = ADDRESS_LIST;
			FormSetFormActiveObject(FORM_MAIL_LIST, mail_list_insert_pt.field_id);
			FieldSetInsertPointPositionByCharPos(mail_list_insert_pt.field_id, mail_list_insert_pt.insert_pt_char_pos);
			FieldSetInsertPointOn(mail_list_insert_pt.field_id);
			EmailChangeFontSize(FORM_MAIL_LIST, font_size);
			FormPopupForm(FORM_MAIL_LIST);
			return TRUE;
		}
		ListSetSelectedItem(LIST_NAME, -1);
		ListSetSelectedItem(LIST_EMAIL, -1);
		FormGetObjectPointer(POPUP_TRIGGER_CATE, &object_type, (void **)&addr);
		((Control*)addr)->control_attr.control_enable = TRUE;
		EmailCateNameToPopupTrigger(email_dbid);
		if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate, &item_num) == TRUE) 
			ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
		else
			ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
		if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate,
			&item_num) == TRUE) 
		{
			ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
			EmailRecordToList(current_cate, char_start, whole_name);
		}
		else
		{
			ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
			EmailRecordToList(EMALL, EMCHARA, whole_name);
		}
		EmailChangeFontSize(FORM_EMAIL_NAME_LIST, font_size);
		FormPopupForm(FORM_EMAIL_NAME_LIST);
		return TRUE;
	case EVT_BITMAP_SELECT:
		FormPopupForm(FORM_VE_EMAIL_NAME);
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SAVE_CHANGES);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailVEEmailNameDelConfirm
* Purpose: 	This function is called to handle the event occured in the 
View Edit Email Name Del Confirmation screen of phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailVEEmailNameDelConfirm(EvtType *Event)
{
	BOOLEAN value;
	BYTE object_type;
	void *addr;
	USHORT item_num;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
                Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_ADD_ERASE_YES;
                Event->evtPBP       = NULL;
            }
			else if (Event->para1 == LLETTER_NO	|| Event->para1 == SLETTER_NO)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_ADD_ERASE_NO;
                Event->evtPBP       = NULL;
            }
        }       
    }                    
	
	
	switch(Event->eventType)
	{
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_ADD_ERASE_YES)
		{
			if (ve_email_name_status.dbid == email_dbid)
			{
				FormGetControlValue(CHECKBOX_ADD_ERASE, &value);
				EmailVEEmailNameDeleteRecord(value);
			}
			else
				EmailVEEmailNameDeleteRecord(FALSE);
			ListSetSelectedItem(LIST_NAME, -1);
			ListSetSelectedItem(LIST_EMAIL, -1);
			FormGetObjectPointer(POPUP_TRIGGER_CATE, &object_type, (void **)&addr);
			((Control*)addr)->control_attr.control_enable = TRUE;
			((Control*)addr)->control_attr.control_visible = TRUE;
			EmailCateNameToPopupTrigger(email_dbid);
			if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate, &item_num) == TRUE) 
				ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
			else
				ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
			if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate,
				&item_num) == TRUE) 
			{
				ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
				EmailRecordToList(current_cate, char_start,NULL);
			}
			else
			{
				ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
				EmailRecordToList(EMALL, EMCHARA,NULL);
			}
			EmailChangeFontSize(FORM_EMAIL_NAME_LIST, font_size);
			FormPopupForm(FORM_EMAIL_NAME_LIST);
			return TRUE;
		}
		else if (Event->eventID == BUTTON_ADD_ERASE_NO)
		{
			FormPopupForm(FORM_VE_EMAIL_NAME);
			return TRUE;
		}
		break;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_ADD_ERASE);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailEmailMessageList
* Purpose: 	This function is called to handle the event occured in the 
Edit Message Listing mode screen of phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailEmailMessageList(EvtType *Event)
{
    AppID   appid = 0xFFFF;
    BYTE    *buffer;
    UWORD   byte_read;
    BYTE    object_type;
    Control *control_ptr;
    
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_EMAIL_MESS_NEW || Event->para1 == SLETTER_EMAIL_MESS_NEW)
			{
                Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_EMAIL_MESS_NEW;
                Event->evtPBP       = NULL;
            }
			else if (Event->para1 == LLETTER_CONNECT || Event->para1 == SLETTER_CONNECT)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_EMAIL_MESS_CONNECT;
                Event->evtPBP       = NULL;
            }
			else if (Event->para1 == LLETTER_CATE)
			{
                ControlPopupPopupTrigger(POPUP_TRIGGER_EMAIL_BOX);
                return TRUE;
            }            
            else if (Event->para2 == 0x215 || Event->para2 == 0x21c)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_EMAIL_MESS, SCROLLBAR_UP_ARROW);            
                return TRUE;            
            }
            else if (Event->para2 == 0x216 || Event->para2 == 0x21d)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_EMAIL_MESS, SCROLLBAR_DOWN_ARROW);            
                return TRUE;            
            }                                
        }       
    }                    
	
	switch (Event->eventType)
	{
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			SysGetAppID(MAINMENU, &appid);
			EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
			EvtAppendEvt(EVT_APP_LAUNCH, appid, 0, 0, NULL);
		}
		return TRUE;        
	case EVT_LIST_SELECT:
		addr_edit_dirty = 0;
		emess_edit_dirty = 0;
		EmailMessListSelectedItemAction(&list_email_mess, Event);
		EmailEditSetScreen();
		EmailChangeFontSize(FORM_EDIT, font_size);
		FormPopupForm(FORM_EDIT);
		return TRUE;
#ifdef PR31700 
	case EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{
			if (Event->para2 == IO_UP_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_EMAIL_MESS, SCROLLBAR_UP_ARROW);
			else if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_EMAIL_MESS, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		return FALSE;
#endif
	case EVT_SCROLLBAR_SELECT:
		ScrollbarDrawScrollbar(SCROLLBAR_EMAIL_MESS);
		break;
	case EVT_SCROLLBAR_REPEAT:
		EmailScrollbarSetEmailMessageList(Event);
		break;
	case EVT_CONTROL_POPUP_SELECT:
		if (EmailEmailMessagePopupCateActions((SHORT)(Event->para1)) == TRUE)
			return TRUE;
		break;
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_EMAIL_MESS_NEW)
		{
			if (MemoryLow || (entry_low_memory && entry_old_edit))
			{
				low_memory_form_id = FORM_EMAIL_MESS_LIST;
				FormPopupForm(FORM_EM_LOW_MEMORY);
				return TRUE;
			}						
			else if (gf_entry && entry_old_edit)
			{         	
				gf_in_form_id = FORM_EMAIL_MESS_LIST;
				FormPopupForm(FORM_EM_DISCARD_CHANGES);
				return TRUE;
			}	                						    
			
			
			addr_edit_dirty = 0;
			emess_edit_dirty = 0;
			FormInitAllFormObjects(FORM_EDIT);
			FormInitAllFormObjects(FORM_MAIL_LIST);
			SetEditEntryStatus(EDIT, 0, DRAFT, TRUE);
			EmailEditSetScreen();
			FieldSetInsertPointOn(FIELD_EDIT_1);
			FieldSetInsertPointPositionByCharPos(FIELD_EDIT_1, 0);
			FormSetFormActiveObject(FORM_EDIT, FIELD_EDIT_1);
			EmailChangeFontSize(FORM_EDIT, font_size);
			FormPopupForm(FORM_EDIT);
			return TRUE;
		}
		else if (Event->eventID == BUTTON_EMAIL_MESS_CONNECT)
		{
			if (MemoryLow)
			{
				low_memory_form_id = FORM_EMAIL_MESS_LIST;
				FormPopupForm(FORM_EM_LOW_MEMORY);
				return TRUE;
			}	                	
			
			SysGetAppID(NETMGR, &appid);
			
			if (SysCheckModemExist() && appid != 0xFFFF)			
			{	
				FormInitAllFormObjects(FORM_DIAL);
				
				DataGetField(emess_dbid, EMAIL_DIAL, 0, &buffer, &byte_read);
				TextboxSetText(TEXTBOX_DIAL, buffer);
				qfree(buffer);
				DataGetField(emess_dbid, EMAIL_DIAL, 1, &buffer, &byte_read);
				TextboxSetText(TEXTBOX_DIAL_OUT, buffer);
				qfree(buffer);
				DataGetField(emess_dbid, EMAIL_DIAL, 2, &buffer, &byte_read);
				FormGetObjectPointer(CHECKBOX_DIAL_OUT, &object_type, (void**)&control_ptr);
				((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = *(BOOLEAN*)buffer;
				qfree(buffer);
				
				DataGetField(emess_dbid, EMAIL_DIAL, 4, &buffer, &byte_read);
				if ((*(ObjectID*)buffer) != 0)
				{           
					FormGetObjectPointer((*(ObjectID*)buffer), &object_type, (void**)&control_ptr);
					((ControlTemplatePushButton*)(control_ptr->control_template))->control_value = TRUE;
				}                
				qfree(buffer);            
				
				EmailDialSetScreen();
				FormPopupForm(FORM_DIAL);
				dial_in_action = FROM_EMESS_LIST;
				email_dial_first_in = 1;
			}
			else
			{
				dial_in_action = FROM_EMESS_LIST;
				FormPopupForm(FORM_PROGRAM_MISSING);
			}				
			return TRUE;
		}
		break;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_EMAIL_MESS_LIST);
		SetEmailMessTop(0, FALSE);
		break;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailEdit
* Purpose: 	This function is the event handler for the NEW DRAFT
page of the Email application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailEdit(EvtType *Event)
{
	EvtType         new_event;
	ObjectID        activeID;
	SHORT           xcoord, ycoord;
	BYTE            object_type;
	Table           *table_ptr;
	UBYTE           cat;
	UBYTE           email_box;
	RecordID        top_rec_id;
	SHORT           item_num;
    Scrollbar       *scrollbar_ptr;
    Field           *field_ptr;
    Control         *control_ptr;
    Bitmap          *bitmap_ptr;
    AppID           appid;
    BYTE            *buffer;
    UWORD           byte_read;
	
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_TO	|| Event->para1 == SLETTER_TO)
			{
				if (FormGetObjectPointer(BITMAP_EDIT_TO, &object_type, (void**)&bitmap_ptr) == TRUE)
				{
					if (bitmap_ptr->bitmap_attr.bitmap_visible && bitmap_ptr->bitmap_attr.bitmap_enable)
					{
                        Event->eventType    = EVT_BITMAP_SELECT;
                        Event->eventID      = BITMAP_EDIT_TO;
                        Event->evtPBP       = NULL;
                    }
                }                                            
            }
			else if (Event->para1 == LLETTER_RESEND || Event->para1 == SLETTER_RESEND)
			{
				if (FormGetObjectPointer(BUTTON_EDIT_RESEND, &object_type, (void**)&control_ptr) == TRUE)
				{
					if (control_ptr->control_attr.control_visible)
					{
                        Event->eventType    = EVT_CONTROL_SELECT;
                        Event->eventID      = BUTTON_EDIT_RESEND;
                        Event->evtPBP       = NULL;
                    }
                }                                            
            }
			else if (Event->para1 == LLETTER_REPLY	|| Event->para1 == SLETTER_REPLY)
			{
				if (FormGetObjectPointer(BUTTON_EDIT_REPLY, &object_type, (void**)&control_ptr) == TRUE)
				{
					if (control_ptr->control_attr.control_visible)
					{
                        Event->eventType    = EVT_CONTROL_SELECT;
                        Event->eventID      = BUTTON_EDIT_REPLY;
                        Event->evtPBP       = NULL;
                    }
                }                                            
            }
			else if (Event->para1 == LLETTER_FORWARD || Event->para1 == SLETTER_FORWARD)
			{
				if (FormGetObjectPointer(BUTTON_EDIT_FORWARD, &object_type, (void**)&control_ptr) == TRUE)
				{
					if (control_ptr->control_attr.control_visible)
					{
                        Event->eventType    = EVT_CONTROL_SELECT;
                        Event->eventID      = BUTTON_EDIT_FORWARD;
                        Event->evtPBP       = NULL;
                    }
                }                                            
            }
			else if (Event->para1 == LLETTER_DEL || Event->para1 == SLETTER_DEL)
			{
				if (FormGetObjectPointer(BUTTON_EDIT_DEL, &object_type, (void**)&control_ptr) == TRUE)
				{
					if (control_ptr->control_attr.control_visible)
					{
                        Event->eventType    = EVT_CONTROL_SELECT;
                        Event->eventID      = BUTTON_EDIT_DEL;
                        Event->evtPBP       = NULL;
                    }
                }                                            
            }
			else if (Event->para1 == LLETTER_SEND || Event->para1 == SLETTER_SEND)
			{
				if (FormGetObjectPointer(BUTTON_EDIT_SEND, &object_type, (void**)&control_ptr) == TRUE)
				{
					if (control_ptr->control_attr.control_visible)
					{
                        Event->eventType    = EVT_CONTROL_SELECT;
                        Event->eventID      = BUTTON_EDIT_SEND;
                        Event->evtPBP       = NULL;
                    }
                }                                            
            }
			else if (Event->para1 == LLETTER_CONNECT || Event->para1 == SLETTER_CONNECT)
			{
				if (FormGetObjectPointer(BUTTON_EDIT_CONNECT, &object_type, (void**)&control_ptr) == TRUE)
				{
					if (control_ptr->control_attr.control_visible)
					{
                        Event->eventType    = EVT_CONTROL_SELECT;
                        Event->eventID      = BUTTON_EDIT_CONNECT;
                        Event->evtPBP       = NULL;
                    }
                }                                            
            }
			else if (Event->para1 == LLETTER_SAVE || Event->para1 == SLETTER_CONNECT)
			{
				if (FormGetObjectPointer(BUTTON_EDIT_SAVE, &object_type, (void**)&control_ptr) == TRUE)
				{
					if (control_ptr->control_attr.control_visible)
					{
                        Event->eventType    = EVT_CONTROL_SELECT;
                        Event->eventID      = BUTTON_EDIT_SAVE;
                        Event->evtPBP       = NULL;
                    }
                }                                            
            }
            else if (Event->para2 == 0x215 || Event->para2 == 0x21c)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_EDIT, SCROLLBAR_UP_ARROW);            
                return TRUE;            
            }
            else if (Event->para2 == 0x216 || Event->para2 == 0x21d)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_EDIT, SCROLLBAR_DOWN_ARROW);            
                return TRUE;            
            }                                
        }       
    }                    
	
	switch(Event->eventType)
	{
	case EVT_FIELD_MODIFIED:
	case EVT_TEXTBOX_MODIFIED:
		emess_edit_dirty = 1;
		break;		
	case EVT_MENU_SELECT_ITEM:
		MenuItemSelectedAction((USHORT)(Event->para1));
		return TRUE;
	case PEN_EVENT:
		FormGetObjectPointer(TABLE_EDIT, &object_type, (void**)&table_ptr);
		xcoord = (SHORT)Event->para1;
		ycoord = (SHORT)Event->para2;
		if (Event->eventID == PEN_DOWN &&
			table_ptr->table_attr.table_enable == FALSE && edit_entry_status.status == VIEW &&
			xcoord >= 0 && xcoord <= 159 && ycoord >= 0 && ycoord <= 159)
		{
			if ((MemoryLow || (entry_low_memory && entry_old_edit)) && (cat == OUTBOX || cat == DRAFT || cat == SENT || (cat == INBOX && rf_action == 1)))
			{
				view_to_edit = TRUE;
				low_memory_form_id = FORM_EDIT;
				FormPopupForm(FORM_EM_LOW_MEMORY);
				return TRUE;
			}			
			
			if (edit_entry_status.new_record != TRUE)
			{
				DataRecordInfo(emess_dbid, edit_entry_status.rec_id, NULL, &cat, NULL, NULL, NULL);
				if (gf_entry && entry_old_edit && cat != INBOX)
				{         	
					gf_in_form_id = FORM_EDIT;
					FormPopupForm(FORM_EM_DISCARD_CHANGES);
					return TRUE;
				}	                						    
				
				if (cat == OUTBOX)
				{
					SetEditEntryStatus(EDIT, edit_entry_status.rec_id, OUTBOX, FALSE);
					SetMailListEntryStatus(EDIT, 0, 0, FALSE);  					  
				}
				else if (cat == DRAFT)
				{
					SetEditEntryStatus(EDIT, edit_entry_status.rec_id, DRAFT, FALSE);
					SetMailListEntryStatus(EDIT, 0, 0, FALSE);  					              	
				}
				else if (cat == SENT/* || cat == DRAFT*/)
				{       
					SetEditEntryStatus(EDIT, edit_entry_status.rec_id, cat, TRUE);
					SetMailListEntryStatus(EDIT, 0, 0, FALSE);  					  
				}
				else if (cat == INBOX && rf_action == 0)
					return TRUE;                               
			}
			EmailEditSetScreen();
			TableUpdateObjectScreenBounds(TABLE_EDIT, BITMAP_EDIT_TO);
			if (edit_entry_status.status != VIEW && cat != INBOX)      
				BitmapDrawBitmap(BITMAP_EDIT_TO);
			FieldSetInsertPointOn(FIELD_EDIT_2);
			FieldSetInsertPointPositionByCharPos(FIELD_EDIT_2, 0);
			FormSetFormActiveObject(FORM_EDIT, FIELD_EDIT_2);
			FormDrawForm(FORM_EDIT);
			return TRUE;
		}   
		break;
	case EVT_INLAY_SELECT:
		EmailCateNameToPopupTrigger(email_dbid);
		if ((Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT) && edit_entry_status.status == VIEW)
		{
			ListSetSelectedItem(LIST_EMAIL_MESS_NAME, -1);
			ListSetSelectedItem(LIST_EMAIL_MESS_SUB, -1);
			ListSetSelectedItem(LIST_EMAIL_MESS_TIME, -1);
			EmailRecordToEmailMessageList(current_email_box, char_start_email_box);
			FormPopupForm(FORM_EMAIL_MESS_LIST);
			return TRUE;
		}
		else if (edit_entry_status.status == EDIT)
		{
			if (Event->para1 == INLAY_OK)
			{
				EmailMessageSave(&email_box, &top_rec_id);
				if (rf_action != 0)
				{
					rf_action = 0;
					ListGetSelectedItem(LIST_EMAIL_MESS_NAME, &item_num);
					new_event.eventType = EVT_LIST_SELECT;
					new_event.eventID = LIST_EMAIL_MESS_NAME;
					new_event.para1 = item_num;
					new_event.para2 = 0;
					new_event.evtPBP = NULL;
					EmailMessListSelectedItemAction(&list_email_mess, &new_event);
					if (DataRecordInfo(emess_dbid, edit_entry_status.rec_id, NULL, NULL, NULL, NULL, NULL) != TRUE)
					{
						if (current_email_box != NULL)
							qfree(current_email_box);
						current_email_box = (BYTE*)qmalloc(7*sizeof(BYTE));
						if (email_box == DRAFT)
						{
							strcpy(current_email_box, EMDRAFT);								
							ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, 3);
						}
						else if (email_box == OUTBOX)
						{
							ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, 1);
							strcpy(current_email_box, EMOUTBOX);
						}
						ListSetSelectedItem(LIST_EMAIL_MESS_NAME, -1);
						ListSetSelectedItem(LIST_EMAIL_MESS_SUB, -1);
						ListSetSelectedItem(LIST_EMAIL_MESS_TIME, -1);
						SetEmailMessTop(top_rec_id, TRUE);
						EmailRecordToEmailMessageList(current_email_box, char_start_email_box);
						FormPopupForm(FORM_EMAIL_MESS_LIST);
					}
					else FormPopupForm(FORM_EDIT);
				}
				else 
				{
					if (current_email_box != NULL)
						qfree(current_email_box);
					current_email_box = (BYTE*)qmalloc(7*sizeof(BYTE));
					if (email_box == DRAFT)
					{
						strcpy(current_email_box, EMDRAFT);								
						ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, 3);
					}
					else if (email_box == OUTBOX)
					{
						ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, 1);
						strcpy(current_email_box, EMOUTBOX);
					}
					ListSetSelectedItem(LIST_EMAIL_MESS_NAME, -1);
					ListSetSelectedItem(LIST_EMAIL_MESS_SUB, -1);
					ListSetSelectedItem(LIST_EMAIL_MESS_TIME, -1);
					SetEmailMessTop(top_rec_id, TRUE);
					EmailRecordToEmailMessageList(current_email_box, char_start_email_box);
					FormPopupForm(FORM_EMAIL_MESS_LIST);
				}
				return TRUE;
			}
			else if (Event->para1 == INLAY_EXIT)
			{
				if (emess_edit_dirty == 1)
					FormPopupForm(FORM_EMESS_SAVE_CHANGES);
				else
				{
					if (rf_action != 0 && DataRecordInfo(emess_dbid, edit_entry_status.rec_id, NULL, NULL, NULL, NULL, NULL) == TRUE)
					{
						rf_action = 0;
						ListGetSelectedItem(LIST_EMAIL_MESS_NAME, &item_num);
						new_event.eventType = EVT_LIST_SELECT;
						new_event.eventID = LIST_EMAIL_MESS_NAME;
						new_event.para1 = item_num;
						new_event.para2 = 0;
						new_event.evtPBP = NULL;
						EmailMessListSelectedItemAction(&list_email_mess, &new_event);
						EmailChangeFontSize(FORM_EDIT, font_size);
						FormPopupForm(FORM_EDIT);
						return TRUE;
					}
					else
					{
						ListSetSelectedItem(LIST_EMAIL_MESS_NAME, -1);
						ListSetSelectedItem(LIST_EMAIL_MESS_SUB, -1);
						ListSetSelectedItem(LIST_EMAIL_MESS_TIME, -1);
						EmailRecordToEmailMessageList(current_email_box, char_start_email_box);
						FormPopupForm(FORM_EMAIL_MESS_LIST);
						return TRUE;
					}
				}
				return TRUE;	
			}
		}
		break;
		case EVT_BITMAP_SELECT:
            email_mail_list_first_in = 1;
			SetMailListInsertPt(TRUE, FIELD_MAIL_LIST_TO, 0);
			SetMailListEntryStatus(EDIT, 0, 0, FALSE);
			FieldSetInsertPointOn(FIELD_MAIL_LIST_TO);
			FieldSetInsertPointPositionByCharPos(FIELD_MAIL_LIST_TO, 0);
            FormSetFormActiveObject(FORM_MAIL_LIST, FIELD_MAIL_LIST_TO);
            EmailChangeFontSize(FORM_MAIL_LIST, font_size);
			FormPopupForm(FORM_MAIL_LIST);
			return TRUE;
		case EVT_KEYBOARD_STATUS:
			EmailEditSetScreen();
			EmailSetEditTable(FORM_EDIT, TABLE_EDIT);
			EmailEditTableSetScrollbar(TABLE_EDIT, SCROLLBAR_EDIT);
			TableEraseTable(TABLE_EDIT);
			TableDrawTable(TABLE_EDIT);
			return TRUE;
#ifdef PR31700
		case EVT_IO_KEY_CTRL:
			if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
			{
				if (Event->para2 == IO_UP_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_EDIT, SCROLLBAR_UP_ARROW);
				else if (Event->para2 == IO_DOWN_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_EDIT, SCROLLBAR_DOWN_ARROW);
				return TRUE;
			}
			return FALSE;
#endif
		case EVT_SCROLLBAR_SELECT:
            FormGetObjectPointer(SCROLLBAR_EDIT, &object_type, (void**)&scrollbar_ptr);
            FormGetObjectPointer(FIELD_EDIT_4, &object_type, (void**)&field_ptr);
            ScrollbarDrawScrollbar(SCROLLBAR_EDIT);
			return TRUE;
		case EVT_SCROLLBAR_REPEAT:
            FormGetObjectPointer(SCROLLBAR_EDIT, &object_type, (void**)&scrollbar_ptr);
            FormGetObjectPointer(FIELD_EDIT_4, &object_type, (void**)&field_ptr);
            EmailScrollbarSetEditTable(TABLE_EDIT, SCROLLBAR_EDIT, Event);
			return TRUE;
		case EVT_FIELD_CHANGED:
			EmailEditSetScreen();
			if (EmailKeyInChangeEditTable(FORM_EDIT, TABLE_EDIT, SCROLLBAR_EDIT))
				TableDrawTable(TABLE_EDIT);
			return TRUE;
		case EVT_KEY:
			if (Event->eventID == SOFT_KEY && edit_entry_status.status == EDIT && (Event->para2 & 0x300) == 0)
			{
				FormGetActiveObject(FORM_EDIT,&activeID);
				EmailSetEditTable(FORM_EDIT, TABLE_EDIT);
				EmailEditTableSetScrollbar(TABLE_EDIT, SCROLLBAR_EDIT);
				if  (activeID >= FIELD_EDIT_0 && activeID <= FIELD_EDIT_3)
				{
					FieldAddKeyInChar(activeID, (BYTE)(Event->para1));
					return TRUE;
				}
			}
			break;
		case EVT_CONTROL_SELECT:
			gf_in_pressed_object = 0;
			switch(Event->eventID)
			{
			case BUTTON_EDIT_RESEND:
				if (MemoryLow || (entry_low_memory && entry_old_edit))
				{
					view_to_edit = FALSE;
					low_memory_form_id = FORM_EDIT;
					FormPopupForm(FORM_EM_LOW_MEMORY);
					return TRUE;
				}			  		 		  	
				
				if (EmailMessageCheckTOFieldEmpty())
				{
					FormPopupForm(FORM_NO_TO_ADDR);
					return TRUE;
				}
				EmailMessageResend(&top_rec_id);
				if (current_email_box != NULL)
					qfree(current_email_box);
				current_email_box = (BYTE*)qmalloc(7*sizeof(BYTE));
				strcpy(current_email_box, EMOUTBOX);
				EmailRecordToEmailMessageList(current_email_box, char_start_email_box);
				ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, 1);
				ListSetSelectedItem(LIST_EMAIL_MESS_NAME, -1);
				ListSetSelectedItem(LIST_EMAIL_MESS_SUB, -1);
				ListSetSelectedItem(LIST_EMAIL_MESS_TIME, -1);
				FormPopupForm(FORM_EMAIL_MESS_LIST);
				return TRUE;
			case BUTTON_EDIT_REPLY:
				if (MemoryLow || (entry_low_memory && entry_old_edit))
				{
					view_to_edit = FALSE;
					low_memory_form_id = FORM_EDIT;
					FormPopupForm(FORM_EM_LOW_MEMORY);
					return TRUE;
				}										
				else if (gf_entry && entry_old_edit)
				{         	
					gf_in_form_id = FORM_EDIT;
					gf_in_pressed_object = BUTTON_EDIT_REPLY;
					FormPopupForm(FORM_EM_DISCARD_CHANGES);
					return TRUE;
				}	                						    
				
				FormPopupForm(FORM_REPLY_TO);
				return TRUE;
			case BUTTON_EDIT_FORWARD:
				if (MemoryLow || (entry_low_memory && entry_old_edit))
				{
					view_to_edit = FALSE;
					low_memory_form_id = FORM_EDIT;
					FormPopupForm(FORM_EM_LOW_MEMORY);
					return TRUE;
				}										
				else if (gf_entry && entry_old_edit)
				{         	
					gf_in_form_id = FORM_EDIT;
					gf_in_pressed_object = BUTTON_EDIT_FORWARD;
					FormPopupForm(FORM_EM_DISCARD_CHANGES);
					return TRUE;
				}	                						    
				
				
				rf_action = FORWARD;					
				SetEditEntryStatus(EDIT, edit_entry_status.rec_id, INBOX, TRUE);
				EmailEditSetScreen();
				EmailReplyForwardPutData(FORWARD);
				FormSetFormActiveObject(FORM_EDIT, FIELD_EDIT_2);
				FormGetObjectPointer(TABLE_EDIT, &object_type, (void**)&table_ptr);
				table_ptr->table_top_row_num = 0;
				FieldSetInsertPointPositionByCharPos(FIELD_EDIT_2, 0);
				FieldSetInsertPointOn(FIELD_EDIT_2);
				EmailChangeFontSize(FORM_EDIT, font_size);
				FormPopupForm(FORM_EDIT);
				return TRUE;
			case BUTTON_EDIT_DEL:
				SetDelEntryStatus(FORM_EDIT, edit_entry_status.rec_id);
				FormPopupForm(FORM_EMAIL_ERASE);
				return TRUE;
			case BUTTON_EDIT_SEND:
				if (MemoryLow || (entry_low_memory && entry_old_edit))
				{
					view_to_edit = FALSE;
					low_memory_form_id = FORM_EDIT;
					FormPopupForm(FORM_VE_EMAIL_NAME);
					return TRUE;
				}			  		 		  	
				
				if (EmailMessageCheckTOFieldEmpty())
				{
					FormPopupForm(FORM_NO_TO_ADDR);
					return TRUE;
				}
				if (edit_entry_status.new_record == FALSE)
					DataDeleteRecord(emess_dbid, edit_entry_status.rec_id, FALSE);
				EmailMessageResend(&top_rec_id);
				if (rf_action != 0)
				{
					rf_action = 0;
					ListGetSelectedItem(LIST_EMAIL_MESS_NAME, &item_num);
					new_event.eventType = EVT_LIST_SELECT;
					new_event.eventID = LIST_EMAIL_MESS_NAME;
					new_event.para1 = item_num;
					new_event.para2 = 0;
					new_event.evtPBP = NULL;
					EmailMessListSelectedItemAction(&list_email_mess, &new_event);
					if (DataRecordInfo(emess_dbid, edit_entry_status.rec_id, NULL, NULL, NULL, NULL, NULL) != TRUE)
					{
						if (current_email_box != NULL)
							qfree(current_email_box);
						current_email_box = (BYTE*)qmalloc(7*sizeof(BYTE));
						if (email_box == DRAFT)
						{
							strcpy(current_email_box, EMDRAFT);								
							ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, 3);
						}
						else if (email_box == OUTBOX)
						{
							ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, 1);
							strcpy(current_email_box, EMOUTBOX);
						}
						ListSetSelectedItem(LIST_EMAIL_MESS_NAME, -1);
						ListSetSelectedItem(LIST_EMAIL_MESS_SUB, -1);
						ListSetSelectedItem(LIST_EMAIL_MESS_TIME, -1);
						SetEmailMessTop(top_rec_id, TRUE);
						EmailRecordToEmailMessageList(current_email_box, char_start_email_box);
						FormPopupForm(FORM_EMAIL_MESS_LIST);
					}
					else
					{
						EmailChangeFontSize(FORM_EDIT, font_size);
						FormPopupForm(FORM_EDIT);
					}
				}
				else 
				{
					if (current_email_box != NULL)
						qfree(current_email_box);
					current_email_box = (BYTE*)qmalloc(7*sizeof(BYTE));
					strcpy(current_email_box, EMOUTBOX);
					ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, 1);
					ListSetSelectedItem(LIST_EMAIL_MESS_NAME, -1);
					ListSetSelectedItem(LIST_EMAIL_MESS_SUB, -1);
					ListSetSelectedItem(LIST_EMAIL_MESS_TIME, -1);
					SetEmailMessTop(top_rec_id, TRUE);
					EmailRecordToEmailMessageList(current_email_box, char_start_email_box);
					FormPopupForm(FORM_EMAIL_MESS_LIST);
				}
				return TRUE;
			case BUTTON_EDIT_CONNECT:
				if (MemoryLow)
				{
					low_memory_form_id = FORM_EDIT;
					FormPopupForm(FORM_EM_LOW_MEMORY);
					return TRUE;
				}	                	
				
				SysGetAppID(NETMGR, &appid);				
				
				if (SysCheckModemExist() && appid != 0xFFFF)
				{
					FormInitAllFormObjects(FORM_DIAL);
					
					DataGetField(emess_dbid, EMAIL_DIAL, 0, &buffer, &byte_read);
					TextboxSetText(TEXTBOX_DIAL, buffer);
					qfree(buffer);
					DataGetField(emess_dbid, EMAIL_DIAL, 1, &buffer, &byte_read);
					TextboxSetText(TEXTBOX_DIAL_OUT, buffer);
					qfree(buffer);
					DataGetField(emess_dbid, EMAIL_DIAL, 2, &buffer, &byte_read);
					FormGetObjectPointer(CHECKBOX_DIAL_OUT, &object_type, (void**)&control_ptr);
					((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = *(BOOLEAN*)buffer;
					qfree(buffer);
					
					DataGetField(emess_dbid, EMAIL_DIAL, 4, &buffer, &byte_read);
					if ((*(ObjectID*)buffer) != 0)
					{           
						FormGetObjectPointer((*(ObjectID*)buffer), &object_type, (void**)&control_ptr);
						((ControlTemplatePushButton*)(control_ptr->control_template))->control_value = TRUE;
					}                
					qfree(buffer);            
					
					dial_in_action = FROM_EDIT;
					email_dial_first_in = 1;	   
					
					
					EmailDialSetScreen();
					FormPopupForm(FORM_DIAL);
					
				}
				else
				{
					dial_in_action = FROM_EDIT;
					FormPopupForm(FORM_PROGRAM_MISSING);
				}				
				return TRUE;
			case BUTTON_EDIT_SAVE:			
				
				EmailMessageSave(&email_box, &top_rec_id);
				if (rf_action != 0)
				{
					rf_action = 0;
					ListGetSelectedItem(LIST_EMAIL_MESS_NAME, &item_num);
					new_event.eventType = EVT_LIST_SELECT;
					new_event.eventID = LIST_EMAIL_MESS_NAME;
					new_event.para1 = item_num;
					new_event.para2 = 0;
					new_event.evtPBP = NULL;
					EmailMessListSelectedItemAction(&list_email_mess, &new_event);
					if (DataRecordInfo(emess_dbid, edit_entry_status.rec_id, NULL, NULL, NULL, NULL, NULL) != TRUE)
					{
						if (current_email_box != NULL)
							qfree(current_email_box);
						current_email_box = (BYTE*)qmalloc(7*sizeof(BYTE));
						if (email_box == DRAFT)
						{
							strcpy(current_email_box, EMDRAFT);								
							ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, 3);
						}
						else if (email_box == OUTBOX)
						{
							ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, 1);
							strcpy(current_email_box, EMOUTBOX);
						}
						ListSetSelectedItem(LIST_EMAIL_MESS_NAME, -1);
						ListSetSelectedItem(LIST_EMAIL_MESS_SUB, -1);
						ListSetSelectedItem(LIST_EMAIL_MESS_TIME, -1);
						SetEmailMessTop(top_rec_id, TRUE);
						EmailRecordToEmailMessageList(current_email_box, char_start_email_box);
						FormPopupForm(FORM_EMAIL_MESS_LIST);
					}
					else
					{
						EmailChangeFontSize(FORM_EDIT, font_size);
						FormPopupForm(FORM_EDIT);
					}
					addr_edit_dirty = 0;
					emess_edit_dirty = 0;
				}
				else 
				{
					if (current_email_box != NULL)
						qfree(current_email_box);
					current_email_box = (BYTE*)qmalloc(7*sizeof(BYTE));
					if (email_box == DRAFT)
					{
						strcpy(current_email_box, EMDRAFT);								
						ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, 3);
					}
					else if (email_box == OUTBOX)
					{
						ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, 1);
						strcpy(current_email_box, EMOUTBOX);
					}
					ListSetSelectedItem(LIST_EMAIL_MESS_NAME, -1);
					ListSetSelectedItem(LIST_EMAIL_MESS_SUB, -1);
					ListSetSelectedItem(LIST_EMAIL_MESS_TIME, -1);
					SetEmailMessTop(top_rec_id, TRUE);
					EmailRecordToEmailMessageList(current_email_box, char_start_email_box);
					addr_edit_dirty = 0;
					emess_edit_dirty = 0;
					FormPopupForm(FORM_EMAIL_MESS_LIST);
				}
				return TRUE;
			default: return FALSE;
			}
			break;
		case EVT_FORM_OPEN:
			EmailEditSetScreen();
			if (launch_cmd != LAUNCH_CMD_GOTO_REC)
			{			
				EmailSetEditTable(FORM_EDIT, TABLE_EDIT);
				EmailEditTableSetScrollbar(TABLE_EDIT, SCROLLBAR_EDIT);
            }
			else launch_cmd = LAUNCH_CMD_NORMAL_LAUNCH;
            FormDrawForm(FORM_EDIT);
			return TRUE;
		default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailMailList
* Purpose: 	This function is the event handler for the Mail List
page of the Email application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN	EmailMailList(EvtType *Event)
{
	ObjectID    activeID;
	BYTE        *field_string;
	BYTE        *email_addr;
	Control     *control_ptr;
    BYTE        object_type;
    Table       *table_ptr;
    UBYTE       cat;
    SHORT       xcoord, ycoord;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_MAIL_LIST || Event->para1 == SLETTER_MAIL_LIST)
			{
				if (FormGetObjectPointer(BUTTON_MAIL_LIST, &object_type, (void**)&control_ptr) == TRUE)
				{
					if (control_ptr->control_attr.control_visible)
					{
                        Event->eventType    = EVT_CONTROL_SELECT;
                        Event->eventID      = BUTTON_MAIL_LIST;
                        Event->evtPBP       = NULL;
                    }
                }                                            
            }
			else if (Event->para1 == LLETTER_MAIL_LIST_ADD || Event->para1 == SLETTER_MAIL_LIST_ADD)
			{
				if (FormGetObjectPointer(BUTTON_MAIL_LIST_ADD, &object_type, (void**)&control_ptr) == TRUE)
				{
					if (control_ptr->control_attr.control_visible)
					{
                        Event->eventType    = EVT_CONTROL_SELECT;
                        Event->eventID      = BUTTON_MAIL_LIST_ADD;
                        Event->evtPBP       = NULL;
                    }
                }                                            
            }
            else if (Event->para2 == 0x215 || Event->para2 == 0x21c)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_EDIT, SCROLLBAR_UP_ARROW);            
                return TRUE;            
            }
            else if (Event->para2 == 0x216 || Event->para2 == 0x21d)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_EDIT, SCROLLBAR_DOWN_ARROW);            
                return TRUE;            
            }                                
        }       
    }                    
    
	
	switch (Event->eventType)
	{
	case PEN_EVENT:
		FormGetObjectPointer(TABLE_MAIL_LIST, &object_type, (void**)&table_ptr);
		xcoord = (SHORT)Event->para1;
		ycoord = (SHORT)Event->para2;
		if (Event->eventID == PEN_DOWN &&
			table_ptr->table_attr.table_enable == FALSE && mail_list_entry_status.status == VIEW &&
			xcoord >= 0 && xcoord <= 159 && ycoord >= 0 && ycoord <= 159)
		{
			if (MemoryLow || (entry_low_memory && entry_old_edit))
			{
				view_to_edit = TRUE;
				low_memory_form_id = FORM_MAIL_LIST;
				FormPopupForm(FORM_EM_LOW_MEMORY);
				return TRUE;
			}			
			else if (gf_entry && entry_old_edit)
			{         	
				gf_in_form_id = FORM_MAIL_LIST;
				FormPopupForm(FORM_EM_DISCARD_CHANGES);
				return TRUE;
			}	                						    
			
			
			if (edit_entry_status.new_record != TRUE)
			{
				DataRecordInfo(emess_dbid, edit_entry_status.rec_id, NULL, &cat, NULL, NULL, NULL);
				if (cat == OUTBOX || cat == DRAFT)
				{
					SetEditEntryStatus(EDIT, edit_entry_status.rec_id, OUTBOX, FALSE);
					SetMailListEntryStatus(EDIT, 0, 0, FALSE);  					  
				}
				else if (cat == SENT/* || cat == DRAFT*/)
				{       
					SetEditEntryStatus(EDIT, edit_entry_status.rec_id, cat, TRUE);
					SetMailListEntryStatus(EDIT, 0, 0, FALSE);  					  
				}
				else if (cat == INBOX && rf_action == 0)
					return TRUE;                               
			}
			EmailMailListSetScreen();
			FieldSetInsertPointOn(FIELD_MAIL_LIST_TO);
			FieldSetInsertPointPositionByCharPos(FIELD_MAIL_LIST_TO, 0);
			FormSetFormActiveObject(FORM_MAIL_LIST, FIELD_MAIL_LIST_TO);
			FormDrawForm(FORM_MAIL_LIST);
			return TRUE;
		}   
		break;
	case EVT_FIELD_MODIFIED:
	case EVT_TEXTBOX_MODIFIED:
		emess_edit_dirty = 1;
		break;		
	case EVT_MENU_SELECT_ITEM:
		MenuItemSelectedAction((USHORT)(Event->para1));
		return TRUE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			EmailGetFirstEmailAddr(&email_addr);
			FieldSetText(FIELD_EDIT_0, email_addr);
			qfree(email_addr);
			FormGetActiveObject(FORM_EDIT, &activeID);
			if (activeID < FIELD_EDIT_0 && activeID > FIELD_EDIT_4 &&
				edit_entry_status.status == EDIT)
				FormSetFormActiveObject(FORM_EDIT, FIELD_EDIT_1);
			EmailChangeFontSize(FORM_EDIT, font_size);
			FormPopupForm(FORM_EDIT);
		}
		return TRUE;
	case EVT_KEYBOARD_STATUS:
		EmailMailListSetScreen();
		EmailSetEditTable(FORM_MAIL_LIST, TABLE_MAIL_LIST);
		EmailEditTableSetScrollbar(TABLE_MAIL_LIST, SCROLLBAR_MAIL_LIST);
		TableEraseTable(TABLE_MAIL_LIST);
		TableDrawTable(TABLE_MAIL_LIST);
		EmailMailListGetInsertPos();
		return TRUE;
#ifdef PR31700
	case EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{
			if (Event->para2 == IO_UP_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_MAIL_LIST, SCROLLBAR_UP_ARROW);
			else if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_MAIL_LIST, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		return FALSE;
#endif
	case EVT_SCROLLBAR_SELECT:
		EmailMailListGetInsertPos();
		ScrollbarDrawScrollbar(SCROLLBAR_MAIL_LIST);
		return TRUE;
	case EVT_SCROLLBAR_REPEAT:
		EmailMailListGetInsertPos();
		EmailScrollbarSetEditTable(TABLE_MAIL_LIST, SCROLLBAR_MAIL_LIST, Event);
		return TRUE;
	case EVT_FIELD_SELECT:
		EmailMailListGetInsertPos();
		return TRUE;
	case EVT_FIELD_CHANGED:
		EmailMailListSetScreen();
		if (EmailKeyInChangeEditTable(FORM_MAIL_LIST, TABLE_MAIL_LIST, SCROLLBAR_MAIL_LIST))
			TableDrawTable(TABLE_MAIL_LIST);
		EmailMailListGetInsertPos();
		return TRUE;
	case EVT_KEY:
		if (Event->eventID == SOFT_KEY && (Event->para2 & 0x300) == 0)
		{
			FormGetActiveObject(FORM_MAIL_LIST,&activeID);
			if  (activeID >= FIELD_MAIL_LIST_TO && activeID <= FIELD_MAIL_LIST_BCC)
			{
				if ((BYTE)(Event->para1) == ',')
					Event->para1 = '\r';
				FieldAddKeyInChar(activeID, (BYTE)(Event->para1));
				EmailMailListGetInsertPos();
				return TRUE;
			}
		}
		break;
	case EVT_CONTROL_SELECT:
		if (mail_list_insert_pt.insert_pt_on != TRUE) return FALSE;
		if (Event->eventID == BUTTON_MAIL_LIST)
		{
			if (gf_entry && entry_old_edit)
			{         	
				gf_in_form_id = FORM_MAIL_LIST;
				FormPopupForm(FORM_EM_DISCARD_CHANGES);
				return TRUE;
			}	                						    
			
			addr_edit_dirty = 0;		
			name_list_in_action = MAIL_LIST;        							  			
			if (current_cate != NULL)
				qfree(current_cate);
			FormInitAllFormObjects(FORM_EMAIL_NAME_LIST);
			EmailCateNameToPopupTrigger(email_dbid);
			current_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
			strcpy(current_cate, EMALL);
			char_start = EMCHARA;
			ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
			EmailRecordToList(current_cate, char_start, NULL);
			EmailChangeFontSize(FORM_EMAIL_NAME_LIST, font_size);
			FormPopupForm(FORM_EMAIL_NAME_LIST);			  
			return TRUE;
		}
		else
		{
			if (gf_entry && entry_old_edit)
			{         	
				gf_in_form_id = FORM_MAIL_LIST;
				FormPopupForm(FORM_EM_DISCARD_CHANGES);
				return TRUE;
			}	                						    
			
			EmailGetLineOfEmail(&field_string);
			if (strlen(field_string) == 0)
			{
				qfree(field_string);
				return TRUE;
			}		  	 	
			new_name_in_action = MAIL_LIST;		 
			FormInitAllFormObjects(FORM_VE_EMAIL_NAME);
			EmailCateNameToPopupTrigger(email_dbid);
			ControlPopupDeleteItem(POPUP_TRIGGER_CATE, 0);
			if (temp_cate != NULL)
				qfree(temp_cate);
			temp_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
			strcpy(temp_cate, EMUNFILED);
			ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
			SetVEEmailNameStatus(EDIT, TRUE, FALSE, 0, email_dbid, TRUE);
			EmailSetupViewEditEmailNameScreen();
			if (strlen(field_string))
				addr_edit_dirty = 1;
			else addr_edit_dirty = 0;
			FieldSetText(FIELD_C_EMAIL, field_string);
			qfree(field_string);
			FormSetFormActiveObject(FORM_VE_EMAIL_NAME, TEXTBOX_LAST_NAME);
			TextboxSetInsertPointOn(TEXTBOX_LAST_NAME);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_LAST_NAME, 0);
			FormPopupForm(FORM_VE_EMAIL_NAME);
			return TRUE;
		}
		break;
	case EVT_FORM_OPEN:
		EmailMailListGetInsertPos();
		EmailMailListSetScreen();
		EmailSetEditTable(FORM_MAIL_LIST, TABLE_MAIL_LIST);
		EmailEditTableSetScrollbar(TABLE_MAIL_LIST, SCROLLBAR_MAIL_LIST);
		if (email_mail_list_first_in && mail_list_entry_status.status == EDIT)
		{
			SetMailListInsertPt(TRUE, FIELD_MAIL_LIST_TO, 0);
			FormSetFormActiveObject(FORM_MAIL_LIST, FIELD_MAIL_LIST_TO);
			FieldSetInsertPointOn(FIELD_MAIL_LIST_TO);
			FieldSetInsertPointPositionByCharPos(FIELD_MAIL_LIST_TO, 0);
			email_mail_list_first_in = 0;
		}
		FormDrawForm(FORM_MAIL_LIST);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailEmailErase
* Purpose: 	This function is the event handler for the Email Erase Confirm
page of the Email application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN	EmailEmailErase(EvtType *Event)
{
	BOOLEAN     control_value;
	ObjectID    count_id;
	
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
                Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_EMAIL_ERASE_YES;
                Event->evtPBP       = NULL;
            }
			else if (Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
			{
                Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_EMAIL_ERASE_NO;
                Event->evtPBP       = NULL;
            }
        }       
    }                    
	
	
	switch (Event->eventType)
	{
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_EMAIL_ERASE_NO)
		{
			if (del_entry_status.prev_form == FORM_EDIT)
			{
				for (count_id = FIELD_EDIT_0; count_id <= FIELD_EDIT_4; count_id++)
					FieldSetInsertPointOff(count_id);		        			        
			}			        
			FormPopupForm(del_entry_status.prev_form);
		}
		else if (Event->eventID == BUTTON_EMAIL_ERASE_YES)
		{
			FormGetControlValue(CHECKBOX_EMAIL_ERASE, &control_value);
			DataCloseRecord(emess_dbid, del_entry_status.rec_id);
			DataDeleteRecord(emess_dbid, del_entry_status.rec_id, control_value);
			EmailRecordToEmailMessageList(current_email_box, char_start_email_box);
			FormPopupForm(FORM_EMAIL_MESS_LIST);
		}
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_EMAIL_ERASE);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailReplyTo
* Purpose: 	This function is the event handler for the FORM_REPLY_TO
page of the Email application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN	EmailReplyTo(EvtType *Event)
{
	Table	*table_ptr;
	BYTE	object_type;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_REPLY_TO_ALL || Event->para1 == SLETTER_REPLY_TO_ALL)
			{
                Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_REPLY_TO_ALL;
                Event->evtPBP       = NULL;
            }
			else if (Event->para1 == LLETTER_REPLY_SENDER || Event->para1 == SLETTER_REPLY_SENDER)
			{
                Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_REPLY_TO_SENDER;
                Event->evtPBP       = NULL;
            }
			else if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
                Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BITMAP_REPLY_TO_X;
                Event->evtPBP       = NULL;
            }            
        }       
    }                    
	
	
	switch (Event->eventType)
	{
	case EVT_INLAY_SELECT:
		FormPopupForm(FORM_EDIT);
		return TRUE;
	case EVT_BITMAP_SELECT:
		FormPopupForm(FORM_EDIT);
		return TRUE;
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_REPLY_TO_ALL)
		{
			addr_edit_dirty = 0;
			emess_edit_dirty = 0;
			rf_action = REPLY_TO_ALL;					
			SetEditEntryStatus(EDIT, edit_entry_status.rec_id, INBOX, TRUE);
			EmailEditSetScreen();
			EmailReplyForwardPutData(REPLY_TO_ALL);
			FormSetFormActiveObject(FORM_EDIT, FIELD_EDIT_2);
			FormGetObjectPointer(TABLE_EDIT, &object_type, (void**)&table_ptr);
			table_ptr->table_top_row_num = 0;
			FieldSetInsertPointPositionByCharPos(FIELD_EDIT_2, 0);
			FieldSetInsertPointOn(FIELD_EDIT_2);
			EmailChangeFontSize(FORM_EDIT, font_size);
			FormPopupForm(FORM_EDIT);
			return TRUE;
		}
		else
		{
			addr_edit_dirty = 0;
			emess_edit_dirty = 0;
			rf_action = REPLY_TO_SENDER;					
			SetEditEntryStatus(EDIT, edit_entry_status.rec_id, INBOX, TRUE);
			EmailEditSetScreen();
			EmailReplyForwardPutData(REPLY_TO_SENDER);
			FormSetFormActiveObject(FORM_EDIT, FIELD_EDIT_2);
			FormGetObjectPointer(TABLE_EDIT, &object_type, (void**)&table_ptr);
			table_ptr->table_top_row_num = 0;
			FieldSetInsertPointPositionByCharPos(FIELD_EDIT_2, 0);
			FieldSetInsertPointOn(FIELD_EDIT_2);
			EmailChangeFontSize(FORM_EDIT, font_size);
			FormPopupForm(FORM_EDIT);
			return TRUE;
		}
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_REPLY_TO);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailMessageSaveChanges
* Purpose: 	This function is the event handler for the EMESS SAVE CHANGES
page of the Email application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailMessageSaveChanges(EvtType *Event)
{
	SHORT item_num;
	BYTE *whole_name = NULL;
	UBYTE email_box;
	RecordID top_rec_id;
	EvtType new_event;
	
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
                Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_EMESS_SAVE_CHANGES_YES;
                Event->evtPBP       = NULL;
            }
			else if (Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
			{
                Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_EMESS_SAVE_CHANGES_NO;
                Event->evtPBP       = NULL;
            }
			else if (Event->para1 == LLETTER_SAVE || Event->para1 == SLETTER_SAVE)
			{
                Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = BITMAP_EMESS_SAVE_CHANGES;
                Event->evtPBP       = NULL;
            }            
        }       
    }                    
	
	
	switch(Event->eventType)
	{
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_EMESS_SAVE_CHANGES_YES)
		{
			EmailMessageSave(&email_box, &top_rec_id);
			if (rf_action != 0)
			{
				rf_action = 0;
				ListGetSelectedItem(LIST_EMAIL_MESS_NAME, &item_num);
				new_event.eventType = EVT_LIST_SELECT;
				new_event.eventID = LIST_EMAIL_MESS_NAME;
				new_event.para1 = item_num;
				new_event.para2 = 0;
				new_event.evtPBP = NULL;
				EmailMessListSelectedItemAction(&list_email_mess, &new_event);
				EmailChangeFontSize(FORM_EDIT, font_size);
				FormPopupForm(FORM_EDIT);
			}
			else 
			{
				if (current_email_box != NULL)
					qfree(current_email_box);
				current_email_box = (BYTE*)qmalloc(7*sizeof(BYTE));
				if (email_box == DRAFT)
				{
					strcpy(current_email_box, EMDRAFT);								
					ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, 3);
				}
				else if (email_box == OUTBOX)
				{
					ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, 1);
					strcpy(current_email_box, EMOUTBOX);
				}
				ListSetSelectedItem(LIST_EMAIL_MESS_NAME, -1);
				ListSetSelectedItem(LIST_EMAIL_MESS_SUB, -1);
				ListSetSelectedItem(LIST_EMAIL_MESS_TIME, -1);
				SetEmailMessTop(top_rec_id, TRUE);
				EmailRecordToEmailMessageList(current_email_box, char_start_email_box);
				FormPopupForm(FORM_EMAIL_MESS_LIST);
			}
			return TRUE;
		}
		else if (Event->eventID == BUTTON_EMESS_SAVE_CHANGES_NO)
		{
			if (rf_action != 0)
			{
				rf_action = 0;
				ListGetSelectedItem(LIST_EMAIL_MESS_NAME, &item_num);
				new_event.eventType = EVT_LIST_SELECT;
				new_event.eventID = LIST_EMAIL_MESS_NAME;
				new_event.para1 = item_num;
				new_event.para2 = 0;
				new_event.evtPBP = NULL;
				EmailMessListSelectedItemAction(&list_email_mess, &new_event);
				EmailChangeFontSize(FORM_EDIT, font_size);
				FormPopupForm(FORM_EDIT);
				return TRUE;
			}
			else
			{
				ListSetSelectedItem(LIST_EMAIL_MESS_NAME, -1);
				ListSetSelectedItem(LIST_EMAIL_MESS_SUB, -1);
				ListSetSelectedItem(LIST_EMAIL_MESS_TIME, -1);
				EmailRecordToEmailMessageList(current_email_box, char_start_email_box);
				FormPopupForm(FORM_EMAIL_MESS_LIST);
			}
			return TRUE;
		}
		break;
	case EVT_BITMAP_SELECT:
		EmailChangeFontSize(FORM_EDIT, font_size);
		FormPopupForm(FORM_EDIT);
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_EMESS_SAVE_CHANGES);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailProgramMissing
* Purpose: 	This function is the event handler for the FORM_PROGRAM_MISSING
page of the Email application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailProgramMissing(EvtType *Event)
{
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
                Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = BITMAP_PROGRAM_MISSING_X;
                Event->evtPBP       = NULL;
            }            
        }       
    }                    
	
	
	switch(Event->eventType)
	{
	case EVT_BITMAP_SELECT:
		if (dial_in_action == FROM_EMESS_LIST)
			FormPopupForm(FORM_EMAIL_MESS_LIST);
		else if (dial_in_action == FROM_EDIT)
		{
			EmailChangeFontSize(FORM_EDIT, font_size);
			FormPopupForm(FORM_EDIT);
		}
		return TRUE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			if (dial_in_action == FROM_EMESS_LIST)
				FormPopupForm(FORM_EMAIL_MESS_LIST);
			else if (dial_in_action == FROM_EDIT)
			{
				EmailChangeFontSize(FORM_EDIT, font_size);
				FormPopupForm(FORM_EDIT);
			}
			return TRUE;									
		}				
		return TRUE;							
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_PROGRAM_MISSING);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailDial
* Purpose: 	This function is the event handler for the FORM_DIAL
page of the Email application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailDial(EvtType *Event)
{
	Textbox 			*textbox_ptr;
	BYTE 				object_type, *text;
	EvtType 			new_event;
	ObjectID 			active_object, pushed_pushbutton;
	AppID				appid = 0xFFFF;
	ObjectID            pushed_button;
	BYTE                *phone_number;
	EmailSettings       email;
	
	
	
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_DIAL || Event->para1 == SLETTER_DIAL)
			{
                Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_DIAL;
                Event->evtPBP       = NULL;
            }            
			else if (Event->para1 == 9)
			{
				ControlGetPushedPushButton(FORM_DIAL, 1, &pushed_button);
                pushed_button ++;
                if (pushed_button == 170)
                    pushed_button = 166;
                
                FormSetControlGroupSelection(FORM_DIAL, pushed_button);
                Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = pushed_button;
                Event->evtPBP       = NULL;
            }                        
        }       
    }                    
	
	
	switch(Event->eventType)
	{
	case EVT_KEY:
		if (Event->eventID == SOFT_KEY && (Event->para2 & 0x300) == 0)
		{
			FormGetActiveObject(FORM_DIAL, &active_object);
			if (active_object == TEXTBOX_DIAL || active_object == TEXTBOX_DIAL_OUT)
			{
				if ((UBYTE)(Event->para1) >= 48 && (UBYTE)(Event->para1) <= 57)
				{
					TextboxAddKeyInChar(active_object, (BYTE)(Event->para1));
					return TRUE;
				}
			}
		}
		break;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			if (dial_in_action == FROM_EMESS_LIST)
			{
				dial_in_action = 0;
				ListSetSelectedItem(LIST_EMAIL_MESS_NAME, -1);
				ListSetSelectedItem(LIST_EMAIL_MESS_SUB, -1);
				ListSetSelectedItem(LIST_EMAIL_MESS_TIME, -1);
				EmailRecordToEmailMessageList(current_email_box, char_start_email_box);
				FormPopupForm(FORM_EMAIL_MESS_LIST);
				return TRUE;
			}
			else
			{
				dial_in_action = 0;
				EmailChangeFontSize(FORM_EDIT, font_size);
				FormPopupForm(FORM_EDIT);
				return TRUE;
			}
			
		}
		break;
	case EVT_FORM_OPEN:
		if (email_dial_first_in)
		{
			SetDialInsertPt(TRUE, TEXTBOX_DIAL, 0);
			FormSetFormActiveObject(FORM_DIAL, TEXTBOX_DIAL);
			TextboxSetInsertPointOn(TEXTBOX_DIAL);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_DIAL, 0);
			email_dial_first_in = 0;
		}
		FormDrawForm(FORM_DIAL);
		return TRUE;
	case EVT_TEXTBOX_SELECT:
		textbox_ptr = (Textbox*)(Event->evtPBP);
		SetDialInsertPt(TRUE, textbox_ptr->identification.ui_object_id, textbox_ptr->textbox_insert_pt_char_pos);
		return TRUE;
	case EVT_CONTROL_SELECT:
		SetDialInsertPt(FALSE,0,0);
		switch (Event->eventID)
		{
		case BUTTON_DIAL:
			SysGetAppID(NETMGR, &appid);
			
			if (!SysCheckModemExist() || appid == 0xFFFF)			
			{       	    			    
				FormPopupForm(FORM_PROGRAM_MISSING);
				return TRUE;
			}		        			                          
			
			
			if (MemoryLow)
			{
				low_memory_form_id = FORM_EMAIL_MESS_LIST;
				FormPopupForm(FORM_EM_LOW_MEMORY);
				return TRUE;
			}	                	
			
			EmailConnectSetScreen();
			StringGetText(STRING_CONNECT_NUM, &phone_number);					
			if (ControlGetPushedPushButton(FORM_DIAL,  1, &pushed_button) != TRUE)        
				pushed_button   =   0;
			
			if (pushed_button == 0)
			{
				FormPopupForm(FORM_COMM_ERROR);
				return TRUE;
			}
			else
			{
				if (pushed_button == PUSHBUTTON_ACCOUNT_0)
					SySetupGetEmailSettings(&email, EMAIL1);                                                                        
				else if (pushed_button == PUSHBUTTON_ACCOUNT_1)
					SySetupGetEmailSettings(&email, EMAIL2);                                                                        
				else if (pushed_button == PUSHBUTTON_ACCOUNT_2)
					SySetupGetEmailSettings(&email, EMAIL3);                                                                        
				else if (pushed_button == PUSHBUTTON_ACCOUNT_3)
					SySetupGetEmailSettings(&email, EMAIL4);                                                                        
				
				if (strlen(phone_number) && strlen(email.login_name) && strlen(email.login_password)
					&& strlen(email.smtp_server) && strlen(email.pop3_server) && strlen(email.user_name)
					&& strlen(email.password) && 
					((strlen(email.pri_dns1) && strlen(email.pri_dns2) &&  strlen(email.pri_dns3) && strlen(email.pri_dns4))||(strlen(email.sec_dns1) && strlen(email.sec_dns2) &&  strlen(email.sec_dns3) && strlen(email.sec_dns4)))
					&& (email.auto_ip_addr || (email.auto_ip_addr == 0 && strlen(email.ip_addr1) && strlen(email.ip_addr2) &&  strlen(email.ip_addr3) && strlen(email.ip_addr4))))                            
				{                          
				/*        	    			SysGetAppID("Network Manager", &appid);
        	    			
							  if (!SysCheckModemExist() || appid == 0xFFFF)			
							  {       	    			    
							  FormPopupForm(FORM_PROGRAM_MISSING);
							  return TRUE;
							  }		        			                          
					*/                            
					
					if (appid != 0xFFFF)
					{
						SysGetAppID(NETMGR, &appid);
						EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
						EvtAppendEvt(EVT_APP_LAUNCH, appid, LAUNCH_CMD_MODEM_CONNECT, 0, NULL);					
					}        	        				       
					return TRUE;
				}
				else 
				{   
					StringInitString(STRING_COMM_ERROR_1);                                                       
					
					if (!strlen(phone_number))
						StringSetText(STRING_COMM_ERROR_1, EMSTR1);
					else if (!strlen(email.login_name))
						StringSetText(STRING_COMM_ERROR_1, EMSTR2);
					else if (!strlen(email.login_password))
						StringSetText(STRING_COMM_ERROR_1, EMSTR3);
					else if (!strlen(email.user_name))
						StringSetText(STRING_COMM_ERROR_1, EMSTR4);
					else if (!strlen(email.password))
						StringSetText(STRING_COMM_ERROR_1, EMSTR5);
					else if (!strlen(email.smtp_server))
						StringSetText(STRING_COMM_ERROR_1, EMSTR6);
					else if (!strlen(email.pop3_server))
						StringSetText(STRING_COMM_ERROR_1, EMSTR7);
					else if (!email.auto_ip_addr && (!strlen(email.ip_addr1) || !strlen(email.ip_addr2) ||  !strlen(email.ip_addr3) || !strlen(email.ip_addr4)))
						StringSetText(STRING_COMM_ERROR_1, EMSTR8);
					else if (!strlen(email.pri_dns1) || !strlen(email.pri_dns2) ||  !strlen(email.pri_dns3) || !strlen(email.pri_dns4))
						StringSetText(STRING_COMM_ERROR_1, EMSTR9);
					else if (!strlen(email.sec_dns1) || !strlen(email.sec_dns2) ||  !strlen(email.sec_dns3) || !strlen(email.sec_dns4))
						StringSetText(STRING_COMM_ERROR_1, EMSTR10);
					
					FormPopupForm(FORM_COMM_ERROR);
					return TRUE;
				}
			}                                                    
			return TRUE;
		case PUSHBUTTON_ACCOUNT_0:
			EmailDialPushButtonAction(EMAIL1);
			return TRUE;
		case PUSHBUTTON_ACCOUNT_1:
			EmailDialPushButtonAction(EMAIL2);
			return TRUE;
		case PUSHBUTTON_ACCOUNT_2:
			EmailDialPushButtonAction(EMAIL3);
			return TRUE;
		case PUSHBUTTON_ACCOUNT_3:
			EmailDialPushButtonAction(EMAIL4);
			return TRUE;
			}
			break;
		case EVT_BITMAP_SELECT:
			if (Event->eventID == BITMAP_DIAL_ENTER)
			{
				SysGetAppID(NETMGR, &appid);
				
				if (!SysCheckModemExist() || appid == 0xFFFF)			
				{       	    			    
					FormPopupForm(FORM_PROGRAM_MISSING);
					return TRUE;
				}		        			                          
				
				if (MemoryLow)
				{
					low_memory_form_id = FORM_EMAIL_MESS_LIST;
					FormPopupForm(FORM_EM_LOW_MEMORY);
					return TRUE;
				}	                	
				
				EmailConnectSetScreen();
				StringGetText(STRING_CONNECT_NUM, &phone_number);					
				if (ControlGetPushedPushButton(FORM_DIAL,  1, &pushed_button) != TRUE)        
					pushed_button   =   0;
				
				if (pushed_button == 0)
				{
					FormPopupForm(FORM_COMM_ERROR);
					return TRUE;
				}
				else
				{
					if (pushed_button == PUSHBUTTON_ACCOUNT_0)
						SySetupGetEmailSettings(&email, EMAIL1);                                                                        
					else if (pushed_button == PUSHBUTTON_ACCOUNT_1)
						SySetupGetEmailSettings(&email, EMAIL2);                                                                        
					else if (pushed_button == PUSHBUTTON_ACCOUNT_2)
						SySetupGetEmailSettings(&email, EMAIL3);                                                                        
					else if (pushed_button == PUSHBUTTON_ACCOUNT_3)
						SySetupGetEmailSettings(&email, EMAIL4);                                                                        
					
					if (strlen(phone_number) && strlen(email.login_name) && strlen(email.login_password)
						&& strlen(email.smtp_server) && strlen(email.pop3_server) && strlen(email.user_name)
						&& strlen(email.password) && 
						((strlen(email.pri_dns1) && strlen(email.pri_dns2) &&  strlen(email.pri_dns3) && strlen(email.pri_dns4))||(strlen(email.sec_dns1) && strlen(email.sec_dns2) &&  strlen(email.sec_dns3) && strlen(email.sec_dns4)))
						&& (email.auto_ip_addr || (email.auto_ip_addr == 0 && strlen(email.ip_addr1) && strlen(email.ip_addr2) &&  strlen(email.ip_addr3) && strlen(email.ip_addr4))))                            
					{                          
					/*        	    			SysGetAppID("Network Manager", &appid);
					
					  if (!SysCheckModemExist() || appid == 0xFFFF)			
					  {       	    			    
					  FormPopupForm(FORM_PROGRAM_MISSING);
					  return TRUE;
					  }		        			                          
					  
						
						  SysGetAppID("Network Manager", &appid);
						*/                            
						
						if (appid != 0xFFFF)
						{
							SysGetAppID(NETMGR, &appid);
							EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
							EvtAppendEvt(EVT_APP_LAUNCH, appid, LAUNCH_CMD_MODEM_CONNECT, 0, NULL);					
						}        	        				       
						return TRUE;
					}
					else 
					{   
						StringInitString(STRING_COMM_ERROR_1);                                                       
						
						if (!strlen(phone_number))
							StringSetText(STRING_COMM_ERROR_1, EMSTR1);
						else if (!strlen(email.login_name))
							StringSetText(STRING_COMM_ERROR_1, EMSTR2);
						else if (!strlen(email.login_password))
							StringSetText(STRING_COMM_ERROR_1, EMSTR3);
						else if (!strlen(email.user_name))
							StringSetText(STRING_COMM_ERROR_1, EMSTR4);
						else if (!strlen(email.password))
							StringSetText(STRING_COMM_ERROR_1, EMSTR5);
						else if (!strlen(email.smtp_server))
							StringSetText(STRING_COMM_ERROR_1, EMSTR6);
						else if (!strlen(email.pop3_server))
							StringSetText(STRING_COMM_ERROR_1, EMSTR7);
						else if (!email.auto_ip_addr && (!strlen(email.ip_addr1) || !strlen(email.ip_addr2) ||  !strlen(email.ip_addr3) || !strlen(email.ip_addr4)))
							StringSetText(STRING_COMM_ERROR_1, EMSTR8);
						else if (!strlen(email.pri_dns1) || !strlen(email.pri_dns2) ||  !strlen(email.pri_dns3) || !strlen(email.pri_dns4))
							StringSetText(STRING_COMM_ERROR_1, EMSTR9);
						else if (!strlen(email.sec_dns1) || !strlen(email.sec_dns2) ||  !strlen(email.sec_dns3) || !strlen(email.sec_dns4))
							StringSetText(STRING_COMM_ERROR_1, EMSTR10);
						
						FormPopupForm(FORM_COMM_ERROR);
						return TRUE;
					}
				}                                                    
				return TRUE;
			}
			if (dial_insert_pt.insert_pt_on == FALSE) return TRUE;
			FormSetFormActiveObject(FORM_DIAL, dial_insert_pt.textbox_id);
			FormGetObjectPointer(dial_insert_pt.textbox_id, &object_type, (void**)&textbox_ptr);
			TextboxSetInsertPointOn(dial_insert_pt.textbox_id);
			switch(Event->eventID)
			{
			case BITMAP_DIAL_LEFT:
				KeyboardSendEvent(KEY_LEFT, FALSE, FALSE, FALSE);
				break;
			case BITMAP_DIAL_C:
				new_event.eventType = EVT_KEY;
				new_event.eventID = SOFT_KEY;
				new_event.para1 = KEY_BACKSPACE;
				new_event.para2 = 0;
				new_event.evtPBP = NULL;
				TextboxHandleEvent(textbox_ptr , &new_event);
				break;
			case BITMAP_DIAL_RIGHT:
				KeyboardSendEvent(KEY_RIGHT, FALSE, FALSE, FALSE);
				break;
			case BITMAP_DIAL_1:
				TextboxAddKeyInChar(dial_insert_pt.textbox_id, '1');
				break;
			case BITMAP_DIAL_2:
				TextboxAddKeyInChar(dial_insert_pt.textbox_id, '2');
				break;
			case BITMAP_DIAL_3:
				TextboxAddKeyInChar(dial_insert_pt.textbox_id, '3');
				break;
			case BITMAP_DIAL_4:
				TextboxAddKeyInChar(dial_insert_pt.textbox_id, '4');
				break;
			case BITMAP_DIAL_5:
				TextboxAddKeyInChar(dial_insert_pt.textbox_id, '5');
				break;
			case BITMAP_DIAL_6:
				TextboxAddKeyInChar(dial_insert_pt.textbox_id, '6');
				break;
			case BITMAP_DIAL_7:
				TextboxAddKeyInChar(dial_insert_pt.textbox_id, '7');
				break;
			case BITMAP_DIAL_8:
				TextboxAddKeyInChar(dial_insert_pt.textbox_id, '8');
				break;
			case BITMAP_DIAL_9:
				TextboxAddKeyInChar(dial_insert_pt.textbox_id, '9');
				break;
			case BITMAP_DIAL_0:
				TextboxAddKeyInChar(dial_insert_pt.textbox_id, '0');
				break;
			case BITMAP_DIAL_LSYM:
				TextboxAddKeyInChar(dial_insert_pt.textbox_id, '#');
				break;
			case BITMAP_DIAL_RSYM:
				TextboxAddKeyInChar(dial_insert_pt.textbox_id, '*');
				break;
			}
			SetDialInsertPt(TRUE, dial_insert_pt.textbox_id, textbox_ptr->textbox_insert_pt_char_pos);
			return TRUE;
			default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailCommError
* Purpose: 	This function is the event handler for the FORM_COMM_ERROR
page of the Email application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailCommError(EvtType *Event)
{
    
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
                Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = BITMAP_COMM_ERROR;
                Event->evtPBP       = NULL;
            }            
        }       
    }                    
	
    
	switch(Event->eventType)
	{
	case EVT_BITMAP_SELECT:
		FormPopupForm(FORM_DIAL);
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_COMM_ERROR);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailConnect
* Purpose: 	This function is the event handler for the FORM_CONNECT
page of the Email application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailConnect(EvtType *Event)
{
    
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
            if (Event->para2 == 0x215 || Event->para2 == 0x21c)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_CONNECT, SCROLLBAR_UP_ARROW);            
                return TRUE;            
            }
            else if (Event->para2 == 0x216 || Event->para2 == 0x21d)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_CONNECT, SCROLLBAR_DOWN_ARROW);            
                return TRUE;            
            }                    
            else if (Event->para1 == LLETTER_DISCONNECT || Event->para2 == LLETTER_DISCONNECT)
            {           
                Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_CONNECT_DISCONNECT;
                Event->evtPBP       = NULL;                
            }                                
        }       
    }                    
    
    
    
	switch(Event->eventType)
	{
#ifdef PR31700
	case EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{
			if (Event->para2 == IO_UP_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_CONNECT, SCROLLBAR_UP_ARROW);
			else if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_CONNECT, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		return FALSE;
#endif
	case EVT_SCROLLBAR_SELECT:
		ScrollbarDrawScrollbar(SCROLLBAR_CONNECT);
		return TRUE;
	case EVT_SCROLLBAR_REPEAT:
		EmailConnectScrollbarSetField(Event);
		return TRUE;
	case EVT_FIELD_CHANGED:
		EmailConnectFieldSetScrollbar();
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_CONNECT);
		return TRUE;
	case EVT_CONTROL_SELECT:
		EmailConnectInsertTextToField(EMSTR11);
		FieldDrawField(FIELD_CONNECT);
		return TRUE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para2 == INLAY_EXIT)
			FormPopupForm(FORM_DIAL);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailEmptyToField
* Purpose: 	This function is the event handler for the FORM_NO_TO_ADDR
page of the Email application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailEmptyToField(EvtType *Event)
{
    ObjectID    count_id;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
            if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
            {           
                Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;                
            }                                
        }       
    }                    
    
    
	switch (Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_NO_TO_ADDR);
		return TRUE;
	case EVT_BITMAP_SELECT:
		EmailChangeFontSize(FORM_EDIT, font_size);
		for (count_id = FIELD_EDIT_0; count_id <= FIELD_EDIT_4; count_id++)
			FieldSetInsertPointOff(count_id);
		LcdEnableInsertPt(FALSE, 0, 0, SMALL_FONT);
		FormPopupForm(FORM_EDIT);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailLowMemoryHandle
* Purpose: 	This function is the event handler for the FORM_EM_LOW_MEMORY
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailLowMemoryHandle(EvtType* Event)
{
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
            if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
            {           
                Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;                
            }                                
        }       
    }                    
    
    
	switch (Event->eventType)
	{
	case EVT_BITMAP_SELECT:	
		switch (low_memory_form_id)
		{
		case FORM_EDIT_CATE:
			FormPopupForm(FORM_EDIT_CATE);
			break;				
		case FORM_EMAIL_MESS_LIST:   		
			FormPopupForm(FORM_EMAIL_MESS_LIST);
			break;               		
		case FORM_EMAIL_NAME_LIST:   		
			FormPopupForm(FORM_EMAIL_NAME_LIST);
			break;               		    
		case FORM_MAIL_LIST:
			FormPopupForm(FORM_MAIL_LIST);
			break;                               		           		
		case FORM_EDIT:   		
			FormPopupForm(FORM_EDIT);
			break;
		case FORM_VE_EMAIL_NAME:   	           		
			FormPopupForm(FORM_VE_EMAIL_NAME);
			break;               		               		                		        	       		               		
		default:
			break;				
		}			
		break;
		case EVT_INLAY_SELECT:
			if (Event->para1 == INLAY_OK || Event->para2 == INLAY_EXIT)
			{
                switch (low_memory_form_id)
                {
				case FORM_EDIT_CATE:
					FormPopupForm(FORM_EDIT_CATE);
					break;
				case FORM_EMAIL_MESS_LIST:   		
					FormPopupForm(FORM_EMAIL_MESS_LIST);
					break;
				case FORM_EMAIL_NAME_LIST:   		
					FormPopupForm(FORM_EMAIL_NAME_LIST);
					break;               		               		                		
				case FORM_MAIL_LIST:
					FormPopupForm(FORM_MAIL_LIST);
					break;               		               		                		        	       		                            	       		
				case FORM_EDIT:   		
					FormPopupForm(FORM_EDIT);
					break;               		               		                		        	       		
				case FORM_VE_EMAIL_NAME:   	           		
					FormPopupForm(FORM_VE_EMAIL_NAME);
					break;               		               		                		        	       		               		        	       		
				default:
					break;
                }
			}
			break;					
		case EVT_FORM_OPEN:
            StringInitString(STRING_EM_LOW_MEMORY_0);
			switch (low_memory_form_id)
			{
			case FORM_EDIT_CATE:
				StringSetText(STRING_EM_LOW_MEMORY_0, EMSTR12);
				break;
			case FORM_EMAIL_MESS_LIST:
			case FORM_EMAIL_NAME_LIST:
				if (!false_restore)
					StringSetText(STRING_EM_LOW_MEMORY_0, EMSTR12);
				else
				{
					false_restore = FALSE;
					StringSetText(STRING_EM_LOW_MEMORY_0, EMSTR13);
				}
				break;
			case FORM_MAIL_LIST:
				if (view_to_edit)
					StringSetText(STRING_EM_LOW_MEMORY_0, EMSTR14);
				else
					StringSetText(STRING_EM_LOW_MEMORY_0, EMSTR12);
				break;
			case FORM_EDIT:
				if (view_to_edit)
					StringSetText(STRING_EM_LOW_MEMORY_0, EMSTR14);
				else
					StringSetText(STRING_EM_LOW_MEMORY_0, EMSTR12);
				break;	
			case FORM_VE_EMAIL_NAME:
				StringSetText(STRING_EM_LOW_MEMORY_0, EMSTR14);
				break;
			default:
				break;
			}
			FormDrawForm(FORM_EM_LOW_MEMORY);
			break;
			default:
				break;
	}
	return TRUE;
}


/********************************************************
* Function:	EmailDiscardChangesHandle
* Purpose: 	This function is the event handler for the FORM_EM_DISCARD_CHANGES
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailDiscardChangesHandle(EvtType *Event)
{
	
    USHORT        item_num;
    ObjectID      tempID;
    UBYTE         cat;
    BYTE          object_type;
    Table         *table_ptr;
    AppID         app_id;
	
    if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
            if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_EM_DISCARD_CHANGES_YES;
                Event->evtPBP       = NULL;
            }
            else if (Event->para1 == LLETTER_NO	|| Event->para1 == SLETTER_NO)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_EM_DISCARD_CHANGES_NO;
                Event->evtPBP       = NULL;
            }            
			else if (Event->para1 == LLETTER_X || Event->para1 == LLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = BITMAP_EM_DISCARD_CHANGES;
                Event->evtPBP       = NULL;
            }                        
        }
    }                    
	
	
    switch (Event->eventType)
    {
	case EVT_BITMAP_SELECT:
		FormPopupForm(gf_in_form_id);
		break;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_EM_DISCARD_CHANGES);
		break;    
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			FormPopupForm(gf_in_form_id);
		return TRUE;
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_EM_DISCARD_CHANGES_YES)
		{
			switch (gf_in_form_id)
			{
			case FORM_EMAIL_MESS_LIST:   		
				gf_entry = FALSE;
				
				addr_edit_dirty = 0;
				emess_edit_dirty = 0;
				FormInitAllFormObjects(FORM_EDIT);
				FormInitAllFormObjects(FORM_MAIL_LIST);
				SetEditEntryStatus(EDIT, 0, DRAFT, TRUE);
				SetMailListEntryStatus(EDIT, 0, 0, FALSE);
				EmailEditSetScreen();
				FieldSetInsertPointOn(FIELD_EDIT_1);
				FieldSetInsertPointPositionByCharPos(FIELD_EDIT_1, 0);
				FormSetFormActiveObject(FORM_EDIT, FIELD_EDIT_1);
				EmailChangeFontSize(FORM_EDIT, font_size);
				FormPopupForm(FORM_EDIT);
				break;               		
			case FORM_EMAIL_NAME_LIST:
				gf_entry = FALSE;
				
				addr_edit_dirty = 0;
				emess_edit_dirty = 0;
				new_name_in_action = ADDRESS_LIST;
				FormInitAllFormObjects(FORM_VE_EMAIL_NAME);
				EmailCateNameToPopupTrigger(email_dbid);
				ControlPopupDeleteItem(POPUP_TRIGGER_CATE, 0);
				if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate,
					&item_num) == TRUE) 
					ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
				else
					ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
				SetVEEmailNameStatus(EDIT, TRUE, FALSE, 0, email_dbid,TRUE);
				if (temp_cate)
					qfree(temp_cate);
				temp_cate = (BYTE*)qmalloc(30 * sizeof(BYTE));
				strcpy(temp_cate, current_cate);
				EmailSetupViewEditEmailNameScreen();
				FormSetFormActiveObject(FORM_VE_EMAIL_NAME, TEXTBOX_LAST_NAME);
				TextboxSetInsertPointOn(TEXTBOX_LAST_NAME);
				TextboxSetInsertPointPositionByCharPos(TEXTBOX_LAST_NAME, 0);
				FormPopupForm(FORM_VE_EMAIL_NAME);
				break;               		               		
			case FORM_EDIT:   	
				gf_entry = FALSE;	    				
				if (gf_in_pressed_object == 0)
				{
					if (edit_entry_status.new_record != TRUE)
					{
						DataRecordInfo(emess_dbid, edit_entry_status.rec_id, NULL, &cat, NULL, NULL, NULL);
						if (cat == OUTBOX || cat == DRAFT)
						{
							SetEditEntryStatus(EDIT, edit_entry_status.rec_id, OUTBOX, FALSE);
							SetMailListEntryStatus(EDIT, 0, 0, FALSE);  					  
						}
						else if (cat == SENT/* || cat == DRAFT*/)
						{       
							SetEditEntryStatus(EDIT, edit_entry_status.rec_id, cat, TRUE);
							SetMailListEntryStatus(EDIT, 0, 0, FALSE);  					  
						}
						else if (cat == INBOX && rf_action == 0)
							return TRUE;                               
					}
					EmailEditSetScreen();
					TableUpdateObjectScreenBounds(TABLE_EDIT, BITMAP_EDIT_TO);
					if (edit_entry_status.status != VIEW && cat != INBOX)      
						BitmapDrawBitmap(BITMAP_EDIT_TO);
					FieldSetInsertPointOn(FIELD_EDIT_2);
					FieldSetInsertPointPositionByCharPos(FIELD_EDIT_2, 0);
					FormSetFormActiveObject(FORM_EDIT, FIELD_EDIT_2);
					FormSetActiveForm(FORM_EDIT);
					FormSetEventHandler(FORM_EDIT,(void**) &FormDispatchEvent, (void*)EmailEdit);                           
					FormDrawForm(FORM_EDIT);    				
				}
				else if (gf_in_pressed_object = BUTTON_EDIT_REPLY)
				{
					FormDrawForm(FORM_EDIT);
					FormPopupForm(FORM_REPLY_TO);
				}
				else if (gf_in_pressed_object = BUTTON_EDIT_FORWARD)
				{
					rf_action = FORWARD;					
					SetEditEntryStatus(EDIT, edit_entry_status.rec_id, INBOX, TRUE);
					EmailEditSetScreen();
					EmailReplyForwardPutData(FORWARD);
					FormSetFormActiveObject(FORM_EDIT, FIELD_EDIT_2);
					FormGetObjectPointer(TABLE_EDIT, &object_type, (void**)&table_ptr);
					table_ptr->table_top_row_num = 0;
					FieldSetInsertPointPositionByCharPos(FIELD_EDIT_2, 0);
					FieldSetInsertPointOn(FIELD_EDIT_2);
					EmailChangeFontSize(FORM_EDIT, font_size);
					FormPopupForm(FORM_EDIT);
				}        					                            
				break;
			case FORM_VE_EMAIL_NAME:   	           		    
				gf_entry = FALSE;
				SetVEEmailNameStatus(EDIT, ve_email_name_status.company, ve_email_name_status.home, 
					ve_email_name_status.rec_id, ve_email_name_status.dbid, FALSE);
				EmailSetupViewEditEmailNameScreen();
				FormSetActiveForm(FORM_VE_EMAIL_NAME);
				FormSetEventHandler(FORM_VE_EMAIL_NAME,(void**) &FormDispatchEvent, (void*)EmailVEEmailName);
				FormDrawForm(FORM_VE_EMAIL_NAME);   				
				break;              
			case FORM_MAIL_LIST:
				gf_entry = FALSE;
				if (edit_entry_status.new_record != TRUE)
				{
					DataRecordInfo(emess_dbid, edit_entry_status.rec_id, NULL, &cat, NULL, NULL, NULL);
					if (cat == OUTBOX || cat == DRAFT)
					{
						SetEditEntryStatus(EDIT, edit_entry_status.rec_id, OUTBOX, FALSE);
						SetMailListEntryStatus(EDIT, 0, 0, FALSE);  					  
					}
					else if (cat == SENT/* || cat == DRAFT*/)
					{       
						SetEditEntryStatus(EDIT, edit_entry_status.rec_id, cat, TRUE);
						SetMailListEntryStatus(EDIT, 0, 0, FALSE);  					  
					}
					else if (cat == INBOX && rf_action == 0)
						return TRUE;                               
				}
				EmailMailListSetScreen();
				FieldSetInsertPointOn(FIELD_MAIL_LIST_TO);
				FieldSetInsertPointPositionByCharPos(FIELD_MAIL_LIST_TO, 0);
				FormSetFormActiveObject(FORM_MAIL_LIST, FIELD_MAIL_LIST_TO);
				FormSetActiveForm(FORM_MAIL_LIST);
				FormSetEventHandler(FORM_MAIL_LIST, (void**) &FormDispatchEvent, (void*)EmailMailList);
				FormDrawForm(FORM_MAIL_LIST);                    
				break;           	       		 		               		                		        	       		               		
			default:
				break;
                }
            }
            else
            {
                switch (gf_in_form_id)
                {    				
				case FORM_EMAIL_MESS_LIST:                     		
				case FORM_EMAIL_NAME_LIST:   		
				case FORM_EDIT:   		
				case FORM_VE_EMAIL_NAME:   	           		    
				case FORM_MAIL_LIST:
					SysGetAppID(EMAIL, &app_id);
					EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
					EvtAppendEvt(EVT_APP_LAUNCH, app_id, LAUNCH_CMD_NORMAL_LAUNCH, 0, NULL);                                            
					break;           	       		 		               		                		        	       		               		          	       		               		               		                		        	       		               		
				default:
					break;
                }                               
            }    
            return TRUE;
        default: 
			return FALSE;
    }
    return FALSE;                                     
}
