/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   appsave.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"

extern 		BOOLEAN     false_restore;
extern 		BOOLEAN 	entry_low_memory;
extern 		BOOLEAN 	entry_old_edit;
extern 		ObjectID	low_memory_form_id;

/********************************************************
* Function:	EmailAppSave
* Purpose: 	This function is called to save the data in 
the application when it is called to stopped
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
void EmailAppSave()
{
	ObjectID    active_form_id;
	BYTE        application_status = RESTART;
	BYTE        *object_text;
	WORD        count = 0;
	BOOLEAN     control_value = TRUE;
    Table       *table_ptr;
    BYTE        object_type;
    ObjectID    control_id;
    
	
	FormGetActiveFormID(&active_form_id);
	if (active_form_id == FORM_EMAIL_MESS_LIST)
		application_status = EMAIL_MESS_LISTING;
	else if (active_form_id == FORM_PROGRAM_MISSING ||
		active_form_id == FORM_CONNECT)
	{
		if (dial_in_action == FROM_EMESS_LIST)
			application_status = EMAIL_MESS_LISTING;
		else application_status = EDIT_EMAIL_MESS;
	}
	else if (active_form_id == FORM_COMM_ERROR ||
		active_form_id == FORM_DIAL)
		application_status = EMAIL_DIAL_KEYIN;
	else if (active_form_id == FORM_EDIT ||
		active_form_id == FORM_REPLY_TO ||
		active_form_id == FORM_EMAIL_ERASE ||
		active_form_id == FORM_EMESS_SAVE_CHANGES ||
		active_form_id == FORM_PROGRAM_MISSING ||
		active_form_id == FORM_NO_TO_ADDR)
		application_status = EDIT_EMAIL_MESS;
	else if (active_form_id == FORM_MAIL_LIST)
		application_status = EDIT_EMAIL_TO;
	else if (active_form_id == FORM_SAVE_CHANGES ||
		active_form_id == FORM_ADD_ERASE ||
		active_form_id == FORM_VE_EMAIL_NAME)
		application_status = EDIT_EMAIL_NAME;
	else if (active_form_id == FORM_FIND_BACKGROUND ||
		active_form_id == FORM_FIND_INPUT ||
		active_form_id == FORM_NOT_FOUND ||
		active_form_id == FORM_FIND_RESULT ||
		active_form_id == FORM_EMAIL_NAME_LIST)
		application_status = EMAIL_NAME_LISTING;
	else if (active_form_id == FORM_EDIT_CATE ||
		active_form_id == FORM_INPUT_CATE ||
		active_form_id == FORM_INPUT_CATE ||
		active_form_id == FORM_NO_CATE ||
		active_form_id == FORM_CATE_NAME_EXISTS ||
		active_form_id == FORM_ERASE_CATE ||
		active_form_id == FORM_REMOVE_CATE ||
		active_form_id == FORM_CATE_FULL)
	{
		if (edit_cate_in_action == FROM_POPUP)
			application_status = EMAIL_NAME_LISTING;
		else application_status = EDIT_EMAIL_NAME;
	}
	EmailDatabaseChecking();
	
	DataWriteField(emess_dbid, EMAIL_STATUS, 0, 1, (BYTE*)&application_status);
	DataWriteField(emess_dbid, EMAIL_STATUS, 1, 1, (BYTE*)&addr_edit_dirty);
	DataWriteField(emess_dbid, EMAIL_STATUS, 2, 1, (BYTE*)&emess_edit_dirty);
    DataWriteField(emess_dbid, EMAIL_STATUS, 3, (strlen(find_string) + 1), find_string);
    DataWriteField(emess_dbid, EMAIL_STATUS, 4, 1, &font_size);
	
	if (current_email_box != NULL)
		DataWriteField(emess_dbid, EMAIL_EMAIL_MESS, 0, (strlen(current_email_box) + 1), current_email_box);
	else DataWriteField(emess_dbid, EMAIL_EMAIL_MESS, 0, 1, EMALL);
	if (current_cate != NULL)
		DataWriteField(emess_dbid, EMAIL_EMAIL_NAME, 0, (strlen(current_cate) + 1), current_cate);
	else DataWriteField(emess_dbid, EMAIL_EMAIL_NAME, 0, 1, (BYTE*)(""));
	DataWriteField(emess_dbid, EMAIL_EMAIL_NAME, 1, 1, (BYTE*)&char_start);
	DataWriteField(emess_dbid, EMAIL_EMAIL_NAME, 2, 1, (BYTE*)&name_list_in_action);
	DataWriteField(emess_dbid, EMAIL_DIAL, 3, 1, (BYTE*)&dial_in_action);
	
	if (temp_cate != NULL)
		DataWriteField(emess_dbid, EMAIL_EMAIL_NAME, 3, (strlen(temp_cate) + 1), temp_cate);
	else DataWriteField(emess_dbid, EMAIL_EMAIL_NAME, 3, 1, (BYTE*)(""));
	
	DataWriteField(emess_dbid, EMAIL_NAME_EDIT, 7, 1, (BYTE*)&new_name_in_action);
	
	/* FORM_EDIT */
	for (count = FIELD_EDIT_0; count<= FIELD_EDIT_4; count++)
	{
		if (FieldGetTextPointer((ObjectID)count, &object_text) == TRUE)
			DataWriteField(emess_dbid, EMAIL_MESS_EDIT, (USHORT)(count - FIELD_EDIT_0), (strlen(object_text) + 1), object_text);
		else DataWriteField(emess_dbid, EMAIL_MESS_EDIT, (USHORT)(count - FIELD_EDIT_0), 1, (BYTE*)(""));
	}
	
	DataWriteField(emess_dbid, EMAIL_MESS_EDIT, 5, sizeof(EditEntryStatus), (BYTE*)&edit_entry_status);
	
    DataWriteField(emess_dbid, EMAIL_MESS_EDIT, 6, (strlen(temp_from) + 1), temp_from);
	
    DataWriteField(emess_dbid, EMAIL_MESS_EDIT, 7, (strlen(temp_to) + 1), temp_to);
	
    DataWriteField(emess_dbid, EMAIL_MESS_EDIT, 8, (strlen(temp_cc) + 1), temp_cc);
	
    DataWriteField(emess_dbid, EMAIL_MESS_EDIT, 9, (strlen(temp_bcc) + 1), temp_bcc);
	/* FORM_MAIL_LIST */	
	for (count = FIELD_MAIL_LIST_TO; count<= FIELD_MAIL_LIST_BCC; count++)
	{
		if (FieldGetTextPointer((ObjectID)count, &object_text) == TRUE)
			DataWriteField(emess_dbid, EMAIL_MESS_TO, (USHORT)(count - FIELD_MAIL_LIST_TO), (strlen(object_text) + 1), object_text);
		else DataWriteField(emess_dbid, EMAIL_MESS_TO, (USHORT)(count - FIELD_MAIL_LIST_TO), 1, (BYTE*)(""));
	}
	DataWriteField(emess_dbid, EMAIL_MESS_TO, 3, sizeof(MailListEntryStatus), (BYTE*)&mail_list_entry_status);
	DataWriteField(emess_dbid, EMAIL_MESS_TO, 4, sizeof(MailListInsertPt), (BYTE*)&mail_list_insert_pt);	 
	
	/* FORM_VE_EMAIL_NAME */
	if (TextboxGetTextPointer(TEXTBOX_LAST_NAME, &object_text) == TRUE)
		DataWriteField(emess_dbid, EMAIL_NAME_EDIT, 0, (strlen(object_text) + 1), object_text);
	else DataWriteField(emess_dbid, EMAIL_NAME_EDIT, 0, 1, (BYTE*)(""));
	if (TextboxGetTextPointer(TEXTBOX_FIRST_NAME, &object_text) == TRUE)
		DataWriteField(emess_dbid, EMAIL_NAME_EDIT, 1, (strlen(object_text) + 1), object_text);
	else DataWriteField(emess_dbid, EMAIL_NAME_EDIT, 1, 1, (BYTE*)(""));
	if (FieldGetTextPointer(FIELD_C_EMAIL, &object_text) == TRUE)
		DataWriteField(emess_dbid, EMAIL_NAME_EDIT, 2, (strlen(object_text) + 1), object_text);
	else DataWriteField(emess_dbid, EMAIL_NAME_EDIT, 2, 1, (BYTE*)(""));
	if (FieldGetTextPointer(FIELD_H_EMAIL, &object_text) == TRUE)
		DataWriteField(emess_dbid, EMAIL_NAME_EDIT, 3, (strlen(object_text) + 1), object_text);
	else DataWriteField(emess_dbid, EMAIL_NAME_EDIT, 3, 1, (BYTE*)(""));
	FormGetControlValue(CHECKBOX_VE_C, &control_value);
	if (control_value == TRUE)
	{
		DataWriteField(emess_dbid, EMAIL_NAME_EDIT, 4, sizeof(BOOLEAN), (BYTE*)&control_value);
		control_value = FALSE;
		DataWriteField(emess_dbid, EMAIL_NAME_EDIT, 5, sizeof(BOOLEAN), (BYTE*)&control_value);
	}
	else 
	{
		DataWriteField(emess_dbid, EMAIL_NAME_EDIT, 4, sizeof(BOOLEAN), (BYTE*)&control_value);
		control_value = TRUE;
		DataWriteField(emess_dbid, EMAIL_NAME_EDIT, 5, sizeof(BOOLEAN), (BYTE*)&control_value);
	}
	DataWriteField(emess_dbid, EMAIL_NAME_EDIT, 6, sizeof(VEEmailNameStatus), (BYTE*)&ve_email_name_status);
	
	/* FORM_DIAL */
	if (TextboxGetTextPointer(TEXTBOX_DIAL, &object_text) == TRUE)
		DataWriteField(emess_dbid, EMAIL_DIAL, 0, (strlen(object_text) + 1), object_text);
	else DataWriteField(emess_dbid, EMAIL_DIAL, 0, 1, (BYTE*)(""));
	if (TextboxGetTextPointer(TEXTBOX_DIAL_OUT, &object_text) == TRUE)
		DataWriteField(emess_dbid, EMAIL_DIAL, 1, (strlen(object_text) + 1), object_text);
	else DataWriteField(emess_dbid, EMAIL_DIAL, 1, 1, (BYTE*)(""));
	
	FormGetControlValue(CHECKBOX_DIAL_OUT, &control_value);
	DataWriteField(emess_dbid, EMAIL_DIAL, 2, sizeof(BOOLEAN), (BYTE*)&control_value);
    
    if (FormGetObjectPointer(TABLE_EDIT, &object_type, (void**)&table_ptr) == TRUE)
        table_ptr->table_num_row = 5;
    if (FormGetObjectPointer(TABLE_MAIL_LIST, &object_type, (void**)&table_ptr) == TRUE)
        table_ptr->table_num_row = 3;   
	
    if (ControlGetPushedPushButton(FORM_DIAL,  1, &control_id) != TRUE)        
        control_id = 0;
	
    DataWriteField(emess_dbid, EMAIL_DIAL, 4, sizeof(ObjectID), (BYTE*)&control_id);
	
	
	DataCloseDB(pb_dbid);
	DataCloseDB(email_dbid);
	DataCloseDB(emess_dbid);
}

/********************************************************
* Function:	EmailAppRestore
* Purpose: 	This function is called to restore the data in 
the application when it is called to stopped
* Scope:		application/internal
* Input:		restart		whether the application is restart or not
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
void EmailAppRestore(BOOLEAN restart)
{
	BYTE 		application_status;
    BYTE 		*buffer, buffer1[200], buffer2[200], buffer3[200];
	UWORD 		byte_read;
	WORD 		count;
	USHORT 		item_num;
	BYTE 		object_type;
	Control 	*control_ptr;
	UBYTE       cate_number;
	
    draw_scrollbar = FALSE;
	/* Allocate global variable */
    find_string[0] = 0;
	addr_edit_dirty = 0;
	emess_edit_dirty = 0;
	pressed_object = 0;
	name_list_in_action = 0;
	edit_cate_in_action = 0;
	new_name_in_action = 0;
	dial_in_action = 0;
	rf_action = 0;
	edit_table_font_size = SMALL_FONT;
	mail_list_table_font_size = SMALL_FONT;
	
	
	current_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
	strcpy(current_cate, (BYTE*)(""));
	temp_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
	strcpy(temp_cate, (BYTE*)(""));
	current_email_box = (BYTE*)qmalloc(30*sizeof(BYTE));
	strcpy(current_email_box, (BYTE*)(""));
    temp_from = (BYTE*)qmalloc(sizeof(BYTE));
    strcpy(temp_from, (BYTE*)(""));
    temp_to = (BYTE*)qmalloc(sizeof(BYTE));
    strcpy(temp_to, (BYTE*)(""));
    temp_cc = (BYTE*)qmalloc(sizeof(BYTE));
    strcpy(temp_cc, (BYTE*)(""));
    temp_bcc = (BYTE*)qmalloc(sizeof(BYTE));
    strcpy(temp_bcc, (BYTE*)(""));
	
	char_start = 'A';
	char_start_email_box = 'A';
	save_first_letter = 'A';
	SetVEEmailNameStatus(VIEW, FALSE, FALSE, 0, 0, FALSE);
	SetEmailMessTop(0,FALSE);
    SetEditEntryStatus(VIEW, 0, 0, FALSE); 
	SetMailListEntryStatus(VIEW, 0, 0, FALSE);
	SetDelEntryStatus(0,0);
	SetMailListInsertPt(FALSE, 0, 0);
	SetDialInsertPt(FALSE, 0, 0);
	
	list_email_name.list_id = LIST_NAME;
	list_find.list_id = LIST_FIND_RESULT_NAME;
	list_email_mess.list_id = LIST_EMAIL_MESS_NAME;
	list_email_name.record_id_block = list_find.record_id_block = list_email_mess.record_id_block = 0;
	list_email_name.num_items_display = list_find.num_items_display = list_email_mess.num_items_display = 0;
	list_email_name.total_num_items = list_find.total_num_items = list_email_mess.total_num_items = 0;
	list_email_name.record_id_block = list_find.record_id_block = list_email_mess.record_id_block = 0;
	
	EmailDatabaseChecking();
	
	if (restart == TRUE)
		application_status = RESTART;
	else
	{
		DataGetField(emess_dbid, EMAIL_STATUS, 0, &buffer, &byte_read);
		application_status = *buffer;
		qfree(buffer);
	}
	DataGetField(emess_dbid, EMAIL_STATUS, 1, &buffer, &byte_read);
	addr_edit_dirty = *buffer;
	qfree(buffer);
	DataGetField(emess_dbid, EMAIL_STATUS, 2, &buffer, &byte_read);
	emess_edit_dirty = *buffer;
	qfree(buffer);
    DataGetField(emess_dbid, EMAIL_STATUS, 3, &buffer, &byte_read);
    strcpy(find_string,buffer);
	qfree(buffer);
    DataGetField(emess_dbid, EMAIL_STATUS, 4, &buffer, &byte_read);
    font_size = *buffer;
	qfree(buffer);
	
	
    FormInitAllFormObjects(FORM_EMAIL_MESS_LIST);
    FormInitAllFormObjects(FORM_EDIT);
    FormInitAllFormObjects(FORM_MAIL_LIST);
    FormInitAllFormObjects(FORM_VE_EMAIL_NAME);
    FormInitAllFormObjects(FORM_EMAIL_NAME_LIST);
	
    if (MemoryLow)
		entry_low_memory = TRUE;
    else entry_low_memory = FALSE;
	
	
	if (application_status != RESTART)
	{
		DataGetField(emess_dbid, EMAIL_MESS_EDIT, 5, &buffer, &byte_read);
		edit_entry_status = *(EditEntryStatus*)buffer;
		qfree(buffer);
		
		DataGetField(emess_dbid, EMAIL_NAME_EDIT, 6, &buffer, &byte_read);
		ve_email_name_status = *(VEEmailNameStatus*)buffer;
		qfree(buffer);
		
		DataGetField(emess_dbid, EMAIL_MESS_TO, 3, &buffer, &byte_read);
		mail_list_entry_status = *(MailListEntryStatus*)buffer;
		qfree(buffer);
    }
    
	if (application_status == EDIT_EMAIL_NAME && ve_email_name_status.dbid == pb_dbid)
	{
		if (DataRecordInfo(pb_dbid, ve_email_name_status.rec_id, NULL, NULL, NULL, NULL, NULL) != TRUE)
			application_status = EMAIL_NAME_LISTING;
	}					
    
    
    if (application_status == EDIT_EMAIL_MESS)   
    {
        if (edit_entry_status.status == EDIT)
            entry_old_edit = TRUE;
        else entry_old_edit = FALSE;
    }                    
    else if (application_status == EDIT_EMAIL_TO)
    {
        if (mail_list_entry_status.status == EDIT)
            entry_old_edit = TRUE;
        else entry_old_edit = FALSE;
    }
    else if (application_status == EDIT_EMAIL_NAME)    
    {
        if (ve_email_name_status.status == EDIT)
            entry_old_edit = TRUE;
        else entry_old_edit = FALSE;    
    }        
	else entry_old_edit = FALSE;    	
    
    if (entry_low_memory && application_status != RESTART && application_status != EMAIL_NAME_LISTING &&
        application_status != EMAIL_DIAL_KEYIN)
	{
		DataGetField(emess_dbid, EMAIL_EMAIL_NAME, 2, &buffer, &byte_read);
		name_list_in_action = *buffer;
		qfree(buffer);
		
		if (application_status == EMAIL_NAME_LISTING)
		{
			if (name_list_in_action == MAIL_LIST)
			{
                false_restore = TRUE;
				application_status = RESTART;
			}				
		}
		else if (application_status == EDIT_EMAIL_NAME)
		{
			if (name_list_in_action == MAIL_LIST)
			{		
                false_restore = TRUE;
				application_status = RESTART;
			}
			else 
				application_status = EMAIL_NAME_LISTING;
		}
		else if (application_status == EDIT_EMAIL_TO || application_status == EDIT_EMAIL_MESS)
		{
            false_restore = TRUE;
			application_status = RESTART;			
		}
	}		
	
    
	if (application_status != RESTART)
	{
		DataGetField(emess_dbid, EMAIL_EMAIL_MESS, 0, &buffer, &byte_read);
		strcpy(current_email_box, buffer);
		qfree(buffer);
		
		DataGetField(emess_dbid, EMAIL_MESS_TO, 3, &buffer, &byte_read);
		mail_list_entry_status = *(MailListEntryStatus*)buffer;
		qfree(buffer);
		
		DataGetField(emess_dbid, EMAIL_MESS_TO, 4, &buffer, &byte_read);
		mail_list_insert_pt = *(MailListInsertPt*)buffer;
		qfree(buffer);
		
        DataGetField(emess_dbid, EMAIL_MESS_EDIT, 5, &buffer, &byte_read);
		edit_entry_status = *(EditEntryStatus*)buffer;
		qfree(buffer);
		
		DataGetField(emess_dbid, EMAIL_EMAIL_NAME, 0, &buffer, &byte_read);
		strcpy(current_cate, buffer);
		qfree(buffer);
		
		DataGetField(emess_dbid, EMAIL_EMAIL_NAME, 1, &buffer, &byte_read);
		char_start = *buffer;
		qfree(buffer);
		
		DataGetField(emess_dbid, EMAIL_EMAIL_NAME, 2, &buffer, &byte_read);
		name_list_in_action = *buffer;
		qfree(buffer);
		
		DataGetField(emess_dbid, EMAIL_EMAIL_NAME, 3, &buffer, &byte_read);
		strcpy(temp_cate, buffer);	
		qfree(buffer);
		
		DataGetField(emess_dbid, EMAIL_NAME_EDIT, 6, &buffer, &byte_read);
		ve_email_name_status = *(VEEmailNameStatus*)buffer;
		qfree(buffer);
		
		DataGetField(emess_dbid, EMAIL_NAME_EDIT, 7, &buffer, &byte_read);
		new_name_in_action = *buffer;
		qfree(buffer);
		
		DataGetField(emess_dbid, EMAIL_DIAL, 3, &buffer, &byte_read);
		dial_in_action = *buffer;
		qfree(buffer);
		
        if (application_status == EDIT_CATE ||
            application_status == FIND      ||
            application_status == EDIT_EMAIL_NAME ||
            application_status == EDIT_EMAIL_TO ||
            (application_status == EMAIL_NAME_LIST && name_list_in_action == MAIL_LIST) ||
            (application_status == EMAIL_DIAL_KEYIN && dial_in_action == FROM_EDIT))
        {
            
            EmailEditSetScreen();            
            for (count = FIELD_EDIT_0; count <= FIELD_EDIT_4; count++)
            {
                DataGetField(emess_dbid, EMAIL_MESS_EDIT, (count - FIELD_EDIT_0), &buffer, &byte_read);
                FieldSetText((ObjectID)count, buffer);
                qfree(buffer);
            }
			
            qfree(temp_from);
            DataGetField(emess_dbid, EMAIL_MESS_EDIT, 6, &temp_from, &byte_read);
            qfree(temp_to);
            DataGetField(emess_dbid, EMAIL_MESS_EDIT, 7, &temp_to, &byte_read);
            qfree(temp_cc);
            DataGetField(emess_dbid, EMAIL_MESS_EDIT, 8, &temp_cc, &byte_read);
            qfree(temp_bcc);
            DataGetField(emess_dbid, EMAIL_MESS_EDIT, 9, &temp_bcc, &byte_read);
			
            for (count = FIELD_MAIL_LIST_TO; count <= FIELD_MAIL_LIST_BCC; count++)
            {
                DataGetField(emess_dbid, EMAIL_MESS_TO, (count - FIELD_MAIL_LIST_TO), &buffer, &byte_read);
                FieldSetText((ObjectID)count, buffer);
                qfree(buffer);
            }
            DataGetField(emess_dbid, EMAIL_NAME_EDIT, 0, &buffer, &byte_read);
            TextboxSetText(TEXTBOX_LAST_NAME, buffer);
            strcpy(buffer1, buffer);
            qfree(buffer);
            DataGetField(emess_dbid, EMAIL_NAME_EDIT, 1, &buffer, &byte_read);
            TextboxSetText(TEXTBOX_FIRST_NAME, buffer);
            strcpy(buffer2, buffer);
            qfree(buffer);
            PhonebookPrepareFirstLastName(buffer1, buffer2, buffer3);
            StringSetText(STRING_VE_NAME, buffer3);
            DataGetField(emess_dbid, EMAIL_NAME_EDIT, 2, &buffer, &byte_read);
            FieldSetText(FIELD_C_EMAIL, buffer);
            qfree(buffer);
            DataGetField(emess_dbid, EMAIL_NAME_EDIT, 3, &buffer, &byte_read);
            FieldSetText(FIELD_H_EMAIL, buffer);
            qfree(buffer);
            DataGetField(emess_dbid, EMAIL_NAME_EDIT, 4, &buffer, &byte_read);   
            if (*(BOOLEAN*)buffer == TRUE)
                FormSetControlGroupSelection(FORM_VE_EMAIL_NAME, CHECKBOX_VE_C);
            else FormSetControlGroupSelection(FORM_VE_EMAIL_NAME, CHECKBOX_VE_H);
        }
	}
	
    switch(application_status)
	{
	case RESTART:
		app_status = EMAIL_MESS_LIST;
		strcpy(current_email_box, EMINBOX);
		EmailCateNameToPopupTriggerEmailBox();
		ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, 0);
		EmailRecordToEmailMessageList(current_email_box, char_start_email_box);
		EmailChangeFontSize(FORM_EMAIL_MESS_LIST, font_size);
		draw_scrollbar = TRUE;
		FormPopupForm(FORM_EMAIL_MESS_LIST);
		if (false_restore)
		{
			low_memory_form_id = FORM_EMAIL_MESS_LIST;
			FormPopupForm(FORM_EM_LOW_MEMORY);
		}             
		return;
	case EMAIL_MESS_LISTING:
		app_status = EMAIL_MESS_LIST;
		EmailCateNameToPopupTriggerEmailBox();
		if (ControlPopupFindItemNum(POPUP_TRIGGER_EMAIL_BOX, current_email_box,
			&item_num) == TRUE) 
			ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, (SHORT)item_num);
		else
			ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, 0);
		EmailRecordToEmailMessageList(current_email_box, char_start_email_box);
		FormPopupForm(FORM_EMAIL_MESS_LIST);
		draw_scrollbar = TRUE;
		return;
	case EMAIL_NAME_LISTING:
		if (EmailCateNameToNum(email_dbid, current_cate, &cate_number) == FALSE)
			strcpy(current_cate, EMALL);
		
		EmailRecordToList(current_cate, char_start,NULL);
		EmailSetAddressListTopItemNum(char_start,0, FALSE);
		EmailCateNameToPopupTrigger(email_dbid);
		EmailChangeFontSize(FORM_EMAIL_NAME_LIST, font_size);
		FormPopupForm(FORM_EMAIL_NAME_LIST);
		break;
	case EDIT_EMAIL_MESS:
		if (edit_entry_status.status == EDIT)
		{
			FieldSetInsertPointOn(FIELD_EDIT_1);
			FieldSetInsertPointPositionByCharPos(FIELD_EDIT_1, 0);
		}
		FormSetFormActiveObject(FORM_EDIT, FIELD_EDIT_1);
		EmailChangeFontSize(FORM_EDIT, font_size);
		FormPopupForm(FORM_EDIT);
		break;
	case EDIT_EMAIL_TO:
		FieldSetInsertPointOn(FIELD_MAIL_LIST_TO);
		FieldSetInsertPointPositionByCharPos(FIELD_MAIL_LIST_TO, 0);
		FormSetFormActiveObject(FORM_MAIL_LIST, FIELD_MAIL_LIST_TO);
		SetMailListInsertPt(TRUE, FIELD_MAIL_LIST_TO, 0);
		EmailChangeFontSize(FORM_MAIL_LIST, font_size);
		FormPopupForm(FORM_MAIL_LIST);
		break;
	case EDIT_EMAIL_NAME:
		EmailCateNameToPopupTrigger(email_dbid);
		ControlPopupDeleteItem(POPUP_TRIGGER_CATE, 0);
		if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, temp_cate,
			&item_num) == TRUE) 
			ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
		else
			ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
		EmailSetupViewEditEmailNameScreen();
		if (ve_email_name_status.status == EDIT)
		{
			TextboxSetInsertPointOn(TEXTBOX_LAST_NAME);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_LAST_NAME, 0);
		}			    
		FormPopupForm(FORM_VE_EMAIL_NAME);
		break;
	case EMAIL_DIAL_KEYIN:
		FormInitAllFormObjects(FORM_DIAL);                         
		DataGetField(emess_dbid, EMAIL_DIAL, 0, &buffer, &byte_read);
		TextboxSetText(TEXTBOX_DIAL, buffer);
		qfree(buffer);
		DataGetField(emess_dbid, EMAIL_DIAL, 1, &buffer, &byte_read);
		TextboxSetText(TEXTBOX_DIAL_OUT, buffer);
		qfree(buffer);
		DataGetField(emess_dbid, EMAIL_DIAL, 2, &buffer, &byte_read);
		FormGetObjectPointer(CHECKBOX_DIAL_OUT, &object_type, (void**)&control_ptr);
		((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = *(BOOLEAN*)buffer;
		qfree(buffer);
		
		DataGetField(emess_dbid, EMAIL_DIAL, 4, &buffer, &byte_read);
		if ((*(ObjectID*)buffer) != 0)
		{           
			FormGetObjectPointer((*(ObjectID*)buffer), &object_type, (void**)&control_ptr);
			((ControlTemplatePushButton*)(control_ptr->control_template))->control_value = TRUE;
		}                
		qfree(buffer);            
		
		EmailDialSetScreen();
		FormPopupForm(FORM_DIAL);
		break;
	default: break;
	}
	EmailCateNameToPopupTriggerEmailBox();
	if (ControlPopupFindItemNum(POPUP_TRIGGER_EMAIL_BOX, current_email_box,
		&item_num) == TRUE) 
		ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, (SHORT)item_num);
	else
		ControlPopupSetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, 0);
    if (EmailCateNameToNum(email_dbid, current_cate, &cate_number) == FALSE)
		strcpy(current_cate, EMALL);		
	EmailRecordToList(current_cate, char_start,NULL);
    draw_scrollbar = TRUE;
}

/********************************************************
* Function:	EmailDatabaseChecking
* Purpose: 	This function is called to check whether the required database 
is already exist or not. If not, it will creat it
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EmailDatabaseChecking()
{
	BYTE	    application_status;
	UWORD	    time_index;
	BYTE	    temp;
	BOOLEAN     control_value;
	ObjectID    id = 0;
	
	/* Check pb_dbid */
	if (DataFindDB(PHONEDB, &pb_dbid) != TRUE)
	{
		/* New Database */
		DataNewDB(PHONEDB, 1, PHONEAPP, &pb_dbid);
        DataOpenDB(pb_dbid, SORT_TEXT_MODE | 2,OPEN_RW);
		
		/* Open Database */
		DataCategorySetName(pb_dbid,0, EMUNFILED);
		DataCategorySetName(pb_dbid,1, EMBUS);
		DataCategorySetName(pb_dbid,2, EMPER);
	}
	else if (DataIsDBOpen(pb_dbid, NULL, NULL) == FALSE)
        DataOpenDB(pb_dbid, SORT_TEXT_MODE | 2, OPEN_RW);
	
	/* Check email_dbid */
	if (DataFindDB(EMAILDB, &email_dbid) != TRUE)
	{
		/* New Database */
		DataNewDB(EMAILDB, 1, EMAILAPP, &email_dbid);
        DataOpenDB(email_dbid, SORT_TEXT_MODE | 2,OPEN_RW);
		
		/* Open Database */
		DataCategorySetName(email_dbid, 0, EMUNFILED);
		DataCategorySetName(email_dbid, 1, EMBUS);
		DataCategorySetName(email_dbid, 2, EMPER);
	}
	else if (DataIsDBOpen(email_dbid, NULL, NULL) == FALSE)
        DataOpenDB(email_dbid, SORT_TEXT_MODE | 2, OPEN_RW);
	
	/* Check emess_dbid */
	if (DataFindDB(EMSGDB, &emess_dbid) != TRUE)
	{
		/* New Database */
		DataNewDB(EMSGDB, 0, EMAILAPP, &emess_dbid);
		DataOpenDB(emess_dbid,1,OPEN_RW);
		
		/* Open Database */
		DataCategorySetName(emess_dbid, 0, (BYTE*)(""));
		DataCategorySetName(emess_dbid, 1, EMINBOX);
		DataCategorySetName(emess_dbid, 2, EMOUTBOX);
		DataCategorySetName(emess_dbid, 3, EMSENT);
		DataCategorySetName(emess_dbid, 4, EMDRAFT);	
	}
	else if (DataIsDBOpen(emess_dbid, NULL, NULL) == FALSE)
		DataOpenDB(emess_dbid, 1,OPEN_RW);
	
	
	if (DataRecordInfo(emess_dbid, TIME_INDEX_RECID, NULL, NULL, NULL, NULL, NULL) != TRUE)
	{
		DataNewRecordWithID(emess_dbid, TIME_INDEX_RECID, 0, 4);
		time_index = 0;
		DataWriteField(emess_dbid, TIME_INDEX_RECID, 0, 4, (BYTE*) &time_index);
		DataWriteField(emess_dbid, TIME_INDEX_RECID, 1, 4, (BYTE*) &time_index);
		DataWriteField(emess_dbid, TIME_INDEX_RECID, 2, 4, (BYTE*) &time_index);
		DataWriteField(emess_dbid, TIME_INDEX_RECID, 3, 4, (BYTE*) &time_index);
	}
	
	if (DataRecordInfo(emess_dbid, EMAIL_STATUS, NULL, NULL, NULL, NULL, NULL) != TRUE)
	{
        DataNewRecordWithID(emess_dbid, EMAIL_STATUS, 0, 5);
		application_status = RESTART;
		DataWriteField(emess_dbid, EMAIL_STATUS, 0, 1, &application_status);
		temp = 0;
		DataWriteField(emess_dbid, EMAIL_STATUS, 1, 1, &temp);
		DataWriteField(emess_dbid, EMAIL_STATUS, 2, 1, &temp);
        DataWriteField(emess_dbid, EMAIL_STATUS, 3, 1, (BYTE*)(""));
        temp = SMALL_FONT;
        DataWriteField(emess_dbid, EMAIL_STATUS, 4, 1, &temp);
	}
	
	if (DataRecordInfo(emess_dbid, EMAIL_EMAIL_MESS, NULL, NULL, NULL, NULL, NULL) != TRUE)
		DataNewRecordWithID(emess_dbid, EMAIL_EMAIL_MESS, 0, 1);
	if (DataRecordInfo(emess_dbid, EMAIL_MESS_TO, NULL, NULL, NULL, NULL, NULL) != TRUE)
		DataNewRecordWithID(emess_dbid, EMAIL_MESS_TO, 0, 5);		
	
	if (DataRecordInfo(emess_dbid, EMAIL_MESS_EDIT, NULL, NULL, NULL, NULL, NULL) != TRUE)
    {
        DataNewRecordWithID(emess_dbid, EMAIL_MESS_EDIT, 0, 10);
        DataWriteField(emess_dbid, EMAIL_MESS_EDIT, 6, 1, (BYTE*)(""));
        DataWriteField(emess_dbid, EMAIL_MESS_EDIT, 7, 1, (BYTE*)(""));
        DataWriteField(emess_dbid, EMAIL_MESS_EDIT, 8, 1, (BYTE*)(""));
        DataWriteField(emess_dbid, EMAIL_MESS_EDIT, 9, 1, (BYTE*)(""));
    }
	
	if (DataRecordInfo(emess_dbid, EMAIL_EMAIL_NAME, NULL, NULL, NULL, NULL, NULL) != TRUE)
		DataNewRecordWithID(emess_dbid, EMAIL_EMAIL_NAME, 0, 4);
	if (DataRecordInfo(emess_dbid, EMAIL_NAME_EDIT, NULL, NULL, NULL, NULL, NULL) != TRUE)
		DataNewRecordWithID(emess_dbid, EMAIL_NAME_EDIT, 0, 8);
	if (DataRecordInfo(emess_dbid, EMAIL_DIAL, NULL, NULL, NULL, NULL, NULL) != TRUE)
	{
		DataNewRecordWithID(emess_dbid, EMAIL_DIAL, 0, 5);
		id = 0;
		DataWriteField(emess_dbid, EMAIL_DIAL, 4, sizeof(ObjectID), (BYTE*)&id);
		
		DataWriteField(emess_dbid, EMAIL_DIAL, 0, 1, (BYTE*)(""));
		DataWriteField(emess_dbid, EMAIL_DIAL, 1, 1, (BYTE*)(""));
		control_value = FALSE;
		DataWriteField(emess_dbid, EMAIL_DIAL, 2, sizeof(BOOLEAN), (BYTE*)&control_value);
		
	}
	
}
