/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   emaildb.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"

UBYTE chartoupper(UBYTE x)
{
	if((x>='a') && (x<='z'))
		x-= 32;
	return x;
}


/*****************************************************************
********************* Database Initialisation ********************
*****************************************************************/

/********************************************************
* Function:	EmailDatabaseClose
* Purpose: 	This fucntion is called in order to close 
email database				
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	This function should be called in the StopApplication
*********************************************************/
void EmailDatabaseClose()
{
	
}
/********************************************************
* Function:	EmailDatabaseInit
* Purpose: 	This function is used to simulate and initialse the 
the datebase in the PDA.Try to preset some records in 
the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	This function should be called in the StartApplication() function.
*********************************************************/
void EmailDatabaseInit()
{
}

/********************************************************
* Function:	EmailCompareTwoStrings
* Purpose: 	This function is called in order to compare two Strings
* Scope:		application
* Input:		string1			string 1
string2			string 2
* Output:		None
* Return:		FIRST			string 1 is smaller string 2
SECOND			string 2 is smaller string 1
SAME			string 1 = string 1
* Comment: 	
*********************************************************/
BYTE EmailCompareTwoStrings(BYTE *string1, BYTE *string2)
{
	USHORT i = 0;
	BYTE result = SAME;
	
	while((UBYTE)string1[i] && (UBYTE)string2[i])
	{
		if(chartoupper((UBYTE)string1[i]) < chartoupper((UBYTE)string2[i]))
		{
			result = FIRST;
			break;
		}
		else if(chartoupper((UBYTE)string2[i]) < chartoupper((UBYTE)string1[i]))
		{
			result = SECOND;
			break;
		}
		/*        else
		{
		if(string1[i] > string2[i])
		{
		result = FIRST;
		break;
		}
		else if(string2[i] > string1[i])
		{
		result = SECOND;
		}
		}
		*/
		i++;
	}
	if(result != SAME)
		return result;
	
	if(string1[i])
		return SECOND;
	
	if(string2[i])
		return FIRST;
	
	return SAME;
	
}

/********************************************************
* Function:	EmailCateNameToNum
* Purpose: 	This function is used find out the cate num
* Scope:		application
* Input:		dbid			The database ID
cate_name		The category name
* Output:		cate_num
* Return:		TRUE		found
FALSE		not exist
* Comment: 	The passed-in database must be opend 
*********************************************************/
BOOLEAN EmailCateNameToNum(DatabaseID dbid, BYTE *cate_name, UBYTE *cate_num)
{
	UBYTE cate[256];
	USHORT i;
	UBYTE num_cate;
	BYTE *cate_cate;
	
	num_cate = DataCategorySort(dbid, cate);
	cate_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
	for (i = 0; i < num_cate; i++)
	{
		DataCategoryName(dbid,cate[i],cate_cate);
		if (EmailCompareTwoStrings(cate_name,cate_cate) == SAME)
		{
			*cate_num = cate[i];
			qfree(cate_cate);
			return TRUE;
		}
	}
	DataCategoryName(dbid,0,cate_cate);
	if (EmailCompareTwoStrings(cate_name,cate_cate) == SAME)
	{
		*cate_num = 0;
		qfree(cate_cate);
		return TRUE;
	}
	qfree(cate_cate);
	*cate_num = 255;
	return FALSE;
}
