/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   appfunc.h
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef __APPFUNC_H_
#define __APPFUNC_H_

/*#include "uifunc.h"
#include "ui.h"
#include "app.h"*/
#include "listdis.h"
#include "system.h"
#include "appfunc.h"


/*==========================================================
================= Application Event Handler ================
===========================================================*/
void EventLoop();
BOOLEAN EmailEmailNameList(EvtType *Event);
BOOLEAN EmailEditCate(EvtType* Event);
BOOLEAN EmailInputCate(EvtType *Event);
BOOLEAN EmailNoCate(EvtType *Event);
BOOLEAN EmailNameExists(EvtType *Event);
BOOLEAN EmailEraseCate(EvtType *Event);
BOOLEAN EmailRemoveCate(EvtType *Event);
BOOLEAN EmailCateFull(EvtType *Event);
BOOLEAN EmailFindBackground(EvtType *Event);
BOOLEAN EmailFindInput(EvtType *Event);
BOOLEAN EmailNameNotFound(EvtType *Event);
BOOLEAN EmailFindResult(EvtType *Event);
BOOLEAN EmailVEEmailName(EvtType *Event);
BOOLEAN EmailSaveChanges(EvtType *Event);
BOOLEAN EmailVEEmailNameDelConfirm(EvtType *Event);
BOOLEAN EmailEmailMessageList(EvtType *Event);
BOOLEAN EmailEdit(EvtType *Event);
BOOLEAN EmailMailList(EvtType *Event);
BOOLEAN EmailView(EvtType *Event);
BOOLEAN EmailReplyTo(EvtType *Event);
BOOLEAN EmailEmailErase(EvtType *Event);
BOOLEAN EmailMessageSaveChanges(EvtType *Event);
BOOLEAN EmailProgramMissing(EvtType *Event);
BOOLEAN EmailDial(EvtType *Event);
BOOLEAN EmailCommError(EvtType *Event);
BOOLEAN EmailConnect(EvtType *Event);
BOOLEAN EmailEmptyToField(EvtType *Event);
BOOLEAN EmailLowMemoryHandle(EvtType* Event);
BOOLEAN EmailDiscardChangesHandle(EvtType *Event);

/*==========================================================
================= Environment Setup Function ===============
===========================================================*/
void PhonebookDatabaseInit();
void PhonebookDatabaseClose();
void EmailDatabaseClose();
void EmailDatabaseInit();
void EmailMessageDatabaseClose();
void EmailMessageDatabaseInit();
void EmailConvertDate(BYTE *input_date, BYTE *date);

BYTE EmailCompareTwoStrings(BYTE *string1, BYTE *string2);
BOOLEAN EmailCateNameToNum(DatabaseID dbid, BYTE *cate_name, UBYTE *cate_num);
BOOLEAN EmailGetRecNumWithCateName(DatabaseID dbid, BYTE *cate_name, UWORD rec_num[], UWORD *num_rec);
BOOLEAN EmailMessageGetNameEmail(BYTE *buffer0, 
								 BYTE ***name, BYTE ***emails, USHORT *num_items,
								 BOOLEAN all_data);

/*==========================================================
================= Application Global Function ===============
===========================================================*/
BOOLEAN EmailGetTableMaxNumLines(ObjectID table_id, BYTE font_id, WORD *max_num_lines);
BOOLEAN EmailGetTableNumLines(ObjectID table_id, USHORT ref_row, WORD *total_num_lines);
WORD EmailGetScrollbarMaxValue(ObjectID table_id, USHORT ref_col);
BOOLEAN EmailKeyboardChangeLayout(USHORT ref_col, SHORT no_key_height,
								  SHORT with_key_height);

/*==========================================================
=============== Email Address List Functions ===============
===========================================================*/
BOOLEAN EmailRecordToList(BYTE *cate_name, BYTE starting_char, BYTE *starting_string);
BOOLEAN EmailListDisplayDrawAddressList(ListDisplay *list_display);
BOOLEAN EmailSetAddressListTopItemNum(BYTE start_char, UWORD nth_record, BOOLEAN preset);
BOOLEAN EmailAddressListSetScrollbar();
void EmailStartCharSetTab(BYTE in_char);
void EmailCateNameToPopupTrigger(DatabaseID dbid);
void EmailScrollbarSetAddressList(EvtType *Event);
BOOLEAN EmailPopupCateActions(SHORT selected_item);
BOOLEAN EmailListSelectedItemAction(ListDisplay *list_display, EvtType *Event);
void	EmailChangeListFont(void);
void EmailChangeFontSize(ObjectID form_id, BYTE font_size);

/*==========================================================
================= Input Cate Functions =====================
===========================================================*/
BOOLEAN InputCatCheckCharIn();

/*==========================================================
================= Edit Categories Functions ================
===========================================================*/
BOOLEAN DeleteCateCheck(SHORT selected_item);
BOOLEAN DeleteCate(SHORT selected_item);
BOOLEAN EmailEditCateSetScrollbar();
void EmailScrollbarSetEditCate(EvtType *Event);

/*==========================================================
================= Find Input Functions =====================
===========================================================*/
BOOLEAN InputFindCharInCheck();
BOOLEAN EmailSearchForText(BYTE *short_string, BYTE *whole_string);

/*==========================================================
================= Find Result Functions =====================
===========================================================*/
BOOLEAN EmailScrollbarSetFindResult(EvtType *Event);

/*==========================================================
======= View Edit New Email Address Functions ===============
===========================================================*/
BOOLEAN EmailSetupViewEditEmailNameScreen();
BOOLEAN EmailVEEmailNameDrawObjects();
void EmailCombineFirstLastName(BYTE *in_string1, BYTE *in_string2, BYTE **out_string);
BOOLEAN EmailVEEmailNameSaveRecord();
BOOLEAN EmailVEEmailNameCheckRecordEmpty();
void PhonebookPrepareFirstLastName(BYTE *in_string1, BYTE *in_string2, BYTE *out_string);
void PhonebookPrepareLastFirstName(BYTE *in_string1, BYTE *in_string2, BYTE *out_string);
void PhonebookPrepareLastFirstNameForDisplay(BYTE *in_string1, BYTE *in_string2, BYTE *out_string);
void PhonebookPrepareLastFirstNameForDisplay1(BYTE *in_string1, BYTE *in_string2, BYTE *out_string);

/*==========================================================
========= VE Email Name ERASE Confirmation Functions =======
===========================================================*/
BOOLEAN EmailVEEmailNameDeleteRecord(BOOLEAN archive);
BOOLEAN EmailVEEmailNameDelSetupScreen();

/*==========================================================
=============== Email Message List Functions ===============
===========================================================*/
void EmailCateNameToPopupTriggerEmailBox();
BOOLEAN EmailRecordToEmailMessageList(BYTE *cate_name, BYTE starting_char);
BOOLEAN EmailGetEMessRecNumWithCateName(DatabaseID dbid, BYTE *cate_name, UWORD rec_num[], UWORD *num_rec);
BOOLEAN EmailSetEmailMessageListTopItemNum(BYTE start_char);
BOOLEAN EmailEmailMessageListSetScrollbar();
BOOLEAN EmailListDisplayDrawEmailMessageList(ListDisplay *list_display);
BOOLEAN EmailEmailMessagePopupCateActions(SHORT selected_item);
void EmailScrollbarSetEmailMessageList(EvtType *Event);
BOOLEAN EmailMessListSelectedItemAction(ListDisplay *list_display, EvtType *Event);
void EmailPrepareCorrectDateFormat(BYTE *input_date, BYTE **output_date);

/*==========================================================
==================== Edit Functions ===================
===========================================================*/
BOOLEAN EmailEditSetScreen();
BOOLEAN EmailSetEditTable(ObjectID form_id, ObjectID table_id);
BOOLEAN EmailEditTableSetScrollbar(ObjectID table_id, ObjectID scrollbar_id);
BOOLEAN EmailScrollbarSetEditTable(ObjectID table_id, ObjectID scrollbar_id, EvtType *Event);
BOOLEAN EmailKeyInChangeEditTable(ObjectID form_id, ObjectID table_id, ObjectID scrollbar_id);
BOOLEAN EmailDecideTopRowNum(ObjectID table_id, ObjectID active_id);						  
BOOLEAN EmailMessageResend(RecordID *top_rec_id);
BOOLEAN EmailMessageSave(UBYTE *email_box, RecordID *top_rec_id);
BOOLEAN EmailEditChangeFont(BOOLEAN draw);
BOOLEAN EmailMessageCheckTOFieldEmpty();

/*==========================================================
==================== Mail List Functions ===================
===========================================================*/
BOOLEAN EmailMailListSetScreen();
void EmailMailListGetInsertPos();
void EmailGetLineOfEmail(BYTE **email);
void EmailGetFirstEmailAddr(BYTE **email_addr);
BOOLEAN EmailMailListChangeFont(BOOLEAN draw);

/*==========================================================
==================== Reply Forward Functions ===================
===========================================================*/
void EmailReplyForwardPutData(BYTE mode);

/*==========================================================
============= Application Save and Restore ===================
===========================================================*/
void EmailAppSave();
void EmailAppRestore(BOOLEAN restart);
void EmailDatabaseChecking();


/*==========================================================
============= Menu Item Functions ===================
===========================================================*/
void MenuItemSelectedAction(USHORT item_num);
void MenuItemSelectedAction1(USHORT item_num);

/*==========================================================
=============  Email Connect Functions ===================
===========================================================*/
void EmailConnectSetScreen();
void EmailConnectInsertTextToField(BYTE *in_text);
void EmailConnectScrollbarSetField(EvtType *Event);
void EmailConnectFieldSetScrollbar();

/*==========================================================
=============  Email Dial Functions ===================
===========================================================*/
void EmailDialSetScreen();
void EmailDialPushButtonAction(UWORD push_button);

/*==========================================================
=============  Email App Launch Functions ===================
===========================================================*/
BOOLEAN EmailAppLaunch(WORD cmd, void *cmd_ptr);
void EmailGotoItem(DatabaseID dbid, RecordID rec_id, USHORT field_num, BYTE *search_string);
void EmailPrepareFindText(DatabaseID dbid, RecordID rec_id, BYTE **prepare_string);

#endif
