/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   listdis.h
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef __LISTDIS_H_
#define __LISTDIS_H_

#include "app.h"

typedef struct _RecordIDBlock
{
	BYTE num_records;
	RecordID record_id[20];
	DatabaseID dbid[20];
	struct _RecordIDBlock *next;
} RecordIDBlock;


typedef struct _ListDisplay
{
	ObjectID list_id;
	USHORT max_num_items_display;
	USHORT num_items_display;
	USHORT total_num_items;
	USHORT top_item_num;
	RecordIDBlock *record_id_block;
} ListDisplay;



/*==========================================================
================= List Display Functions =====================
===========================================================*/
void ListDisplaySetNumItemsDisplay(ListDisplay *list_display, USHORT num_items);
void ListDisplaySetTotalNumItems(ListDisplay *list_display, USHORT num_items);
void ListDisplaySetTopItemNum(ListDisplay *list_display, USHORT item_num);
void ListDisplayInsertRecordID(ListDisplay *list_display, RecordID record_id, DatabaseID dbid);
BOOLEAN ListDisplayDeleteAllRecordID(ListDisplay *list_display);
BOOLEAN ListDisplayGetText(ListDisplay *list_display, USHORT field_num, USHORT item_num, BYTE **text);
BOOLEAN ListDisplayGetRecordID(ListDisplay *list_display, USHORT item_num, RecordID *rec_id, DatabaseID *dbid);
#endif
