/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   maillist.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"

/********************************************************
* Function:	EmailMailListGetInsertPtPos
* Purpose: 	This function is called in order to get the 
information about where the insert pt is in the MAIL_LIST
Screen
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE		Success
FALSE		NotHandled
* Comment: 	None
*********************************************************/
void EmailMailListGetInsertPos()
{
	Field *field_ptr;
	BYTE object_type;
	ObjectID activeID;
	
	FormGetActiveObject(FORM_MAIL_LIST,&activeID);
	if (activeID < FIELD_MAIL_LIST_TO || activeID > FIELD_MAIL_LIST_BCC)
	{
		SetMailListInsertPt(FALSE, 0, 0);
		return;
	}
	FormGetObjectPointer(activeID, &object_type, (void**)&field_ptr);
	if (field_ptr->field_attr.field_insert_pt_visible == TRUE)
		SetMailListInsertPt(TRUE, field_ptr->identification.ui_object_id,
		field_ptr->field_insert_pt_char_pos);
}

/********************************************************
* Function:	EmailMailListSetScreen
* Purpose: 	This function is called in order to set the layout of the 
Edit screen
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE		Success
FALSE		NotHandled
* Comment: 	None
*********************************************************/
BOOLEAN EmailMailListSetScreen()
{
    BYTE        object_type;
    Table       *table_ptr;
    Scrollbar   *scroll_ptr;
    ObjectID    count_id;
    Field       *field_ptr;
    Control     *control_ptr;
	
	/*Setup Table*/
	FormGetObjectPointer(TABLE_MAIL_LIST, &object_type, (void**)&table_ptr);
	FormGetObjectPointer(SCROLLBAR_MAIL_LIST, &object_type, (void**)&scroll_ptr);
	if (KeyboardCheckKeyboardStatus())
	{
		scroll_ptr->bounds.height = 80;
		table_ptr->bounds.height = 80;
	}
	else
	{
		scroll_ptr->bounds.height = 124;
		table_ptr->bounds.height = 124;
	}
	
	if (mail_list_entry_status.status == VIEW)
		table_ptr->table_attr.table_enable = FALSE;
	else
		table_ptr->table_attr.table_enable = TRUE;
	
	/*initialisation of Field's backline */
	for (count_id = FIELD_MAIL_LIST_TO; count_id <= FIELD_MAIL_LIST_BCC; count_id++)
	{
		FormGetObjectPointer(count_id, &object_type, (void**)&field_ptr);
        if (mail_list_entry_status.status == EDIT)
			field_ptr->field_back_line = GREY_LINE;
		else field_ptr->field_back_line = NO_LINE;
	}
	
	
    /* BUTTON_MAIL_LIST */
	FormGetObjectPointer(BUTTON_MAIL_LIST, &object_type, (void**)&control_ptr);
	if (mail_list_entry_status.status == VIEW)
		control_ptr->control_attr.control_visible = FALSE;
	else control_ptr->control_attr.control_visible = TRUE;
    
    /* BUTTON_MAIL_LIST */
	FormGetObjectPointer(BUTTON_MAIL_LIST_ADD, &object_type, (void**)&control_ptr);
	if (mail_list_entry_status.status == VIEW)
		control_ptr->control_attr.control_visible = FALSE;
	else control_ptr->control_attr.control_visible = TRUE;
    
	
	
	
    return TRUE;
}

void EmailGetLineOfEmail(BYTE **email)
{
	Field	*field_ptr;
	BYTE	object_type;
	BYTE	*buffer;
	WORD	length = 0;
	WORD	count = 0;
	WORD	start = 0xFFFF,end = 0xFFFF;
	WORD	num_chars = 0;
	
	FormGetObjectPointer(mail_list_insert_pt.field_id, &object_type, (void**)&field_ptr);
	
	num_chars = strlen(field_ptr->field_string);
	/*finding the starting point of copy */
	if (mail_list_insert_pt.insert_pt_char_pos == 0)
		start = 0;
	else
	{
		for (count = (mail_list_insert_pt.insert_pt_char_pos - 1); count >=0; count--)
		{
			if (field_ptr->field_string[count] != '\r')
				start = count;
			if (field_ptr->field_string[count] == '\r')
				break;
		}
	}
	
	if (start == 0xFFFF)
		start = mail_list_insert_pt.insert_pt_char_pos;
	
	
	/*finding the end point of copy */
	if (mail_list_insert_pt.insert_pt_char_pos == (WORD)(strlen(field_ptr->field_string)))
		end = num_chars - 1;
	else
	{
		end = mail_list_insert_pt.insert_pt_char_pos;
		for (count = mail_list_insert_pt.insert_pt_char_pos; count < (WORD)(strlen(field_ptr->field_string)); count++)
		{
			if (field_ptr->field_string[count] != '\r')
				end = count;
			if (field_ptr->field_string[count] == '\r')
				break;
		}
	}
	
	if (end == 0xFFFF)
		end = num_chars;
	
	
	length = num_chars + 1;
	
	(*email) = (BYTE*)qmalloc(length*sizeof(BYTE));
	buffer = field_ptr->field_string;
	buffer += start;
	strcpy((*email), buffer);
	(*email)[end - start + 1] = '\0';
}

/********************************************************
* Function:	EmailGetLineOfEmail
* Purpose: 	This function is called in order to get the 
email in the line that the insert point is on
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE		Success
FALSE		NotHandled
* Comment: 	None
*********************************************************/
void EmailGetFirstEmailAddr(BYTE **email_addr)
{
	Field *field_ptr;
	BYTE object_type;
	BYTE *buffer;
	WORD length = 0;
	WORD count = 0;
	WORD start,end;
	BYTE *field_text;
	WORD i;
	BOOLEAN found = FALSE;
	
	/*	for (i = FIELD_MAIL_LIST_TO; i <= FIELD_MAIL_LIST_BCC; i++)
	{
	FieldGetTextPointer((ObjectID)(i), &field_text);
	if (strlen(field_text) != 0)
	{
	found = TRUE;
	break;
	}
	}
	
	  if (found == FALSE)
	  {
	  (*email_addr) = (BYTE*)qmalloc(1*sizeof(BYTE));
	  strcpy((*email_addr), (BYTE*)(""));
	  return;
	  }
	*/
	FieldGetTextPointer(FIELD_MAIL_LIST_TO, &field_text);
	if (strlen(field_text) == 0)
	{
		(*email_addr) = (BYTE*)qmalloc(1*sizeof(BYTE));
		strcpy((*email_addr), (BYTE*)(""));
        return;
	}
	
	FormGetObjectPointer(FIELD_MAIL_LIST_TO, &object_type, (void**)&field_ptr);
	
	/*finding the starting point of copy */
	start = 0;
	
	/*finding the end point of copy */
	for (count = 0; count < (WORD)(strlen(field_ptr->field_string)); count++)
	{
		if (field_ptr->field_string[count] != '\r')
			end = count;
		if (field_ptr->field_string[count] == '\r')
			break;
	}
	
	length = strlen(field_ptr->field_string) + 1;
	
	(*email_addr) = (BYTE*)qmalloc(length*sizeof(BYTE));
	buffer = field_ptr->field_string;
	buffer += start;
	strcpy((*email_addr), buffer);
	(*email_addr)[end - start + 1] = '\0';
}
