/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   replyfor.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"

/********************************************************
* Function:	EmailReplyForwardPutData
* Purpose: 	This function is called to put reply for forward data
to FORM_EDIT screen
* Scope:		application/internal
* Input:		mode		REPLY_TO_ALL or FORWARD or REPLY_TO_SENDER
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EmailReplyForwardPutData(BYTE mode)
{
	BYTE *separator;
	BYTE *body, *body1;
	WORD total_length = 0;
	WORD count = 0;
	BYTE *buffer;
	BYTE *subj, *subj1, *subject;
	UWORD rec_num;
	RecordID rec_id;
	BYTE **names, **emails;
	UWORD byte_read;
	USHORT num_items;
	BYTE *to = NULL, *to1 = NULL;
	BYTE *temp;
	WORD whole_length;
	BYTE *cc, *cc1;
	
	
	separator = (BYTE*)qmalloc(40*sizeof(BYTE));
	if (mode != FORWARD)
		strcpy(separator, EMSTR16);
	else strcpy(separator, EMSTR17);
	
	for (count = 0; count < 4; count++)
	{
		FieldGetTextPointer((ObjectID)(FIELD_EDIT_0 + count), &buffer);
		total_length += strlen(buffer);
	}
    FieldGetTextPointer(FIELD_EDIT_4, &buffer);
    total_length += strlen(buffer) + 200;
	
	body = (BYTE*)qmalloc(total_length*sizeof(BYTE));
	body1 = body;
	*body1 = '\r';
	body1 ++;
	strcpy(body1, separator);
	body1 += strlen(separator);
	*body1 = '\r';
	body1 ++;
	strcpy(body1, EMFROM1);
	body1 += strlen(EMFROM1);
	FieldGetTextPointer(FIELD_EDIT_1, &buffer);
	strcpy(body1, buffer);
	body1 += strlen(buffer);
	*body1 = '\r';
	body1 ++;
	strcpy(body1, EMSUBJ1);
	body1 += strlen(EMSUBJ1);
	FieldGetTextPointer(FIELD_EDIT_2, &buffer);
	strcpy(body1, buffer);
	subj = (BYTE*)qmalloc((strlen(buffer) + 10)*sizeof(BYTE));
	subject = (BYTE*)qmalloc((strlen(buffer) + 1)*sizeof(BYTE));
	strcpy(subject, buffer);
	subj1 = subj;
	body1 += strlen(buffer);
	*body1 = '\r';
	body1 ++;
	strcpy(body1, EMBODY1);
	body1 += strlen(EMBODY1);
	FieldGetTextPointer(FIELD_EDIT_4, &buffer);
	strcpy(body1, buffer);
	FieldSetText(FIELD_EDIT_2, body);
	FieldGetTextPointer(FIELD_EDIT_2, &buffer);
	qfree(body);
	
	if (mode == REPLY_TO_ALL)
	{
		FormInitAllFormObjects(FORM_MAIL_LIST);
		strcpy(subj1, EMRE1);
		subj1 += 4;
		strcpy(subj1, subject);
		FieldSetText(FIELD_EDIT_1, subj);
		qfree(subj);
		EmailMessageGetNameEmail(temp_cc, &names, &emails, &num_items, TRUE);
		whole_length = 0;
		if (num_items != 0)
		{
			for (count = 0; count < num_items; count++)
				whole_length += strlen(emails[count]) + 1;
			cc = (BYTE*)qmalloc(whole_length * sizeof (BYTE));
			cc1 = cc;
			for (count = 0; count < num_items; count++)
			{
				strcpy(cc, emails[count]);
				if (count != num_items - 1)
				{
					cc += strlen(emails[count]);
					*cc = '\r';
					cc ++;
				}
				qfree(emails[count]); qfree(names[count]);
			}
			qfree(names); qfree(emails);
			FieldSetText(FIELD_MAIL_LIST_CC, cc1);
			qfree(cc1);
		}
		EmailMessageGetNameEmail(temp_from, &names, &emails, &num_items, FALSE);
		temp = NULL;
		if (num_items > 0)
		{
			temp = (BYTE*)qmalloc((strlen(emails[0]) + 1)*sizeof(BYTE));
			strcpy(temp, emails[0]);
			qfree(emails[0]); qfree(names[0]); qfree(names); qfree(emails);
			FieldSetText(FIELD_EDIT_0, temp);
		}
		EmailMessageGetNameEmail(temp_to, &names, &emails, &num_items, TRUE);
		if (temp)
			whole_length = strlen(temp) + 1;
		else
			whole_length = 0;		
		to = NULL;
		if (num_items != 0)
		{
			for (count = 0; count < num_items; count++)
				whole_length += strlen(emails[count]) + 1;
			to = (BYTE*)qmalloc(whole_length * sizeof (BYTE));
			to1 = to;
			if (temp != NULL)
			{
				strcpy(to, temp);
				to += strlen(temp);
				*to = '\r';
				to ++;
				qfree(temp);
				temp = NULL;
			}
			for (count = 0; count < num_items; count++)
			{
				if (strlen(emails[count]) == 0)
					continue;				
				strcpy(to, emails[count]);
				if (count != num_items - 1)
				{
					to += strlen(emails[count]);
					*to = '\r';
					to ++;
				}
				qfree(emails[count]); qfree(names[count]);
			}
			qfree(emails); qfree(names);
		}
		
		if (to == NULL && temp)
		{
			if (strlen(temp))
				to1 = temp;
		}
		
		if (to1)
		{
			FieldSetText(FIELD_MAIL_LIST_TO, to1);
			qfree(to1);
		}
		else
			FieldSetText(FIELD_MAIL_LIST_TO, (BYTE*)"");
		
		return;
	}
	else if (mode == REPLY_TO_SENDER)
	{
		FormInitAllFormObjects(FORM_MAIL_LIST);
		strcpy(subj1, EMRE1);
		subj1 += 4;
		strcpy(subj1, subject);
		EmailMessageGetNameEmail(temp_from, &names, &emails, &num_items, FALSE);
		if (num_items == 0)
		{
			FieldSetText(FIELD_EDIT_0, (BYTE*)(""));
			FieldSetText(FIELD_MAIL_LIST_TO, (BYTE*)(""));
		}
		else
		{	
			FieldSetText(FIELD_EDIT_0, emails[0]);
			FieldSetText(FIELD_MAIL_LIST_TO, emails[0]);
		}
		if (num_items > 0)
		{
			qfree(emails[0]); qfree(names[0]); qfree(names); qfree(emails);
		}
		FieldSetText(FIELD_EDIT_1, subj);
		qfree(subj);
		DataCloseRecord(emess_dbid, rec_id);
		return ;
	}
	else if (mode == FORWARD)
	{
		FormInitAllFormObjects(FORM_MAIL_LIST);
		strcpy(subj1, EMFWD1);
		subj1 += 5;
		strcpy(subj1, subject);
		FieldSetText(FIELD_EDIT_1, subj);
		qfree(subj);
		FieldSetText(FIELD_EDIT_0, (BYTE*)(""));
		return ;
	}
}
