/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   expsave.c
Author(s)   :   Jason Ngan
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "expdef.h"
#include "expense.h"
#include "system.h"

//#define DEBUG_MICH

extern ObjectID	ActiveTextboxID;
extern USHORT	NewItemNumInList;
extern BYTE		CatText[20];
extern UBYTE	CatNum;
extern BYTE		LargeFontInEdcat;

extern BOOLEAN ApplicationHandleEvent(EvtType *Event);

extern UWORD			G_del_expense_type;
extern UWORD			G_rename_expense_type;
extern UWORD			G_add_expense_type;

/*****************************************************************
* Function:	ExpenseAppSave
* Purpose: 	This function is called to save the data in 
the application when it is called to stopped
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
******************************************************************/
void ExpenseAppSave(void)
{
	ExpenseMainAppSave();
	ExpenseMDBAppSave();
	ExpenseDatabaseClose();
	
	return;
}


/********************************************************
* Function:	ExpenseAppRestore
* Purpose: 	This function is called to restore the data in 
the application when it is called to stopped
* Scope:		application/internal
* Input:		restart		whether the application is restart or not
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
void ExpenseAppRestore(BOOLEAN is_restart)
{
	BYTE		*textbox_string, *string_len, *buffer, cat_string[30];
	UWORD		byte_read;
	DatabaseID	Expense_dbid;
	Err			err;
	USHORT		total;
	
#ifdef DEBUG_MICH
	printf("\n\n In ExpenseAppRestore()");
#endif
	
	FormInitAllFormObjects(FORM_EXPENSE_LIST);
	FormInitAllFormObjects(FORM_EXPENSE_DATE);
	FormInitAllFormObjects(FORM_EXPENSE_TYPE);
	FormInitAllFormObjects(FORM_EXPENSE_CURR);
	FormInitAllFormObjects(FORM_EXPENSE_EDCAT);
	FormInitAllFormObjects(FORM_EXPENSE_DIALOG_EDCAT);
	//L=====================================================
	FormInitAllFormObjects(FORM_EXPENSE_DIALOG_DEL_TYPE);
	//L=====================================================
	
	ExpenseDatabaseInit(is_restart);
	ExpenseInitMainGlobal(is_restart);
	ExpenseInitMDBGlobal(is_restart);
	ExpenseInitTypeCurr();
	
	
	if (is_restart)
	{
		FormPopupForm(FORM_EXPENSE_EDCAT);
	}
	else
	{
		DataFindDB(EXPDB, &Expense_dbid);
		DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ActiveFormID, &buffer, &byte_read);
		
		switch(*(ObjectID*)buffer)
		{
		case FORM_EXPENSE_EDCAT:
			// ===============================================================
			// add at 14062000
			if (LargeFontInEdcat)
				ExpenseCatToList(CatText, FALSE);
			// ===============================================================
			FormPopupForm(FORM_EXPENSE_EDCAT);
			break;
		case FORM_EXPENSE_DIALOG_EDCAT:
			FormPopupForm(FORM_EXPENSE_EDCAT);
			FormSetFormActiveObject(FORM_EXPENSE_DIALOG_EDCAT, TEXTBOX_EXPENSE_DIALOG_EDCAT);
			DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ExpTextboxString, &string_len, &byte_read);
			TextboxSetText(TEXTBOX_EXPENSE_DIALOG_EDCAT, string_len);
			TextboxSetInsertPointOn(TEXTBOX_EXPENSE_DIALOG_EDCAT);
			DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ExpTextboxCharPos, &textbox_string, &byte_read);
			if ((WORD)(*(BYTE*)textbox_string) > -1)
			{
				TextboxSetInsertPointPositionByCharPos(TEXTBOX_EXPENSE_DIALOG_EDCAT, (WORD)(*(BYTE*)textbox_string));
				TextboxSetInsertPointOn(TEXTBOX_EXPENSE_DIALOG_EDCAT);
			}				
			else
			{
				TextboxSetHighlightSelection(TEXTBOX_EXPENSE_DIALOG_EDCAT, 0, strlen(string_len));
				TextboxSetInsertPointOff(TEXTBOX_EXPENSE_DIALOG_EDCAT);
			}				
			qfree(string_len);
			qfree(textbox_string);
			FormPopupForm(FORM_EXPENSE_DIALOG_EDCAT);
			break;
		case FORM_EXPENSE_DATE:
			err = DataCategoryName(Expense_dbid, CatNum, cat_string);
			if (err != 1)
			{
				FormPopupForm(FORM_EXPENSE_EDCAT);
				break;
			}
			FormPopupForm(FORM_EXPENSE_DATE);
			break;
		case FORM_EXPENSE_TYPE:
			err = DataCategoryName(Expense_dbid, CatNum, cat_string);
			if (err != 1)
			{
				FormPopupForm(FORM_EXPENSE_EDCAT);
				break;
			}
			FormPopupForm(FORM_EXPENSE_LIST);
			
			
			if (G_del_expense_type != NO_SELECT || G_rename_expense_type != NO_SELECT )
			{
				G_del_expense_type = NO_SELECT ;
				G_rename_expense_type = NO_SELECT ;
				break;
			}
			FormPopupForm(FORM_EXPENSE_TYPE);
			break;
		case FORM_EXPENSE_CURR:
			err = DataCategoryName(Expense_dbid, CatNum, cat_string);
			if (err != 1)
			{
				FormPopupForm(FORM_EXPENSE_EDCAT);
				break;
			}
			FormPopupForm(FORM_EXPENSE_LIST);
			FormPopupForm(FORM_EXPENSE_CURR);
			break;
			
		case FORM_EXPENSE_DIALOG_SAVE:
			err = DataCategoryName(Expense_dbid, CatNum, cat_string);
			if (err != 1)
			{
				FormPopupForm(FORM_EXPENSE_EDCAT);
				break;
			}
			KeyboardSetKeyboardInvisible();
			ExpenseLoadRecord(CatText, FALSE);
			ExpenseRecordToList(&NewItemNumInList);
			ExpenseListSetScrollbar();
			ExpenseKeypadVisible();
			FormSetFormActiveObject(FORM_EXPENSE_LIST, ActiveTextboxID);
			DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ExpTextboxString, &string_len, &byte_read);
			TextboxSetText(ActiveTextboxID, string_len);
			TextboxSetInsertPointOn(ActiveTextboxID);
			DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ExpTextboxCharPos, &textbox_string, &byte_read);
			if ((WORD)(*(BYTE*)textbox_string) > -1)
			{
				TextboxSetInsertPointPositionByCharPos(ActiveTextboxID, (WORD)(*(BYTE*)textbox_string));
				TextboxSetInsertPointOn(ActiveTextboxID);
			}
			else
			{
				TextboxSetHighlightSelection(ActiveTextboxID, 0, strlen(string_len));
				TextboxSetInsertPointOff(ActiveTextboxID);
			}
			qfree(string_len);
			qfree(textbox_string);
			FormDrawForm(FORM_EXPENSE_LIST);
			FormPopupForm(FORM_EXPENSE_DIALOG_SAVE);
			break;
			
		case FORM_EXPENSE_LIST:
			err = DataCategoryName(Expense_dbid, CatNum, cat_string);
			if (err != 1)
			{
				FormPopupForm(FORM_EXPENSE_EDCAT);
				break;
			}
			DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ExpKeypadInvisible, &textbox_string, &byte_read);
			if (!(BOOLEAN)(*(BYTE*)textbox_string))
			{
				FormSetEventHandler(FORM_EXPENSE_LIST, (void**)&FormDispatchEvent, ExpenseList);
				FormSetActiveForm(FORM_EXPENSE_LIST);
				KeyboardSetKeyboardInvisible();
				ExpenseLoadRecord(CatText, FALSE);
				ExpenseRecordToList(&NewItemNumInList);
				ExpenseListSetScrollbar();
				ExpenseKeypadVisible();
				FormSetFormActiveObject(FORM_EXPENSE_LIST, ActiveTextboxID);
				DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ExpTextboxString, &string_len, &byte_read);
				TextboxSetText(ActiveTextboxID, string_len);
				TextboxSetInsertPointOn(ActiveTextboxID);
				DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ExpTextboxCharPos, &textbox_string, &byte_read);
				if ((WORD)(*(BYTE*)textbox_string) > -1)
				{
					TextboxSetInsertPointPositionByCharPos(ActiveTextboxID, (WORD)(*(BYTE*)textbox_string));
					TextboxSetInsertPointOn(ActiveTextboxID);
				}
				else
				{
					TextboxSetHighlightSelection(ActiveTextboxID, 0, strlen(string_len));
					TextboxSetInsertPointOff(ActiveTextboxID);
				}
				qfree(string_len);
				qfree(textbox_string);
				FormDrawForm(FORM_EXPENSE_LIST);
			}
			else
				FormPopupForm(FORM_EXPENSE_LIST);
			break;
			
		case FORM_EXPENSE_DIALOG_SELCAT:
			FormPopupForm(FORM_EXPENSE_EDCAT);
			FormPopupForm(FORM_EXPENSE_DIALOG_SELCAT);
			break;
		case FORM_EXPENSE_DIALOG_EXIST:
			FormPopupForm(FORM_EXPENSE_EDCAT);
			FormPopupForm(FORM_EXPENSE_DIALOG_EXIST);
			break;
		case FORM_EXPENSE_DIALOG_ERASE:
			err = DataCategoryName(Expense_dbid, CatNum, cat_string);
			if (err != 1)
			{
				FormPopupForm(FORM_EXPENSE_EDCAT);
				break;
			}
			FormPopupForm(FORM_EXPENSE_LIST);
			FormPopupForm(FORM_EXPENSE_DIALOG_ERASE);
			break;
		case FORM_EXPENSE_DIALOG_REMOVE:
			FormPopupForm(FORM_EXPENSE_EDCAT);
			FormPopupForm(FORM_EXPENSE_DIALOG_REMOVE);
			break;
		case FORM_EXPENSE_DIALOG_SELTYPE:
			err = DataCategoryName(Expense_dbid, CatNum, cat_string);
			if (err != 1)
			{
				FormPopupForm(FORM_EXPENSE_EDCAT);
				break;
			}
			FormPopupForm(FORM_EXPENSE_LIST);
			FormPopupForm(FORM_EXPENSE_DIALOG_SELTYPE);
			break;
		case FORM_EXPENSE_DIALOG_INPUT_TYPE:
#ifdef DEBUG_MICH
			printf("\n active_form_id == FORM_EXPENSE_DIALOG_INPUT_TYPE");
			printf("\n G_add_expense_type = %ld", G_add_expense_type);
			printf("\n G_rename_expense_type = %ld",  G_rename_expense_type);
#endif
			FormPopupForm(FORM_EXPENSE_LIST);
			
			// =====================================================================
			// modified at 28062000
			/*
			if (G_add_expense_type || G_rename_expense_type)
			{
			G_add_expense_type = 0;
			G_rename_expense_type = 0;
			//break;
			}
			*/
			if (G_add_expense_type != NO_SELECT)
				G_add_expense_type = 0;
			if (G_rename_expense_type != NO_SELECT)
				G_rename_expense_type = 0;
			// =========================================================================
			
#ifdef DEBUG_MICH
			printf("\n\n G_add_expense_type = %ld", G_add_expense_type);
			printf("\n G_rename_expense_type = %ld",  G_rename_expense_type);
#endif
			
			FormInitAllFormObjects(FORM_EXPENSE_DIALOG_INPUT_TYPE);
			FormSetFormActiveObject(FORM_EXPENSE_DIALOG_INPUT_TYPE, TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE);
			DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ExpTextboxString, &string_len, &byte_read);
			TextboxSetText(TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE, string_len);
			TextboxSetInsertPointOn(TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE);
			DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ExpTextboxCharPos, &textbox_string, &byte_read);
			if ((WORD)(*(BYTE*)textbox_string) > -1)
			{
				TextboxSetInsertPointPositionByCharPos(TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE, (WORD)(*(BYTE*)textbox_string));
				TextboxSetInsertPointOn(TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE);
			}				
			else
			{
				TextboxSetHighlightSelection(TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE, 0, strlen(string_len));
				TextboxSetInsertPointOff(TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE);
			}				
			qfree(string_len);
			qfree(textbox_string);
			FormPopupForm(FORM_EXPENSE_DIALOG_INPUT_TYPE);
			break;
			
		default:
			G_del_expense_type = NO_SELECT;
			G_rename_expense_type = NO_SELECT;
			G_add_expense_type = NO_SELECT;
			err = DataCategoryName(Expense_dbid, CatNum, cat_string);
			if (err != 1)
			{
				FormPopupForm(FORM_EXPENSE_EDCAT);
				break;
			}
			FormPopupForm(FORM_EXPENSE_LIST);
			break;
			
		}
		qfree(buffer);
		
	}	
	
	return;
	
}



/********************************************************
* Function:	ExpenseAppLaunch
* Purpose: 	This function is called to launch the 
Expense application
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN ExpenseAppLaunch(WORD cmd, void *cmd_ptr)
{
	
	RTM			modi_date;
	UBYTE		cat;
	UWORD		rec_size;
	Attribute	secret, lock;
    Err         Error;
	
	DatabaseID		Expense_dbid;
	
	switch(cmd)
	{
	case LAUNCH_CMD_NORMAL_LAUNCH:
		UIApplicationInit();
		
		/* New Database */
		//            if (DataFindDB(EXPDB, &Expense_dbid) != TRUE)
		//                DataNewDB(EXPDB, 0, (BYTE*)("Expense Application"), &Expense_dbid);
		DataFindDB(EXPDB, &Expense_dbid);
		DataOpenDB(Expense_dbid, F_DATE, OPEN_RW);
		
		if (DataRecordInfo(Expense_dbid, EXPENSE_MAIN_APP_SAVE, &rec_size, &cat,
			&secret, &lock, &modi_date) != TRUE)
		{
			ExpenseAppRestore(TRUE);
		}
		else
		{
			ExpenseAppRestore(FALSE);
		}
		
		EventLoop();
		ExpenseAppSave();
		UIDeleteAllAppObjects();		
		
#ifndef PR31700
		UIApplicationInit();
		ExpenseAppRestore(FALSE);
		EventLoop();
		ExpenseAppSave();
		UIDeleteAllAppObjects();		
		UIApplicationInit();
		ExpenseAppRestore(FALSE);
		EventLoop();
		ExpenseAppSave();
		UIDeleteAllAppObjects();		
		UIApplicationInit();
		ExpenseAppRestore(FALSE);
		EventLoop();
		ExpenseAppSave();
		UIDeleteAllAppObjects();		
		UIApplicationInit();
		ExpenseAppRestore(FALSE);
		EventLoop();
		ExpenseAppSave();
		UIDeleteAllAppObjects();		
#endif									
		return TRUE;
		
	case LAUNCH_CMD_FIND:
		pfree(cmd_ptr);
		return TRUE;
	case LAUNCH_CMD_GOTO_REC:
		if (((GotoRec*)cmd_ptr)->find_string)
			(((GotoRec*)cmd_ptr)->find_string);
		pfree(cmd_ptr);
		return TRUE;
	case LAUNCH_CMD_ALARM_HIT:
		pfree(cmd_ptr);
		return TRUE;
		
	default:
		return FALSE;
	}
	return FALSE;
}
