/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   main.c
Author(s)   :   Jason Ngan
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"

#include "system.h"
#include "expdef.h"
#include "expense.h"
#include "sysetup.h"


//#define DEBUG

/* ==================================================================== */
/* ========================= Function Prototypes ====================== */
/* ==================================================================== */
void MMUInit();
void KernelInit();
void ResInit();
static BOOLEAN ApplicationHandleEvent(EvtType *Event);

BOOLEAN (*FormDispatchEvent)(EvtType *Event);

extern REGISTRY app_reg[];


#ifdef PC_SIM
extern BOOL m_bIsExit;
#endif

/* ==================================================================== */
/* ========================= Global Variables ========================= */
/* ==================================================================== */
AppID app_id;
extern UBYTE res_data [];
UBYTE sysres_data[1];

/********************************************************
* Function:	ApplicationHandleEvent
* Purpose: 	This function is used to load the specific data of
form and set event handler of the form
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
static BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
	Form *form_ptr;
	ObjectID form_id;
	BYTE object_type;
	Err Error;
	
	if (Event->eventType == EVT_FORM_LOAD)
	{
		form_id = (ObjectID)Event->eventID;
		Error = UISearchForAddress(form_id,&object_type,(void**)&form_ptr);
		if (Event->para1 == 1 || Error != TRUE)
		{
			FormInitForm(form_id);
		}
		if (!UISearchForAddress(form_id,&object_type,(void**)&form_ptr)) return FALSE;
		
		switch (form_id)
		{
		case FORM_EXPENSE_LIST:
			FormSetEventHandler(FORM_EXPENSE_LIST, (void**)&FormDispatchEvent, ExpenseList);
			break;
			
		case FORM_EXPENSE_DATE:
			FormSetEventHandler(FORM_EXPENSE_DATE, (void**)&FormDispatchEvent, ExpenseDate);
			break;
			
		case FORM_EXPENSE_TYPE:
			FormSetEventHandler(FORM_EXPENSE_TYPE, (void**)&FormDispatchEvent, ExpenseType);
			break;
			
		case FORM_EXPENSE_CURR:
			FormSetEventHandler(FORM_EXPENSE_CURR, (void**)&FormDispatchEvent, ExpenseCurr);
			break;
			
		case FORM_EXPENSE_EDCAT:
			FormSetEventHandler(FORM_EXPENSE_EDCAT, (void**)&FormDispatchEvent, ExpenseEditCate);
			break;
			
		case FORM_EXPENSE_DIALOG_SAVE:
			FormSetEventHandler(FORM_EXPENSE_DIALOG_SAVE, (void**)&FormDispatchEvent, ExpenseDialogSave);
			break;
			
		case FORM_EXPENSE_DIALOG_SELCAT:
			FormSetEventHandler(FORM_EXPENSE_DIALOG_SELCAT, (void**)&FormDispatchEvent, ExpenseDialogSelectCat);
			break;
			
		case FORM_EXPENSE_DIALOG_SELTYPE:
			FormSetEventHandler(FORM_EXPENSE_DIALOG_SELTYPE, (void**)&FormDispatchEvent, ExpenseDialogSelectType);
			break;
			
		case FORM_EXPENSE_DIALOG_EXIST:
			FormSetEventHandler(FORM_EXPENSE_DIALOG_EXIST, (void**)&FormDispatchEvent, ExpenseDialogExist);
			break;
			
		case FORM_EXPENSE_DIALOG_ERASE:
			FormSetEventHandler(FORM_EXPENSE_DIALOG_ERASE, (void**)&FormDispatchEvent, ExpenseDialogErase);
			break;
			
		case FORM_EXPENSE_DIALOG_EDCAT:
			FormSetEventHandler(FORM_EXPENSE_DIALOG_EDCAT, (void**)&FormDispatchEvent, ExpenseDialogEditCat);
			break;
			
		case FORM_EXPENSE_DIALOG_REMOVE:
			FormSetEventHandler(FORM_EXPENSE_DIALOG_REMOVE, (void**)&FormDispatchEvent, ExpenseDialogRemove);
			break;
		case FORM_EXPENSE_DIALOG_LOW_MEMORY:
			FormSetEventHandler(FORM_EXPENSE_DIALOG_LOW_MEMORY, (void**)&FormDispatchEvent, ExpenseDialogLowMemory);
			break;
			//t===============================================================================
		case FORM_EXPENSE_DIALOG_INPUT_TYPE:
			FormSetEventHandler(FORM_EXPENSE_DIALOG_INPUT_TYPE, (void**)&FormDispatchEvent, ExpenseDialogInputType);
			break;
			
		case FORM_EXPENSE_DIALOG_DEL_TYPE:
			FormSetEventHandler(FORM_EXPENSE_DIALOG_DEL_TYPE, (void**)&FormDispatchEvent, ExpenseDialogDelType);
			break;
			
		case FORM_EXPENSE_DIALOG_TYPE_EXIST:
			FormSetEventHandler(FORM_EXPENSE_DIALOG_TYPE_EXIST, (void**)&FormDispatchEvent, ExpenseDialogTypeExist);
			break;
			
			
			//t===============================================================================
		}
		FormSetActiveForm(form_id);
		return TRUE;
	}
	//----------------------------------------------------------------------------------------------
	//------- For Hardware Keyboard's key ----------------------------------------------------------
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)	
	{
		if ((Event->para2 & 0x00000200))
		{
			FormGetActiveFormID(&form_id);
			switch (form_id)
			{
			case FORM_EXPENSE_LIST:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_EXPENSE_LIST: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				if (Event->para1 == LLETTER_NEW || Event->para1 == SLETTER_NEW)
				{
					Event->eventType	= EVT_CONTROL_SELECT;
					Event->eventID		= BUTTON_EXPENSE_LIST_NEW;
					Event->evtPBP		= NULL;
				}
				else if(Event->para1 == LLETTER_EXP_LIST || Event->para1 == SLETTER_EXP_LIST)
				{
				/*
				ControlPopupSetSelectedItem(POPUP_EXPENSE_LIST, 0);
				Event->eventType	= EVT_CONTROL_POPUP_SELECT;
				Event->eventID		= POPUP_EXPENSE_LIST;
				Event->evtPBP		= NULL;
					*/
					ControlPopupPopupTrigger(POPUP_EXPENSE_LIST);
				}
				
				break;
			case FORM_EXPENSE_DATE:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_EXPENSE_DATE: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				if (Event->para1 == LLETTER_TODAY || Event->para1 == SLETTER_TODAY)
				{
					Event->eventType	= EVT_CONTROL_SELECT;
					Event->eventID		= BUTTON_EXPENSE_DATE_TODAY;
					Event->evtPBP		= NULL;
				}
				break;
			case FORM_EXPENSE_TYPE:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_EXPENSE_TYPE: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				break;
			case FORM_EXPENSE_CURR:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_EXPENSE_CURR: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				break;
			case FORM_EXPENSE_EDCAT:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_EXPENSE_EDCAT: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				if (Event->para1 == LLETTER_NEW	|| Event->para1 == SLETTER_NEW)
				{
					Event->eventType	= EVT_CONTROL_SELECT;
					Event->eventID		= BUTTON_EXPENSE_EDCAT_NEW;
					Event->evtPBP		= NULL;
				}
				else if (Event->para1 == LLETTER_DEL || Event->para1 == SLETTER_DEL)
				{
					Event->eventType	= EVT_CONTROL_SELECT;
					Event->eventID		= BUTTON_EXPENSE_EDCAT_DEL;
					Event->evtPBP		= NULL;
				}
				else if (Event->para1 == LLETTER_RENAME || Event->para1 == SLETTER_RENAME)
				{
					Event->eventType	= EVT_CONTROL_SELECT;
					Event->eventID		= BUTTON_EXPENSE_EDCAT_RENAME;
					Event->evtPBP		= NULL;
				}
				break;
			case FORM_EXPENSE_DIALOG_SAVE:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_EXPENSE_DIALOG_SAVE: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
				{
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_EXPENSE_DIALOG_SAVE_X;
					Event->evtPBP		= NULL;
				}
				else if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
				{
					Event->eventType	= EVT_CONTROL_SELECT;
					Event->eventID		= BUTTON_EXPENSE_DIALOG_SAVE_YES;
					Event->evtPBP		= NULL;
				}
				else if (Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
				{
					Event->eventType	= EVT_CONTROL_SELECT;
					Event->eventID		= BUTTON_EXPENSE_DIALOG_SAVE_NO;
					Event->evtPBP		= NULL;
				}
				break;
			case FORM_EXPENSE_DIALOG_SELCAT:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_EXPENSE_DIALOG_SELCAT: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
				{
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_EXPENSE_DIALOG_SELCAT_X;
					Event->evtPBP		= NULL;
				}
				break;	
			case FORM_EXPENSE_DIALOG_SELTYPE:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_EXPENSE_DIALOG_SELTYPE: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
				{
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_EXPENSE_DIALOG_SELTYPE_X;
					Event->evtPBP		= NULL;
				}
				break;		
			case FORM_EXPENSE_DIALOG_EXIST:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_EXPENSE_DIALOG_EXIST: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				break;	
			case FORM_EXPENSE_DIALOG_ERASE:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_EXPENSE_DIALOG_ERASE: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
				{
					Event->eventType	= EVT_CONTROL_SELECT;
					Event->eventID		= BUTTON_EXPENSE_DIALOG_ERASE_YES;
					Event->evtPBP		= NULL;
				}
				else if (Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
				{
					Event->eventType	= EVT_CONTROL_SELECT;
					Event->eventID		= BUTTON_EXPENSE_DIALOG_ERASE_NO;
					Event->evtPBP		= NULL;
				}
				break;
			case FORM_EXPENSE_DIALOG_EDCAT:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_EXPENSE_DIALOG_EDCAT: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
				{
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_EXPENSE_DIALOG_EDCAT_X;
					Event->evtPBP		= NULL;
				}
				break;
			case FORM_EXPENSE_DIALOG_REMOVE:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_EXPENSE_DIALOG_REMOVE: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
				{
					Event->eventType	= EVT_CONTROL_SELECT;
					Event->eventID		= BUTTON_EXPENSE_DIALOG_REMOVE_YES;
					Event->evtPBP		= NULL;
				}
				else if (Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
				{
					Event->eventType	= EVT_CONTROL_SELECT;
					Event->eventID		= BUTTON_EXPENSE_DIALOG_REMOVE_NO;
					Event->evtPBP		= NULL;
				}
				break;
			case FORM_EXPENSE_DIALOG_LOW_MEMORY:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_EXPENSE_DIALOG_LOW_MEMORY: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
				{
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_EXPENSE_DIALOG_LOW_MEMORY_X;
					Event->evtPBP		= NULL;
				}
				break;
			default:
#ifdef DEBUG
				printf("\n--->> AHE2 default: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				break;
			}
		}
	}
	
	return FALSE;
}

/********************************************************
* Function:	EventLoop
* Purpose: 	This function is a loop to get events from event
manager and then passes the event to different
event handler
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EventLoop(void)
{
	EvtType event;
	do
	{
		EvtGetEvent (&event);
		if (!ExpenseHandleKeyInStatus(&event))
		{
			if (!SystemHandleEvent(&event))
			{
				if (!MenuHandleEvent(&event))
				{
					if (!ApplicationHandleEvent(&event))
					{
						FormDispatchEvent(&event);
					}
				}
			}
		}
	}
#ifdef PC_SIM
	while (event.eventType != EVT_APP_STOP && m_bIsExit == FALSE);
#else
	while (event.eventType != EVT_APP_STOP);
#endif
}
/********************************************************
* Function:	main
* Purpose: 	main procedure of the application
* Scope:		Application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
__main(WORD cmd, void *cmd_ptr)
{
	ExpenseAppLaunch(cmd, (void*)cmd_ptr);
}

