/* cicbind.h
 *------------------------------------------------------------------------------
 * SCCS 1.5, 09:51:19 9/30/94
 *------------------------------------------------------------------------------
 *      CIC Software Int and Structure definition
 *
 * JP Shipherd	23-Jan-93   Added infndef CICBIND_H
 * D. Foyt	05-Apr-94   Added CL_UK language type for British English.
 * M. Wenocur   23-May-94   Added CL_JAPAN language type
 * K. Rolle     30-Sep-94   Change interrupt name from CIC_INT to CIC_INTERRUPT.
 *------------------------------------------------------------------------------
 */
#ifndef CICBIND_H
#define CICBIND_H

/*
 *------------------------------------------------------------------------------
 * NOTE: (IBSIZE) and (MAX_COORD_PAIRS) are in assembler and here.
 * They must match.
 *------------------------------------------------------------------------------
 */

#define MAX_COORD_PAIRS	2*100	 /* Maximum number of coord pair structures  */
				 /* that directly follow the CICSTROKE       */
				 /* structure. */

#define IBSIZE		MAX_COORD_PAIRS*4  /* Tablet fifo input buffer size */

#define CIC_INTERRUPT     0x15    /* software interrupt used to transfer data */
                                  /* to the CIC Code from the SmallTalk/v286  */
				  /* prims */

#define CIC_FUNC	  0xC5	  /* int 15 function number for calling HSM   */
/*
 *------------------------------------------------------------------------------
 *  The conventions followed by the CIC software int interface are as follows:
 *        AH = Function Code
 *        AL = Sub Function (or 1st byte parameter, ie. TRUE,FALSE)
 *	  AX = Error code returned to caller
 *        DX = Segment Value for FAR POINTERS
 *        BX = Offset Value for FAR POINTERS
 *        CX = Sub-function code returned to caller with CIC_QUERY_FUNC
 *
 *  Query functions have the high bit of AH set.  For example:  Query Char Set
 *          AH = CIC_QUERY_FUNC | CIC_CHAR_SET
 *------------------------------------------------------------------------------
 */
#define CIC_QUERY_FUNC 	0x80

#define CIC_CHAR_SET	0x00
#define CCS_NUMERIC	  0x01	/* subfunction codes for CIC_CHAR_SET */
#define CCS_LOWER_AN  	  0x02
#define CCS_UPPER_A   	  0x03
#define CCS_UPPER_AN  	  0x04
#define CCS_LOWER_A   	  0x05
#define CCS_GESTURE       0x06

#define CIC_QUERY	0x01  	/* CIC function number placed in AH */
#define CIC_STROKE  	0x02
#define CIC_SEGMENT   	0x03

#define CIC_GRID_MODE	0x04
#define   CGM_MODE_GRIDLESS 0x01/* subfunction codes for CIC_GRID_MODE */
#define   CGM_MODE_GRIDDED  0x02
#define   CGM_MODE_LINED    0x03

#define CIC_AUTO_SPACE	0x05
#define   CAS_SPACE_OFF	  0x00
#define   CAS_SPACE_ON	  0x01

#define CIC_AUTO_NEWLINE   0x06
#define   CAN_NEWLINE_OFF    0x00
#define   CAN_NEWLINE_ON     0x01

#define CIC_DOT_SEPARATOR  0x07
#define   CDS_DOT_OFF	     0x00
#define   CDS_DOT_ON	     0x01

#define CIC_LANGUAGE	   0x08
#define   CL_USA	     0x01
#define   CL_GERMAN	     0x02
#define   CL_FRENCH	     0x03
#define   CL_ITALIAN	     0x04
#define   CL_SPANISH	     0x05
#define   CL_ALL	     0x06
#define   CL_WESTERN         0x07
#define   CL_EASTERN         0x08
#define   CL_UK		     0x09
#define   CL_JAPAN	     0x0a

#define   CIC_X_ORIGIN       0x09
#define   CIC_Y_ORIGIN	     0x0a
#define   CIC_DELTAX	     0x0b
#define   CIC_DELTAY	     0x0c
#define   CIC_FLUSH	     0x0d
#define   CIC_HCP_PUTBYTE    0x0e
#define   CIC_HCP_GETBYTE    0x0f
#define   CIC_INIT           0x10
#define   CIC_START_QUERY    0x11
#define   CIC_SET_QUERY      0x12
#define   CIC_SIG_STROKE     0x13
#define   CIC_END_SIG        0x14
#define   CIC_STOP           0x15
#define   CIC_SET_TRAINMODE     0x20
#define   CIC_ADD_CONFLICT      0x21
#define   CIC_ADD_TEMPLATE      0x22
#define   CIC_REPORT_CONFLICT   0x23
#define   CIC_REPORT_TEMPLATE   0x24
#define   CIC_REMOVE_TEMPLATE   0x25
#define   CIC_DISCARD_TEMPLATES 0x26
#define   CIC_SET_CICMODE       0x27
#define   CIC_PROBE_HSM		0x28

/*
 *------------------------------------------------------------------------------
 *      Status Codes Returned in AX
 *------------------------------------------------------------------------------
 */

#define CE_NO_ERR	     0x00
#define CE_BAD_FUN	     0x01
#define CE_BAD_SUBFUN	     0x02

/*
 *------------------------------------------------------------------------------
 *      Structure Definition for the CIC_QUERY function.
 *------------------------------------------------------------------------------
 */
#define CICQUERY struct cicquery
CICQUERY
    {
    UCOUNT asciival;
    UCOUNT numstks;
    UCOUNT uid[10];
    };

#endif	    /* ifndef CICBIND_H */
