/* disdef.h			CIC Proprietary
 *-----------------------------------------------------------------------------
 * SCCS Version 1.2, 15:34:30 1/7/93
 *---------------------------------------------------------------------
 * Header file containing definitions relevant to disambiguation routines
 * and their data packing, plus symbols for referencing internal disambiguation
 * routine information.
 *
 * NOTE: <dicpro.h> should be included before this file, but will be included
 *	 here if it has not already been included.  When compiling files that
 *	 #include "disdef.h", the compiler switch -I(directory) must be given
 *	 to specify the directory for "disdef.h" (typically -I../include).
 *
 * DO NOT EDIT disdef.h DIRECTLY.  It is assembled automatically from
 * the files disdef.ha and disdef.hz, which contain the first and last parts
 * of disdef.h, and from disdef.hm, which is generated automatically by
 * wrtdisfil.exe.  To make changes, either edit disdef.ha, edit disdef.hz, or
 * change the wrtdisfil functions that generate disdef.hm.
 *
 *  9-Aug-1985	P. Edberg
 *  2-Apr-1986	P. Edberg	Reorganized disamspec files
 * 13-Feb-1987	P. Edberg	Modified TERMDAT struct
 * 28-Apr-1987	P. Edberg	Add tregset[] to TERMDAT struct
 * 09-Feb-1988	P. Edberg	Add DISDEFINC to test if it has already been
 *				  #included
 * 10-Mar-1988	P. Edberg	Uncommented the GETDICP struc; automatically
 *				  include <dicpro.h>
 * 11-Mar-1988	P. Edberg	Comment out GETDICP again
 * 03-Aug-1990  D. Foyt		Add STR_PAR
 *-----------------------------------------------------------------------------
 */

#ifndef DICPROINC
#include <dicpro.h>
#endif

#ifndef DISDEFINC

/* define different kinds of disamb parameters identified by parser */
#define NUM_PAR 1
#define LET_PAR 2
#define REG_PAR 3
#define STR_PAR 4

/* Everything up to here is from disdef.ha */

#define BRAC_INDX 25

#define MXPACK 8	/* Guaranteed to be a multiple of 2 */
#define MAXROU 34
#define MXDPAR 7

/* Everything after here is in disdef.hz
 *---------------------------------------------------------------------
 * SCCS Version 1.2, 15:34:31 1/7/93
 *---------------------------------------------------------------------
 */

#define PACKDAT union packdat
PACKDAT
    {
    TINY tinyC[MXPACK];
    COUNT count[MXPACK/2];
    };

#define TERMDAT struct termdat
TERMDAT
    {
    COUNT   ttype;	/* 0 if routine; >0 is index into blkdatG for block  */
    COUNT   tsize;	/* in bytes					     */
    PACKDAT tpack;	/* packed bytes for routine			     */
    COUNT   tregset[MAXREG + 1];
    };

/*
 *-----------------------------------------------------------------------------
 * This struc planned in Aug. 86
 *-----------------------------------------------------------------------------
#define GETDICP struct getdicp
GETDICP
    {
    BOOL rdfilB;
    union
	{
	TINY *memP;
	FILE *filP;
	} src;
    };
 *-----------------------------------------------------------------------------
 */

#define DISDEFINC
#endif
