/* geoscode.h			CIC Proprietary
 *----------------------------------------------------------------------------
 * SCCS Version 1.1, 10:41:03 4/8/96
 *----------------------------------------------------------------------------
 * PC/GEOS definition of characters
 *
 * J. Wang          08-Mar-96   Initial.
 *----------------------------------------------------------------------------
 */
#ifndef GEOSCODE_H
#define GEOSCODE_H  

typedef unsigned char ZO_CHAR;

#define NC					0x00
#define SPACE					0x20	
#define EXCLAMATION_MARK			0x21
#define QUOTATION_MARK				0x22
#define NUMBER_SIGN				0x23
#define DOLLAR_SIGN				0x24
#define PERCENT_SIGN				0x25
#define AMPERSAND				0x26
#define APOSTROPHE_QUOTE			0x27
#define OPENING_PARENTHESIS			0x28                            
#define CLOSING_PARENTHESIS			0x29
#define ASTERISK				0x2A
#define PLUS_SIGN				0x2B
#define COMMA					0x2C
#define HYPHEN_MINUS				0x2D
#define PERIOD					0x2E
#define SLASH					0x2F
#define DIGIT_ZERO				0x30
#define DIGIT_ONE				0x31
#define DIGIT_TWO				0x32
#define DIGIT_THREE				0x33
#define DIGIT_FOUR				0x34
#define DIGIT_FIVE				0x35
#define DIGIT_SIX				0x36
#define DIGIT_SEVEN				0x37
#define DIGIT_EIGHT				0x38
#define	DIGIT_NINE				0x39
#define COLON					0x3A
#define SEMICOLON				0x3B
#define LESS_THAN_SIGN				0x3C
#define EQUALS_SIGN				0x3D
#define GREATER_THAN_SIGN			0x3E
#define QUESTION_MARK				0x3F
#define COMMERCIAL_AT				0x40
#define LATIN_CAPITAL_LETTER_A			0x41
#define LATIN_CAPITAL_LETTER_B			0x42
#define LATIN_CAPITAL_LETTER_C			0x43
#define LATIN_CAPITAL_LETTER_D			0x44
#define LATIN_CAPITAL_LETTER_E			0x45
#define LATIN_CAPITAL_LETTER_F			0x46
#define LATIN_CAPITAL_LETTER_G			0x47
#define LATIN_CAPITAL_LETTER_H			0x48
#define LATIN_CAPITAL_LETTER_I			0x49
#define LATIN_CAPITAL_LETTER_J			0x4A
#define LATIN_CAPITAL_LETTER_K			0x4B
#define LATIN_CAPITAL_LETTER_L			0x4C
#define LATIN_CAPITAL_LETTER_M			0x4D
#define LATIN_CAPITAL_LETTER_N			0x4E
#define LATIN_CAPITAL_LETTER_O			0x4F
#define LATIN_CAPITAL_LETTER_P			0x50
#define LATIN_CAPITAL_LETTER_Q			0x51
#define LATIN_CAPITAL_LETTER_R			0x52
#define LATIN_CAPITAL_LETTER_S			0x53
#define LATIN_CAPITAL_LETTER_T			0x54
#define LATIN_CAPITAL_LETTER_U			0x55
#define LATIN_CAPITAL_LETTER_V			0x56
#define LATIN_CAPITAL_LETTER_W			0x57
#define LATIN_CAPITAL_LETTER_X			0x58
#define LATIN_CAPITAL_LETTER_Y			0x59
#define LATIN_CAPITAL_LETTER_Z			0x5A
#define OPENING_SQUARE_BRACKET			0x5B
#define BACKSLASH				0x5C
#define CLOSING_SQUARE_BRACKET			0x5D
#define SPACING_CIRCUMFLEX			0x5E
#define SPACING_UNDERSCORE			0x5F
#define SPACING_GRAVE				0x60
#define LATIN_SMALL_LETTER_A			0x61
#define LATIN_SMALL_LETTER_B			0x62
#define LATIN_SMALL_LETTER_C			0x63
#define LATIN_SMALL_LETTER_D			0x64
#define LATIN_SMALL_LETTER_E			0x65
#define LATIN_SMALL_LETTER_F			0x66
#define LATIN_SMALL_LETTER_G			0x67
#define LATIN_SMALL_LETTER_H			0x68
#define LATIN_SMALL_LETTER_I			0x69
#define LATIN_SMALL_LETTER_J			0x6A
#define LATIN_SMALL_LETTER_K			0x6B
#define LATIN_SMALL_LETTER_L			0x6C
#define LATIN_SMALL_LETTER_M			0x6D
#define LATIN_SMALL_LETTER_N			0x6E
#define LATIN_SMALL_LETTER_O			0x6F
#define LATIN_SMALL_LETTER_P			0x70
#define LATIN_SMALL_LETTER_Q			0x71
#define LATIN_SMALL_LETTER_R			0x72
#define LATIN_SMALL_LETTER_S			0x73
#define LATIN_SMALL_LETTER_T			0x74
#define LATIN_SMALL_LETTER_U			0x75
#define LATIN_SMALL_LETTER_V			0x76
#define LATIN_SMALL_LETTER_W			0x77
#define LATIN_SMALL_LETTER_X			0x78
#define LATIN_SMALL_LETTER_Y			0x79
#define LATIN_SMALL_LETTER_Z			0x7A
#define OPENING_CURLY_BRACKET			0x7B
#define VERTICAL_BAR				0x7C
#define CLOSING_CURLY_BRACKET			0x7D
#define TILDE					0x7E
#define DELETE_KEY  					0x7F

#define NON_BREAKING_SPACE			0xCA
#define INVERTED_EXCLAMATION_MARK		0xC1
#define CENT_SIGN				0xA2
#define POUND_SIGN				0xA3
#define CURRENCY_SIGN				0xDB
#define YEN_SIGN				0xB4
#define SECTION_SIGN				0xA4
#define SPACING_DIAERESIS			0xAC
#define COPYRIGHT_SIGN				0xA9
#define FEMININE_ORDINAL_INDICATOR		0xBB
#define LEFT_POINTING_GUILLEMET			0xC7
#define NOT_SIGN				0xC2
#define REGISTERED_TRADE_MARK_SIGN		0xA8
#define DEGREE_SIGN				0xA1
#define PLUS_OR_MINUS_SIGN			0xB1
#define SPACING_ACUTE				0xAB
#define PARAGRAPH_SIGN				0xA6
#define MIDDLE_DOT				0xE1
#define SUPERSCRIPT_DIGIT_ONE			0xF5
#define MASCULINE_ORDINAL_INDICATOR    		0xBC
#define RIGHT_POINTING_GUILLEMET		0xC8
#define INVERTED_QUESTION_MARK			0xC0
#define LATIN_CAPITAL_LETTER_A_GRAVE		0xCB
#define LATIN_CAPITAL_LETTER_A_ACUTE		0xE7
#define LATIN_CAPITAL_LETTER_A_CIRCUMFLEX	0xE5
#define LATIN_CAPITAL_LETTER_A_TILDE		0xCC
#define LATIN_CAPITAL_LETTER_A_DIAERESIS 	0x80
#define LATIN_CAPITAL_LETTER_A_RING		0x81
#define LATIN_CAPITAL_LETTER_A_E		0xAE
#define LATIN_CAPITAL_LETTER_CEDILLA  		0x82
#define LATIN_CAPITAL_LETTER_E_GRAVE		0xE9
#define LATIN_CAPITAL_LETTER_E_ACUTE		0x83
#define LATIN_CAPITAL_LETTER_E_CIRCUMFLEX	0xE6
#define LATIN_CAPITAL_LETTER_E_DIAERESIS	0xE8
#define LATIN_CAPITAL_LETTER_I_GRAVE		0xED
#define LATIN_CAPITAL_LETTER_I_ACUTE		0xEA
#define LATIN_CAPITAL_LETTER_I_CIRCUMFLEX	0xEB
#define LATIN_CAPITAL_LETTER_I_DIAERESIS	0xEC
#define LATIN_CAPITAL_LETTER_ETH		0xF0
#define LATIN_CAPITAL_LETTER_N_TILDE		0x84
#define LATIN_CAPITAL_LETTER_O_GRAVE		0xF1
#define LATIN_CAPITAL_LETTER_O_ACUTE		0xEE
#define LATIN_CAPITAL_LETTER_O_CIRCUMFLEX	0xEF
#define LATIN_CAPITAL_LETTER_O_TILDE		0xCD
#define LATIN_CAPITAL_LETTER_O_DIAERESIS	0xC3
#define LATIN_CAPITAL_LETTER_O_SLASH		0xAF
#define LATIN_CAPITAL_LETTER_U_GRAVE		0xF4
#define LATIN_CAPITAL_LETTER_U_ACUTE		0xF2
#define LATIN_CAPITAL_LETTER_U_CIRCUMFLEX	0xF3
#define LATIN_CAPITAL_LETTER_U_DIAERESIS	0x86
#define LATIN_CAPITAL_LETTER_Y_ACUTE		0xDF
#define LATIN_CAPITAL_LETTER_THORN		0xDA
#define LATIN_SMALL_LETTER_SHARP_S		0xA7
#define LATIN_SMALL_LETTER_A_GRAVE		0x88
#define LATIN_SMALL_LETTER_A_ACUTE		0x87
#define LATIN_SMALL_LETTER_A_CIRCUMFLEX		0x89
#define LATIN_SMALL_LETTER_A_TILDE		0x8B
#define LATIN_SMALL_LETTER_A_DIAERESIS 		0x8A
#define LATIN_SMALL_LETTER_A_RING		0x8C
#define LATIN_SMALL_LETTER_A_E			0xBE
#define LATIN_SMALL_LETTER_CEDILLA  		0x8D
#define LATIN_SMALL_LETTER_E_GRAVE		0x8F
#define LATIN_SMALL_LETTER_E_ACUTE		0x8E
#define LATIN_SMALL_LETTER_E_CIRCUMFLEX		0x90
#define LATIN_SMALL_LETTER_E_DIAERESIS		0x91
#define LATIN_SMALL_LETTER_I_GRAVE		0x93
#define LATIN_SMALL_LETTER_I_ACUTE		0x92
#define LATIN_SMALL_LETTER_I_CIRCUMFLEX		0x94
#define LATIN_SMALL_LETTER_I_DIAERESIS		0x95
#define LATIN_SMALL_LETTER_ETH			0xE4
#define LATIN_SMALL_LETTER_N_TILDE		0x96
#define LATIN_SMALL_LETTER_O_GRAVE		0x98
#define LATIN_SMALL_LETTER_O_ACUTE		0x97
#define LATIN_SMALL_LETTER_O_CIRCUMFLEX		0x99
#define LATIN_SMALL_LETTER_O_TILDE		0x9B
#define LATIN_SMALL_LETTER_O_DIAERESIS		0x9A
#define DIVISION_SIGN				0xD6
#define LATIN_SMALL_LETTER_O_SLASH		0xBF
#define LATIN_SMALL_LETTER_U_GRAVE		0x9D
#define LATIN_SMALL_LETTER_U_ACUTE		0x9C
#define LATIN_SMALL_LETTER_U_CIRCUMFLEX		0x9E
#define LATIN_SMALL_LETTER_U_DIAERESIS		0x9F
#define LATIN_SMALL_LETTER_Y_ACUTE		0xDE
#define LATIN_SMALL_LETTER_THORN		0xD7
#define LATIN_SMALL_LETTER_Y_DIAERESIS 		0xD8
#define LATIN_CAPITAL_LETTER_O_E		0xCE
#define LATIN_SMALL_LETTER_O_E			0xCF
#define LATIN_CAPITAL_LETTER_Y_DIAERESIS	0xD9 
#define LATIN_SMALL_LETTER_SCRIPT_F		0xC4 
#define NON_SPACING_GRAVE			0x60
#define NON_SPACING_ACUTE			0xAB
#define NON_SPACING_DIAERESIS			0xAC
#define NON_SPACING_CIRCUMFLEX			0xF6
#define NON_SPACING_TILDE			0xF7
#define NON_SPACING_MACRON			0xF8
#define NON_SPACING_BREVE			0xF9
#define NON_SPACING_DOT_ABOVE			0xFA
#define NON_SPACING_RING_ABOVE			0xFB
#define NON_SPACING_DOUBLE_ACUTE		0xFD
#define NON_SPACING_HACEK			0xFF
#define NON_SPACING_CEDILLA			0xFC
#define NON_SPACING_OGONEK			0xFE
#define GREEK_CAPITAL_LETTER_DELTA		0xC6
#define GREEK_CAPITAL_LETTER_PI			0xB8
#define GREEK_CAPITAL_LETTER_SIGMA		0xB7
#define GREEK_CAPITAL_LETTER_OMEGA		0xBD
#define GREEK_SMALL_LETTER_DELTA		0xB6
#define GREEK_SMALL_LETTER_MU			0xB5
#define GREEK_SMALL_LETTER_PI			0xB9
#define EN_DASH					0xD0
#define EM_DASH					0xD1
#define SINGLE_TURNED_COMMA_QUOTATION_MARK	0xD4
#define SINGLE_COMMA_QUOTATION_MARK		0xD5 
#define LOW_SINGLE_COMMA_QUOTATION_MARK		0xE2
#define DOUBLE_TURNED_COMMA_QUOTATION_MARK	0xD2
#define DOUBLE_COMMA_QUOTATION_MARK		0xD3
#define LOW_DOUBLE_COMMA_QUOTATION_MARK		0xE3
#define DAGGER					0xA0
#define DOUBLE_DAGGER				0xE0
#define HORIZONTAL_ELLIPSIS			0xC9
#define BULLET					0xA5
#define PER_MILLER_SIGN				0xE4
#define LEFT_POINTING_SINGLE_GUILLEMET		0xDC
#define RIGHT_POINTING_SINGLE_GUILLEMET		0xDD
#define TRADEMARK				0xAA
#define INFINITY				0xB0
#define INTEGRAL				0xBA
#define NOT_EQUAL_TO				0xAD
#define ALMOST_EQUAL_TO				0xC5
#define LESS_THAN_OR_EQUAL_TO			0xB2
#define GREATER_THAN_OR_EQUAL_TO		0xB3 
#define LOZENGE					0xD7 

#define PZ_WAIT_FOUR				0x1F
#define PZ_WAIT_X				0x1E

#define PZ_MODE_UCALPHA				0x01
#define PZ_MODE_LCALPHA				0x02
#define PZ_MODE_NUMERIC				0x03
#define PZ_MODE_PUNCTUATION			0x04
#define PZ_MODE_EXTENDED			0x05
#define PZ_MODE_DEFAULT				PZ_MODE_LCALPHA
#define PZ_INK_KEEP_THIS			0x06
#define PZ_INK_CLEAR_ALL                        0x07
#define BACKSPACE				0x08
#define HORIZONTAL_TABULATION			0x09                        
#define PZ_CHANGE_LAST_CHAR			0x0A
#define PZ_GESTURE_CAPS_LOCK			0x0B
#define PZ_GESTURE_CAPS_SHIFT			0x0C
#define CARRIAGE_RETURN				0x0D
#define PZ_GESTURE_CUT				0x0E
#define PZ_GESTURE_COPY				0x0F
#define PZ_GESTURE_PASTE			0x10
#define PZ_GESTURE_DELETE			0x11
#define PZ_GESTURE_RESET			0x12
#define PZ_MACRO				0x13 
#define PZ_OPERATION				0x14

#endif
