/* unicode.h			CIC Proprietary
 *----------------------------------------------------------------------------
 * SCCS Version 1.5, 15:05:39 9/5/96
 *----------------------------------------------------------------------------
 * Unicode definition of characters
 *
 * J. Wang          08-Mar-96   Initial.
 *----------------------------------------------------------------------------
 */
#ifndef UNICODE_H
#define UNICODE_H

/*
 *----------------------------------------------------------------------------
 * Define the type of char. For Unicode, this should be a 2-byte, unsigned int.
 * If ZORRO is ported to other systems, this probably needs change.
 *----------------------------------------------------------------------------
 */
typedef unsigned int ZO_CHAR;

#define NC					0x0000	
#define BACKSPACE				0x0008
#define HORIZONTAL_TABULATION			0x0009                        
#define CARRIAGE_RETURN				0x000D
#define SPACE					0x0020	
#define EXCLAMATION_MARK			0x0021
#define QUOTATION_MARK				0x0022
#define NUMBER_SIGN				0x0023
#define DOLLAR_SIGN				0x0024
#define PERCENT_SIGN				0x0025
#define AMPERSAND				0x0026
#define APOSTROPHE_QUOTE			0x0027
#define OPENING_PARENTHESIS			0x0028                            
#define CLOSING_PARENTHESIS			0x0029
#define ASTERISK				0x002A
#define PLUS_SIGN				0x002B
#define COMMA					0x002C
#define HYPHEN_MINUS				0x002D
#define PERIOD					0x002E
#define SLASH					0x002F
#define DIGIT_ZERO				0x0030
#define DIGIT_ONE				0x0031
#define DIGIT_TWO				0x0032
#define DIGIT_THREE				0x0033
#define DIGIT_FOUR				0x0034
#define DIGIT_FIVE				0x0035
#define DIGIT_SIX				0x0036
#define DIGIT_SEVEN				0x0037
#define DIGIT_EIGHT				0x0038
#define	DIGIT_NINE				0x0039
#define COLON					0x003A
#define SEMICOLON				0x003B
#define LESS_THAN_SIGN				0x003C
#define EQUALS_SIGN				0x003D
#define GREATER_THAN_SIGN			0x003E
#define QUESTION_MARK				0x003F
#define COMMERCIAL_AT				0x0040
#define LATIN_CAPITAL_LETTER_A			0x0041
#define LATIN_CAPITAL_LETTER_B			0x0042
#define LATIN_CAPITAL_LETTER_C			0x0043
#define LATIN_CAPITAL_LETTER_D			0x0044
#define LATIN_CAPITAL_LETTER_E			0x0045
#define LATIN_CAPITAL_LETTER_F			0x0046
#define LATIN_CAPITAL_LETTER_G			0x0047
#define LATIN_CAPITAL_LETTER_H			0x0048
#define LATIN_CAPITAL_LETTER_I			0x0049
#define LATIN_CAPITAL_LETTER_J			0x004A
#define LATIN_CAPITAL_LETTER_K			0x004B
#define LATIN_CAPITAL_LETTER_L			0x004C
#define LATIN_CAPITAL_LETTER_M			0x004D
#define LATIN_CAPITAL_LETTER_N			0x004E
#define LATIN_CAPITAL_LETTER_O			0x004F
#define LATIN_CAPITAL_LETTER_P			0x0050
#define LATIN_CAPITAL_LETTER_Q			0x0051
#define LATIN_CAPITAL_LETTER_R			0x0052
#define LATIN_CAPITAL_LETTER_S			0x0053
#define LATIN_CAPITAL_LETTER_T			0x0054
#define LATIN_CAPITAL_LETTER_U			0x0055
#define LATIN_CAPITAL_LETTER_V			0x0056
#define LATIN_CAPITAL_LETTER_W			0x0057
#define LATIN_CAPITAL_LETTER_X			0x0058
#define LATIN_CAPITAL_LETTER_Y			0x0059
#define LATIN_CAPITAL_LETTER_Z			0x005A
#define OPENING_SQUARE_BRACKET			0x005B
#define BACKSLASH				0x005C
#define CLOSING_SQUARE_BRACKET			0x005D
#define SPACING_CIRCUMFLEX			0x005E
#define SPACING_UNDERSCORE			0x005F
#define SPACING_GRAVE				0x0060
#define LATIN_SMALL_LETTER_A			0x0061
#define LATIN_SMALL_LETTER_B			0x0062
#define LATIN_SMALL_LETTER_C			0x0063
#define LATIN_SMALL_LETTER_D			0x0064
#define LATIN_SMALL_LETTER_E			0x0065
#define LATIN_SMALL_LETTER_F			0x0066
#define LATIN_SMALL_LETTER_G			0x0067
#define LATIN_SMALL_LETTER_H			0x0068
#define LATIN_SMALL_LETTER_I			0x0069
#define LATIN_SMALL_LETTER_J			0x006A
#define LATIN_SMALL_LETTER_K			0x006B
#define LATIN_SMALL_LETTER_L			0x006C
#define LATIN_SMALL_LETTER_M			0x006D
#define LATIN_SMALL_LETTER_N			0x006E
#define LATIN_SMALL_LETTER_O			0x006F
#define LATIN_SMALL_LETTER_P			0x0070
#define LATIN_SMALL_LETTER_Q			0x0071
#define LATIN_SMALL_LETTER_R			0x0072
#define LATIN_SMALL_LETTER_S			0x0073
#define LATIN_SMALL_LETTER_T			0x0074
#define LATIN_SMALL_LETTER_U			0x0075
#define LATIN_SMALL_LETTER_V			0x0076
#define LATIN_SMALL_LETTER_W			0x0077
#define LATIN_SMALL_LETTER_X			0x0078
#define LATIN_SMALL_LETTER_Y			0x0079
#define LATIN_SMALL_LETTER_Z			0x007A
#define OPENING_CURLY_BRACKET			0x007B
#define VERTICAL_BAR				0x007C
#define CLOSING_CURLY_BRACKET			0x007D
#define TILDE					0x007E
#define DELETE_KEY  				0x007F
#define SPACING_CIRCUMFLEX2			0x0088
#define NON_BREAKING_SPACE			0x00A0
#define INVERTED_EXCLAMATION_MARK		0x00A1
#define CENT_SIGN				0x00A2
#define POUND_SIGN				0x00A3
#define CURRENCY_SIGN				0x00A4
#define YEN_SIGN				0x00A5
#define BROKEN_VERTICAL_BAR			0x00A6
#define SECTION_SIGN				0x00A7
#define SPACING_DIAERESIS			0x00A8
#define COPYRIGHT_SIGN				0x00A9
#define FEMININE_ORDINAL_INDICATOR		0x00AA
#define LEFT_POINTING_GUILLEMET			0x00AB
#define NOT_SIGN				0x00AC
#define SOFT_HYPHEN				0x00AD
#define REGISTERED_TRADE_MARK_SIGN		0x00AE
#define SPACING_MACRON				0x00AF
#define DEGREE_SIGN		                0x00B0
#define PLUS_OR_MINUS_SIGN		        0x00B1
#define SUPERSCRIPT_DIGIT_TWO			0x00B2
#define SUPERSCRIPT_DIGIT_THREE			0x00B3
#define SPACING_ACUTE			        0x00B4
#define MICRO_SIGN			        0x00B5
#define PARAGRAPH_SIGN				0x00B6
#define MIDDLE_DOT				0x00B7
#define SPACING_CEDILLA				0x00B8
#define SUPERSCRIPT_DIGIT_ONE			0x00B9
#define MASCULINE_ORDINAL_INDICATOR    		0x00BA
#define RIGHT_POINTING_GUILLEMET		0x00BB
#define FRACTION_ONE_QUARTER			0x00BC
#define FRACTION_ONE_HALF			0x00BD
#define FRACTION_THREE_QUARTERS			0x00BE
#define INVERTED_QUESTION_MARK			0x00BF
#define LATIN_CAPITAL_LETTER_A_GRAVE		0x00C0
#define LATIN_CAPITAL_LETTER_A_ACUTE		0x00C1
#define LATIN_CAPITAL_LETTER_A_CIRCUMFLEX	0x00C2
#define LATIN_CAPITAL_LETTER_A_TILDE		0x00C3
#define LATIN_CAPITAL_LETTER_A_DIAERESIS 	0x00C4
#define LATIN_CAPITAL_LETTER_A_RING		0x00C5
#define LATIN_CAPITAL_LETTER_A_E		0x00C6
#define LATIN_CAPITAL_LETTER_CEDILLA  		0x00C7
#define LATIN_CAPITAL_LETTER_E_GRAVE		0x00C8
#define LATIN_CAPITAL_LETTER_E_ACUTE		0x00C9
#define LATIN_CAPITAL_LETTER_E_CIRCUMFLEX	0x00CA
#define LATIN_CAPITAL_LETTER_E_DIAERESIS	0x00CB
#define LATIN_CAPITAL_LETTER_I_GRAVE		0x00CC
#define LATIN_CAPITAL_LETTER_I_ACUTE		0x00CD
#define LATIN_CAPITAL_LETTER_I_CIRCUMFLEX	0x00CE
#define LATIN_CAPITAL_LETTER_I_DIAERESIS	0x00CF
#define LATIN_CAPITAL_LETTER_ETH		0x00D0
#define LATIN_CAPITAL_LETTER_N_TILDE		0x00D1
#define LATIN_CAPITAL_LETTER_O_GRAVE		0x00D2
#define LATIN_CAPITAL_LETTER_O_ACUTE		0x00D3
#define LATIN_CAPITAL_LETTER_O_CIRCUMFLEX	0x00D4
#define LATIN_CAPITAL_LETTER_O_TILDE		0x00D5
#define LATIN_CAPITAL_LETTER_O_DIAERESIS	0x00D6
#define MULTIPLICATION_SIGN			0x00D7
#define LATIN_CAPITAL_LETTER_O_SLASH		0x00D8
#define LATIN_CAPITAL_LETTER_U_GRAVE		0x00D9
#define LATIN_CAPITAL_LETTER_U_ACUTE		0x00DA
#define LATIN_CAPITAL_LETTER_U_CIRCUMFLEX	0x00DB
#define LATIN_CAPITAL_LETTER_U_DIAERESIS	0x00DC
#define LATIN_CAPITAL_LETTER_Y_ACUTE		0x00DD
#define LATIN_CAPITAL_LETTER_THORN		0x00DE
#define LATIN_SMALL_LETTER_SHARP_S		0x00DF
#define LATIN_SMALL_LETTER_A_GRAVE		0x00E0
#define LATIN_SMALL_LETTER_A_ACUTE		0x00E1
#define LATIN_SMALL_LETTER_A_CIRCUMFLEX		0x00E2
#define LATIN_SMALL_LETTER_A_TILDE		0x00E3
#define LATIN_SMALL_LETTER_A_DIAERESIS 		0x00E4
#define LATIN_SMALL_LETTER_A_RING		0x00E5
#define LATIN_SMALL_LETTER_A_E			0x00E6
#define LATIN_SMALL_LETTER_CEDILLA  		0x00E7
#define LATIN_SMALL_LETTER_E_GRAVE		0x00E8
#define LATIN_SMALL_LETTER_E_ACUTE		0x00E9
#define LATIN_SMALL_LETTER_E_CIRCUMFLEX		0x00EA
#define LATIN_SMALL_LETTER_E_DIAERESIS		0x00EB
#define LATIN_SMALL_LETTER_I_GRAVE		0x00EC
#define LATIN_SMALL_LETTER_I_ACUTE		0x00ED
#define LATIN_SMALL_LETTER_I_CIRCUMFLEX		0x00EE
#define LATIN_SMALL_LETTER_I_DIAERESIS		0x00EF
#define LATIN_SMALL_LETTER_ETH			0x00E0
#define LATIN_SMALL_LETTER_N_TILDE		0x00F1
#define LATIN_SMALL_LETTER_O_GRAVE		0x00F2
#define LATIN_SMALL_LETTER_O_ACUTE		0x00F3
#define LATIN_SMALL_LETTER_O_CIRCUMFLEX		0x00F4
#define LATIN_SMALL_LETTER_O_TILDE		0x00F5
#define LATIN_SMALL_LETTER_O_DIAERESIS		0x00F6
#define DIVISION_SIGN				0x00F7
#define LATIN_SMALL_LETTER_O_SLASH		0x00F8
#define LATIN_SMALL_LETTER_U_GRAVE		0x00F9
#define LATIN_SMALL_LETTER_U_ACUTE		0x00FA
#define LATIN_SMALL_LETTER_U_CIRCUMFLEX		0x00FB
#define LATIN_SMALL_LETTER_U_DIAERESIS		0x00FC
#define LATIN_SMALL_LETTER_Y_ACUTE		0x00FD
#define LATIN_SMALL_LETTER_THORN		0x00FE
#define LATIN_SMALL_LETTER_Y_DIAERESIS 		0x00FF
#define LATIN_CAPITAL_LETTER_O_E		0x0152
#define LATIN_SMALL_LETTER_O_E			0x0153
#define LATIN_CAPITAL_LETTER_S_HACEK		0x0160
#define LATIN_SMALL_LETTER_S_HACEK		0x0161
#define LATIN_CAPITAL_LETTER_Y_DIAERESIS	0x0178
#define LATIN_SMALL_LETTER_SCRIPT_F		0x0192
#define FLORIN                          LATIN_SMALL_LETTER_SCRIPT_F
#define SPACING_TILDE                   	0x02DC
#define NON_SPACING_GRAVE			0x0300
#define NON_SPACING_ACUTE			0x0301
#define NON_SPACING_CIRCUMFLEX			0x0302
#define NON_SPACING_TILDE			0x0303
#define NON_SPACING_MACRON			0x0304
#define NON_SPACING_OVERSCORE			0x0305
#define NON_SPACING_BREVE			0x0306
#define NON_SPACING_DOT_ABOVE			0x0307
#define NON_SPACING_DIAERESIS			0x0308
#define NON_SPACING_RING_ABOVE			0x030A
#define NON_SPACING_DOUBLE_ACUTE		0x030B
#define NON_SPACING_HACEK			0x030C
#define NON_SPACING_CEDILLA			0x0327
#define NON_SPACING_OGONEK			0x0328
#define GREEK_CAPITAL_LETTER_DELTA		0x0394
#define GREEK_CAPITAL_LETTER_PI			0x03A0
#define GREEK_CAPITAL_LETTER_SIGMA		0x03A3
#define GREEK_CAPITAL_LETTER_OMEGA		0x03A9
#define GREEK_SMALL_LETTER_DELTA		0x03B4 
#define GREEK_SMALL_LETTER_MU			0x03B5
#define GREEK_SMALL_LETTER_PI			0x03C0
#define EN_DASH					0x2013
#define EM_DASH					0x2014
#define SINGLE_TURNED_COMMA_QUOTATION_MARK	0x2018
#define SINGLE_COMMA_QUOTATION_MARK		0x2019
#define LOW_SINGLE_COMMA_QUOTATION_MARK		0x201A
#define DOUBLE_TURNED_COMMA_QUOTATION_MARK	0x201C
#define DOUBLE_COMMA_QUOTATION_MARK		0x201D
#define LOW_DOUBLE_COMMA_QUOTATION_MARK		0x201E
#define DAGGER					0x2020
#define DOUBLE_DAGGER				0x2021
#define HORIZONTAL_ELLIPSIS			0x2026
#define BULLET					0x2022
#define PER_MILLER_SIGN				0x2030
#define LEFT_POINTING_SINGLE_GUILLEMET		0x2039
#define RIGHT_POINTING_SINGLE_GUILLEMET		0x203A
#define TRADEMARK				0x2122
#define INFINITY				0x221E
#define INTEGRAL				0x222B
#define NOT_EQUAL_TO				0x2260
#define ALMOST_EQUAL_TO				0x2248
#define LESS_THAN_OR_EQUAL_TO			0x2264
#define GREATER_THAN_OR_EQUAL_TO		0x2265 
#define LOZENGE					0x25CA 
                 
#define PZ_WAIT_FOUR                		0xE000
#define PZ_WAIT_X			        0xE001
                 
#define PZ_MODE_UCALPHA				0xFDFF
#define PZ_MODE_LCALPHA				0xFDFE
#define PZ_MODE_NUMERIC				0xFDFD
#define PZ_MODE_PUNCTUATION			0xFDFC
#define PZ_MODE_EXTENDED			0xFDFB
#define PZ_MODE_DEFAULT				PZ_MODE_LCALPHA
#define PZ_INK_KEEP_THIS			0xFDEF
#define PZ_INK_CLEAR_ALL            		0xFDEE
#define PZ_CHANGE_LAST_CHAR			0xFDD0
#define PZ_GESTURE_CAPS_LOCK			0xFDCF
#define PZ_GESTURE_CAPS_SHIFT			0xFDCE
#define PZ_GESTURE_CUT				0xFDCD
#define PZ_GESTURE_COPY				0xFDCC
#define PZ_GESTURE_PASTE			0xFDCB
#define PZ_GESTURE_DELETE			0xFDCA
#define PZ_GESTURE_UNDO				0xFDC9
#define PZ_GESTURE_RESET			0xFDC8
#define PZ_MACRO			        0xFDC7
#define PZ_OPERATION				0xFDC6

#endif 
