/* zohmmpub.h			CIC Proprietary
 *----------------------------------------------------------------------------
 * SCCS Version %I%, %U% %G%
 *----------------------------------------------------------------------------
 * Public header file for HMM method for ZORRO
 * 
 * J. Wang          21-May-96   Initial.
 *----------------------------------------------------------------------------
 */
#ifndef ZOHMMPUB_H
#define ZOHMMPUB_H

#include <params.h>
#include <zover.h>

#define ISLOWER(x) (((x) >= 'a') && ((x) <= 'z'))
#define ISUPPER(x) (((x) >= 'A') && ((x) <= 'Z'))
#define ISDIGIT(x) (((x) >= '0') && ((x) <= '9'))
#define ISALPHA(x) ((ISLOWER(x)) || (ISUPPER(x)))
#define ISVOWEL(x) ((x) == 'a' || (x) == 'e' || (x) == 'i' || (x) == 'o' || (x) == 'u')

#define TOLOWER(x) (ISUPPER(x) ? (CIC_TEXT) ((COUNT)(x) + 32) : x)
#define TOUPPER(x) (ISLOWER(x) ? (CIC_TEXT) ((COUNT)(x) - 32) : x)

#define IS_DELIMIT_CHAR(x) ((x) == ' ' || (x) == NEWLINE || (x) == TAB || \
	(x) == BACKSPACE || (x) == '.' || (x) == '!' || (x) == '?' || \
	(x) == ',')

#if ZO_DEBUG
#define LIST_EVERY_RECOGNITION 0x01
#define LIST_ERROR_RECOGNITION 0x02
#define STOP_REC_ERROR		0x04
#define STOP_DIS_ERROR		0x08
#define GET_HMM_DICT_STAT	0x10

/*
 *----------------------------------------------------------------------------
 * Macro to pack and unpack a version into an integer
 *----------------------------------------------------------------------------
 */
#define MAKEVER(row,col,ver) ((ver) * 10000 + (row) * 100 + (col))
#define GETVER(v) ((v) / 10000)
#define GETROW(v) (((v) % 10000) / 100)
#define GETCOL(v) ((v) % 100)

#endif

#define ZO_MAXSTK 2

/*
 *----------------------------------------------------------------------------
 * bit flag in certain masks for different recognition mode
 *----------------------------------------------------------------------------
 */
#define ZO_NON  0x00
#define ZO_LOW	0x01
#define ZO_UPP  0x02
#define ZO_NUM  0x04
#define ZO_PUN  0x08
#define ZO_EXT  0x10 
#define ZO_ALL  0x1F
#define ZO_LU	ZO_LOW | ZO_UPP
#define ZO_UN   ZO_UPP | ZO_NUM
#define ZO_LN	ZO_LOW | ZO_NUM
#define ZO_LUN	ZO_LOW | ZO_UPP | ZO_NUM

/*
 *----------------------------------------------------------------------------
 * bit flags for waiting status
 *----------------------------------------------------------------------------
 */
#define ZW_CLEAR 0x1F
#define ZW_NON	0x00
#define ZW_LOW	0x20
#define ZW_UPP	0x40
#define ZW_NUM	0x80
#define ZW_LU	ZW_LOW | ZW_UPP
#define ZW_UN	ZW_UPP | ZW_NUM
#define ZW_LN	ZW_LOW | ZW_NUM
#define ZW_LUN	ZW_LOW | ZW_UPP | ZW_NUM

/*
 *----------------------------------------------------------------------------
 * Size of the dot
 *----------------------------------------------------------------------------
 */

#define  MAX_HMM      60        /* Max. no of HMM model picked               */
#define  MAX_MAP     120        /* Max. no of Dictionary cv mapped           */
#define DICT_PENALTY       17   /* Penalty applied to dictionary failure     */
#define NDIC_PENALTY       25   /* Penalty applied to fail stroke check      */
#define DESC_PENALTY       20   /* Penalty applied to fail descender logic   */
#define POST_PENALTY        7   /* Penalty applied to post logic failure     */
#define  UNKNOWN_REC   0        /* Unknown state                             */
#define  DICT_PASSED   2        /* Passed disambiguation test                */
#define  DICT_FAILED   3        /* Failed disambiguation test                */

#if ZORRO_SPACE_DETECTION       /* Only compile if this flag is set     */

#define MAX_HISTORY     7
#define MIN_SPACE_GAP   40
#define WIDTH_MULTIPLIER 2
#define GAP_MULTIPLIER  3
 
typedef struct
    {
    CIC_UINT8   verUC;          /* Recognized version                   */
    ZO_RECT     rect;           /* Rect of char                         */
    CIC_INT16   gapW;           /* Gap to previous char                 */
    } SP_CHAR;
 
typedef struct
    {
    SP_CHAR sp_histAr[MAX_HISTORY];     /* Buffer for history char      */
    CIC_INT16   ibeginW;                /* Index for first char         */
    CIC_INT16   nhistW;                 /* Number of history char       */
    CIC_INT16   rightestW;              /* The current rigthest coord   */
    CIC_INT16   avg_gapW;               /* Gap between strokes          */
    CIC_INT16   avg_widthW;             /* Width of strokes             */
    } SP_HISTORY;

#endif	/* #if ZORRO_SPACE_DETECTION	*/

#define MAX_RESULTS 2

/*
 *----------------------------------------------------------------------------
 * The overall data structure for all global variables.
 *----------------------------------------------------------------------------
 */
typedef struct
    {
   /* 
    *-------------------------------------------------------------------------
	* The masks of each character
	*-------------------------------------------------------------------------
	*/
	CIC_UINT8	maskUCAr[MAX_ZS_VERSION];	/* Masks for each version	*/
	CIC_UINT8	two_stroke_maskUCAr[MAX_TWO_STROKE_VERSION];
											/* Enabled/Disabled flag for */
											/*   two stroke versions	 */
	CIC_BOOL	verticalB;					/* TRUE if in vertical mode */

   /*
    *-------------------------------------------------------------------------
	* The trainer mask bits info
	*-------------------------------------------------------------------------
	*/
	CIC_UINT32	trainUL;					/* Trained mask bits		*/
   
   /*
    *--------------------------------------------------------------------------
    * Variables used in HMM match
    *--------------------------------------------------------------------------
    */
    STROKE	strk[ZO_MAXSTK];
    HMM_RESULTS resultsG[NUM_HMM_SAVE];
    CIC_INT16 	nresultWG;

   /*
    *--------------------------------------------------------------------------
    * Variables used in disambiguation
    *--------------------------------------------------------------------------
    */
    UTINY 	regC[3];
    COUNT 	offset;
    COUNT 	ratval;

#if ZORRO_SPACE_DETECTION
    SP_HISTORY sp_historyG;
#endif
    } ZO_DATA;


/*
 *----------------------------------------------------------------------------
 * Function prototypes
 *----------------------------------------------------------------------------
 */                             
CIC_ULONG cic_sqrt
    (
    CIC_ULONG argUL	     /* variable whose square root is to be obtained */
    );
    
ULONG eucdis
    (
    LONG deltaxL,			/* x difference = x0 - x1	      */
    LONG deltayL			/* y difference = y0 - y1	      */
    );
    
COUNT cic_atan2
    (
    COUNT x, 
    COUNT y
    );   

COUNT ang32L
    (
    LONG dxL,                                   /* X difference */
    LONG dyL                                    /* Y difference */
    );

VOID hmm_spa_samp
    (
    COUNT  numin,               /* Number of input in raw data               */
    COUNT  xarray[],            /* Input array of x-coordinate values        */
    COUNT  yarray[],            /* Input array of y-coordinate values        */
    COUNT  numout,              /* Number of output points                   */
    LONG   lxL[],               /* Spatially sampled x values                */
    LONG   lyL[],               /* Spatially sampled y values                */
    LONG   cumlenL[]            /* saves accumated length along stroke       */
    );

BOOL dcheck
    (
    ZO_DATA	*zo_dataP,	/* Overall global data			     */
    COUNT ndis,                 /* No. of bytes of disamb. for this block    */
    TINY  *dpt,                 /* Pointer to start of disamb. logic block   */
    BOOL  btype                 /* YES if this is an OR block, NO if AND     */
    );

BOOL plsjso
    (
    COUNT  x[],                         /* X values of character             */
    COUNT  y[],                         /* X values of character             */
    COUNT  beg,                         /* starting index                    */
    COUNT  end,                         /* ending   index                    */
    COUNT  maxpts,                      /* maximum dimensioned length of X,Y */
    COUNT  lowccw,                      /* lower thres counterclockwise angle*/
    COUNT  upccw,                       /* upper thres counterclockwise angle*/
    COUNT  lowcw,                       /* lower thres for clockwise angle   */
    COUNT  upcw,                        /* upper thres for clockwise angle   */
    COUNT  lghseg,                      /* length of PLS arm                 */
    COUNT *indexP,                      /* index of largest angle            */
    COUNT *angleP                       /* value of largest angle (x10)      */
    );

BOOL len3
    (    
    STROKE * sP,
    COUNT  i1,     /* Beginning point of first segment                  */
    COUNT  i2,     /* End point of first segment                        */
    COUNT  j1,     /* Beginning point of second segment                 */
    COUNT  j2,     /* End point of second segment                       */
    COUNT parm          /* Fraction (in eighths) for comparison              */
    );

BOOL kangl
    (
    STROKE *s1P,                      /* pointer to  first stroke            */
    STROKE *s2P,                      /* pointer to second stroke            */
    COUNT ibeg1,                      /* beginning point for  first stroke   */
    COUNT iend1,                      /*    ending point for  first stroke   */
    COUNT ibeg2,                      /* beginning point for second stroke   */
    COUNT iend2,                      /*    ending point for second stroke   */
    COUNT parm1,                      /* lower input threshold divided by 5  */
    COUNT parm2                       /* upper input threshold divided by 5  */
    );

BOOL resamp
    (
    COUNT ix[],         /* array of original x values                        */
    COUNT iy[],         /* array of original y values                        */
    COUNT ibeg,         /* first point of original sample for resampling     */
    COUNT iend,         /* last point of original sample for resampling      */
    COUNT *ixn,         /* array of resampled x values                       */
    COUNT *iyn,         /* array of resampled y values                       */
    COUNT numout        /* number of points in the output arrays             */
    );

BOOL resamp2
    (
    COUNT *ix,          /* array of original x values                        */
    COUNT *iy,          /* array of original y values                        */
    COUNT ibeg,         /* first point of original sample for resampling     */
    COUNT iend,         /* last point of original sample for resampling      */
    COUNT *ixn,         /* array of resampled x values                       */
    COUNT *iyn          /* array of resampled y values                       */
    );

ARGINT hookdt
    (
    STROKE *instkP,
                                /* Pointer to input stroke (to be resampled) */
    STROKE *outstkP,
                                /* Pointer to buffer for copy of input stroke*/
    COUNT *endptP,              /* Point index of detected end hook          */
    COUNT *begptP               /* Point index of detected beginning hook    */
    );

LONG rawdis
    (
    COUNT i,
    COUNT j,
    COUNT ax[],
    COUNT ay[]
    );

CIC_VOID copy_default_two_stroke_masks
	(
	CIC_UINT8	*two_stroke_maskUCAr	
	);

CIC_VOID set_two_stroke_mask
	(
	CIC_UINT8	*two_stroke_maskUCAr,
	unsigned long trainUL
	);

CIC_VOID set_shape_mask
	(
	CIC_UINT8	*maskAr,
	unsigned long trainUL
	);

#if SUN
CIC_VOID plot_data
    (
    CIC_COUNT type,             /* type of plot. Values are 1 for raw data,  */
                                /* 2  after compression                      */
    CIC_COUNT window,           /* which window to plot in (in range 2-6)    */
    CIC_COUNT xshift,           /* Xshift for plotting multiple charcters    */
    CIC_COUNT yshift,           /* Yshift for plotting multiple charcters    */
    CIC_COUNT numsegs,
    CIC_COUNT segpnts,
    CIC_COUNT x[],              /* X-coordinates of signal                   */
    CIC_COUNT y[],              /* Y-coordinates of signal                   */
    CIC_TEXT  promptC,          /* label of input response(what it should be)*/
    CIC_LONG  kounterL,         /* keeps track of enumber of input samples   */
    STROKE      *stkP,          /* The segmented data.                       */
    CIC_TEXT  *infoS
    );

CIC_VOID plot_init
    (
    );

CIC_VOID plot_close
    (
    );
#endif

#endif 	/* #ifndef ZOHMMPUB_H */

