/* ZORROCTRL.H         CIC Proprietary
 *-----------------------------------------------------------------------------
 * Definition of CicZorroControl class and Global Registration Funcs
 *
 * D.C. Foyt    9-Jul-96
 *-----------------------------------------------------------------------------
 */

#ifndef __CFCZORROCTRL_H
#define __CFCZORROCTRL_H

#include <cfcctrl.h>
#include <cfcreco.h>

/*
 *-----------------------------------------------------------------------------
 * Define message handling constants
 *-----------------------------------------------------------------------------
 */

const LRESULT WM_CIC_RECOREADY = (WM_USER + 2014L);

/*
 *-----------------------------------------------------------------------------
 * Define MODELINE structure
 *-----------------------------------------------------------------------------
 */
#define ML_RADIUS 	         4
#define INITIAL_BOX_MODELINE 0.4
#define LINE_DEFAULT	     PS_DOT
#define LINE_PUNC	         PS_SOLID                                  
#define ML_HMOVABLE	         0x01
#define ML_VMOVABLE 	     0x02
#define ML_EXTENDABLE	     0x04
#define ML_HVCONVERTABLE     0x08
#define ML_FITPARENT	     0x10
#define szZorroVArrowClass   "PAVArrowClass"
#define ML_DIM		         6

typedef struct tagMODELINE
    {
    HWND	hwndOwner;	// Owner window           
    HWND	hwndPos;	// window to adjust position
    HWND	hwndLen;	// window to adjust length
    HWND	hwndLine;	// window represent the line
    POINT 	pos;  		// position
    int 	len;            // length
    int		dir;            // direction
    int		style;		// PS_SOLID or PS_DOT
    int		action;		// Action to take for mouse events
    } MODELINE;
/*
 *-----------------------------------------------------------------------------
 * Define the CicZorroControl Data Object
 *-----------------------------------------------------------------------------
 */

class CicPublicClass CicZorroControl : public CicInkControl
    {
    public:
        // Public functions
        CicZorroControl(HWND hWnd);
        ~CicZorroControl();
        BOOL Configure(DWORD dwFeature);
        BOOL GetConfig(DWORD dwFeature, DWORD* pdwParam) const;

    protected:
        friend LRESULT CALLBACK CICZorroCtrlProc(HWND hWnd, UINT message,
            UINT wParam, LONG lParam);
        friend LRESULT CALLBACK  ModeLineWndProc(HWND hwnd, UINT message,
            WPARAM wParam, LPARAM lParam);

        // Protected data members
        WNDPROC        m_lpInkControlWndProc;
        CicRecognizer* m_pRecognizer;
        MODELINE       m_vMLBox;
    };

//
// Global Function Prototypes and const variables
//

CicPublicClass BOOL RegisterZorroControl(CREATESTRUCT& cs);
CicPublicClass BOOL RegisterZorroControl(HINSTANCE hInstance);
CicPublicClass BOOL UnregisterZorroControl(HINSTANCE hInstance);

CicPublicClass CicZorroControl* GetZorroControl(HWND hWnd);
CicPublicClass CicZorroControl* GetZorroControl(HWND hDlg, const int nDlgItemId);

const char CICZorroControlClass[] = "CICRECOCTRL";

#endif
