/* zover.h			CIC Proprietary
 *-----------------------------------------------------------------------------
 * SCCS Version 1.1, 10:03:16 9/3/96
 *-----------------------------------------------------------------------------
 * Definition of versions
 *
 * J. Wang          09-Aug-96   Initial.
 *-----------------------------------------------------------------------------
 */
#ifndef ZOVER_H
#define ZOVER_H

#define NDEF	255

/*
 *-----------------------------------------------------------------------------
 * Definition of recognized shape versions
 *-----------------------------------------------------------------------------
 */
#define MAX_ZS_VERSION		117
#define MAX_HMM_VERSION		84
#define MAX_TWO_STROKE_VERSION	128

#define ZS_CICSPACE		0
#define ZS_TILDE		1
#define ZS_LBRACE		2
#define ZS_RBRACE		3
#define ZS_AMPERSAND1		4
#define ZS_AMPERSAND2		5
#define ZS_AT			6
#define ZS_TWO			7
#define ZS_THREE		8
#define ZS_FOUR1		9
#define ZS_FOUR2		10
#define ZS_FIVE			11
#define ZS_SIX			12
#define ZS_SEVEN		13
#define ZS_EIGHT1		14
#define ZS_EIGHT2		15
#define ZS_NINE1		16
#define ZS_NINE2		17
#define ZS_UCA1			18
#define ZS_UCA2			19
#define ZS_UCA3			20
#define ZS_UCA4			21
#define ZS_UCB1			22
#define ZS_UCB2			23
#define ZS_UCD1			24
#define ZS_UCD2			25
#define ZS_UCE			26
#define ZS_UCG1			27
#define ZS_UCG2			28
#define ZS_UCG3			29
#define ZS_UCH			30
#define ZS_UCJ			31
#define ZS_UCL			32
#define ZS_UCN1			33
#define ZS_UCN2			34
#define	ZS_UCR1			35
#define ZS_UCR2			36
#define ZS_UCT			37
#define ZS_LCA1			38
#define ZS_LCA2			39
#define ZS_LCB1			40
#define ZS_LCB2			41
#define ZS_LCC			42
#define ZS_LCD1			43
#define ZS_LCD2			44
#define ZS_LCD3			45
#define ZS_LCE			46
#define ZS_LCF			47
#define ZS_LCG1			48
#define ZS_LCG2			49
#define ZS_LCH1			50
#define ZS_LCH2			51
#define ZS_LCJ			52
#define ZS_LCK1			53
#define ZS_LCK2			54
#define ZS_LCL1			55
#define ZS_LCL2			56
#define ZS_LCM			57
#define ZS_UCM			58
#define ZS_LCN			59
#define ZS_LCO1			60
#define ZS_LCO2			61
#define ZS_LCO3			62
#define ZS_LCO4			63
#define ZS_LCO5			64
#define ZS_LCO6			65
#define ZS_LCP1			66
#define ZS_LCP2			67
#define ZS_LCQ1			68	
#define ZS_LCQ2			69
#define ZS_LCR			70
#define ZS_LCS			71
#define ZS_LCT1			72
#define ZS_LCT2			73
#define ZS_LCT3			74
#define ZS_LCU1			75
#define ZS_LCU2			76
#define ZS_LCV1			77
#define ZS_LCV2			78
#define ZS_LCW			79
#define ZS_LCY1			80
#define ZS_LCY2			81
#define ZS_LCZ1			82
#define ZS_LCZ2			83
#define ZS_SLASH1		84
#define ZS_SLASH2		85
#define ZS_BACKSLASH		86
#define ZS_LPARENTHESIS		87
#define ZS_RPARENTHESIS		88
#define ZS_LSQBRACKET		89
#define ZS_RSQBRACKET		90
#define ZS_RIGHT		91
#define ZS_LEFT			92
#define ZS_LBRACKET		93
#define ZS_RBRACKET		94
#define ZS_RIGHT_R		95
#define ZS_LEFT_R		96
#define ZS_DOT			97
#define ZS_CHECK		98
#define ZS_CUT			99	
#define ZS_COPY			100
#define ZS_PASTE		101
#define ZS_UNDO			102
#define ZS_DOWN_R		103
#define ZS_SPACE		104
#define	ZS_NEWLINE		105
#define ZS_TAB			106
#define	ZS_UPPERLEFT_R		107
#define	ZS_UPPERRIGHT_R		108
#define	ZS_FOUR_F		109
#define	ZS_FIVE_F		110
#define ZS_LCO_R		111
#define ZS_LCF_F		112
#define ZS_UP			113
#define ZS_NEWPASTE		114
#define ZS_NEWCOPY		115
#define ZS_UPPERLEFT		116

/*
 *-----------------------------------------------------------------------------
 * Definition of two stroke character versions
 *-----------------------------------------------------------------------------
 */
#define MAX_MS_VERSION 23

#define	MS_Q			0	/* 3 49 21 */
#define	MS_F1			1	/* 3 70 21 */
#define MS_F2			2	/* 3 70 22 */
#define	MS_I1			3	/* 3 73 21 */
#define MS_I2			4	/* 3 73 22 */
#define	MS_J1			5	/* 3 74 21 */
#define MS_J2			6	/* 3 42 21 */
#define MS_J3			7	/* 3 42 22 */
#define MS_K			8	/* 3 75 21 */
#define MS_T1			9  	/* 3 84 21 */
#define MS_T2			10	/* 3 84 22 */
#define MS_T3			11	/* 3 84 23 */
#define MS_X			12	/* 3 88 21 */
#define MS_EQUAL		13	/* 1 65 21 */
#define MS_FOUR1		14	/* 3 20 21 */
#define MS_FOUR2		15	/* 3 20 22 */
#define MS_FIVE1		16	/* 3 21 21 */
#define MS_FIVE2		17	/* 3 21 22 */
#define MS_EXCLA		18	/* 1 10 21 */
#define MS_QUES			19 	/* 1  9 21 */
#define MS_DOLLAR		20 	/* 1 80 21 */
#define MS_Y			21	/* 3 89 21 */
#define MS_P			22	/* 3 80 21 */

#endif

