/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   app.h
Author(s)   :   J. Wang
Company     :   Communication Intelligence Corporation
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef _APP_H_
#define _APP_H_

#include "uifunc.h"
#include "uidef.h"
#include "bcd.h"
#include "jotlang.h"

// Jot Macro Editor 
#define NUM_MACRO_TABLE_ROW 7
#define MAX_MACRO_NAME_LEN 7
#define MAX_MACRO_TEXT_LEN 255	

// Jot Form
#define FORM_JOT				0
#define PUSHBUTTON_TIMEOUTS		1
#define PUSHBUTTON_ADVANCED		2

// Timeout
#define STRING_TIMEOUT			3
#define SCROLLBAR_TIMEOUT		4
#define STRING_SHORTPAUSE		5
#define STRING_LONGPAUSE		6
#define STRING_TIME				7

// Macro display in Jot Form
#define STRING_MACRO_NAME		8
#define STRING_MACRO_OUTPUT		9
#define LINE_MACRO				10
#define LIST_MACRO_NAME			11
#define LIST_MACRO_TEXT			12
#define BUTTON_MACRO_EDITOR		13
#define BUTTON_TRAINER			14
#define SCROLLBAR_MACRO			67

// Macro Editor Form
#define FORM_MACRO_EDITOR		15
#define STRING_MACRO_NAME1		16
#define STRING_MACRO_OUTPUT1	17
#define LINE_MACRO1				18
#define LIST_MACRO_NAME1		19
#define LIST_MACRO_TEXT1		20
#define BUTTON_JOT_MACROEDITOR_NEW 21
#define BUTTON_JOT_MACROEDITOR_EDIT 22
#define BUTTON_JOT_MACROEDITOR_DELETE 23
#define SCROLLBAR_JOT_MACRO		68

#define FORM_JOT_NEWMACRO 24
#define STRING_JOT_MACRO_NAME 25
#define TEXTBOX_JOT_MACRO_NAME 26
#define STRING_JOT_MACRO_TEXT 27
#define FIELD_JOT_MACRO_TEXT 28
#define BUTTON_JOT_NEWMACRO_DELETE 29
#define BUTTON_JOT_NEWMACRO_DONE 30
#define SCROLLBAR_NEWMACRO 69


// OKCANCEL dialog
#define FORM_OKCANCEL			31
#define STRING_OKCANCEL1		32
#define STRING_OKCANCEL2		33
#define BUTTON_OKCANCEL_OK		34
#define BUTTON_OKCANCEL_CANCEL	35

// Warning dialog
#define FORM_WARNING	36
#define STRING_WARNING	37
#define BUTTON_WARNING_OK 38

// Trainer form
#define FORM_TRAINER			39
#define BUTTON_RESET			40
#define STRING_TRAINER1			41
#define STRING_TRAINER2			42
#define STRING_TRAINER3			43
#define STRING_TRAINER4			44
#define PUSHBUTTON_J			45
#define PUSHBUTTON_k			46
#define PUSHBUTTON_p			47
#define PUSHBUTTON_Q			48
#define PUSHBUTTON_t1			49
#define PUSHBUTTON_t2			50
#define PUSHBUTTON_i			51
#define PUSHBUTTON_DOLLAR		52
#define STRING_QUESTION1		53
#define STRING_QUESTION2		54
#define CHECKBOX_YES			55
#define CHECKBOX_NO				56
#define STRING_YES				57
#define STRING_NO				58
#define BITMAP_J				59
#define BITMAP_K				60
#define BITMAP_P				61
#define BITMAP_Q				62
#define BITMAP_T1				63
#define BITMAP_T2				64
#define BITMAP_I				65
#define BITMAP_DOLLAR			66
#define PUSHBUTTON_INTRO		70



/*==================== Menu Item ===========================*/
#define MENU_ITEM_COPY			0
#define MENU_ITEM_CUT			1
#define MENU_ITEM_PASTE			2
#define MENU_ITEM_UNDO			3

#endif
