#ifndef __BCD_H__
#define __BCD_H__

#include "datatype.h"

#define POSITIVE	TRUE
#define NEGATIVE	FALSE
#define FIRST		0
#define SECOND		1
#define SAME		2

struct B_cd
{
    BOOLEAN sign;
    BYTE mantissa[14];
    SHORT exp;
};

typedef struct B_cd Bcd;
/*
typedef struct aaa
{
    BOOLEAN sign;
    BYTE mantissa[14];
    SHORT exp;
} Bcd;
*/
void BcdAddByte(BYTE input1, BYTE input2, BOOLEAN old_carry, BYTE* result, BOOLEAN *carry);
void BcdSubByte(BYTE input1, BYTE input2, BOOLEAN old_borrow, BYTE* result, BOOLEAN *borrow);
void BcdMulByte(BYTE input1, BYTE input2, BYTE old_carry, BYTE* result, BYTE *carry);
BOOLEAN BcdCompareZero(Bcd input);
Bcd BcdMulAll(Bcd input1, Bcd input2);
Bcd BcdMulByteToAll(Bcd input1, BYTE input2);
Bcd BcdAddAll(Bcd input1, Bcd input2);
Bcd BcdSubAll(Bcd input1, Bcd input2);
Bcd BcdDivAll(Bcd input1, Bcd input2);
Bcd BcdSquRoot(Bcd input);
void BcdAlign(Bcd *input);
Bcd BcdShiftRight(Bcd input1);
Bcd BcdShiftLeft(Bcd input1);
void BcdAlignTwoNums(Bcd *input1, Bcd *input2);
#endif
