/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   main.c
Author(s)   :   J. Wang
Company     :   Communication Intelligence Corporation
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "system.h"
#include "app.h"
#include "jot.h"
#include "jotui.h"

#define JOT_RES_SIZE 11839

/* ==================================================================== */
/* ========================= Function Prototypes ====================== */
/* ==================================================================== */
void EventLoop();
void MMUInit();
void KernelInit();
void ResInit();
static BOOLEAN ApplicationHandleEvent(EvtType *Event);

extern UWORD *sys_page, *app_page;
extern REGISTRY app_reg[];

BOOLEAN (*FormDispatchEvent)(EvtType *Event);

#ifdef PC_SIM
extern BOOL m_bIsExit;
#endif

extern UBYTE res_data[];


/* ==================================================================== */
/* ========================= Global Defines =========================== */
/* ==================================================================== */
extern ObjectID g_prevForm;

JOT_STATUS jot_status;

int g_pushbutton = PUSHBUTTON_TIMEOUTS;


void GotoPage(int page)
{
	BOOLEAN show;
	
	if (g_pushbutton != page)
	{
		EvtType Event;
		Event.eventType = EVT_FORM_CLOSE;
		switch (g_pushbutton)
		{
		case PUSHBUTTON_TIMEOUTS:
			TimeoutsHandleEvent(&Event);
			break;
		case PUSHBUTTON_ADVANCED:
			AdvancedHandleEvent(&Event);
			break;
		}
	}
	
	// Advanced
	if (page == PUSHBUTTON_ADVANCED)
		show = TRUE;
	else
		show = FALSE;
	
	ControlSetAttributes(BUTTON_MACRO_EDITOR,
		show,	// enable
		FALSE,	// drawn
		FALSE,	// save behind
		FALSE,	// active
		show);	// visible
	ControlSetAttributes(BUTTON_TRAINER,
		show,	// enable
		FALSE,	// drawn
		FALSE,	// save behind
		FALSE,	// active
		show);	// visible
	ListSetAttribute(LIST_MACRO_NAME,
		FALSE,	// att_enable,
		FALSE,	// att_drawn,
		FALSE,	// att_active, 
		show,	// att_visible, 
		FALSE);	// att_set_scroll
	ListSetAttribute(LIST_MACRO_TEXT,
		FALSE,	// att_enable,
		FALSE,	// att_drawn,
		FALSE,	// att_active, 
		show,	// att_visible, 
		FALSE);	// att_set_scroll
	StringSetAttribute(STRING_MACRO_NAME, FALSE, show);
	StringSetAttribute(STRING_MACRO_OUTPUT, FALSE, show);
	LineSetAttribute(LINE_MACRO, FALSE, show);
	if (GetJotMacroNum() > 9)
		ScrollbarSetScrollbarVisible(SCROLLBAR_MACRO, show);
	else
		ScrollbarSetScrollbarVisible(SCROLLBAR_MACRO, FALSE);
	
	if (page == PUSHBUTTON_TIMEOUTS)
		show = TRUE;
	else
		show = FALSE;
	
	ScrollbarSetScrollbarVisible(SCROLLBAR_TIMEOUT, show);
	StringSetAttribute(STRING_TIMEOUT, FALSE, show);
	StringSetAttribute(STRING_SHORTPAUSE, FALSE, show);
	StringSetAttribute(STRING_LONGPAUSE, FALSE, show);
	StringSetAttribute(STRING_TIME, FALSE, show);
	
	if (g_pushbutton != page)
	{
		EvtType Event;
		Event.eventType = EVT_FORM_OPEN;
		switch (page)
		{
		case PUSHBUTTON_TIMEOUTS:
			TimeoutsHandleEvent(&Event);
			break;
		case PUSHBUTTON_ADVANCED:
			AdvancedHandleEvent(&Event);
			break;
		}
	}
	
	g_pushbutton = page;
}

/********************************************************
* Function:	JotFormEventHandler
* Purpose: 	This function is the event handler for the first
page of the Jot application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN JotFormEventHandler(EvtType *Event)
{
	EvtType new_event;
    AppID   appid = 0xFFFF;
	
	switch (Event->eventType)
	{
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			SysGetAppID(MAINMENU, &appid);
			EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
			EvtAppendEvt(EVT_APP_LAUNCH, appid, 0, 0, NULL);
		}
		return TRUE;        
	case EVT_CONTROL_SELECT:
		{
			switch (Event->eventID)
			{
			case PUSHBUTTON_ADVANCED:
			case PUSHBUTTON_TIMEOUTS:
				GotoPage(Event->eventID);
				FormDrawForm(FORM_JOT);
				break;
			}
		}
		break;
	case EVT_FORM_OPEN:
		g_prevForm = FORM_JOT;
		GotoPage(g_pushbutton);
		FormDrawForm(FORM_JOT);
		FormSetControlGroupSelection(FORM_JOT, g_pushbutton);
		break;
	case EVT_FORM_CLOSE:
		break;
	}
	
	switch (g_pushbutton)
	{
	case PUSHBUTTON_ADVANCED:
		AdvancedHandleEvent(Event);
		break;
	case PUSHBUTTON_TIMEOUTS:
		TimeoutsHandleEvent(Event);
		break;
	}
	
	return TRUE;
}

/********************************************************
* Function:	ApplicationHandleEvent
* Purpose: 	This function is used to load the specific data of
form and set event handler of the form
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
static BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
	Form *form_ptr;
	ObjectID form_id;
	BYTE object_type;
	Err Error;
	
	if (Event->eventType == EVT_FORM_LOAD)
	{
		form_id = (ObjectID)Event->eventID;
		Error = UISearchForAddress(form_id,&object_type,(void**)&form_ptr);
		if (Event->para1 == 1 || Error != TRUE)
			FormInitAllFormObjects(form_id);
		
		if (!UISearchForAddress(form_id,&object_type,(void**)&form_ptr)) return FALSE;
		switch (form_id)
		{
		case FORM_JOT:
			FormSetEventHandler(FORM_JOT, (void**)&FormDispatchEvent, (void*) JotFormEventHandler);
			break;
		case FORM_MACRO_EDITOR:
			FormSetEventHandler(FORM_MACRO_EDITOR, (void**)&FormDispatchEvent, (void*) MacroEditorHandleEvent);
			break;
		case FORM_TRAINER:
			FormSetEventHandler(FORM_TRAINER, (void**)&FormDispatchEvent, (void*) TrainerHandleEvent);
			break;
		case FORM_JOT_NEWMACRO:
			FormSetEventHandler(FORM_JOT_NEWMACRO, (void**)&FormDispatchEvent, (void*) NewMacroFormEventHandler);
			break;
		case FORM_WARNING:
			FormSetEventHandler(FORM_WARNING, (void**)&FormDispatchEvent, (void *)WarningFormEventHandler);
			break;
		case FORM_OKCANCEL:
			FormSetEventHandler(FORM_OKCANCEL, (void**)&FormDispatchEvent, (void *)OkCancelFormEventHandler);
			break;
		}
		FormSetActiveForm(form_id);
		return TRUE;
	}
	return FALSE;
}
/********************************************************
* Function:	EventLoop
* Purpose: 	This function is a loop to get events from event
manager and then passes the event to different
event handler
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
static void EventLoop(void)
{
	EvtType event;
	
	do
	{
		EvtGetEvent (&event);
		if (!SystemHandleEvent(&event))
			if (!MenuHandleEvent(&event))
				if (!ApplicationHandleEvent(&event))
					FormDispatchEvent(&event);
    }
#ifdef PC_SIM
    while (event.eventType != EVT_APP_STOP && m_bIsExit == FALSE);
#else
    while (event.eventType != EVT_APP_STOP);
#endif
}
/********************************************************
* Function:	main
* Purpose: 	main procedure of the application
* Scope:		Application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
__main(WORD cmd, void *cmd_ptr)
{	
	if (cmd == LAUNCH_CMD_FIND)
		pfree(cmd_ptr);
	else if (cmd == LAUNCH_CMD_NORMAL_LAUNCH)
	{
        UIApplicationInit();
		OpenJotMacroDB();
		UpdateJotTrainerDB(JOT_READ_DB);
		UpdateJotStatusDB(JOT_READ_DB);
        FormPopupForm(jot_status.formID);
		EventLoop();
		CloseJotMacroDB();
		UpdateJotTrainerDB(JOT_WRITE_DB);
		UpdateJotStatusDB(JOT_WRITE_DB);
		JotUpdate();
        UIDeleteAllAppObjects();
	}
	else if (cmd == LAUNCH_CMD_ALARM_HIT)
		pfree(cmd_ptr);
	else if (cmd == LAUNCH_CMD_GOTO_REC)
	{
		if (((GotoRec*)cmd_ptr)->find_string)
			pfree(((GotoRec*)cmd_ptr)->find_string);
		pfree(cmd_ptr);
	}
	return;
}

void SaveFormJot()
{
	jot_status.form_jot_page = g_pushbutton;
}

void RestoreFormJot()
{
	g_pushbutton = jot_status.form_jot_page;
}
