/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   main.c
Author(s)   :   Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#include "stdafx.h"
#include "resource.h"
#include "kernel.h"
#include "resmgr.h"
#include "app.h"
#include "ui.h"
#include "uifunc.h"
#include "inlay.h"
#include "system.h"

/* ==================================================================== */
/* ========================= Function Prototypes ====================== */
/* ==================================================================== */
static void EventLoop();
void MMUInit();
void KernelInit();
void ResInit();
static BOOLEAN ApplicationHandleEvent(EvtType *Event);
extern void AllApplicationDatabaseInit();

BOOLEAN (*FormDispatchEvent)(EvtType *Event);
extern UWORD *sys_page, *app_page;
extern REGISTRY app_reg[];

#ifdef PC_SIM
extern BOOL m_bIsExit;
#endif



/* ==================================================================== */
/* ========================= Global Defines =========================== */
/* ==================================================================== */

/* ==================================================================== */
/* ========================= Global Variables ========================= */
/* ==================================================================== */
DatabaseID maths_dbid;
DatabaseID sys_dbid;
UWORD tmr;
extern UBYTE res_data[];


/********************************************************
* Function:	ApplicationHandleEvent
* Purpose: 	This function is used to load the specific data of
form and set event handler of the form
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
static BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
	Form *form_ptr;
	ObjectID form_id;
	BYTE object_type;
	Err Error;
	
	if (Event->eventType == EVT_FORM_LOAD)
	{
		form_id = (ObjectID)Event->eventID;
		Error = UISearchForAddress(form_id,&object_type,(void**)&form_ptr);
		if (Event->para1 == 1 || Error != TRUE)
			FormInitForm(form_id);
		if (!UISearchForAddress(form_id,&object_type,(void**)&form_ptr)) return FALSE;
		switch (form_id)
		{
		case FORM_MAIN_MENU:
			FormSetEventHandler(FORM_MAIN_MENU, (void**)&FormDispatchEvent, (void*)MainMenuForm1);
			break;
			
		}
		FormSetActiveForm(form_id);
		return TRUE;
	}
	return FALSE;
}
/********************************************************
* Function:	EventLoop
* Purpose: 	This function is a loop to get events from event
manager and then passes the event to different
event handler
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
static void EventLoop(void)
{
	EvtType event;
	do
	{
		EvtGetEvent (&event);
		if (!SystemHandleEvent(&event))
			if (!MenuHandleEvent(&event))
				if (!ApplicationHandleEvent(&event))
					FormDispatchEvent(&event);
	}
#ifdef PC_SIM
	while (event.eventType != EVT_APP_STOP && m_bIsExit == FALSE);
#else
	while (event.eventType != EVT_APP_STOP);
#endif
}
/********************************************************
* Function:	main
* Purpose: 	main procedure of the application
* Scope:		Application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
#ifdef PC_SIM
void LoadRes();
#endif

#ifdef PC_SIM
void main(WORD cmd, void *cmd_ptr)
#endif
#ifdef PR31700
__main(WORD cmd, void *cmd_ptr)
#endif
{
#ifdef PC_SIM
	MsgQueueCreate(&msgQueue);
	EvtQueueCreate(&evtQueue);
	KeyboardInitKeyboard();
	MMUInit();
	ResInit();
	LcdInit();
	UIInit();
#endif
	
	AllApplicationDatabaseInit();
	
	if (cmd == LAUNCH_CMD_FIND)
        pfree(cmd_ptr);
	else if (cmd == LAUNCH_CMD_NORMAL_LAUNCH)
	{
        UIApplicationInit();
        FormPopupForm(FORM_MAIN_MENU);
        EventLoop();
        TmrIntDisable(tmr);
        UIDeleteAllAppObjects();
	}
	else if (cmd == LAUNCH_CMD_ALARM_HIT)
        pfree(cmd_ptr);
	else if (cmd == LAUNCH_CMD_GOTO_REC)
	{
        if (((GotoRec*)cmd_ptr)->find_string)
			pfree(((GotoRec*)cmd_ptr)->find_string);
        pfree(cmd_ptr);
	}
	DataCloseDB(sys_dbid);
	if (object_array)
		qfree(object_array);
	return;
}

#ifdef PC_SIM
void LoadRes()
{
	char app_name[20];
	UBYTE *ptr;
	UWORD *ptable;
	AppID app_id;
	unsigned long res_size = 6691;
	unsigned long i;
	
	MemoryInstallProg(MAINMENU, res_size, APP_TYPE_APP, FALSE, 0, &app_id, (UBYTE **) &ptr, (UWORD **)&ptable);
	if(ptr == NULL)
	{
		printf("\nNot enough memory to install resource ");
		return;
	}
	
	for(i=0;i<res_size;i++)
		ptr[i] = res_data[i];
}
#endif
