/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   memo.h
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#ifndef __MEMO_H_
#define __MEMO_H_

#include "uifunc.h"
#include "ui.h"
#include "mmu.h"
#include "MemoLch.h"
#include "MemoFunc.h"
#include "MemoDB.h"
#include "memolang.h"
#ifdef PR31700
#include "ioconmsg.h"
#endif

/*****************************************************************
********************** Anniversaries Application *****************
*****************************************************************/
BOOLEAN MemoList(EvtType* Event);
BOOLEAN MemoViewing(EvtType* Event);
BOOLEAN MemoNew(EvtType* Event); 
BOOLEAN MemoSaveChanges(EvtType* Event);
BOOLEAN MemoItemErase(EvtType* Event);
BOOLEAN MemoSort(EvtType* Event);
BOOLEAN MemoEditCate(EvtType* Event);
BOOLEAN MemoSelectCate(EvtType* Event);
BOOLEAN MemoEraseCate(EvtType* Event);
BOOLEAN MemoRemoveCate(EvtType* Event);
BOOLEAN MemoFullCate(EvtType *Event);
BOOLEAN MemoNewCate(EvtType *Event);
BOOLEAN MemoExistsCate(EvtType *Event);
BOOLEAN MemoSysLowMem(EvtType *Event);

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
extern	DatabaseID	memo_dbid;
extern	AppStatus	app_status;
extern	MemoSketch	memo_sketch;
extern	BYTE *		current_cate;
extern	BYTE *		temp_cate;
extern	BYTE **		memo_field_buffer;

/*****************************************************************
*********************** Global Defines ***************************
*****************************************************************/
#define	MEMO_LIST							0
#define MEMO_VIEWING						1
#define MEMO_NEW							2

#define	MEMO_NO_SKETCH						0
#define MEMO_SKETCH							1
#define MEMO_NUM_FIELD                      4
#define	MEMO_BLOCK_SIZE						20
#define MEMO_SFONT_NUM_OF_ROW					13
#define MEMO_LFONT_NUM_OF_ROW					9
#define MEMO_NUM_OF_ROW						13
#define MEMO_SFONT_NUM_OF_CELL					52
#define MEMO_LFONT_NUM_OF_CELL					36
#define MEMO_BITMAP_OFFSET					19
#define	MEMO_LCOLUMN_1						22
#define	MEMO_LCOLUMN_2						16
#define	MEMO_LCOLUMN_3						96
#define	MEMO_SCOLUMN_1						20
#define	MEMO_SCOLUMN_2						16
#define	MEMO_SCOLUMN_3						98
#define	MEMO_COLUMN_0						0
#define	MEMO_COLUMN_1						1
#define	MAX_TEXT_ON_DISPLAY					50

#define	ALP_ORDER							0
#define	CHR_ORDER							1

#define FIELD_HEIGHT_KEYBOARD_ON			79
#define FIELD_HEIGHT_KEYBOARD_OFF			117
#define SCROLLBAR_HEIGHT_KEYBOARD_ON		81
#define SCROLLBAR_HEIGHT_KEYBOARD_OFF		123

#define	MAX_NUM_OF_CATE						255

/*==================== Compare Two Strings =================*/
#define FIRST								0
#define SECOND								1
#define SAME								2

/*==================== Menu Item ===========================*/
#define MENU_ITEM_COPY						0
#define MENU_ITEM_CUT						1
#define MENU_ITEM_PASTE						2
#define MENU_ITEM_UNDO						3
#define MENU_ITEM_ZOOM						4
#define MEMO_MENU						89

/*==================== Menu Large Text ===========================*/
#define MENU_SMALL_TEXT						0
#define MENU_LARGE_TEXT						1


/*======================= Memo Database =====================*/
#define MEMO_STATUS							0x80001004
#define MEMO_EDIT_INFO						0x80001005

/*============ Memo Status Define (Close Application) =======*/
#define RESTART_MEMO						0
#define RESTART_MEMO_VIEWING				1
#define RESTART_MEMO_NEW					2

/*======================= Memo Category =====================*/
#define	UNFILED								0
#define BUSINESS							1
#define PERSONAL							2

/******************************************************************
********************** OBJECT ID Defines **************************
******************************************************************/
/*		FORM MEMO LIST (Form 1)	*/
#define FORM_MEMO_LIST						0
#define	POPUP_TRIGGER_CATEGORY				1
#define	SCROLLBAR_MEMO_LIST					2
#define	BUTTON_MEMO_SORT					3
#define	BUTTON_MEMO_NEW						4
#define TABLE_MEMO_LIST						5
#define	STRING_MEMO_CONTENT_N1					6
#define	STRING_MEMO_LIST_MONTH					93
#define BITMAP_MEMO_N1						19
#define MENU_CHANGE_FONT					91


/*		FORM MEMO VIEWING (Form 2)	*/
#define	FORM_MEMO_VIEWING					32
#define	SCROLLBAR_MEMO_VIEWING				33
#define	BUTTON_MEMO_SKETCH					34
#define	BUTTON_MEMO_DEL						35
#define	BITMAP_MEMO_SKETCH					36
#define	STRING_MEMO_TITLE					37
#define	FIELD_MEMO_VIEWING					38

/*		FORM ANNIVERSARIES NEW (Form 3)		*/
#define	FORM_MEMO_NEW						39
#define	FIELD_MEMO_NEW						40
//#define	POPUP_TRIGGER_NEW_CATEGORY			90

/*		FORM SAVE CHANGE (Form 4)			*/
#define	FORM_SAVE_CHANGES					41	
#define	BITMAP_SAVE_EXIT					42
#define	BUTTON_SAVE_CHANGES_YES				44
#define	BUTTON_SAVE_CHANGES_NO				45

/*		FORM ITEM ERASE (Form 5)			*/
#define	FORM_ITEM_ERASE						46
#define	CHECKBOX_ITEM_ERASE					49
#define	BUTTON_ITEM_ERASE_YES				50
#define	BUTTON_ITEM_ERASE_NO				51

/*		FORM SORT BY (Form 6)				*/
#define	FORM_SORT_BY						52
#define	PUSHBUTTON_SORT_N1					53
#define	PUSHBUTTON_SORT_N2					54
#define BITMAP_MEMO_SORT_EXIT					56

/*		FORM SELECT CATE (Form 7)			*/
#define	FORM_SELECT_CATE					57
#define	BITMAP_SELECT_CATE_X					58

/*		FORM_NEW_CATE (Form 8)				*/
#define	FORM_NEW_CATE						60
#define	BITMAP_NEW_CATE_X					61
#define	TEXTBOX_NEW_CATE					63

/*		FORM_ERASE_CATE (Form 9)			*/
#define	FORM_ERASE_CATE						64
#define	BUTTON_ERASE_CATE_YES					66
#define	BUTTON_ERASE_CATE_NO					67

/*		FORM_REMOVE_CATE (Form 10)			*/
#define	FORM_REMOVE_CATE					68
#define	BUTTON_REMOVE_CATE_YES					73
#define	BUTTON_REMOVE_CATE_NO					74

/*		FORM_EXISTS_CATE (Form 11)			*/
#define	FORM_EXISTS_CATE					75
#define	BITMAP_CATE_NAME_EXISTS_X				76

/*		FORM_FULL_CATE (Form 12)			*/
#define	FORM_FULL_CATE						80
#define	BITMAP_CATE_FULL_X					81

/*		FORM_EDIT_CATE (Form 13)			*/
#define	FORM_EDIT_CATE						85
#define	BUTTON_RENAME_CATE					86
#define	BUTTON_DEL_CATE						88
#define	LIST_CATE							90
#define	MEMO_CATE_MENU						92

/*		FORM_FULL_CATE (Form 14)			*/
#define	FORM_SYSTEM_LOW_MEM					120
#define	BITMAP_SYS_LOW_MEMORY_X					121
#endif
