/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   main.c
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#ifdef PC_SIM
#include "resource.h"
#endif
#include "kernel.h"
#include "resmgr.h"
#include "ui.h"
#include "uifunc.h"
#include "inlay.h"
#include "system.h"
#include "Memo.h"
#include "MemoFunc.h"
#include "MemoDB.h"
#include "MemoLch.h"
#include "sysetup.h"

extern UWORD _fdata, etext, _fbss, ebss;
#ifdef PR31700
BOOLEAN (*FormDispatchEvent)(EvtType *Event);
#endif

///#define DEBUG
//#define DEBUG_HENRY

/* ==================================================================== */
/* ========================= Function Prototypes ====================== */
/* ==================================================================== */
void EventLoop();
void MMUInit();
void KernelInit();
void ResInit();
BOOLEAN ApplicationHandleEvent(EvtType *Event);
AppID app_id;

extern UWORD *sys_page, *app_page;
extern REGISTRY app_reg[];

#ifdef PC_SIM
extern BOOL m_bIsExit;
#endif


/* ==================================================================== */
/* ========================= Global Variables ========================= */
/* ==================================================================== */
BOOLEAN		restore_status;
extern UBYTE	res_data[];

/********************************************************
* Function:	ApplicationHandleEvent
* Purpose: 	This function is used to load the specific data of
form and set event handler of the form
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
	Form *form_ptr;
	ObjectID form_id;
	BYTE object_type;
	Err Error;
	
	if (Event->eventType == EVT_FORM_LOAD)
	{
		form_id = (ObjectID)Event->eventID;
		Error = UISearchForAddress(form_id,&object_type,(void**)&form_ptr);
		if (Event->para1 == 1 || Error != TRUE)
		{
			FormInitForm(form_id);
		}
		if (!UISearchForAddress(form_id,&object_type,(void**)&form_ptr)) return FALSE;
		
		switch (form_id)
		{
		case FORM_MEMO_LIST:	/* Form 1 */
			FormSetEventHandler(FORM_MEMO_LIST,(void**)&FormDispatchEvent,(void*)MemoList);
			break;
		case FORM_MEMO_VIEWING:	/* Form 2 */
			FormSetEventHandler(FORM_MEMO_VIEWING,(void**)&FormDispatchEvent,(void*)MemoViewing);
			break;
		case FORM_MEMO_NEW:		/* Form 3 */
			FormSetEventHandler(FORM_MEMO_NEW,(void**)&FormDispatchEvent,(void*)MemoNew);
			break;
		case FORM_SAVE_CHANGES:	/* Form 4 */
			FormSetEventHandler(FORM_SAVE_CHANGES,(void**)&FormDispatchEvent,(void*)MemoSaveChanges);
			break;
		case FORM_ITEM_ERASE:	/* Form 5 */
			FormSetEventHandler(FORM_ITEM_ERASE,(void**)&FormDispatchEvent,(void*)MemoItemErase);
			break;
		case FORM_SORT_BY:		/* Form 6 */
			FormSetEventHandler(FORM_SORT_BY,(void**)&FormDispatchEvent,(void*)MemoSort);
			break;
		case FORM_SELECT_CATE:	/* Form 7 */
			FormSetEventHandler(FORM_SELECT_CATE,(void**)&FormDispatchEvent,(void*)MemoSelectCate);
			break;
		case FORM_NEW_CATE:	/* Form 8 */
			FormSetEventHandler(FORM_NEW_CATE,(void**)&FormDispatchEvent,(void*)MemoNewCate);
			break;
		case FORM_ERASE_CATE:	/* Form 9 */
			FormSetEventHandler(FORM_ERASE_CATE,(void**)&FormDispatchEvent,(void*)MemoEraseCate);
			break;
		case FORM_REMOVE_CATE:	/* Form 10 */
			FormSetEventHandler(FORM_REMOVE_CATE,(void**)&FormDispatchEvent,(void*)MemoRemoveCate);
			break;
		case FORM_EXISTS_CATE:	/* Form 11 */
			FormSetEventHandler(FORM_EXISTS_CATE,(void**)&FormDispatchEvent,(void*)MemoExistsCate);
			break;
		case FORM_FULL_CATE:	/* Form 12 */
			FormSetEventHandler(FORM_FULL_CATE,(void**)&FormDispatchEvent,(void*)MemoFullCate);
			break;
		case FORM_EDIT_CATE:	/* Form 13 */
			FormSetEventHandler(FORM_EDIT_CATE,(void**)&FormDispatchEvent,(void*)MemoEditCate);
			break;
		case FORM_SYSTEM_LOW_MEM:/* Form 14 */
			FormSetEventHandler(FORM_SYSTEM_LOW_MEM,(void**)&FormDispatchEvent,(void*)MemoSysLowMem);
			break;
		}
		FormSetActiveForm(form_id);
		return TRUE;
	}
	return FALSE;
}

/********************************************************
* Function:	EventLoop
* Purpose: 	This function is a loop to get events from event
manager and then passes the event to different
event handler
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EventLoop(void)
{
	EvtType event;
	do
	{
		EvtGetEvent (&event);
		if (!SystemHandleEvent(&event))
			if (!MenuHandleEvent(&event))
				if (!ApplicationHandleEvent(&event))
					FormDispatchEvent(&event);
	}
#ifdef PC_SIM
	while (event.eventType != EVT_APP_STOP && m_bIsExit == FALSE);
#else
	while (event.eventType != EVT_APP_STOP);
#endif
}

/********************************************************
* Function:	main
* Purpose: 	main procedure of the application
* Scope:		Application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
__main(WORD cmd, void *cmd_ptr)
{
	
	MemoAppLaunch(cmd, (void*)cmd_ptr);
}
