/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   app.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#include "stdafx.h"
#include "datatype.h"
#include "App.h"
#include "sysetup.h"

AppID           app_id;
//#define         DEBUG

//-------------------- Global Variable ---------------------------
PasswordSettings    password_settings;
BYTE                retry_times = 0;

/********************************************************
* Function:	PasswordInput
* Purpose: 	This function is called to handle the application
handle of FORM_PASSWORD_INPUT
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PasswordInput(EvtType *Event)
{
	ObjectID	tempID;
    OwnerInfo   owner_info;
    BYTE        *text;
    USHORT      count = 0;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_HINT || Event->para1 == SLETTER_HINT)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_PASSWORD_HINT;
                Event->evtPBP       = NULL;
            }
        }       
    }                    
	
	
	
	switch(Event->eventType)
	{	
	case EVT_INLAY_SELECT:
		if (!PasswordChecking())
		{
			if (retry_times == 5)
			{
				retry_times = 0;
				//FormDrawForm(FORM_PASSWORD_BACKGROUND);
				FormInitAllFormObjects(FORM_PASSWORD_INVALID);
				PasswordInvalidSetScreen();
				FormPopupForm(FORM_PASSWORD_INVALID);
			}
			else
			{
				if (retry_times == 1)
					PasswordInputSetScreen();
				FormSetFormActiveObject(FORM_PASSWORD_INPUT, TEXTBOX_PASSWORD_INPUT);
				TextboxSetText(TEXTBOX_PASSWORD_INPUT, (BYTE*)(""));
				TextboxSetInsertPointPositionByCharPos(TEXTBOX_PASSWORD_INPUT, 0);
				TextboxSetInsertPointOn(TEXTBOX_PASSWORD_INPUT);
				//FormDrawForm(FORM_PASSWORD_BACKGROUND);
				PasswordEraseBackground();
				FormDrawForm(FORM_PASSWORD_INPUT);
				if (KeyboardCheckKeyboardStatus())
				{
					KeyboardSaveBehindBits();
					KeyboardDrawKeyboard();
				}
			}
		}
		else    EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
		return TRUE;
	case EVT_CONTROL_SELECT:
		FormInitAllFormObjects(FORM_PASSWORD_HINT);
		FieldSetText(FIELD_PASSWORD_HINT, password_settings.hints);
		PasswordFieldSetScrollbar();
		FormPopupForm(FORM_PASSWORD_HINT);
		return TRUE;
	case EVT_KEY:
		if (Event->eventID == SOFT_KEY)
		{
			FormGetActiveObject(FORM_PASSWORD_INPUT,&tempID);
			if (tempID == TEXTBOX_PASSWORD_INPUT) 
			{
				if ((BYTE)(Event->para1) == 13)
				{
					if (!PasswordChecking())
					{
						if (retry_times == 5)
						{
							retry_times = 0;
							//FormDrawForm(FORM_PASSWORD_BACKGROUND);
							FormInitAllFormObjects(FORM_PASSWORD_INVALID);
							PasswordInvalidSetScreen();
							FormPopupForm(FORM_PASSWORD_INVALID);
						}
						else
						{
							if (retry_times == 1)
								PasswordInputSetScreen();
							FormSetFormActiveObject(FORM_PASSWORD_INPUT, TEXTBOX_PASSWORD_INPUT);
							TextboxSetText(TEXTBOX_PASSWORD_INPUT, (BYTE*)(""));
							TextboxSetInsertPointPositionByCharPos(TEXTBOX_PASSWORD_INPUT, 0);
							TextboxSetInsertPointOn(TEXTBOX_PASSWORD_INPUT);
							//KeyboardSetKeyboardStatus(FALSE);
							//FormDrawForm(FORM_PASSWORD_BACKGROUND);
							PasswordEraseBackground();
							FormDrawForm(FORM_PASSWORD_INPUT);
							if (KeyboardCheckKeyboardStatus())
							{
								KeyboardSaveBehindBits();
								KeyboardDrawKeyboard();
							}
						}
					}
					else
					{
						EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
						//                            EvtAppendEvt(EVT_APP_LAUNCH, 1, 0, 0, NULL);
					}
				}
				else TextboxAddKeyInChar(TEXTBOX_PASSWORD_INPUT, (BYTE)(Event->para1));
				return TRUE;
			}
		}
		break;
	case EVT_FORM_OPEN:          
		PasswordEraseBackground();
		SySetupGetOwnerInfo(&owner_info);
		text = (BYTE*)qmalloc((strlen(owner_info.first_name) + strlen(owner_info.last_name) + 10) * sizeof(BYTE));
		count += sprintf((char*)text, "%s", (char*)owner_info.first_name);
		count += sprintf((char*)text + count, "%s", (char*)(" "));
		count += sprintf((char*)text + count, "%s", (char*)owner_info.last_name);
		StringSetText(STRING_PASSWORD_BELONGS_0, text);
		qfree(text);
		StringSetText(STRING_PASSWORD_BELONGS_1, owner_info.company_name);
		StringSetText(STRING_PASSWORD_BELONGS_2, owner_info.contact_tel);
		
		TextboxSetInsertPointOn(TEXTBOX_PASSWORD_INPUT);
		TextboxSetInsertPointPositionByCharPos(TEXTBOX_PASSWORD_INPUT, 0);
		FormDrawForm(FORM_PASSWORD_INPUT);
		return TRUE;
	default:
		break;
	}
	return FALSE;
}

/********************************************************
* Function:	PasswordInvalid
* Purpose: 	This function is called to handle the application
handle of FORM_PASSWORD_INVALID
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PasswordInvalid(EvtType *Event)
{
    OwnerInfo   owner_info;
    BYTE        *text;
    USHORT      count = 0;
	
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_PASSWORD_INVALID_YES;
                Event->evtPBP       = NULL;
            }
			else if (Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_PASSWORD_INVALID_NO;
                Event->evtPBP       = NULL;
            }            
        }       
    }                    
	
	
	
	switch(Event->eventType)
	{	
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_PASSWORD_INVALID_NO)
		{
			retry_times = 0;
			PasswordInputSetScreen();
			//FormDrawForm(FORM_PASSWORD_BACKGROUND);
			FormPopupForm(FORM_PASSWORD_INPUT);
			return TRUE;
		}
		else if (Event->eventID == BUTTON_PASSWORD_INVALID_YES)
		{
			//FormDrawForm(FORM_PASSWORD_BACKGROUND);
			FormInitAllFormObjects(FORM_PASSWORD_ERASE_CONFIRM);
			PasswordEraseConfirmSetScreen();
			FormPopupForm(FORM_PASSWORD_ERASE_CONFIRM);
			return TRUE;
		}
		return FALSE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK)
		{
			//FormDrawForm(FORM_PASSWORD_BACKGROUND);
			FormInitAllFormObjects(FORM_PASSWORD_ERASE_CONFIRM);
			PasswordEraseConfirmSetScreen();
			FormPopupForm(FORM_PASSWORD_ERASE_CONFIRM);
			return TRUE;
		}
		else if (Event->para1 == INLAY_EXIT)
		{
			retry_times = 0;
			PasswordInputSetScreen();
			//FormDrawForm(FORM_PASSWORD_BACKGROUND);
			FormPopupForm(FORM_PASSWORD_INPUT);
			return TRUE;
		}
		return FALSE;
	case EVT_BITMAP_SELECT:
		retry_times = 0;
		PasswordInputSetScreen();
		//FormDrawForm(FORM_PASSWORD_BACKGROUND);
		FormPopupForm(FORM_PASSWORD_INPUT);
		return TRUE;
	case EVT_FORM_OPEN:
		PasswordEraseBackground();
		SySetupGetOwnerInfo(&owner_info);
		text = (BYTE*)qmalloc((strlen(owner_info.first_name) + strlen(owner_info.last_name) + 10) * sizeof(BYTE));
		count += sprintf((char*)text, "%s", (char*)owner_info.first_name);
		count += sprintf((char*)text + count, "%s", (char*)(" "));
		count += sprintf((char*)text + count, "%s", (char*)owner_info.last_name);
		StringSetText(STRING_PASSWORD_BELONGS_0, text);
		qfree(text);
		StringSetText(STRING_PASSWORD_BELONGS_1, owner_info.company_name);
		StringSetText(STRING_PASSWORD_BELONGS_2, owner_info.contact_tel);
		//            TextboxSetInsertPointOn(TEXTBOX_PASSWORD_INPUT);
		//          TextboxSetInsertPointPositionByCharPos(TEXTBOX_PASSWORD_INPUT, 0);
		FormDrawForm(FORM_PASSWORD_INVALID);
		return TRUE;
	default:
		break;
	}
	return FALSE;
}

/********************************************************
* Function:	PasswordEraseConfirm
* Purpose: 	This function is called to handle the application
handle of FORM_PASSWORD_ERASE_CONFIRM
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PasswordEraseConfirm(EvtType *Event)
{
    OwnerInfo   owner_info;
    BYTE        *text;
    USHORT      count = 0;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_PASSWORD_INVALID_YES;
                Event->evtPBP       = NULL;
            }
			else if (Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_PASSWORD_INVALID_NO;
                Event->evtPBP       = NULL;
            }            
            else if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
            {
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;
            }                
        }       
    }                    
	
	
	switch(Event->eventType)
	{	
		
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK)
		{
#ifdef PC_SIM
			AfxMessageBox("Erase All Data and restart");
			return TRUE;
#endif
#ifdef PR31700
			SysClearDBData();
			AllApplicationDatabaseInit();
			EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
#endif
		}
		else if (Event->para2 == INLAY_EXIT)
		{
			retry_times = 0;
			PasswordInputSetScreen();
			//FormDrawForm(FORM_PASSWORD_BACKGROUND);
			FormPopupForm(FORM_PASSWORD_INPUT);
			return TRUE;
		}
		return FALSE;
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_PASSWORD_INVALID_YES)
		{
#ifdef PC_SIM
			AfxMessageBox("Erase All Data and restart");
			return TRUE;
#endif
#ifdef PR31700
			SysClearDBData();
			AllApplicationDatabaseInit();
			EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
#endif
		}
		else if (Event->eventID == BUTTON_PASSWORD_INVALID_NO)
		{
			retry_times = 0;
			PasswordInputSetScreen();
			//FormDrawForm(FORM_PASSWORD_BACKGROUND);
			FormPopupForm(FORM_PASSWORD_INPUT);
			return TRUE;
		}
		return FALSE;
	case EVT_BITMAP_SELECT:
		retry_times = 0;
		PasswordInputSetScreen();
		//FormDrawForm(FORM_PASSWORD_BACKGROUND);
		FormPopupForm(FORM_PASSWORD_INPUT);
		return TRUE;
	case EVT_FORM_OPEN:
		PasswordEraseBackground();
		SySetupGetOwnerInfo(&owner_info);
		text = (BYTE*)qmalloc((strlen(owner_info.first_name) + strlen(owner_info.last_name) + 10) * sizeof(BYTE));
		count += sprintf((char*)text, "%s", (char*)owner_info.first_name);
		count += sprintf((char*)text + count, "%s", (char*)(" "));
		count += sprintf((char*)text + count, "%s", (char*)owner_info.last_name);
		StringSetText(STRING_PASSWORD_BELONGS_0, text);
		qfree(text);
		StringSetText(STRING_PASSWORD_BELONGS_1, owner_info.company_name);
		StringSetText(STRING_PASSWORD_BELONGS_2, owner_info.contact_tel);
		FormDrawForm(FORM_PASSWORD_ERASE_CONFIRM);
		return TRUE;
	default:
		break;
	}
	return FALSE;
}

/********************************************************
* Function:	PasswordHint
* Purpose: 	This function is called to handle the application
handle of FORM_PASSWORD_HINT
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PasswordHint(EvtType *Event)
{
    BYTE    *text;
	
	
	switch(Event->eventType)
	{	
	case EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{                
			if (Event->para2 == IO_UP_ARROW)
				
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_PASSWORD_HINT, SCROLLBAR_UP_ARROW);
			else if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_PASSWORD_HINT, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		return FALSE;    
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			//FormDrawForm(FORM_PASSWORD_BACKGROUND);
			FormPopupForm(FORM_PASSWORD_INPUT);
			TextboxGetTextPointer(TEXTBOX_PASSWORD_INPUT, &text);
			FormSetFormActiveObject(FORM_PASSWORD_INPUT, TEXTBOX_PASSWORD_INPUT);
			TextboxSetInsertPointOn(TEXTBOX_PASSWORD_INPUT);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_PASSWORD_INPUT, 0);
			return TRUE;
		}
		return FALSE;
	case EVT_SCROLLBAR_REPEAT:
		PasswordScrollbarSetField(Event);
		return TRUE;
	case EVT_SCROLLBAR_SELECT:
		ScrollbarDrawScrollbar(SCROLLBAR_PASSWORD_HINT);
		return TRUE;
	case EVT_FORM_OPEN:
		PasswordEraseBackground();
		FormDrawForm(FORM_PASSWORD_HINT);
		return TRUE;
	default:
		break;
	}
	return FALSE;
}
