/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   app.h
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#ifndef _APP_H_
#define _APP_H_

#include "system.h"
#include "appfunc.h"
#include "sysetup.h"
#include "passlang.h"
#include "passsize.h"

extern PasswordSettings password_settings;
extern BYTE	retry_times;

/*****************************************************************
******************** FORM PASSWORD_BACKGROUND ********************
*****************************************************************/
#define FORM_PASSWORD_BACKGROUND			0

#define STRING_PASSWORD_BELONGS_0           19
#define STRING_PASSWORD_BELONGS_1           20
#define STRING_PASSWORD_BELONGS_2           21

/*****************************************************************
******************** FORM PASSWORD_INPUT *************************
*****************************************************************/
#define FORM_PASSWORD_INPUT					1
#define BITMAP_PASSWORD_INPUT_X				2
#define STRING_PASSWORD_INPUT_0				3
#define STRING_PASSWORD_INPUT_1				4
#define BITMAP_PASSWORD_INPUT_WARN			5
#define TEXTBOX_PASSWORD_INPUT				6
#define BUTTON_PASSWORD_HINT				7

/*****************************************************************
******************** FORM PASSWORD_INVALID *************************
*****************************************************************/
#define FORM_PASSWORD_INVALID				8
#define STRING_PASSWORD_INVALID_0			9
#define STRING_PASSWORD_INVALID_1			10
#define STRING_PASSWORD_INVALID_2			11
#define BUTTON_PASSWORD_INVALID_YES			12
#define BUTTON_PASSWORD_INVALID_NO			13

/*****************************************************************
******************** FORM PASSWORD_ERASE_CONFIRM ****************
*****************************************************************/
#define FORM_PASSWORD_ERASE_CONFIRM				14
#define STRING_PASSWORD_ERASE_CONFIRM			15

/*****************************************************************
******************** FORM PASSWORD_HINT ****************
*****************************************************************/
#define FORM_PASSWORD_HINT						16
#define FIELD_PASSWORD_HINT						17
#define	SCROLLBAR_PASSWORD_HINT					18


#endif
