/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   inlay.h
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for Inlay 
Revision    :   1.1
Note        :   None
===========================================================================
*/              
                

#ifndef __INLAY_H_
#define __INLAY_H_

extern BYTE inlay_status;

#define EVT_INLAY_SELECT		120
#define EVT_INLAY_ENTER			121
#define EVT_INLAY_EXIT			122


#define INLAY_MENU				0
#define INLAY_OK				1
#define INLAY_KEYBOARD                          2
#define INLAY_EXIT				3
#define INLAY_MAIN_MENU                         4
#define INLAY_CALCULATOR                        5
#define INLAY_LEFT                              6
#define INLAY_RIGHT                             7


SHORT InlayGetClickedRegion(SHORT xcoord, SHORT ycoord);
BOOLEAN InlayHandleEvent(EvtType *Event);
BOOLEAN InlayCheckEnableStatus();
void    InlaySetEnableStatus(BOOLEAN status);
#endif
