/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   iocon.h
Author(s)   :   Garick Ngai
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for I/O control module
Revision    :   1.1
Note        :   None
===========================================================================
*/              
                
#ifndef _IOCTRL_
#define _IOCTRL_

#include "datatype.h"
#include "ioconmsg.h"
#include "QTYPE.H"
#include "print.h"
#include "uart.h"
#include "pr31700s.h"
#include "pr31700c.h"
#include "system.h"



    /* Command For Accessory */
#define MSG_IOKEY_PRESS     10000
#define MSG_IOKEY_REPEAT    10001
#define MSG_POWER_PRESS     10002
#define MSG_POWER_REPEAT    10003
#define MSG_HOTSYN_KEY_PRESS 10004

//#define TRUE                1
//#define FALSE               0

#define POWER_REPEAT_ON     1
#define POWER_REPEAT_OFF    0


    /* I/O Control */
#define KEY_8           0x00000001
#define KEY_1TO7        0x00003f80
#define DIS_N_KEY_1TO7  0xffffff80
#define POWER_PIN       0x00800000
#define IOKEY_PWRON     0x00803f80
#define DIS_KEY_8       0xfffffffe
#define DIS_KEY_1TO7    0xffffc000
#define DIS_POWER_PIN   0xff7fffff
#define POWER_REG       0x80000000
#define HOTSYNC         0x02000000


#define MFIO_IOKEY8_SEL     0x00000001
#define MFIO_IOKEY8_DIRECTN 0xfffffffe

#define MFIO_HOTSYNC_SEL     0x02000000
#define MFIO_HOTSYNC_DIRECTN 0xfdffffff


#define IO_KEY1TO7_DEBOUN   0x7f000000
#define IO_KEY1TO7_DIRECTN  0xff80ffff
#define READ_IO_KEY1TO7     0x0000007f
#define CHK_IO_KEY1TO8      0x000000ff
#define POWER_DEBOUN        0x00000008


void IOKeyCtrlInit();
void IOCtrl();
void PowerCtrl();
void PowerRepeat();
void IOKeyRepeat();
void EnPowerPinInt();
void DisPowerPinInt();
void EnPowerTimerInt();
void DisPowerTimerInt();
void EnIOKeyInt();
void DisIOKeyInt();
void EnIOKeyTimerInt();
void DisIOKeyTimerInt();
void ReadIOKeyData();
void ResetIOIntFlag();
void ResetPowerFlag();
void HotSynDebounCheck();
void HotSyncDet();
void HotSynPortMoveOut();
void DisHotSynCheck();
void CheckKey8();
void KbPowerCtrl();
void ReadKey8();
void OnPdaTxRecKey();
void KeyUp();
void KeyDown();
void KeyStop();
void PlaySoundKey();
void ReadPlaySoundKey();
#endif  /* _IOCTRL_ */


