/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   jot.h
Author(s)   :   Jiping Wang (CIC)
Company     :   Communication Intelligence Corporation
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for JOT CIC 
Revision    :   1.1
Note        :   Jot Macro Editor related functions
===========================================================================
*/              
                
#ifndef JOT_H
#define JOT_H

/* The default timeout for symbol mode: 2 seconds*/
#define JOT_SYMBOL_TIMEOUT 20

/* The default timeout for 2-stroke chars 't', 'x' etc: 0.5 seconds */
#define JOT_STROKE_TIMEOUT 5

#define JOT_READ_DB 0
#define JOT_WRITE_DB 1

#define JOT_MACRO_DB_NAME (BYTE *)"jotmacrodb"
#define JOT_MACRO_DB_VERSION 0x0100
#define JOT_MACRO_DB_INFO (BYTE *)"Developed by Jiping Wang of CIC"

#define JOT_TRAINER_DB_NAME (BYTE *)"jottrainerdb"
#define JOT_TRAINER_DB_VERSION 0x0100
#define JOT_TRAINER_DB_INFO (BYTE *)"Developed by Jiping Wang of CIC"

/* These are main API functions for Jot's systam part */
void JotInit();
BOOLEAN JotHandleEvent(EvtType *Event);
void JotUpdate();

BOOLEAN OpenJotMacroDB();
BOOLEAN CloseJotMacroDB();
BOOLEAN IsJotMacroAlreadyExist(BYTE *macroName);
BOOLEAN AddJotMacro(BYTE *macroName, BYTE *macroText);
BOOLEAN DeleteJotMacro(BYTE *macroName);
BOOLEAN ChangeJotMacro(BYTE *macroName, BYTE *macroText);
int GetJotMacroNum();
BOOLEAN GetJotMacro(int index);
int MatchJotMacro
	(
    int         num_input,      /* Number of input macro name   */
    char        *inputS,        /* Input macro string           */
    int         *num_outputP,   /* Number of output characters  */
    char        **outputP       /* Returned pointer to a string */
                                /*   for recognized output      */
	);

BOOLEAN UpdateJotTrainerDB(int read_or_write);

// Jot Macro Editor
#define NUM_MACRO_TABLE_ROW 8
#define MAX_MACRO_NAME_LEN 7
#define MAX_MACRO_TEXT_LEN 255	

#define FORM_JOT				0
#define PUSHBUTTON_MACRO_EDITOR 1
#define PUSHBUTTON_TRAINER		2
#define PUSHBUTTON_TIMEOUTS		3
#define BUTTON_JOT_MACROEDITOR_NEW 4
#define BUTTON_JOT_MACROEDITOR_EDIT 5
#define BUTTON_JOT_MACROEDITOR_DELETE 6
#define LIST_JOT_MACRO_NAME 7
#define LIST_JOT_MACRO_TEXT 8

#define FORM_JOT_NEWMACRO 9
#define STRING_JOT_MACRO_NAME 10
#define TEXTBOX_JOT_MACRO_NAME 11
#define STRING_JOT_MACRO_TEXT 12
#define FIELD_JOT_MACRO_TEXT 13
#define BUTTON_JOT_NEWMACRO_SAVE 14
#define BUTTON_JOT_NEWMACRO_DONE 15
#define FORM_WARNING	16
#define STRING_WARNING	17
#define BUTTON_WARNING_OK 18

// Jot Trainer
#define TABLE_JOT_TRAINER		19
#define CHECKBOX_K				20
#define BITMAP_K				21
#define CHECKBOX_P				22
#define BITMAP_P				23
#define CHECKBOX_Q				24
#define BITMAP_Q				25
#define CHECKBOX_T1				26
#define BITMAP_T1				27
#define CHECKBOX_T2				28
#define BITMAP_T2				29
#define CHECKBOX_J				30
#define BITMAP_J				31
#define CHECKBOX_I				32
#define BITMAP_I				33
#define CHECKBOX_DOLLAR			34
#define BITMAP_DOLLAR			35
#define REPEATBUTTON_UP			36
#define REPEATBUTTON_DOWN		37

// Timeout
#define STRING_TIMEOUT			38
#define SCROLLBAR_TIMEOUT		39
#define STRING_SHORTPAUSE		40
#define STRING_LONGPAUSE		41
#define STRING_TIME				42

#endif
