/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   penmgr.h
Author(s)   :   Andrew Hui
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for pen manager
Revision    :   1.1
Note        :   None
===========================================================================
*/              
                
#include "platform.h"
#ifdef PR31700

#ifndef  __PEN_MANAGER__
#define  __PEN_MANAGER__



#include "pr31700s.h"
#include "pr31700c.h"
#include "std.h"
#include "uart.h"
#include "dev_bety.h"

#include "dev_sib.h"   /* SibInit() only */

#include "intc.h"
#include "datatype.h"
#include "qtype.h"
#include "tmrapi.h"




#define     PEN_EVNT_Q_SIZE   50
#define     PEN_SAMPLE_PERIOD 20   /* sampling period of x,y information  */

#define     PEN_RECOGNITION     1
#define     PEN_CALIBRATION     2
#define     PEN_NORMAL          4

#define     PEN_EVENT  123
#define     PEN_UP     0
#define     PEN_DOWN   2
#define     PEN_MOVE   1

#define     PEN_FILTER_SAMPLE   3   /* buffer 3 sample before gen any event */
#define     PEN_MOVE_THRESHOLD  2

typedef struct {
                    WORD x     :14 ;
                    WORD y     :14 ;
                    WORD status: 4 ;
               } PenBufType;



extern PenBufType  PenEvntQ[PEN_EVNT_Q_SIZE];   /* X, Y, PenStatus = PEN_UP/PEN_MOVE */

extern WORD PenMgrStatus;  /* PEN_DOWN / PEN_MOVE */

extern WORD PenMgrMode;   /* PEN_RECOGNITION, PEN_CALIBRATION, PEN_NORMAL */

extern WORD pen_xy_rotate;

/* pen calibration information */

extern WORD emitpenevent;

extern WORD PenMinX;
extern WORD PenMaxX;
extern WORD PenMinY;
extern WORD PenMaxY;
extern WORD PenEvntPtr  ;
extern WORD PenFilterMask [PEN_FILTER_SAMPLE] ;   /* sum >2 = pen move */

void PenMgr(MsgType *Pmsg);
int Iabs( int a);

void PenSetCalMode(void);
void PenSetNormalMode(void);
extern WORD pu_x, pu_y;

//#define PenSetCalMode()    PenMgrMode=PEN_CALIBRATION
//#define PenSetNormalMode() PenMgrMode=PEN_NORMAL

#endif   __PEN_MANAGER__
#endif

