/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   sio.h
Author(s)   :   Garick Ngai
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   Header file for SIO
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef _SIO_
#define _SIO_

#include "datatype.h"
#include "QTYPE.H"
#include "print.h"
#include "uart.h"
#include "pr31700s.h"
#include "pr31700c.h"
#include "intc.h"



    /* Command For Accessory */
#define FIRST_DOWNLOAD      0x81
#define N_FIRST_DOWNLOAD    0x7E
#define PDA_SLEEP           0x55
#define RESET_ACC_SYS       0x33
#define RESEND_BYTE         0x01
#define RESEND_BLOCK        0x02
#define DRV_DATA_ACK_OK     0x04
#define NOT_ENOUGH_MEM      0x05
#define CHECKSUM_OK         0x18

   /*  CONTANT DEFINE */
#define SIO_BLOCK_SIZE                     33
#define FILL_PROG_BOX_TO_MESSAGE_QUEUE     32
#define SET_CLK_RATE                       0
#define SET_TXCLK_RATE                     0
#define BYTE0                              0
#define BYTE1                              8
#define BYTE2                              16
#define BYTE3                              24

    /* Data in without use */
//#define SIO_DATA_IN_NO_USE     0x00002000

    /* I/O Control */
#define SIO_PIN_SEL 		   0xF000E000
#define SIO_OUT_PIN_SET_HIGH   0xA000C000
#define SIO_OUT_PIN            0xA000E000
#define SIO_PIN_DIRECTION	   0xA000C000
#define SIO_DEVDET			   0x40000000
#define SIO_DEVDET_POWER_EN    0x80000000
//#define SIO_CAN_POWER_DOWN_PIN 0x0000E000
#define SIO_CAN_POWER_DOWN_PIN 0xF000E000
#define SIO_POWER_ON		   0x80000000
#define SIO_POWER_OFF		   0x7fffffff

#define SIO_CUT_POWER          0x80000000
#define SIO_DATA_IN_NO_USE     0x00002000
#define SIO_RDY                0x10000000

#define SIO_CS                 0x20000000

extern volatile UWORD   sio_download_driver;


void ProgTimeOut();
void AccDataTimeOut();


void SIOInit();
void SIODebounCheck();
void SioDevDet();
void DisSioDevDet();
void SioDevMoveOut();
void SwSIOInit();
void SIORdy();
void SIOTransmit(UWORD command_data);
void SIORecieve(UWORD *rx_data);  
void SIOPowerOn();
void SIOPowerOff();
void SIOOff();
void SIOOn();
void ActiveSIORdy();


void HwSioOn();
void HwSioOff();
void HwSioInit();

//void SIOMgr(MsgType msg);
//void FormDispatchEvent(EvtType *event);
//static void EventLoop(void);
void TDelay(int count);


#endif  /* _SIO_ */


