/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/****************************************************************************
 *
 * SoftModemTypes.h 
 *
 *
 * Description:
 *	This file contains some of the type declarations for SoftModem
 *
 *
 *
 *
 *
 * Copyright (c) 1993-1997 AltoCom, Inc. All rights reserved.
 * Authors: Mark Gonikberg, Haixiang Liang.
 *
 * $Revision: 1.12 $
 *
 * $Id: SoftModemTypes.h,v 1.12 1998/02/09 18:24:49 scott Exp $
 *
 * $Log: SoftModemTypes.h,v $
 * Revision 1.12  1998/02/09 18:24:49  scott
 * Defined "Private" as nothing for GreenHill (to prevent erroneous section
 * allocations for data)
 *
 * Revision 1.11  1997/08/29 21:39:24  scott
 * Added check for LONG_IS_INT define (for TI C6X support)
 *
 * Revision 1.10  1997/05/29 19:50:23  mwg
 * Added code to avoid type redefintions under SunOS.
 *
 * Revision 1.9  1997/03/19 18:35:08  mwg
 * Changed copyright notice.
 *
 * Revision 1.8  1997/02/11  00:05:53  mwg
 * Minor adjustments for Pentium optimization.
 *
 * Revision 1.7  1997/01/11  01:30:47  mwg
 * Added new macro WARN -- the same as ASSERT but without exit.
 *
 * Revision 1.6  1996/08/22  20:07:39  liang
 * When ASSERT fires, only print out information, don't exit.
 *
 * Revision 1.5  1996/05/06  06:49:10  mwg
 * Fixed linux problems.
 *
 * Revision 1.4  1996/05/02  08:40:16  mwg
 * Merged in Chromatic bug fixes.
 *
 * Revision 1.3  1996/04/01  20:59:53  mwg
 * Added macros to setup and use debug pointer.
 *
 * Revision 1.2  1996/02/27  01:50:04  mwg
 * Added ASSERT() macro.
 *
 * Revision 1.1.1.1  1996/02/14  02:35:13  mwg
 * Redesigned the project directory structure. Merged V.34 into the project.
 *
 * Revision 1.2  1995/12/03  06:59:31  mwg
 * Fixed all gcc varnings. We are now running under Linux on a PC!
 *
 *****************************************************************************/
#ifndef	SoftModemTypesh
#define	SoftModemTypesh

#ifdef LONG_SHORTS
#define	short	long
#define	ushort	unsigned long
#endif

typedef signed char			schar;
typedef unsigned char		uchar;

#if !defined _NO_TYPE_DEFS_ && !defined _SYS_TYPES_H && !defined __SYS_TYPES_H__ && !defined _SYS_BSD_TYPES_H && !defined _LINUX_TYPES_H
 typedef unsigned int		uint;
 typedef unsigned long		ulong;
#ifndef ushort
 typedef unsigned short		ushort;
#endif
#endif

#ifdef GREENHILL /* GH allocates private data to incorrect section */
#define Private
#else
#define Private             static
#endif

#define Public

#ifndef NULL
#define NULL 0
#endif
#ifndef nil
#define nil 0
#endif

#define false 0
#define true 1
typedef unsigned char Boolean;

#ifdef LONG_IS_INT
#define long int
#define ulong uint
#endif

#define POSTULATE(postulate)											\
   do																	\
	   {																\
	   typedef struct													\
		   {															\
		   char	NegativeSizeIfPostulateFalse[((int)(postulate))*2 - 1];	\
		   } PostulateCheckStruct;										\
	   }																\
   while (0)

#ifdef DEBUG
#define WARN(assertion) \
	{ if (!(assertion)) \
		{ \
		fprintf(stderr, "Assertion failed: %s\n", #assertion); \
		fprintf(stderr, "%s:%d\n", __FILE__, __LINE__); \
		} \
	}
#define ASSERT(assertion) \
	{ if (!(assertion)) \
		{ \
		fprintf(stderr, "Assertion failed: %s\n", #assertion); \
		fprintf(stderr, "%s:%d\n", __FILE__, __LINE__); \
		exit(1); \
		} \
	}
#else
#define	WARN(a)
#define	ASSERT(a)
#endif

/*
 * Debug stuff
 */
#ifdef DEBUG
#define	DECLARE_DEBUG_PTR(type)		static	type	*gv;
#define	SETUP_DEBUG_PTR()			gv = &globalVar
#else
#define	DECLARE_DEBUG_PTR(type)
#define	SETUP_DEBUG_PTR()
#endif
/*
 * Obsolete stuff
 */
#ifdef DEBUG
#define	HereIsTheGlobalVarPointerMacro		SETUP_DEBUG_PTR();
#else
#define	HereIsTheGlobalVarPointerMacro
#endif
#endif
