/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   sysetup.h
Author(s)   :   Jason Ngan
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for sysetup functions
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#ifndef _SYSETUP_H_
#define _SYSETUP_H_

#include "stdafx.h"
#include "uifunc.h"
#include "uidef.h"
#include "ui.h"
#include "sylang.h"


/******************************************************************
******************************************************************/


/******************************************************************
***************** SYSTEM SETUP FIELD ID DEFINES *******************
******************************************************************/
/* Field 0 is reserved for marking different applications in 
	System Setup */

#define		F_App				0
/*---------------------------------------------------------------*/
/*------- SYSTEM SETUP APPLICATION ID DEFINES IN FIELD 0 --------*/
#define		CLOCK				0
#define		SOUND				1
#define		PASSWORD			2
#define		COUNTRY				3
#define		OWNINFO				4
#define		MODEM				5
#define		EMAIL1				6
#define		EMAIL2				7
#define		EMAIL3				8
#define		EMAIL4				9
#define		KEY_MAPPING			10
#define		SYSINFO				11
#define		SND_EFFECT			12

//by Henry Fok
#define     ALARMGR_FONT        0x80001005

/*===============================================================*/
/*============== FIELD_CLOCK ====================================*/
/* CLOCK structure */
typedef	struct	_ClockSettings
{
	BYTE	auto_off_time;
	BYTE	home_country;
	BYTE	visit_country;
	BYTE	home_dst_active;
	BYTE	visit_dst_active;
} ClockSettings;

/* Clock Settings Defines */
/*
#define		FRANCE					0
#define		HONG_KONG				1
#define		SAN_FRANCISCO			2
*/

/*===============================================================*/
/*============== FIELD_DATE =====================================*/

/* Date Settings Defines */
#define		SYSETUP_YEAR_OFFSET		1900
#define		SYSETUP_YEAR_LEFT		0
#define		SYSETUP_YEAR_RIGHT		1

/*===============================================================*/
/*============== FIELD_SOUND ====================================*/
/* SOUND structure */
typedef	struct	_SoundSettings
{
	BYTE	vol_min;
	BYTE	vol_max;
	BYTE	vol_curr;
	BYTE	click_min;
	BYTE	click_max;
	BYTE	click_curr;
#ifdef MIC_IN_SET
// New add on 04/11/99 "Mic Settings"
	BYTE	mic_min;
	BYTE	mic_max;
	BYTE	mic_curr;
#endif
} SoundSettings;

/*===============================================================*/
/*============== FIELD_PASSWORD =================================*/
/* PASSWORD structure */
typedef	struct	_PasswordSettings
{
	BYTE	check_password;
	BYTE	password[20];
	BYTE	*hints;
} PasswordSettings;


/* Password Settings Defines */
#define		SYSETUP_PASSWORD_CHANGED				2
#define		SYSETUP_PASSWORD_NOT_CHANGED			3
#define		SYSETUP_OLD_PASSWORD_NOT_MATCH			4
#define		SYSETUP_CONFIRM_PASSWORD_NOT_MATCH		5

/*===============================================================*/
/*============== FIELD_COUNTRY ==================================*/
/* COUNTRY structure */
typedef	struct	_CountrySettings
{
	BYTE	region;
	BYTE	time_fmt;
	BYTE	date_fmt;
	BYTE	start_of_week;
	BYTE	nums;
	BYTE	units;
} CountrySettings;

/*----- Country Settings Defines -----*/
/* time format */
#define		SYSETUP_12HR_DISPLAY	0
#define		SYSETUP_24HR_DISPLAY	1

/* date format */
#define		SYSETUP_YMD				0
#define		SYSETUP_DMY				1
#define		SYSETUP_MDY				2

/* start of week */
#define		SYSETUP_SUN				0
#define		SYSETUP_MON				1
#define		SYSETUP_TUE				2
#define		SYSETUP_WED				3
#define		SYSETUP_THU				4
#define		SYSETUP_FRI				5
#define		SYSETUP_SAT				6

/* numbers */
#define		SYSETUP_NUMS_C_F		0
#define		SYSETUP_NUMS_F_C		1
#define		SYSETUP_NUMS_S_C		2
#define		SYSETUP_NUMS_S_F		3
#define		SYSETUP_NUMS_N_C		4
#define		SYSETUP_NUMS_N_F		5

/* units */
#define		SYSETUP_UNITS_IMPERIAL	0
#define		SYSETUP_UNITS_METRIC	1

/*===============================================================*/
/*============== FIELD_OWNINFO ==================================*/
/* OWNINFO structure */
typedef	struct	_OwnerInfo
{
	BYTE	*first_name;
	BYTE	*last_name;
	BYTE	*contact_tel;
	BYTE	*company_name;
} OwnerInfo;

/*===============================================================*/
/*============== FIELD_MODEM ====================================*/
/* MODEM structure */
typedef	struct	_ModemSettings
{
	BYTE	speed_type;
	BYTE	line_type;
	BYTE	speed;
	BYTE	parity;
	BYTE	data_bit;
	BYTE	stop_bit;
	BYTE	hand_flow_control;
	BYTE	data_compression;
	BYTE	*dial_out_code;
	BYTE	sync_speed;

} ModemSettings;

/*----- Modem Settings Defines -----*/
#define		SYSETUP_SLOW		0
#define		SYSETUP_NORMAL		1
#define		SYSETUP_FAST		2

#define		SYSETUP_TONE		0
#define		SYSETUP_PULSE		1

/* speed */
#define		SYSETUP_AUTO		0
#define		SYSETUP_9K			1
#define		SYSETUP_14K			2
#define		SYSETUP_28K			3

/* parity */
#define		SYSETUP_NONE		0
#define		SYSETUP_ODD			1
#define		SYSETUP_EVEN		2

/* data bit */
#define		SYSETUP_BIT8		0
#define		SYSETUP_BIT7		1

/* stop bit */
#define		SYSETUP_BIT1		0
#define		SYSETUP_BIT2		1

/* hand flow control / data compression */
#define		SYSETUP_ON			0
#define		SYSETUP_OFF			1

/* sync. speed */
#define		SYSETUP_57600BPS	0
#define		SYSETUP_38400BPS	1
#define		SYSETUP_19200BPS	2
#define		SYSETUP_9600BPS		3


/*===============================================================*/
/* Screen Calibration Defines */
#define		SYSETUP_LEFT_TOP_X				4
#define		SYSETUP_LEFT_TOP_Y				19
#define		SYSETUP_LEFT_TOP_CENTRE_X		10
#define		SYSETUP_LEFT_TOP_CENTRE_Y		25
#define		SYSETUP_RIGHT_BOTTOM_X			143
#define		SYSETUP_RIGHT_BOTTOM_Y			143
#define		SYSETUP_RIGHT_BOTTOM_CENTRE_X	149
#define		SYSETUP_RIGHT_BOTTOM_CENTRE_Y	149

/*===============================================================*/
/*============== FIELD_EMAIL ====================================*/
/* EMAIL structure */
typedef	struct	_EmailSettings
{
	BYTE	auto_ip_addr;
	BYTE	apop;
	BYTE	del_mail;
	BYTE	*isp;
	BYTE	*tel;
	//BYTE	*fax;
	BYTE	*email_addr;
	BYTE	*login_name;
	BYTE	*login_password;
	BYTE	*smtp_server;
	BYTE	*pop3_server;
	BYTE	*user_name;
	BYTE	*password;
	BYTE	*pri_dns1;
	BYTE	*pri_dns2;
	BYTE	*pri_dns3;
	BYTE	*pri_dns4;
	BYTE	*sec_dns1;
	BYTE	*sec_dns2;
	BYTE	*sec_dns3;
	BYTE	*sec_dns4;
	BYTE	*ip_addr1;
	BYTE	*ip_addr2;
	BYTE	*ip_addr3;
	BYTE	*ip_addr4;

} EmailSettings;



/*===============================================================*/
/*============== FIELD_KEY_MAPPING ==============================*/
/*----- Key mapping Settings Defines -----*/
#define		SYSETUP_APP_NONE				0
#define		SYSETUP_ANNIVERSARIES			1
#define		SYSETUP_CALCULATOR				2
#define		SYSETUP_EMAIL					3
#define		SYSETUP_EXPENSE					4
#define		SYSETUP_GLOBAL_FIND				5
#define		SYSETUP_MEMO					6
#define		SYSETUP_PHONEBOOK				7
#define		SYSETUP_TO_DO_LIST				8
#define		SYSETUP_SCHEDULER				9
#define		SYSETUP_SKETCH					10
#define		SYSETUP_SYSTEM_SETUP			11
#define		SYSETUP_PC_SYNC					12
#define		SYSETUP_VOICE_MEMO				13
#define		SYSETUP_JOT						14
/* KEY_MAPPING structure */
typedef	struct	_KeyMappingSettings
{
	BYTE	key1;
	BYTE	key2;
	BYTE	key3;
	BYTE	key4;
	BYTE	key5;
} KeyMappingSettings;


/*===============================================================*/
/*============== FIELD_SYSINFO ==================================*/
/* SYSINF structure */
typedef	struct	_SysInfoSettings
{
	BYTE	version[10];
	UWORD	sdram;
	UWORD	sys_used;
} SysInfoSettings;


/* Global Variables */
extern BYTE    GPassCheck;
extern BYTE    GAutoPwrOffTime;
extern KeyMappingSettings		GKeyMapping;


/* API functions in System Setup */
BOOLEAN SySetupAppLaunch(WORD cmd, void *cmd_ptr);
void	SySetupAppSave(void);
BOOLEAN SySetupAppRestore(void);
BOOLEAN	SySetupInitMainGlobal(BOOLEAN is_restart);
void	SySetupInitMDBGlobal(void);
BOOLEAN SySetupMainAppSave(void);

/* Date Settings Functions */
BOOLEAN	SySetupDateUpdateTable(ObjectID table_id, SHORT year, SHORT month, 
			SHORT day, SHORT start_of_week, USHORT *row_num, USHORT *col_num);
BOOLEAN	SySetupDateUpdateYearBar(ObjectID year_push_id, ObjectID year_push_bkgrd_id, SHORT shift_action);
void	SySetupGetDateSettings(ObjectID form_id, ObjectID table_id, ObjectID month_push_id, 
			USHORT year_group_id, USHORT month_group_id, USHORT row_num, USHORT col_num,
			SHORT *year, SHORT *month, SHORT *day);
void	SySetupRestoreDateSettings(ObjectID form_id, ObjectID table_id, ObjectID year_push_id, 
			ObjectID month_push_id, USHORT *row_num, USHORT *col_num);


BOOLEAN SySetupCheckPassword(BYTE *input_password);
BOOLEAN	SySetupDatabaseInit(void);
BOOLEAN	SySetupGetClockSettings(ClockSettings *clock);
BOOLEAN SySetupGetCountrySettings(CountrySettings *country);
BOOLEAN SySetupGetEmailSettings(EmailSettings *email, UWORD isp);
BOOLEAN SySetupGetKeyMappingSettings(KeyMappingSettings *key_mapping);
BOOLEAN SySetupGetModemSettings(ModemSettings *modem);
BOOLEAN SySetupGetSyncSpeedSettings(WORD *sync_speed);
BOOLEAN SySetupGetOwnerInfo(OwnerInfo *ownerinfo);
BOOLEAN SySetupGetPasswordSettings(PasswordSettings *password);
BOOLEAN SySetupGetSoundSettings(SoundSettings *sound);
void 	SySetupGetCalPenMode(BYTE *cal_pen_status);
void	SySetupGetSystemInfo(USHORT *free_mem);
BOOLEAN SySetupRestoreSettingsAfterSync(void);
void 	SySetupSetCheckPassword(BYTE check_password);
void 	SySetupSetAutoOffTime(BYTE auto_off_time);
void 	SySetupSetKeyMapping(KeyMappingSettings key_mapping);
void 	SySetupSetCalPenMode(BYTE cal_pen_status);
BOOLEAN	SySetupSetVolSettings(USHORT min_value, USHORT max_value, USHORT new_value);
BOOLEAN	SySetupScrollbarSetVolSettings(USHORT min_value, USHORT max_value, USHORT new_value);
BOOLEAN	SySetupScrollbarSetClickSoundSettings(USHORT min_value, USHORT max_value, USHORT new_value);
BOOLEAN SySetupPlaySoundEffect(USHORT snd_eff_num);

void	EventLoop();



#endif
