/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   tmrapi.h
Author(s)   :   Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for Timer manager
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef _TMRAPI_
#define _TMRAPI_

#include "msg.h"

typedef struct
{
	UWORD h;
	UWORD l;
} LLONG;

typedef struct
{
	SHORT msec;
	SHORT sec;
	SHORT min;
	SHORT hour;
	SHORT mday;
	SHORT mon;
	SHORT year;
	SHORT wday;
	SHORT yday;
} RTM;

typedef struct
{
	UWORD label;
        UWORD period;
        UWORD offset;
        BOOLEAN msg;
        void (*fptr)();
} TMR_TABLE;

#define RTC_EVENT		10
#define RTC_ROLLOVER	1
#define RTC_GETTIME		2

#define ALARM_EVENT		11
#define ALARM_HIT		1
#define TMR_MAX_ENTRY 	10

#ifdef PR31700
#define SET_PERVAL(a)	(CPU->REG_PERIODIC_TIMER = PERVAL(a))
#define ENA_PERTIMER    (CPU->REG_TIMER_CTRL |= ENPERTIMER)
#define DIS_PERTIMER    (CPU->REG_TIMER_CTRL &= ~ENPERTIMER)
#endif

UWORD Hcf(UWORD n1, UWORD n2);
UWORD Lcm(UWORD n1, UWORD n2);
LLONG WordBreak(UWORD n1);
LLONG LLAdd(LLONG n1, LLONG n2);
LLONG LLMin(LLONG n1, LLONG n2);
LLONG LLMul1(UWORD n1, UWORD n2);
LLONG LLMul2(LLONG n1, LLONG n2);
LLONG LLDiv(LLONG n1, UWORD n2, UWORD *n3_r);

void RtcToTime(LLONG cnt, RTM *time);
LLONG TimeToRtc(RTM time);
void TmrInit();
UWORD LcmCnt();
void TmrISR();
UWORD TmrIntEnable(UWORD period, void *fptr);
UWORD TmrIntEnableInt(UWORD period, void *fptr);
UWORD TmrIntEnableIntPen(UWORD period, void *fptr);
void TmrIntDisable(UWORD label);
void TmrIntDisableInt(UWORD label);
void TmrIntDisableAll();
void TmrWaitTime(UWORD interval);

void RtcISR();
void RtcDecode(MsgType *msg);
void RtcGetTimeEvt();
void RtcClr();
void RtcGetTime(RTM *time);
void RtcSetTime(RTM *time);
void RtcRollOver();
LLONG RtcDiffTime(RTM *time_1, RTM *time_2);
BOOLEAN RtcCompareTime(RTM *time_1, RTM *time_2);

SHORT RtcGetDaysInMonth(SHORT year, SHORT mon);
BOOLEAN RtcCheckYMDValid(SHORT year, SHORT mon, SHORT mday);
void RtcYMDToWday1(SHORT year, SHORT mon, SHORT mday, SHORT *wday, SHORT *nth_week);
BOOLEAN RtcWday1ToYMD(SHORT year, SHORT mon, SHORT wday, SHORT nth_week, SHORT *mday);
void RtcYMDToWday2(SHORT year, SHORT mon, SHORT mday, SHORT *wday, SHORT *nth_wday);
BOOLEAN RtcWday2ToYMD(SHORT year, SHORT mon, SHORT wday, SHORT nth_wday, SHORT *mday);
void RtcYMDToWday3(SHORT year, SHORT mon, SHORT mday, SHORT *wday, SHORT *nth_wday);
void RtcWday3ToYMD(SHORT year, SHORT nth_wday, SHORT wday, SHORT *mon, SHORT *mday);
void RtcYMDToWday4(SHORT year, SHORT mon, SHORT mday, SHORT *wday, SHORT *nth_week);
BOOLEAN RtcWday4ToYMD(SHORT year, SHORT nth_week, SHORT wday, SHORT *mon, SHORT *mday);
BOOLEAN RtcWday5ToYMD(SHORT year, SHORT nth_week, SHORT wday, SHORT *mon, SHORT *mday);
void RtcDaysShift(SHORT *year, SHORT *mon, SHORT *mday, SHORT day);

void AlmISR();
void AlmDecode(MsgType *msg);
void AlmSetStatus(BOOLEAN status);
void AlmGetTime(RTM *time);
void AlmSetTime(RTM *time);
SHORT RtcFormatDate(RTM *in_date, BYTE *date_pref, BYTE *out_buf);
UWORD TmrQuantizePeriod(UWORD period);
void TmrComputeTimeBase();
void ClearAppTmr();
#endif	/* _TMRAPI_ */
