/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   passin.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#include "stdafx.h"
#include "app.h"

//#define DEBUG

/********************************************************
* Function:	PasswordInputSetScreen
* Purpose: 	This function is called to setup the screen 
of FORM_PASSWORD_INPUT
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
void PasswordInputSetScreen()
{
	Textbox			*textbox_ptr;
	Control			*control_ptr;
	String			*string_ptr;
	Bitmap			*bitmap_ptr;
	Form			*form_ptr;
	BYTE			object_type;
	
	// FORM
	FormGetObjectPointer(FORM_PASSWORD_INPUT, &object_type, (void**)&form_ptr);
	if (retry_times == 0)
	{
		form_ptr->bounds.ycoord = PASS_YCOORD6;
		form_ptr->bounds.height = PASS_HEIGHT6;
	}
	else
	{
		form_ptr->bounds.ycoord = PASS_YCOORD7;
		form_ptr->bounds.height = PASS_HEIGHT7;
	}
	
	// STRING 0
	FormGetObjectPointer(STRING_PASSWORD_INPUT_0, &object_type, (void**)&string_ptr);
	if (retry_times == 0)
	{
		string_ptr->bounds.xcoord = PASS_XCOORD1;
		string_ptr->bounds.ycoord = PASS_YCOORD1;
        string_ptr->bounds.width = PASS_WIDTH1;
		string_ptr->bounds.height = PASS_HEIGHT1;
		StringSetText(STRING_PASSWORD_INPUT_0, PASSSTR1);
		string_ptr->text_alignment = CENTRE_ALIGN;
	}
	else
	{
		string_ptr->bounds.xcoord = PASS_XCOORD2;
		string_ptr->bounds.ycoord = PASS_YCOORD2;
		string_ptr->bounds.width = PASS_WIDTH2;
		string_ptr->bounds.height = PASS_HEIGHT2;
        StringSetText(STRING_PASSWORD_INPUT_0, PASSSTR2);
		string_ptr->text_alignment = LEFT_ALIGN;
	}
	
	// STRING 1
	FormGetObjectPointer(STRING_PASSWORD_INPUT_1, &object_type, (void**)&string_ptr);
	if (retry_times == 0)
	{	
		string_ptr->string_attr.string_visible = FALSE;
		string_ptr->text_alignment = LEFT_ALIGN;
	}
	else
	{
		string_ptr->string_attr.string_visible = TRUE;
		string_ptr->bounds.xcoord = PASS_XCOORD3;
        string_ptr->bounds.ycoord = PASS_YCOORD3;
		string_ptr->bounds.width = PASS_WIDTH3;
		string_ptr->bounds.height = PASS_HEIGHT3;
		StringSetText(STRING_PASSWORD_INPUT_1, PASSSTR3);
		string_ptr->text_alignment = LEFT_ALIGN;
	}
	
	// BITMAP
	FormGetObjectPointer(BITMAP_PASSWORD_INPUT_WARN, &object_type, (void**)&bitmap_ptr);
	bitmap_ptr->bounds.ycoord = PASS_YCOORD8;
	if (retry_times == 0)
		bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
	else
		bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
	
	// TEXTBOX
	FormGetObjectPointer(TEXTBOX_PASSWORD_INPUT, &object_type, (void**)&textbox_ptr);
	TextboxSetText(TEXTBOX_PASSWORD_INPUT, (BYTE*)(""));
	textbox_ptr->textbox_insert_pt_char_pos = 0;
	textbox_ptr->textbox_attr.textbox_insert_pt_visible = TRUE;
	FormSetFormActiveObject(FORM_PASSWORD_INPUT, TEXTBOX_PASSWORD_INPUT);
	if (retry_times == 0)
	{
		textbox_ptr->bounds.xcoord = PASS_XCOORD4;
		textbox_ptr->bounds.ycoord = PASS_YCOORD4;
	}
	else
	{
		textbox_ptr->bounds.xcoord = PASS_XCOORD5;
		textbox_ptr->bounds.ycoord = PASS_YCOORD5;
	}
	
	// BUTTON
	FormGetObjectPointer(BUTTON_PASSWORD_HINT, &object_type, (void**)&control_ptr);
	if (retry_times == 0)
        control_ptr->bounds.ycoord = PASS_YCOORD19;
	else
		control_ptr->bounds.ycoord = PASS_YCOORD20;
}	

/********************************************************
* Function:	PasswordScrollbarSetField
* Purpose: 	This function is called to set the field while the 
scrollbar is moved
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
void PasswordScrollbarSetField(EvtType *Event)
{
    WORD        max,min,value,pagesize;
    WORD        scroll_total_lines;
    BYTE        object_type;
    Scrollbar   *scroll_ptr;
    Field       *field_ptr;
	
	if (Event->para1 == Event->para2) return;
	
	ScrollbarGetScrollbar(SCROLLBAR_PASSWORD_HINT, &value, &max, &min, &pagesize, &scroll_total_lines);
	ScrollbarSetScrollbar(SCROLLBAR_PASSWORD_HINT, Event->para2, max, min, pagesize, scroll_total_lines);
	FieldSetTopLineNum(FIELD_PASSWORD_HINT, Event->para2);
	
	FieldDrawField(FIELD_PASSWORD_HINT);
	ScrollbarDrawScrollbar(SCROLLBAR_PASSWORD_HINT);		
}

/********************************************************
* Function:	PasswordFieldSetScrollbar
* Purpose: 	This function is called to set the scrollbar
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
void PasswordFieldSetScrollbar()
{
	Scrollbar	*scroll_ptr;
	Field		*field_ptr;
	BYTE		object_type;
	
	
	FormGetObjectPointer(SCROLLBAR_PASSWORD_HINT, &object_type, (void**)&scroll_ptr);
	FormGetObjectPointer(FIELD_PASSWORD_HINT, &object_type, (void**)&field_ptr);
	
#ifdef DEBUG
    printf("\n total_num_lines = %ld", field_ptr->field_total_num_lines);
#endif
	
    if (field_ptr->field_total_num_lines <= 14)
	{
#ifdef DEUBG
        printf("\n A");
#endif
		scroll_ptr->scrollbar_attr.scrollbar_visible = FALSE;		
		return;
	}
	else
	{
#ifdef DEBUG
        printf("\n B");
#endif
		scroll_ptr->scrollbar_attr.scrollbar_visible = TRUE;
        ScrollbarSetScrollbar(SCROLLBAR_PASSWORD_HINT, 0, (WORD)(field_ptr->field_total_num_lines - 14), 0, 14, field_ptr->field_total_num_lines);
        ScrollbarSetScrollbarDrawPagesize(SCROLLBAR_PASSWORD_HINT, 14);
	}
}

/********************************************************
* Function:	PasswordChecking
* Purpose: 	This function is called to compare the 
password with the key-in chars
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if match
FALSE if not match
* Comment: 	None
*********************************************************/
BOOLEAN PasswordChecking()
{
	BYTE	*password;
	
	TextboxGetTextPointer(TEXTBOX_PASSWORD_INPUT, &password);
	if (strcmp((char*)password, (char*)(password_settings.password)) != 0)
	{
		retry_times ++;
#ifdef DEBUG
        printf("\n Password checking for %s = FALSE", password);
        printf("\n Real Password is %s", password_settings.password);
#endif
        return FALSE;
	}
    else
    {
#ifdef DEBUG
        printf("\n Password checking for %s = TRUE", password);
        printf("\n Real Password is %s", password_settings.password);
#endif
        return TRUE;
    }
}

/********************************************************
* Function:	PasswordInvalidSetScreen
* Purpose: 	This fucntion is called to setup the screen 
of FORM_PASSWORD_INVALID
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
void PasswordInvalidSetScreen()
{
	Control			*control_ptr;
	String			*string_ptr;
	BYTE			object_type;
	
	
	// STRING 0
	FormGetObjectPointer(STRING_PASSWORD_INVALID_0, &object_type, (void**)&string_ptr);
	string_ptr->bounds.ycoord = PASS_YCOORD11;
	string_ptr->string_attr.string_visible = TRUE;
	StringSetText(STRING_PASSWORD_INPUT_0, PASSSTR4);
	string_ptr->text_alignment = CENTRE_ALIGN;
	
	// STRING 1
	FormGetObjectPointer(STRING_PASSWORD_INVALID_1, &object_type, (void**)&string_ptr);
	string_ptr->bounds.ycoord = PASS_YCOORD12;
	string_ptr->string_attr.string_visible = TRUE;
	StringSetText(STRING_PASSWORD_INVALID_1, PASSSTR5);
	string_ptr->text_alignment = CENTRE_ALIGN;
	
	// STRING 2
	FormGetObjectPointer(STRING_PASSWORD_INVALID_2, &object_type, (void**)&string_ptr);
	string_ptr->bounds.ycoord = PASS_YCOORD13;
	string_ptr->string_attr.string_visible = TRUE;
	StringSetText(STRING_PASSWORD_INVALID_2, PASSSTR6);
	string_ptr->text_alignment = CENTRE_ALIGN;
	
	// BUTTON_YES
	FormGetObjectPointer(BUTTON_PASSWORD_INVALID_YES, &object_type, (void**)&control_ptr);
	control_ptr->bounds.ycoord = PASS_YCOORD14;
	
	// BUTTON_NO
	FormGetObjectPointer(BUTTON_PASSWORD_INVALID_NO, &object_type, (void**)&control_ptr);
	control_ptr->bounds.ycoord = PASS_YCOORD15;
}	

/********************************************************
* Function:	PasswordInvalidSetScreen
* Purpose: 	This fucntion is called to setup the screen 
of FORM_PASSWORD_INVALID
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
void PasswordEraseConfirmSetScreen()
{
	Control			*control_ptr;
	String			*string_ptr;
	BYTE			object_type;
	
	
	// STRING 0
	FormGetObjectPointer(STRING_PASSWORD_INVALID_0, &object_type, (void**)&string_ptr);
	string_ptr->bounds.ycoord = PASS_YCOORD16;
	string_ptr->string_attr.string_visible = TRUE;
	StringSetText(STRING_PASSWORD_INPUT_0, PASSSTR7);
	string_ptr->text_alignment = CENTRE_ALIGN;
	
	// STRING 1
	FormGetObjectPointer(STRING_PASSWORD_INVALID_1, &object_type, (void**)&string_ptr);
	string_ptr->string_attr.string_visible = FALSE;
	
	// STRING 2
	FormGetObjectPointer(STRING_PASSWORD_INVALID_2, &object_type, (void**)&string_ptr);
	string_ptr->string_attr.string_visible = FALSE;
	
	// BUTTON_YES
	FormGetObjectPointer(BUTTON_PASSWORD_INVALID_YES, &object_type, (void**)&control_ptr);
	control_ptr->bounds.ycoord = PASS_YCOORD17;
	
	// BUTTON_NO
	FormGetObjectPointer(BUTTON_PASSWORD_INVALID_NO, &object_type, (void**)&control_ptr);
	control_ptr->bounds.ycoord = PASS_YCOORD18;
}	

/********************************************************
* Function:    PasswordEraseBackground
* Purpose:     This function is called to Erase the 160 x 160 background
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
void PasswordEraseBackground()
{
    ObjectBounds    bounds;
	
    bounds.xcoord = 0;
    bounds.ycoord = 0;
    bounds.width = 160;
    bounds.height = 160;
	
    LcdEraseRegion(&bounds);
	
}
