/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   app.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#include "app.h"

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
ObjectID        pressed_object = 0;
BYTE            *current_cate = NULL;
BYTE            char_start = PBCHARA;
BYTE            *temp_cate = NULL;
ListDisplay     list_tel_list = {LIST_NAME,0,0,0,0,0};
ListDisplay     list_find = {LIST_FIND_RESULT_NAME,0,0,0,0,0};
AppStatus       app_status = {TEL_LIST,FALSE,FALSE,0,FALSE};
BYTE            **field_buffers;
BYTE            *save_cate = NULL;
BYTE            save_first_letter = PBCHARA;
Scroll          virtual_scrollbar;
BYTE            table_font_size = SMALL_FONT, font_size = SMALL_FONT;
BYTE            edit_dirty = 0;
BYTE            find_string[120];
BOOLEAN         draw_scrollbar = TRUE;
BOOLEAN         draw_view_edit_scrollbar = TRUE;
BOOLEAN         gf_entry = FALSE;
ObjectID        gf_in_form_id;
ObjectID        low_memory_form_id;
BOOLEAN	        entry_low_memory;
BOOLEAN	        entry_old_edit;
BOOLEAN			textbox_clear = TRUE;
BOOLEAN			letter_bar = TRUE;
BOOLEAN			bln1,bln2,bln3,bln4,bln5;
BYTE			company[120];


WORD			gTopNum = 0;
WORD			gSelNum = -1;
BYTE			sort_mode = 2;
BYTE			show_mode = 0;

WORD			char_pos[9];

#ifdef DEBUG
char debug_msg[80];
#endif

void PerformListCorrection(void)
{
	if(list_tel_list.total_num_items <= list_tel_list.max_num_items_display)
	{
		gSelNum = list_tel_list.top_item_num;
		list_tel_list.top_item_num = 0;
		ListDisplayDraw(&list_tel_list);
		ListSetHighlightedItem(LIST_NAME,gSelNum);
		ListSetHighlightedItem(LIST_PHONENUM,gSelNum);
		PhonebookTelListSetScrollbar();
	}
	else if(list_tel_list.top_item_num > (list_tel_list.total_num_items-list_tel_list.max_num_items_display))
	{
		gSelNum = list_tel_list.top_item_num - (list_tel_list.total_num_items-list_tel_list.max_num_items_display);
		list_tel_list.top_item_num = (list_tel_list.total_num_items-list_tel_list.max_num_items_display);
		ListDisplayDraw(&list_tel_list);
		ListSetHighlightedItem(LIST_NAME,gSelNum);
		ListSetHighlightedItem(LIST_PHONENUM,gSelNum);
		PhonebookTelListSetScrollbar();
	}
	else
		gSelNum = 0;
	gTopNum = list_tel_list.top_item_num;
}

void UpdateInsertionPoint(void)
{
	BYTE offset,offset1,offset2;
	ObjectID formID;
	
	if(app_status.status != EDIT)
		return;
	
	FormGetActiveFormID(&formID);
	offset = (app_status.company) ?  0 : 1;
	FormSetFormActiveObject(formID, char_pos[2*offset]);
	if(char_pos[(2*offset) + 1]!=-1)
	{
		FieldSetInsertPointPositionByCharPos(char_pos[2*offset],char_pos[(2*offset) + 1]);
		
		offset1 = (app_status.home) ? char_pos[6] : char_pos[7];
		offset2 = (font_size==SMALL_FONT) ? 12 : 10;
		if(KeyboardCheckKeyboardStatus())
			offset2 -=5;
		
		if((char_pos[2*offset]>=(offset1+FIELD_ROW0))&&(char_pos[2*offset]<(offset1+offset2+FIELD_ROW0)))
			FieldSetInsertPointOn(char_pos[2*offset]);
		else
			FieldSetInsertPointOff(char_pos[2*offset]);
	}
}

void SetListDisplayItemsCount()
{
	BYTE index;
	
	index = (KeyboardCheckKeyboardStatus()) ? 4 :  10;
	if(!letter_bar)
		index +=2;
	ListSetNumItemsDisplay(LIST_NAME,index);
	ListSetNumItemsDisplay(LIST_PHONENUM,index);
}

void SaveViewEditTopRowNum()
{
	USHORT row_num;
	
	TableGetTopRowNum(TABLE_VIEW_EDIT,&row_num);
	if(app_status.home)
		char_pos[6] = row_num;
	else
		char_pos[7] = row_num;
}

void RestoreViewEditTopRowNum()
{
	BYTE index;
	
	index = (app_status.home) ? char_pos[6] : char_pos[7];
	TableSetTopRowNum(TABLE_VIEW_EDIT,index);
}

void SwitchViewViews()
{
	PhonebookFieldBuffersToField();
	PhonebookViewEditSetupScreen();
	PhonebookPrepareChangeInfo();
	RestoreViewEditTopRowNum();
	PhonebookSetViewEditTable(FORM_VIEW_EDIT, TABLE_VIEW_EDIT);
	PhonebookViewEditTableSetScrollbar(TABLE_VIEW_EDIT, SCROLLBAR_VIEW_EDIT);
	FormDrawForm(FORM_VIEW_EDIT);
}

/********************************************************
* Function:	PhonebookSetScrollbar
* Purpose: 	This function is called in order to set the 
*			values for a scrollbar		
* Scope:	application
* Input:	None
* Output:	None
* Return:	TRUE				scrollbar is erased
*			FALSE				scrollbar is drawn
* Comment: 	If a scrollbar is not required, then the scrollbar will be erased 
*			If a scrollbar is required, the scrollbar will be displayed accordingly 
*********************************************************/
BOOLEAN PhonebookSetScrollbar(ObjectID field_id, ObjectID scrollbar_id)
{
	Field		*field_ptr;
	Scrollbar	*scroll_ptr;
	BYTE		font_id;
	BYTE		object_type;
	WORD		max_num_lines,max_value, min_value, pagesize;
	
	
	FormGetObjectPointer(field_id, &object_type, (void**)&field_ptr);
	
	FieldGetFont(field_id, &font_id);
    max_num_lines = field_ptr->bounds.height/(SysGetFontHeight(font_id) + SPACE_LINE);
	
	pagesize = max_num_lines  - 1;
	min_value = 0;	
	max_value = field_ptr->field_total_num_lines - pagesize - 1;	
	
	if (field_ptr->field_total_num_lines > max_num_lines)
		ScrollbarSetScrollbarVisible(scrollbar_id, TRUE);
	else
	{
		ScrollbarSetScrollbarVisible(scrollbar_id, FALSE);
		ScrollbarEraseScrollbar(scrollbar_id);
		return FALSE;
	}
	
	FormGetObjectPointer(scrollbar_id, &object_type, (void**)&scroll_ptr);
	scroll_ptr->scrollbar_draw_pagesize = max_num_lines;
	
	if (field_ptr->field_top_line_num > (field_ptr->field_total_num_lines - max_num_lines))
		ScrollbarSetScrollbar(scrollbar_id, max_value, max_value, min_value, pagesize, field_ptr->field_total_num_lines);
	else
		ScrollbarSetScrollbar(scrollbar_id, field_ptr->field_top_line_num, max_value, min_value, pagesize, field_ptr->field_total_num_lines);
	
	ScrollbarDrawScrollbar(scrollbar_id);
	return TRUE;
}

/********************************************************
* Function:	TextboxClear
* Purpose: 	This function is called in order to clear the find
textbox
* Scope:		application
* Input:		none
* Output:		none
* Return:		void
* Comment: 	None
*********************************************************/
void TextboxClear()
{
	if(textbox_clear)
		return;
	TextboxSetInsertPointPositionByCharPos(TEXTBOX_LOOKUP,0);
	TextboxSetText(TEXTBOX_LOOKUP,"");
	TextboxDrawTextbox(TEXTBOX_LOOKUP);
	textbox_clear = TRUE;
}

/********************************************************
* Function:	ListCompareNChar
* Purpose: 	This function is called in order to compare the string bText
to the listview
* Scope:		application
* Input:		none
* Output:		none
* Return:		void
* Comment: 	None
*********************************************************/
BOOLEAN ListCompareNChar(BYTE *bText, USHORT nPos)
{
	USHORT curr_item = list_tel_list.top_item_num;
	BYTE	*item_text;
	BYTE	start_char,curr_char;
	BOOLEAN blnRetVal = TRUE;
	int i;
	
	while(1)
	{
		//start at current item and check against first char
		if(ListDisplayGetText(&list_tel_list, curr_item, &item_text)==FALSE)
			return FALSE;
		start_char = chartoupper(item_text[0]);
		if(start_char!=char_start)
		{
			qfree(item_text);
			return FALSE;
		}
		//now compare remaining chars
		start_char = chartoupper(bText[nPos]);
		curr_char = chartoupper(item_text[nPos]);
		if(curr_char==start_char)
		{
			for(i=1;i<nPos;i++)
				blnRetVal &= (chartoupper(bText[i])==chartoupper(item_text[i]));
			if(blnRetVal)
				list_tel_list.top_item_num =  curr_item;
			qfree(item_text);
			return blnRetVal;
		}
		curr_item++;
	}
}

/********************************************************
* Function:	SetScreenLayout
* Purpose: 	This function is called in order to adjust screen 
position of UI objects for keyboard
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void SetScreenLayout()
{
	void     *addr;
    BYTE        object_type;
    USHORT      item_num;
	ObjectBounds ob;
	BYTE	offset;
	
	offset = (KeyboardCheckKeyboardStatus()) ? -60 : 60;
	TextboxGetTextboxBounds(TEXTBOX_LOOKUP,&ob);
	if(((ob.ycoord == 85) && (offset == -60))||((ob.ycoord == 145) && (offset == 60)))
		return;
	
	FormGetObjectPointer(TEXTBOX_LOOKUP,&object_type,&addr);
	for(item_num=2;item_num<11;item_num++)
	{
		FormGetObjectBounds(item_num,&ob);
		ob.ycoord += offset;
		FormSetObjectBounds(item_num,ob);
	}
	FormGetObjectBounds(BUTTON_NEW_RECORD,&ob);
	ob.ycoord += offset;
	FormSetObjectBounds(BUTTON_NEW_RECORD,ob);
	FormGetObjectBounds(STRING_LOOKUP,&ob);
	ob.ycoord += offset;
	FormSetObjectBounds(STRING_LOOKUP,ob);
	TextboxGetTextboxBounds(TEXTBOX_LOOKUP,&ob);
	ob.ycoord += offset;
	((Textbox*)addr)->textbox_insert_pt_y += 60;	
	TextboxSetBounds(TEXTBOX_LOOKUP,ob);
	FormGetObjectBounds(LIST_NAME,&ob);
	ob.height += offset;
	FormSetObjectBounds(LIST_NAME,ob);
	FormGetObjectBounds(LIST_PHONENUM,&ob);
	ob.height += offset;
	FormSetObjectBounds(LIST_PHONENUM,ob);
	FormGetObjectBounds(SCROLLBAR_TEL_LIST,&ob);
	ob.height += offset;
	FormSetObjectBounds(SCROLLBAR_TEL_LIST,ob);
	ListSetNumItemsDisplay(LIST_NAME,10);
	ListSetNumItemsDisplay(LIST_PHONENUM,10);
	list_tel_list.max_num_items_display = 10;
	FormGetObjectBounds(BITMAP_PAGE_UP,&ob);
	ob.ycoord += offset;
	FormSetObjectBounds(BITMAP_PAGE_UP,ob);
	FormGetObjectBounds(BITMAP_PAGE_DN,&ob);
	ob.ycoord += offset;
	FormSetObjectBounds(BITMAP_PAGE_DN,ob);
	FormGetObjectBounds(BUTTON_LETTER_BAR,&ob);
	ob.ycoord += offset;
	FormSetObjectBounds(BUTTON_LETTER_BAR,ob);
    FormGetObjectPointer(PUSHBUTTON_LF, &object_type, &addr);
	((Control*)addr)->bounds.ycoord += offset;
	((ControlTemplateCheckBox*)((Control*)addr)->control_template)->checkbox_bitmap1.ycoord +=offset;
	((ControlTemplateCheckBox*)((Control*)addr)->control_template)->checkbox_bitmap2.ycoord +=offset;
    FormGetObjectPointer(PUSHBUTTON_FL, &object_type, &addr);
	((Control*)addr)->bounds.ycoord += offset;
	((ControlTemplateCheckBox*)((Control*)addr)->control_template)->checkbox_bitmap1.ycoord +=offset;
	((ControlTemplateCheckBox*)((Control*)addr)->control_template)->checkbox_bitmap2.ycoord +=offset;
    FormGetObjectPointer(PUSHBUTTON_CL, &object_type, &addr);
	((Control*)addr)->bounds.ycoord += offset;
	((ControlTemplateCheckBox*)((Control*)addr)->control_template)->checkbox_bitmap1.ycoord +=offset;
	((ControlTemplateCheckBox*)((Control*)addr)->control_template)->checkbox_bitmap2.ycoord +=offset;
}

/********************************************************
* Function:	MoveControlsForLetterBar
* Purpose: 	This function is called in order to adjust screen 
position of UI objects for letterbar
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void MoveControlsForLetterBar(void)
{	//now move controls
	ObjectBounds ob;
	BYTE height;
	
	height = (letter_bar) ? 109 : 121;
	if(KeyboardCheckKeyboardStatus())
		height -= 60;
	FormGetObjectBounds(LIST_NAME,&ob);
	ob.height = height;
	FormSetObjectBounds(LIST_NAME,ob);
	FormGetObjectBounds(LIST_PHONENUM,&ob);
	ob.height = height;
	FormSetObjectBounds(LIST_PHONENUM,ob);
	FormGetObjectBounds(SCROLLBAR_TEL_LIST,&ob);
	ob.height = height;
	FormSetObjectBounds(SCROLLBAR_TEL_LIST,ob);
}

/********************************************************
* Function:	SetLetterBar
* Purpose: 	This function is called in order to adjust screen 
position of UI objects for letterbar
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void SetLetterBar(void)
{
	ObjectBounds ob;
	USHORT		i;
	Textbox     *textbox_ptr;
	
	ob.xcoord = 3;
	ob.ycoord = (KeyboardCheckKeyboardStatus()) ? 68 : 128;
	ob.height = 12;
	ob.width = 155;
	LcdEraseRegion(&ob);
	
	for(i=2;i<11;i++)
	{
		ControlGetAttributes(i,&bln1,&bln2,&bln3,&bln4,&bln5);
		ControlSetAttributes(i,bln1,bln2,bln3,bln4,letter_bar);
		if(letter_bar)
			ControlDrawControl(i);
		else
			ControlEraseControl(i);
		PhonebookStartCharSetTab(-1);
	}
	
	MoveControlsForLetterBar();	
	SetListDisplayItemsCount();
	DisplayScrollbarIfNeeded();
}

void HandleLetterBarLetter(void)
{
    SHORT		item_num;
	BOOLEAN		blnFound = FALSE;
	
	gSelNum = -1;
	gTopNum = 0;
	TextboxClear();
	if(!PhonebookSetTelListTopItemNum(char_start, 0, FALSE))
	{
		if(!PhonebookSetTelListTopItemNum(char_start + 1, 0, FALSE))
		{
			if(char_start!='Y')
			{
				if(!PhonebookSetTelListTopItemNum(char_start + 2, 0, FALSE))
					PhonebookStartCharSetTab(-1);
				else
					blnFound = TRUE;
			}
			else
				PhonebookStartCharSetTab(-1);
		}
		else
			blnFound = TRUE;
	}
	else
		blnFound = TRUE;
	
	//list correction
	if(blnFound)
	{
		PerformListCorrection();
	}
	
	ListDrawList(LIST_NAME);
	ListDrawList(LIST_PHONENUM);
}

void PhonebookSelectItem(BOOLEAN reload)
{
	USHORT item_num;
	UBYTE cate_num;
	BYTE *cate_name;
	
	FormInitAllFormObjects(FORM_VIEW_EDIT);
	PhonebookCateNameToPopupTrigger(pb_dbid);
	ControlPopupDeleteItem(POPUP_TRIGGER_CATE, 0);
	DataRecordInfo(pb_dbid, app_status.rec_id, NULL, &cate_num, NULL, NULL, NULL);
	cate_name = (BYTE*)qmalloc(30*sizeof(BYTE));
	DataCategoryName(pb_dbid, cate_num, cate_name);
	if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, cate_name, &item_num) == TRUE) 
		ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
	else
		ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
	
	if(reload)
	{
		if (temp_cate != NULL)
			qfree(temp_cate);
		temp_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
		strcpy(temp_cate, cate_name);
		qfree(cate_name);
		
		char_pos[0] = char_pos[2] = FIELD_ROW0;
		char_pos[1] = char_pos[3] = 0;
		char_pos[4] = char_pos[5] = 0;
		char_pos[6] = char_pos[7] = 0;
		char_pos[8] = 0;
		PhonebookRecordToFieldBuffers(app_status.rec_id);
		edit_dirty = 0;
		
		for(item_num=15;item_num<25;item_num++)
		{
			if(strlen(field_buffers[item_num])!=0)
				break;
		}
		if(item_num==25)
		{
			for(item_num=5;item_num<15;item_num++)
			{
				if(strlen(field_buffers[item_num])!=0)
					break;
			}
			
			if(item_num!=15)
			{
				app_status.home = FALSE;
				app_status.company = TRUE;
			}
		}
	}
	
	SetStatus(app_status.status,app_status.company,app_status.home,app_status.rec_id,FALSE);
	PhonebookFieldBuffersToField();
	if (save_cate != NULL)
		qfree(save_cate);
	save_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
	strcpy (save_cate, current_cate);
	//check for no personal data
	//if no personal data and there is company data
	//change status to company view
	KeyboardSetKeyboardInvisible();
	PhonebookSetViewEditTable(FORM_VIEW_EDIT, TABLE_VIEW_EDIT);
	PhonebookChangeFontSize(FORM_VIEW_EDIT, font_size);
	PhonebookPrepareChangeInfo();
	PhonebookViewEditTableSetScrollbar(TABLE_VIEW_EDIT, SCROLLBAR_VIEW_EDIT);
	PhonebookViewEditSetupScreen();
	
	FormPopupForm(FORM_VIEW_EDIT);
}

void PhonebookSetXBitmap(USHORT x, USHORT y)
{
	ObjectBounds ob;
	BitmapTemplate bt0,bt1;
	
	BitmapInitBitmap(BITMAP_X);
	BitmapGetBitmapBounds(BITMAP_X,&ob);
	BitmapGetBitmapTemplate(BITMAP_X,&bt0,&bt1);
	ob.xcoord = bt0.xcoord = x;
	ob.ycoord = bt0.ycoord = y;
	BitmapSetBitmapBounds(BITMAP_X,ob);
	BitmapSetBitmapTemplate(BITMAP_X,bt0,bt1);
}

void FormGotoApp(BYTE* app_name)
{
	ObjectID objid;
	
	FormGetActiveFormID(&objid);
	EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
	SysGetAppID(app_name,&objid);
	EvtAppendEvt(EVT_APP_STOP,0,0,0,NULL);
	EvtAppendEvt(EVT_APP_LAUNCH,objid,0,0,NULL);
	return;
}

/*****************************************************************
***************** Application Event Handle Function **************
*****************************************************************/
/********************************************************
* Function:	PhonebookTelList
* Purpose: 	This function is the event handler for the TEL LIST
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookTelList(EvtType* Event)
{
    USHORT      item_num;
    BYTE        *cate_name;
	BYTE		*text_buffer;
    UBYTE       cate_num;
    BYTE        object_type;
    List        *list_ptr;
    ObjectID    pushed_button;
    Scrollbar   *scroll_ptr;
	ObjectBounds	ob;
	UWORD		rec_num;
	RecordID	rec_id;
	UWORD total_num_rec;
	UWORD *cate_rec_num;
	UWORD cate_num_rec;
	
	//FormObjectSetFocus(TEXTBOX_LOOKUP);
	TextboxSetInsertPointOn(TEXTBOX_LOOKUP);	
	switch (Event->eventType)
	{
	case EVT_MENU_SELECT_ITEM:
		MenuItemSelectedAction1((USHORT)(Event->para1));
		return TRUE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			FormGotoApp(MAINMENU);
		return TRUE;        
	case EVT_LIST_SELECT:
		if (Event->para1 == -1) return TRUE;
		table_font_size = SMALL_FONT;
		TextboxClear();
		
		gTopNum = list_tel_list.top_item_num;
		gSelNum = Event->para1;
		
		ListDisplayGetRecordID(&list_tel_list, (USHORT)(Event->para1 + list_tel_list.top_item_num), &(app_status.rec_id));
		
		app_status.company = TRUE;
		app_status.home = FALSE;
		app_status.status=VIEW;
		app_status.company = FALSE;
		app_status.home = TRUE;
		PhonebookSelectItem(TRUE);
		
		ListDisplayGetText(&list_tel_list, Event->para1 + list_tel_list.top_item_num, &text_buffer);
		char_start = text_buffer[0];
		return TRUE;
	case EVT_IO_KEY_CTRL:
		TextboxClear();
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{                
			if (Event->para2 == IO_UP_ARROW)
			{
				if (FormGetObjectPointer(SCROLLBAR_TEL_LIST, &object_type, (void**)&scroll_ptr))
				{
					if (scroll_ptr->scrollbar_attr.scrollbar_visible && list_tel_list.total_num_items == 1)
						EvtAppendEvt(EVT_SCROLLBAR_REPEAT, SCROLLBAR_TEL_LIST, 0, 0, (void*)scroll_ptr);
					else
						ScrollbarHardButtonSetScrollbar(SCROLLBAR_TEL_LIST, SCROLLBAR_UP_ARROW);
				}
			}
			else if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_TEL_LIST, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		return FALSE;
	case EVT_SCROLLBAR_REPEAT:
		PhonebookScrollbarSetTelList(Event);
		gTopNum = list_tel_list.top_item_num;
		gSelNum = -1;
		return TRUE;
	case EVT_SCROLLBAR_SELECT:            
		TextboxClear();
		ScrollbarDrawScrollbar(SCROLLBAR_TEL_LIST);
		gTopNum = list_tel_list.top_item_num;
		gSelNum = -1;
		return TRUE;
	case EVT_CONTROL_POPUP_SELECT:
		TextboxClear();
		gTopNum = 0;
		gSelNum = -1;
		if (PhonebookPopupCateActions((SHORT)(Event->para1)) == TRUE) 
			return TRUE;
		break;
	case EVT_CONTROL_SELECT:
		TextboxClear();
		switch (Event->eventID)
		{	
		case BUTTON_NEW_RECORD:				
			if (MemoryLow || (entry_low_memory && entry_old_edit))
			{
				low_memory_form_id = FORM_TEL_LIST;
				FormPopupForm(FORM_PB_LOW_MEMORY);	
				return TRUE;
			}											
			else if (gf_entry && entry_old_edit)
			{
				gf_in_form_id = FORM_TEL_LIST;
				FormPopupForm(FORM_PB_DISCARD_CHANGES);	
				return TRUE;
			}											    
			
			table_font_size = SMALL_FONT;
			PhonebookInitFieldBuffers();
			SetStatus(EDIT, FALSE, TRUE, 0,TRUE);
			FormInitAllFormObjects(FORM_VIEW_EDIT);
			
			if(KeyboardCheckKeyboardStatus())
			{
				KeyboardSetKeyboardStatus(FALSE);
				SetScreenLayout();
			}
			
			PhonebookCateNameToPopupTrigger(pb_dbid);
			ControlPopupDeleteItem(POPUP_TRIGGER_CATE,0);
			
			if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate, &item_num) == TRUE) 
				ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
			else
				ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
			
			PhonebookChangeFontSize(FORM_VIEW_EDIT, font_size);
			PhonebookViewEditSetupScreen();
			if (save_cate != NULL)
				qfree(save_cate);
			save_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
			strcpy (save_cate, PBALL);
			if (temp_cate != NULL)
				qfree(temp_cate);
			temp_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
			if((strlen(current_cate)==0)||(strcmp(current_cate,PBALL)==0))
				strcpy(temp_cate,PBUNFILED);
			else
				strcpy (temp_cate, current_cate);
			char_pos[0] = char_pos[2] = FIELD_ROW0;
			char_pos[1] = char_pos[3] = 0;
			char_pos[4] = char_pos[5] = 0;
			char_pos[6] = char_pos[7] = 0;
			char_pos[8] = 0;
			FormPopupForm(FORM_VIEW_EDIT);
			return TRUE;
		case BUTTON_TEL_LIST_ZOOMIN:
			PhonebookChangeListFont();
			return TRUE;
		case PUSHBUTTON_ABC:
			char_start = PBCHARA;
			HandleLetterBarLetter();
			return TRUE;
		case PUSHBUTTON_DEF:
			char_start = 'D';
			HandleLetterBarLetter();
			return TRUE;
		case PUSHBUTTON_GHI:
			char_start = 'G';
			HandleLetterBarLetter();
			return TRUE;
		case PUSHBUTTON_JKL:
			char_start = 'J';
			HandleLetterBarLetter();
			return TRUE;
		case PUSHBUTTON_MNO:
			char_start = 'M';
			HandleLetterBarLetter();
			return TRUE;
		case PUSHBUTTON_PQR:
			char_start = 'P';
			HandleLetterBarLetter();
			return TRUE;
		case PUSHBUTTON_STU:
			char_start = 'S';
			HandleLetterBarLetter();
			return TRUE;
		case PUSHBUTTON_VWX:
			char_start = 'V';
			HandleLetterBarLetter();
			return TRUE;
		case PUSHBUTTON_YZ:
			char_start = 'Y';
			HandleLetterBarLetter();
			return TRUE;
		case BUTTON_LETTER_BAR:
			letter_bar = !letter_bar;
			if(!letter_bar)
			{
				if(font_size == SMALL_FONT)
				{
					if(gTopNum > (list_tel_list.total_num_items - 12))
					{
						gTopNum = (gTopNum > 2) ? gTopNum - 2 : 0;
						list_tel_list.top_item_num = gTopNum;
					}
				}
				else
				{
					if(gTopNum > (list_tel_list.total_num_items - 10))
					{
						gTopNum = (gTopNum > 1) ? gTopNum - 1 : 0;
						list_tel_list.top_item_num = gTopNum;
					}
				}
			}
			SetLetterBar();
			ListDisplayDraw(&list_tel_list);
			ListDrawList(LIST_NAME);
			ListDrawList(LIST_PHONENUM);
			break;
		case PUSHBUTTON_LF:
		case PUSHBUTTON_CL:
		case PUSHBUTTON_FL:
			if(gSelNum!=-1)
				gTopNum = gSelNum;
			//get top item
			DataNumtoRecID(pb_dbid,gTopNum,&rec_id);
			switch(Event->eventID)
			{
			case PUSHBUTTON_LF:  //last,first
				sort_mode = 2;
				break;
			case PUSHBUTTON_CL:  //company, last
				sort_mode = 29;
				break;
			case PUSHBUTTON_FL:  //first last
				sort_mode = 30;
				break;
			}
			char_start=PBCHARA;
			gSelNum = -1;
			DataCloseDB(pb_dbid);
			if(DataOpenDB(pb_dbid,SORT_TEXT_MODE | sort_mode, OPEN_RW)!= TRUE)
			{
				sort_mode = 2;
				DataOpenDB(pb_dbid,SORT_TEXT_MODE | 2, OPEN_RW);
			}
			PhonebookRecordToList(pb_dbid, current_cate, char_start, NULL);
			DataRecIDtoNum(pb_dbid,rec_id,&rec_num);
			gTopNum = rec_num;
			DataTotalRecord(pb_dbid, &total_num_rec);
			cate_rec_num = (UWORD*)qmalloc(total_num_rec*sizeof(UWORD));
			PhonebookGetRecNumWithCateNameEx(pb_dbid, current_cate, cate_rec_num, &cate_num_rec);
			//find rec_id in cate_rec_num
			for(gTopNum=0;gTopNum<cate_num_rec;gTopNum++)
			{
				if(cate_rec_num[gTopNum] == rec_id)
					break;
			}
			qfree(cate_rec_num);
			if(gTopNum==cate_num_rec)
				gTopNum = 0;
			list_tel_list.top_item_num = gTopNum;
			ListDisplayDraw(&list_tel_list);
			PhonebookTelListSetScrollbar();
			PhonebookStartCharSetTab(-1);
			ListDrawList(LIST_NAME);
			ListDrawList(LIST_PHONENUM);
			FormObjectSetFocus(TEXTBOX_LOOKUP);
			break;
			default: 
				return FALSE;
			}
			break;
		case EVT_BITMAP_SELECT:
			object_type = 0;
			switch(Event->eventID)
			{
			case BITMAP_PAGE_UP:
				if(list_tel_list.top_item_num!=0)
				{
					object_type = 1;
					if(list_tel_list.top_item_num < list_tel_list.max_num_items_display)
						list_tel_list.top_item_num = 0;
					else
						list_tel_list.top_item_num -= list_tel_list.max_num_items_display;
				}
				break;
			case BITMAP_PAGE_DN:
				if(list_tel_list.top_item_num<(list_tel_list.total_num_items-list_tel_list.max_num_items_display))
				{
					object_type = 1;
					list_tel_list.top_item_num += list_tel_list.max_num_items_display;
					if(list_tel_list.top_item_num > (list_tel_list.total_num_items-list_tel_list.max_num_items_display))
						list_tel_list.top_item_num = (list_tel_list.total_num_items-list_tel_list.max_num_items_display);
				}
				break;
			default:
				return FALSE;
			}
			if(object_type)
			{
				ListDisplayDraw(&list_tel_list);
				ListDrawList(LIST_NAME);
				ListDrawList(LIST_PHONENUM);
				PhonebookTelListSetScrollbar();
				if(ListDisplayGetText(&list_tel_list, list_tel_list.top_item_num, &cate_name)==TRUE)
					char_start = chartoupper(cate_name[0]);
				else
					char_start = -1;
				
				PhonebookStartCharSetTab(char_start);
				gTopNum = list_tel_list.top_item_num;
				gSelNum = -1;
			}
			FormObjectSetFocus(TEXTBOX_LOOKUP);
			TextboxSetInsertPointOn(TEXTBOX_LOOKUP);	
			return TRUE;
			case EVT_KEY:
				if (Event->eventID == SOFT_KEY && (Event->para2 & 0x300) == 0)
				{
					TextboxAddKeyInChar(TEXTBOX_LOOKUP, (BYTE)(Event->para1));
					textbox_clear = FALSE;
					return TRUE;
				}
				break;
			case EVT_KEYBOARD_STATUS:
				if(!KeyboardCheckKeyboardStatus())
				{
					//erase keyboard bitmap
					ob.xcoord = 0;
					ob.ycoord = 90;
					ob.width = 160;
					ob.height = 70;
					LcdEraseRegion(&ob);
					char_pos[8] = 0;
					if(font_size == SMALL_FONT)
					{
						if(!letter_bar)
						{
							if(gTopNum > (list_tel_list.total_num_items - 12))
							{
								gTopNum = (gTopNum > 6) ? gTopNum - 6 : 0;
								list_tel_list.top_item_num = gTopNum;
							}
						}
						else
						{
							if(gTopNum > (list_tel_list.total_num_items - 10))
							{
								gTopNum = (gTopNum > 6) ? gTopNum - 6 : 0;
								list_tel_list.top_item_num = gTopNum;
							}
						}
					}
					else
					{
						if(!letter_bar)
						{
							if(gTopNum > (list_tel_list.total_num_items - 10))
							{
								gTopNum = (gTopNum > 6) ? gTopNum - 6 : 0;
								list_tel_list.top_item_num = gTopNum;
							}
						}
						else
						{
							if(gTopNum > (list_tel_list.total_num_items - 9))
							{
								gTopNum = (gTopNum > 4) ? gTopNum - 4 : 0;
								list_tel_list.top_item_num = gTopNum;
							}
						}
					}
				}
				else
					char_pos[8] = 1;
				
				SetScreenLayout();
				ob.xcoord = 3;
				ob.ycoord = 19;
				ob.height = (KeyboardCheckKeyboardStatus()) ? 80 : 137;
				ob.width = 155;
				LcdEraseRegion(&ob);
				for(item_num=2;item_num<11;item_num++)
					ControlDrawControl(item_num);
				ControlDrawControl(BUTTON_NEW_RECORD);
				ControlDrawControl(BUTTON_LETTER_BAR);
				ControlDrawControl(PUSHBUTTON_LF);
				ControlDrawControl(PUSHBUTTON_FL);
				ControlDrawControl(PUSHBUTTON_CL);
				BitmapDrawBitmap(BITMAP_PAGE_UP);
				BitmapDrawBitmap(BITMAP_PAGE_DN);
				StringDrawString(STRING_LOOKUP);
				TextboxDrawTextbox(TEXTBOX_LOOKUP);
				SetListDisplayItemsCount();
				DisplayScrollbarIfNeeded();
				ListDisplayDraw(&list_tel_list);
				ListDrawList(LIST_NAME);
				ListDrawList(LIST_PHONENUM);
				break;
			case EVT_TEXTBOX_CHANGED:
				TextboxGetTextPointer(TEXTBOX_LOOKUP,&text_buffer);
				
				gTopNum = rec_num;
				gSelNum = total_num_rec;
				
				if(text_buffer)
				{
					if(strlen(text_buffer))
					{
						char_start = chartoupper(text_buffer[0]);
						if(PhonebookSetTelListTopItemNum(char_start, 0, FALSE))
						{
							if(text_buffer[1]!='\0')
							{
								if(ListCompareNChar(text_buffer,1))
								{
									if(text_buffer[2]!='\0')
									{
										if(ListCompareNChar(text_buffer,2))
										{
											if(text_buffer[3]!='\0')
											{
												if(!ListCompareNChar(text_buffer,3))
													EvtAppendEvt(EVT_KEY,SOFT_KEY,KEY_BACKSPACE,1,NULL);
											}
										}
										else
											EvtAppendEvt(EVT_KEY,SOFT_KEY,KEY_BACKSPACE,1,NULL);
									}
								}
								else
									EvtAppendEvt(EVT_KEY,SOFT_KEY,KEY_BACKSPACE,1,NULL);
							}
							
							ListDisplayDraw(&list_tel_list);
							PhonebookTelListSetScrollbar();
							ListSetHighlightedItem(LIST_NAME,0);
							ListSetHighlightedItem(LIST_PHONENUM,0);
							PhonebookStartCharSetTab(char_start);
							gTopNum = list_tel_list.top_item_num;
							gSelNum = 0;
						}
						else
							EvtAppendEvt(EVT_KEY,SOFT_KEY,KEY_BACKSPACE,1,NULL);
					}
					else
					{
						ListSetHighlightedItem(LIST_NAME,-1);
						ListSetHighlightedItem(LIST_PHONENUM,-1);
						PhonebookStartCharSetTab(-1);
						list_tel_list.top_item_num = 0;
						gTopNum = 0;
						gSelNum = -1;
					}
					
					//list correction
					if(((gTopNum != rec_num)||(gSelNum != total_num_rec))&&(gSelNum > -1))
					{
						PerformListCorrection();
					}
					
					TextboxDrawTextbox(TEXTBOX_LOOKUP);
					ListDrawList(LIST_NAME);
					ListDrawList(LIST_PHONENUM);
				}
				break;
			case EVT_FORM_OPEN:
				KeyboardSetKeyboardVisible();
				FormGetObjectPointer(LIST_NAME, &object_type, (void**)&list_ptr);
				text_buffer = (list_ptr->list_text_font == SMALL_FONT) ? PBLFONT : PBSFONT;
				MenuDeleteItem(MENU_TEL_LIST, 0);
				MenuInsertItem(MENU_TEL_LIST, 0, text_buffer);
				ControlSetLabel(BUTTON_TEL_LIST_ZOOMIN, text_buffer);
				SetStatus(TEL_LIST,FALSE,FALSE,app_status.rec_id,FALSE);
				edit_dirty = 0;
				
				SetLetterBar();
				
				list_tel_list.top_item_num = gTopNum;
				ListDisplayDraw(&list_tel_list);
				if(gSelNum==-1)
					PhonebookStartCharSetTab(-1);
				else
				{
					PhonebookStartCharSetTab(char_start);
					ListSetHighlightedItem(LIST_NAME,gSelNum);
					ListSetHighlightedItem(LIST_PHONENUM,gSelNum);			
				}
				
				DisplayScrollbarIfNeeded();
				
				switch(sort_mode)
				{
				case 2:  //last,first
					FormSetControlGroupSelection(FORM_TEL_LIST,PUSHBUTTON_LF);
					break;
				case 29:  //company, last
					FormSetControlGroupSelection(FORM_TEL_LIST,PUSHBUTTON_CL);
					break;
				case 30:  //first last
					FormSetControlGroupSelection(FORM_TEL_LIST,PUSHBUTTON_FL);
					break;
				}
				
				FormDrawForm(FORM_TEL_LIST);
				FormObjectSetFocus(TEXTBOX_LOOKUP);
				TextboxSetInsertPointOn(TEXTBOX_LOOKUP);
				if(char_pos[8])  //popup keyboard
				{
					KeyboardDrawKeyboard();
					KeyboardSetKeyboardStatus(TRUE);
					SetScreenLayout();
					ob.xcoord = 3;
					ob.ycoord = 19;
					ob.height = 80;
					ob.width = 155;
					LcdEraseRegion(&ob);
					for(item_num=2;item_num<11;item_num++)
						ControlDrawControl(item_num);
					ControlDrawControl(BUTTON_NEW_RECORD);
					ControlDrawControl(BUTTON_LETTER_BAR);
					ControlDrawControl(PUSHBUTTON_LF);
					ControlDrawControl(PUSHBUTTON_FL);
					ControlDrawControl(PUSHBUTTON_CL);
					BitmapDrawBitmap(BITMAP_PAGE_UP);
					BitmapDrawBitmap(BITMAP_PAGE_DN);
					StringDrawString(STRING_LOOKUP);
					TextboxDrawTextbox(TEXTBOX_LOOKUP);
					SetListDisplayItemsCount();
					DisplayScrollbarIfNeeded();
					ListDisplayDraw(&list_tel_list);
					ListDrawList(LIST_NAME);
					ListDrawList(LIST_PHONENUM);
				}
				return TRUE;
				default:
					return FALSE;
	}
	return FALSE;
}
/********************************************************
* Function:	PhonebookEditCate
* Purpose: 	This function is the event handler for the EDIT CATEGORIES
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookEditCate(EvtType* Event)
{
	SHORT selected_cate;
	USHORT num_items;
	BYTE *list_string;
	USHORT item_num;
    BYTE        object_type;
    List        *list_ptr;
	
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_NEW || Event->para1 == SLETTER_NEW)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_CATE_NEW;
                Event->evtPBP       = NULL;
            }
            else if (Event->para1 == LLETTER_DEL || Event->para1 == SLETTER_NEW)
            {
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_CATE_DEL;
                Event->evtPBP       = NULL;
            }            	            
            else if (Event->para1 == LLETTER_RENAME || Event->para1 == SLETTER_RENAME)
            {
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_CATE_RENAME;
                Event->evtPBP       = NULL;
            }            	                        
            else if (Event->para2 == 0x215 || Event->para2 == 0x21c)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_CATE, SCROLLBAR_UP_ARROW);            
                return TRUE;            
            }
            else if (Event->para2 == 0x216 || Event->para2 == 0x21d)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_CATE, SCROLLBAR_DOWN_ARROW);            
                return TRUE;            
            }                                
        }       
    }                    
	
	switch (Event->eventType)
	{
	case EVT_MENU_SELECT_ITEM:
		MenuItemSelectedAction1((USHORT)(Event->para1));
		return TRUE;
	case EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{
			if (Event->para2 == IO_UP_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_CATE, SCROLLBAR_UP_ARROW);
			else if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_CATE, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		return FALSE;
	case EVT_SCROLLBAR_SELECT:
		ScrollbarDrawScrollbar(SCROLLBAR_CATE);
		return TRUE;
	case EVT_SCROLLBAR_REPEAT:
		PhonebookScrollbarSetEditCate(Event);
		return TRUE;
	case EVT_INLAY_SELECT:
		//set current_cate to selected cate
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			ListGetSelectedItem(LIST_CATE,&item_num);
			if((item_num!=65535)&&(Event->para1==INLAY_OK)) //BYTE for -1
			{
				ListGetListItem(LIST_CATE, item_num, &list_string);
				if(app_status.status == EDIT)
					strcpy(current_cate,list_string);
				else
					strcpy(temp_cate,list_string);
			}
			
			ControlInitControl(POPUP_TRIGGER_CATE);
			PhonebookCateNameToPopupTrigger(pb_dbid);
			
			if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate,&item_num) == TRUE) 
			{
				ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT) item_num);
				PhonebookRecordToList(pb_dbid, current_cate, char_start,NULL);
			}
			else
			{
				ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)0);
				PhonebookRecordToList(pb_dbid, PBALL, PBCHARA,NULL);
			}		
			
			if (app_status.status == TEL_LIST)
				FormPopupForm(FORM_TEL_LIST);
			else // if (app_status.status == EDIT || app_status.status == VIEW)
			{
				if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, PBALL,&item_num) == TRUE) 
					ControlPopupDeleteItem(POPUP_TRIGGER_CATE,item_num);
				FormPopupForm(FORM_VIEW_EDIT);
			}
			return TRUE;
		}
		return FALSE;		
	case EVT_CONTROL_SELECT:
		switch (Event->eventID)
		{	
		case BUTTON_CATE_NEW:				
			if (MemoryLow || (entry_low_memory && entry_old_edit))
			{
				low_memory_form_id = FORM_EDIT_CATE;
				FormPopupForm(FORM_PB_LOW_MEMORY);	
				return TRUE;
			}											
			
			ListGetNumOfItems(LIST_CATE,&num_items);
			if (num_items == 255)
				FormPopupForm(FORM_CATE_FULL);
			else
			{				
				TextboxSetText(TEXTBOX_INPUT_CATE,(BYTE*)(""));
				TextboxSetLeftCharPos(TEXTBOX_INPUT_CATE, 0);
				TextboxSetRightCharPos(TEXTBOX_INPUT_CATE, -1);
				TextboxSetInsertPointPositionByCharPos(TEXTBOX_INPUT_CATE,0);
				FormSetFormActiveObject(FORM_INPUT_CATE,TEXTBOX_INPUT_CATE);
				pressed_object = BUTTON_CATE_NEW;
				FormPopupForm(FORM_INPUT_CATE);
			}
			break;
		case BUTTON_CATE_DEL:		
			if (MemoryLow || (entry_low_memory && entry_old_edit))
			{
				low_memory_form_id = FORM_EDIT_CATE;
				FormPopupForm(FORM_PB_LOW_MEMORY);	
				return TRUE;
			}											
			
			ListGetSelectedItem(LIST_CATE, &selected_cate);
			if (selected_cate != -1)
			{
				if (DeleteCateCheck(selected_cate) == TRUE) 
					return TRUE;
			}
			else
			{
				FormPopupForm(FORM_NO_CATE);
				return TRUE;
			}
			break;
		case BUTTON_CATE_RENAME:
			if (MemoryLow || (entry_low_memory && entry_old_edit))
			{
				low_memory_form_id = FORM_EDIT_CATE;
				FormPopupForm(FORM_PB_LOW_MEMORY);	
				return TRUE;
			}											
			
			ListGetSelectedItem(LIST_CATE, &selected_cate);
			if (selected_cate != -1)
			{
				TextboxInitTextbox(TEXTBOX_INPUT_CATE);
				ListGetListItem(LIST_CATE,(USHORT)selected_cate, &list_string);
				TextboxSetText(TEXTBOX_INPUT_CATE, list_string);
				TextboxSetInsertPointPositionByCharPos(TEXTBOX_INPUT_CATE,strlen(list_string));
				TextboxSetInsertPointOn(TEXTBOX_INPUT_CATE);
				FormSetFormActiveObject(FORM_INPUT_CATE,TEXTBOX_INPUT_CATE);
				pressed_object = BUTTON_CATE_RENAME;
				FormPopupForm(FORM_INPUT_CATE);
				return TRUE;
			}
			else
			{
				FormPopupForm(FORM_NO_CATE);
				return TRUE;
			}
			break;
		case BUTTON_CATE_ZOOMIN:
			PhonebookChangeListFont();
			break;
		default: return FALSE;
		}
		break;
        case EVT_LIST_SELECT:
            ListSetHighlightedItem(LIST_CATE, (SHORT)(Event->para1));
            ListDrawList(LIST_CATE);
            return TRUE;
		case EVT_FORM_OPEN:
			if (FormCheckObjectExists(SCROLLBAR_CATE) == FALSE)
				ScrollbarInitScrollbar(SCROLLBAR_CATE);
			PhonebookEditCateSetScrollbar();
            FormGetObjectPointer(LIST_CATE, &object_type, (void**)&list_ptr);
			list_string = (list_ptr->list_text_font == SMALL_FONT) ? PBLFONT : PBSFONT;
			list_ptr->list_max_num_items_on_display = (list_ptr->list_text_font == SMALL_FONT) ? 11 : 9;
			MenuDeleteItem(MENU_EDIT_CATE, 0);
            MenuInsertItem(MENU_EDIT_CATE, 0, list_string);
            ControlSetLabel(BUTTON_CATE_ZOOMIN, list_string);
			FormDrawForm(FORM_EDIT_CATE);
			return TRUE;
		default:
			return FALSE;
	}
	return FALSE;
}
/********************************************************
* Function:	PhonebookInputCate
* Purpose: 	This function is the event handler for the INPUT CATEGORIES
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookInputCate(EvtType *Event)
{
	ObjectID tempID;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;
            }
        }       
    }                    
	
	switch (Event->eventType)
	{
	case EVT_MENU_SELECT_ITEM:
		MenuItemSelectedAction((USHORT)(Event->para1));
		return TRUE;
	case EVT_INLAY_SELECT:
		switch (Event->para1)
		{
		case INLAY_OK:
			if (InputCatCheckCharIn() == TRUE) 
				return TRUE;
			break;
		case INLAY_EXIT:
			FormPopupForm(FORM_EDIT_CATE);
			return TRUE;
		default: return FALSE;
		}
		break;
		case EVT_KEY:
			if (Event->eventID == SOFT_KEY && (Event->para2 & 0x300) == 0)
			{
				FormGetActiveObject(FORM_INPUT_CATE,&tempID);
				if (tempID == TEXTBOX_INPUT_CATE) 
				{
					if ((BYTE)(Event->para1) == 13 && (InputCatCheckCharIn() == TRUE)) return TRUE;
					else TextboxAddKeyInChar(TEXTBOX_INPUT_CATE, (BYTE)(Event->para1));
					return TRUE;
				}
			}
			break;
		case EVT_BITMAP_SELECT:
			PhonebookEditCateSetScrollbar();
			FormPopupForm(FORM_EDIT_CATE);
			return TRUE;
		case EVT_FORM_OPEN:
			PhonebookSetXBitmap(141,34);
			FormDrawForm(FORM_INPUT_CATE);
			FormSetFormActiveObject(FORM_INPUT_CATE, TEXTBOX_INPUT_CATE);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_INPUT_CATE,0);
			TextboxSetInsertPointOn(TEXTBOX_INPUT_CATE);
			return TRUE;
		default:
			return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	PhonebookNoCate
* Purpose: 	This function is the event handler for the NO CATEGORY SELECTED
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookNoCate(EvtType* Event)
{
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;
            }
        }       
    }                    	
	
	switch (Event->eventType)
	{
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_EXIT || Event->para1 == INLAY_OK)
		{
			FormPopupForm(FORM_EDIT_CATE);
			return TRUE;
		}
		break;
	case EVT_BITMAP_SELECT:
		FormPopupForm(FORM_EDIT_CATE);
		return TRUE;
	case EVT_FORM_OPEN:
		PhonebookSetXBitmap(141,55);
		FormDrawForm(FORM_NO_CATE);
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	PhonebookNameExists
* Purpose: 	This function is the event handler for the CATEGORY ALREADY EXISTS
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookNameExists(EvtType *Event)
{
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;
            }
        }       
    }                    
	
	switch (Event->eventType)
	{
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_EXIT || Event->para1 == INLAY_OK)
		{
			TextboxSetInsertPointOn(TEXTBOX_INPUT_CATE);
			TextboxDrawTextbox(TEXTBOX_INPUT_CATE);
			FormSetFormActiveObject(FORM_INPUT_CATE,TEXTBOX_INPUT_CATE);
			FormPopupForm(FORM_EDIT_CATE);
			FormPopupForm(FORM_INPUT_CATE);
			return TRUE;
		}
		break;
	case EVT_BITMAP_SELECT:
		TextboxSetInsertPointOn(TEXTBOX_INPUT_CATE);
		TextboxDrawTextbox(TEXTBOX_INPUT_CATE);
		FormSetFormActiveObject(FORM_INPUT_CATE,TEXTBOX_INPUT_CATE);
		FormPopupForm(FORM_EDIT_CATE);
		FormPopupForm(FORM_INPUT_CATE);
		return TRUE;
	case EVT_FORM_OPEN:
		PhonebookSetXBitmap(141,50);
		FormDrawForm(FORM_CATE_NAME_EXISTS);
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	PhonebookEraseCate
* Purpose: 	This function is the event handler for the ERASE CATEGORY
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookEraseCate(EvtType *Event)
{
	SHORT selected_item;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_ERASE_CATE_YES;
                Event->evtPBP       = NULL;
            }
            else if (Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
            {
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_ERASE_CATE_NO;
                Event->evtPBP       = NULL;
            }            	            
        }       
    }                    
	
	
	switch (Event->eventType)
	{
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_ERASE_CATE_YES)
		{	
			ListGetSelectedItem(LIST_CATE,&selected_item);
			if (DeleteCate(selected_item) == TRUE)
			{
				FormPopupForm(FORM_EDIT_CATE);
				return TRUE;
			}
			else break;
		}
		else if (Event->eventID == BUTTON_ERASE_CATE_NO)
			FormPopupForm(FORM_EDIT_CATE);
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_ERASE_CATE);
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	PhonebookRemoveCate
* Purpose: 	This function is the event handler for the REMOVE CATEGORY
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookRemoveCate(EvtType *Event)
{
	SHORT selected_item;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_REMOVE_CATE_YES;
                Event->evtPBP       = NULL;
            }
            else if (Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
            {
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_REMOVE_CATE_NO;
                Event->evtPBP       = NULL;
            }            	            
        }       
    }                    
	
	
	switch (Event->eventType)
	{
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_REMOVE_CATE_YES)
		{	
			ListGetSelectedItem(LIST_CATE,&selected_item);
			if (DeleteCate(selected_item) == TRUE)
			{
				FormPopupForm(FORM_EDIT_CATE);
				return TRUE;
			}
			else break;
		}
		else if (Event->eventID == BUTTON_REMOVE_CATE_NO)
			FormPopupForm(FORM_EDIT_CATE);
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_REMOVE_CATE);
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	PhonebookCateFull
* Purpose: 	This function is the event handler for the CATEGORY FULL
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookCateFull(EvtType *Event)
{
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;
            }
        }       
    }                    
	
	
	switch (Event->eventType)
	{
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_EXIT || Event->para1 == INLAY_OK)
		{
			FormPopupForm(FORM_EDIT_CATE);
			return TRUE;
		}
		break;
	case EVT_BITMAP_SELECT:
		FormPopupForm(FORM_EDIT_CATE);
		return TRUE;
	case EVT_FORM_OPEN:
		PhonebookSetXBitmap(141,50);
		FormDrawForm(FORM_CATE_FULL);
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	PhonebookFindBackground
* Purpose: 	This function is called to handle the event occured in the 
FIND BACKGROUND screen of phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookFindBackground(EvtType *Event)
{
	switch (Event->eventType)
	{
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_EXIT || Event->para1 == INLAY_OK)
		{
			FormPopupForm(FORM_TEL_LIST);
			return TRUE;
		}
		break;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_FIND_BACKGROUND);
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	PhonebookFindInput
* Purpose: 	This function is called to handle the event occured in the 
FIND INPUT screen of phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookFindInput(EvtType *Event)
{
	ObjectID tempID;
    BYTE *textbox_string;
    BYTE    object_type;
    Textbox *textbox_ptr;
	
	
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;
            }
        }            
    }                    
	
	
	switch (Event->eventType)
	{
	case EVT_MENU_SELECT_ITEM:
		MenuItemSelectedAction((USHORT)(Event->para1));
		return TRUE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_EXIT)
		{
			PhonebookChangeFontSize(FORM_TEL_LIST, font_size);
			FormPopupForm(FORM_TEL_LIST);
			return TRUE;
		}
		else if (Event->para1 == INLAY_OK)
		{
			if (InputFindCharInCheck() == TRUE) 
				return TRUE;
			break;
		}
		break;
	case EVT_KEY:
		if (Event->eventID == SOFT_KEY && (Event->para2 & 0x300) == 0)
		{
			FormGetActiveObject(FORM_FIND_INPUT,&tempID);
			if (tempID == TEXTBOX_FIND_INPUT) 
			{
				if ((BYTE)(Event->para1) == 13 && (InputFindCharInCheck() == TRUE)) return TRUE;
				else TextboxAddKeyInChar(TEXTBOX_FIND_INPUT, (BYTE)(Event->para1));
				return TRUE;
			}
		}
		break;
	case EVT_BITMAP_SELECT:
		PhonebookChangeFontSize(FORM_TEL_LIST, font_size);
		FormPopupForm(FORM_TEL_LIST);
		return TRUE;
	case EVT_FORM_OPEN:
		FormSetFormActiveObject(FORM_FIND_INPUT, TEXTBOX_FIND_INPUT);
		TextboxGetTextPointer(TEXTBOX_FIND_INPUT, &textbox_string);
		FormGetObjectPointer(TEXTBOX_FIND_INPUT, &object_type, (void**)&textbox_ptr);
		if (strlen(textbox_string) == 0)
		{
			TextboxSetInsertPointOn(TEXTBOX_FIND_INPUT);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_FIND_INPUT, 0);
			textbox_ptr->textbox_attr.textbox_highlight = FALSE;
		}
		else
		{
			TextboxSetInsertPointOff(TEXTBOX_FIND_INPUT);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_FIND_INPUT, 0);
			TextboxSetLeftCharPos(TEXTBOX_FIND_INPUT, 0);
			TextboxSetRightCharPos(TEXTBOX_FIND_INPUT, -1);
			textbox_ptr->textbox_attr.textbox_highlight = TRUE;
			TextboxSetHighlightSelection(TEXTBOX_FIND_INPUT, 0, strlen(textbox_string));
		}
		PhonebookSetXBitmap(141,34);
		FormDrawForm(FORM_FIND_INPUT);
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	PhonebookNotFound
* Purpose: 	This function is called to handle the event occured in the 
NOT FOUND screen of phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookNotFound(EvtType *Event)
{
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;
            }
        }
    }                    
	
	
	switch (Event->eventType)
	{
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_EXIT || Event->para1 == INLAY_OK)
		{
			FormPopupForm(FORM_FIND_BACKGROUND);
			FormPopupForm(FORM_FIND_INPUT);
			return TRUE;
		}
		break;
	case EVT_BITMAP_SELECT:
		FormPopupForm(FORM_FIND_BACKGROUND);
		FormPopupForm(FORM_FIND_INPUT);
		return TRUE;
	case EVT_FORM_OPEN:
		PhonebookSetXBitmap(141,50);
		FormDrawForm(FORM_NOT_FOUND);
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	PhonebookFindResult
* Purpose: 	This function is called to handle the event occured in the 
FIND RESULT screen of phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookFindResult(EvtType *Event)
{
	USHORT item_num;
	UBYTE cate_num;
	BYTE *cate_name;
    BYTE    object_type;
    Textbox *textbox_ptr;
	List	*list_ptr;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_NEW || Event->para1 == SLETTER_NEW)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_FIND_RESULT_NEW;
                Event->evtPBP       = NULL;
            }
            else if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
            {
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;
            }            	            
            else if (Event->para2 == 0x215 || Event->para2 == 0x21c)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_FIND_RESULT, SCROLLBAR_UP_ARROW);            
                return TRUE;            
            }
            else if (Event->para2 == 0x216 || Event->para2 == 0x21d)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_FIND_RESULT, SCROLLBAR_DOWN_ARROW);            
                return TRUE;            
            }                                
        }       
    }                    
	
	switch(Event->eventType)
	{
	case EVT_MENU_SELECT_ITEM:
		MenuItemSelectedAction1((USHORT)(Event->para1));
		return TRUE;
	case EVT_LIST_SELECT:
		if (Event->para1 == -1) return TRUE;
		table_font_size = SMALL_FONT;
		
		ListDisplayGetRecordID(&list_find, (USHORT)(Event->para1 + list_find.top_item_num), &(app_status.rec_id));
		app_status.status=VIEW;
		app_status.company = FALSE;
		app_status.home = TRUE;
		PhonebookSelectItem(TRUE);
		
		return TRUE;
	case EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{
			if (Event->para2 == IO_UP_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_FIND_RESULT, SCROLLBAR_UP_ARROW);
			else if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_FIND_RESULT, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		return FALSE;
	case EVT_SCROLLBAR_SELECT:
		ScrollbarDrawScrollbar(SCROLLBAR_FIND_RESULT);
		return TRUE;
	case EVT_SCROLLBAR_REPEAT:
		PhonebookScrollbarSetFindResult(Event);
		return TRUE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			PhonebookChangeFontSize(FORM_TEL_LIST, font_size);
			FormPopupForm(FORM_TEL_LIST);
			return TRUE;
		}
		break;
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_FIND_RESULT_NEW)
		{
			FormEraseForm(FORM_FIND_RESULT);
			TextboxSetText(TEXTBOX_FIND_INPUT, (BYTE *)(""));
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_FIND_INPUT, 0);
			TextboxSetInsertPointOn(TEXTBOX_FIND_INPUT);
			FormPopupForm(FORM_FIND_INPUT);
		}
		else if (Event->eventID == BUTTON_FIND_RESULT_ZOOMIN)
			PhonebookChangeListFont();                
		return TRUE;
	case EVT_BITMAP_SELECT:
		FormEraseForm(FORM_FIND_RESULT);
		FormGetObjectPointer(TEXTBOX_FIND_INPUT, &object_type, (void**)&textbox_ptr);
		TextboxSetInsertPointOff(TEXTBOX_FIND_INPUT);
		TextboxSetInsertPointPositionByCharPos(TEXTBOX_FIND_INPUT, 0);
		TextboxSetLeftCharPos(TEXTBOX_FIND_INPUT, 0);
		TextboxSetRightCharPos(TEXTBOX_FIND_INPUT, -1);
		textbox_ptr->textbox_attr.textbox_highlight = TRUE;
		TextboxSetHighlightSelection(TEXTBOX_FIND_INPUT, 0, strlen(textbox_ptr->textbox_string));
		FormPopupForm(FORM_FIND_INPUT);
		return TRUE;
	case EVT_FORM_OPEN:
		FormGetObjectPointer(LIST_FIND_RESULT_NAME, &object_type, (void**)&list_ptr);
		cate_name = (list_ptr->list_text_font == SMALL_FONT) ? PBLFONT : PBSFONT;
		MenuDeleteItem(MENU_FIND_RESULT, 0);
		MenuInsertItem(MENU_FIND_RESULT, 0, cate_name);
		ControlSetLabel(BUTTON_FIND_RESULT_ZOOMIN, cate_name);
		PhonebookSetXBitmap(141,23);
		FormDrawForm(FORM_FIND_RESULT);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	PhonebookReturnToTelList
* Purpose: 	This function is helper to save, then 
return to list view
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		BOOLEAN True if ok to save
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookReturnSaveToTelList()
{
	BYTE object_type;
    BOOLEAN         control_value;
	void *addr;
    USHORT          item_num;
	
	if (PhonebookViewEditCheckEmptyFields() == FALSE)
	{
		KeyboardSetKeyboardStatus(FALSE);
		PhonebookSaveRecord(pb_dbid, app_status.rec_id, app_status.new_record);
		if(app_status.new_record)
			strcpy(current_cate, save_cate);
		ListSetSelectedItem(LIST_NAME, -1);
		ListSetSelectedItem(LIST_PHONENUM, -1);
		gSelNum = -1;
		char_start = save_first_letter;
		FormGetObjectPointer(POPUP_TRIGGER_CATE, &object_type, (void **)&addr);
		
		((Control*)addr)->control_attr.control_enable = TRUE;
		PhonebookCateNameToPopupTrigger(pb_dbid);
		if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate, &item_num) == FALSE) 
			item_num = 0;
		ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
		
		if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate,&item_num) == TRUE) 
		{
			ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
			PhonebookRecordToList(pb_dbid, current_cate, char_start, field_buffers[2]);
		}
		else
		{
			ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
			PhonebookRecordToList(pb_dbid, PBALL, PBCHARA,NULL);
		}
		PhonebookClearFieldBuffers();
		PhonebookChangeFontSize(FORM_TEL_LIST, font_size);
		char_pos[0] = char_pos[2] = FIELD_ROW0;
		char_pos[1] = char_pos[3] = 0;
		char_pos[4] = char_pos[5] = 0;
		char_pos[6] = char_pos[7] = 0;
		char_pos[8] = 0;
		FormPopupForm(FORM_TEL_LIST);
		return TRUE;
	}
	return FALSE;
}

void PhonebookGotoEditMode()
{
    ObjectID        tempID;
	void* addr;
	BYTE object_type;
	ObjectBounds ob;
	
	if (MemoryLow || (entry_low_memory && entry_old_edit))
	{
		low_memory_form_id = FORM_VIEW_EDIT;
		FormPopupForm(FORM_PB_LOW_MEMORY);
		return;
	}			  		
	else if (gf_entry && entry_old_edit)
	{
		gf_in_form_id = FORM_VIEW_EDIT;
		FormPopupForm(FORM_PB_DISCARD_CHANGES);
		return;
	}			  					    
	
	if(gf_entry)
	{
		char_pos[0] = char_pos[2] = FIELD_ROW0;
		char_pos[1] = char_pos[3] = 0;
		char_pos[4] = char_pos[5] = 0;
		char_pos[6] = char_pos[7] = 0;
		char_pos[8] = 0;
	}
	
	KeyboardSetKeyboardVisible();
	PhonebookFieldBuffersToField();
	for (tempID = FIELD_ROW0; tempID <= FIELD_ROW11; tempID ++)
		FieldSetTopLineNum(tempID, 0);
	SetStatus(EDIT, app_status.company, app_status.home,app_status.rec_id,app_status.new_record);
	RestoreViewEditTopRowNum();
	PhonebookFieldBuffersToField();
	PhonebookViewEditSetupScreen();
	PhonebookPrepareChangeInfo();
	PhonebookSetViewEditTable(FORM_VIEW_EDIT, TABLE_VIEW_EDIT);
	PhonebookViewEditTableSetScrollbar(TABLE_VIEW_EDIT, SCROLLBAR_VIEW_EDIT);
	FormDrawForm(FORM_VIEW_EDIT);
	if(char_pos[8])
	{
		KeyboardDrawKeyboard();
		PhonebookViewEditSetupScreen();
		PhonebookSetViewEditTable(FORM_VIEW_EDIT, TABLE_VIEW_EDIT);
		PhonebookViewEditTableSetScrollbar(TABLE_VIEW_EDIT, SCROLLBAR_VIEW_EDIT);
		FormGetObjectPointer(TABLE_VIEW_EDIT, &object_type, (void **)&addr);
		//before repaint, clean up
		ob.xcoord = 0;
		ob.width = 160;
		ob.ycoord = (KeyboardCheckKeyboardStatus()) ? ((Table*)addr)->bounds.ycoord : 151;
		ob.height = (KeyboardCheckKeyboardStatus()) ? (99 - ((Table*)addr)->bounds.ycoord) : 6;
		LcdEraseRegion(&ob);
		TableDrawTable(TABLE_VIEW_EDIT);
		ScrollbarDrawScrollbar(SCROLLBAR_VIEW_EDIT);
		if(KeyboardCheckKeyboardStatus()==FALSE)
			BitmapDrawBitmap(BITMAP_NOTES);
		UpdateInsertionPoint();
		SaveViewEditTopRowNum();
	}
}

/********************************************************
* Function:	PhonebookReturnToTelList
* Purpose: 	This function is helper to return to list view
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void PhonebookReturnToTelList()
{
	BYTE object_type;
	void *addr;
    USHORT          item_num;
	
	//close keyboard
	KeyboardSetKeyboardStatus(FALSE);
	PhonebookClearFieldBuffers();
	ListSetSelectedItem(LIST_NAME, -1);
	ListSetSelectedItem(LIST_PHONENUM, -1);
	FormGetObjectPointer(POPUP_TRIGGER_CATE, &object_type, (void **)&addr);
	((Control*)addr)->control_attr.control_enable = TRUE;
	((Control*)addr)->control_attr.control_visible = TRUE;
	PhonebookCateNameToPopupTrigger(pb_dbid);
	if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate, &item_num) == TRUE) 
		ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
	else
		ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
	PhonebookRecordToList(pb_dbid, current_cate, char_start,NULL);
	PhonebookChangeFontSize(FORM_TEL_LIST, font_size);
	char_pos[0] = char_pos[2] = FIELD_ROW0;
	char_pos[1] = char_pos[3] = 0;
	char_pos[4] = char_pos[5] = 0;
	char_pos[6] = char_pos[7] = 0;
	char_pos[8] = 0;
	FormPopupForm(FORM_TEL_LIST);
}

/********************************************************
* Function:	PhonebookViewEdit
* Purpose: 	This function is the event handler for the VIEW EDIT
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookViewEdit(EvtType *Event)
{
    ObjectID        tempID;
    BYTE            object_type;
    void            *addr;
    SHORT           xcoord,ycoord;
    USHORT          item_num,total_num;
    BYTE            *textbox_string, *textbox_string1, *string;
    void            *addr1, *addr2;
    USHORT          selected_item, popup_total_num_items;
    BYTE            *item_text, *whole_name;
    List            *list_ptr;
    Control         *control_ptr;
	ObjectBounds	ob;
	WORD			f_char_pos;
	WORD			l_char_pos;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if (app_status.status == VIEW)
        {
            if ((Event->para2 & 0x00000200))
			{
				if (Event->para1 == LLETTER_DEL || Event->para1 == SLETTER_DEL)
				{
					if (FormGetObjectPointer(BUTTON_VIEW_DEL, &object_type, (void**)&control_ptr) == TRUE)
					{
						if (control_ptr->control_attr.control_visible)
						{
							Event->eventType    = EVT_CONTROL_SELECT;
                            Event->eventID      = BUTTON_VIEW_DEL;
                            Event->evtPBP       = NULL;
                        }                        
                    }                        
                }
                else if (Event->para1 == LLETTER_SWITCH || Event->para1 == SLETTER_SWITCH)
                {
					if (FormGetObjectPointer(BUTTON_VIEW_HOME, &object_type, (void**)&control_ptr) == TRUE)
					{
						if (control_ptr->control_attr.control_visible)
                        {
							Event->eventType    = EVT_CONTROL_SELECT;
                            Event->eventID      = BUTTON_VIEW_HOME;
                            Event->evtPBP       = NULL;
                        }                        
                    }                        
                }
                else if (Event->para1 == LLETTER_CATE || Event->para1 == SLETTER_CATE)
                {
                    ControlPopupPopupTrigger(POPUP_TRIGGER_CATE);
                    return TRUE;
                }            	                                           	            
                else if (Event->para2 == 0x215 || Event->para2 == 0x21c)
                {           
                    ScrollbarHardButtonSetScrollbar(SCROLLBAR_VIEW_EDIT, SCROLLBAR_UP_ARROW);            
                    return TRUE;            
                }
                else if (Event->para2 == 0x216 || Event->para2 == 0x21d)
                {           
                    ScrollbarHardButtonSetScrollbar(SCROLLBAR_VIEW_EDIT, SCROLLBAR_DOWN_ARROW);            
                    return TRUE;            
                }                                    
                
            }       
        }
        else
        {
            if ((Event->para2 & 0x00000200))
			{           
				if (Event->para1 == LLETTER_DEL || Event->para1 == SLETTER_DEL)
				{
					if (FormGetObjectPointer(BUTTON_VIEW_DEL, &object_type, (void**)&control_ptr) == TRUE)
					{
						if (control_ptr->control_attr.control_visible)
						{
							Event->eventType    = EVT_CONTROL_SELECT;
                            Event->eventID      = BUTTON_VIEW_DEL;
                            Event->evtPBP       = NULL;
                        }                        
                    }                        
                }
                else if (Event->para2 == 0x215 || Event->para2 == 0x21c)
                {           
                    ScrollbarHardButtonSetScrollbar(SCROLLBAR_VIEW_EDIT, SCROLLBAR_UP_ARROW);            
                    return TRUE;            
                }
                else if (Event->para2 == 0x216 || Event->para2 == 0x21d)
                {           
                    ScrollbarHardButtonSetScrollbar(SCROLLBAR_VIEW_EDIT, SCROLLBAR_DOWN_ARROW);            
                    return TRUE;            
                }                                                   
            }                
        }               
    }                    
	
	
	switch(Event->eventType)
	{
	case EVT_FIELD_SELECT:
		if(app_status.status==EDIT)
		{
			FormGetObjectPointer(Event->eventID, &object_type, &addr);
			object_type = (app_status.company) ? 0 : 1;
			char_pos[(2*object_type)] = Event->eventID;
			char_pos[(2*object_type) + 1] = ((Field*)addr)->field_insert_pt_char_pos;
		}
		break;
	case EVT_FIELD_MODIFIED:
		edit_dirty = 1;
		FormGetObjectPointer(Event->eventID, &object_type, &addr);
		object_type = (app_status.company) ? 0 : 1;
		char_pos[2*object_type] = Event->eventID;
		char_pos[(2*object_type) + 1] = ((Field*)addr)->field_insert_pt_char_pos;
		return TRUE;
	case EVT_MENU_SELECT_ITEM:
		if(Event->para1==MENU_ITEM_ZOOM)
		{
			TableEraseTable(TABLE_VIEW_EDIT);
			ScrollbarEraseScrollbar(SCROLLBAR_VIEW_EDIT);
		}
		else if(Event->para1==MENU_ITEM_SHOW)
			PhonebookFieldToFieldBuffer();
		
		MenuItemSelectedAction((USHORT)(Event->para1));
		
		if(Event->para1==MENU_ITEM_ZOOM)
		{
			PhonebookFieldToFieldBuffer();
			TableSetTopRowNum(TABLE_VIEW_EDIT, 0);
			for (tempID = FIELD_ROW0; tempID <= FIELD_ROW11; tempID ++)
				FieldSetTopLineNum(tempID, 0);
			TableSetTopRowNum(TABLE_VIEW_EDIT, 0);
			PhonebookFieldBuffersToField();
			PhonebookViewEditSetupScreen();
			PhonebookSetViewEditTable(FORM_VIEW_EDIT, TABLE_VIEW_EDIT);
			PhonebookViewEditTableSetScrollbar(TABLE_VIEW_EDIT, SCROLLBAR_VIEW_EDIT);
			TableDrawTable(TABLE_VIEW_EDIT);
			ScrollbarDrawScrollbar(SCROLLBAR_VIEW_EDIT);
			UpdateInsertionPoint();
		}
		return TRUE;
	case EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{
			if (Event->para2 == IO_UP_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_VIEW_EDIT, SCROLLBAR_UP_ARROW);
			else if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_VIEW_EDIT, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		return FALSE;
	case EVT_SCROLLBAR_SELECT:
		ScrollbarDrawScrollbar(SCROLLBAR_VIEW_EDIT);
		UpdateInsertionPoint();
		break;
	case EVT_SCROLLBAR_REPEAT:
		PhonebookScrollbarSetViewEditTable(TABLE_VIEW_EDIT, SCROLLBAR_VIEW_EDIT, Event);
		SaveViewEditTopRowNum();
		UpdateInsertionPoint();
		break;
	case EVT_FIELD_CHANGED:
		PhonebookViewEditSetupScreen();
		if (PhonebookKeyInChangeViewEditTable(FORM_VIEW_EDIT, TABLE_VIEW_EDIT, SCROLLBAR_VIEW_EDIT))
			TableDrawTable(TABLE_VIEW_EDIT);
		break;
	case EVT_CONTROL_POPUP_SELECT:
		if(Event->eventID != POPUP_TRIGGER_CATE)
			edit_dirty = 1;
		switch(Event->eventID)
		{
		case POPUP_TRIGGER_CATE:
			gSelNum = -1;
			gTopNum = 0;
			ControlPopupGetTotalItems(POPUP_TRIGGER_CATE, &popup_total_num_items);
			ControlPopupGetPopupItem(POPUP_TRIGGER_CATE, (USHORT)(Event->para1), &item_text);
			selected_item = (USHORT)(Event->para1);
			if (popup_total_num_items == ((USHORT)selected_item + 1))
			{
				if((strlen(temp_cate)==0)||(strcmp(temp_cate,PBALL)==0))
					strcpy(temp_cate, PBUNFILED);
				PhonebookFieldToFieldBuffer();
				PhonebookPopupCateActions((USHORT)(selected_item));
			}
			else
			{
				if (temp_cate != NULL)
					qfree(temp_cate);
				temp_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
				strcpy(temp_cate, item_text);
				edit_dirty = 1;
			}
			break;
		case POPUP_TRIGGER_OT:
			ControlPopupGetSelectedItem(POPUP_TRIGGER_OT,&item_num);
			field_buffers[26][0] = (BYTE)item_num;
			break;
		case POPUP_TRIGGER_DL:
			ControlPopupGetSelectedItem(POPUP_TRIGGER_DL,&item_num);
			field_buffers[26][1] = (BYTE)item_num;
			break;
		case POPUP_TRIGGER_OF:
			ControlPopupGetSelectedItem(POPUP_TRIGGER_OF,&item_num);
			field_buffers[26][2] = (BYTE)item_num;
			break;
		case POPUP_TRIGGER_HT:
			ControlPopupGetSelectedItem(POPUP_TRIGGER_HT,&item_num);
			field_buffers[26][3] = (BYTE)item_num;
			break;
		case POPUP_TRIGGER_HF:
			ControlPopupGetSelectedItem(POPUP_TRIGGER_HF,&item_num);
			field_buffers[26][4] = (BYTE)item_num;
			break;
		case POPUP_TRIGGER_HP:
			ControlPopupGetSelectedItem(POPUP_TRIGGER_HP,&item_num);
			field_buffers[26][5] = (BYTE)item_num;
			break;
		case POPUP_TRIGGER_HM:
			ControlPopupGetSelectedItem(POPUP_TRIGGER_HM,&item_num);
			field_buffers[26][6] = (BYTE)item_num;
			break;
		}
		return TRUE;
		case PEN_EVENT:
			if ((Event->eventID == PEN_DOWN) && (app_status.status==VIEW) && ((SHORT)Event->para1 > 4 ) && ((SHORT)Event->para1 <155) && ((SHORT)Event->para2 > 15) && ((SHORT)Event->para2 < 141))
			{
				char_pos[6] = char_pos[7] = 0;
				if (MemoryLow || (entry_low_memory && entry_old_edit))
				{
					low_memory_form_id = FORM_VIEW_EDIT;
					FormPopupForm(FORM_PB_LOW_MEMORY);
					return TRUE;
				}			  		
				else if (gf_entry && entry_old_edit)
				{
					gf_in_form_id = FORM_VIEW_EDIT;
					FormPopupForm(FORM_PB_DISCARD_CHANGES);
					return TRUE;
				}
				PhonebookGotoEditMode();
			}
			return TRUE;
		case EVT_KEYBOARD_STATUS:
			TableGetTopRowNum(TABLE_VIEW_EDIT,&item_num);
			if(KeyboardCheckKeyboardStatus()==FALSE)
			{
				ob.xcoord = 0;
				ob.ycoord = 90;
				ob.width = 160;
				ob.height = 70;
				LcdEraseRegion(&ob);
				//change top row num if necessary
				TableGetNumOfColumns (TABLE_VIEW_EDIT,&total_num);
				if(font_size == SMALL_FONT)
				{
					if(item_num > (total_num - 7))
						item_num = (item_num > 5) ? item_num - 5 : 0;
				}
				else
				{
					if(item_num > (total_num - 5))
						item_num = (item_num > 4) ? item_num - 4 : 0;
				}
			}
			TableSetTopRowNum(TABLE_VIEW_EDIT, item_num);
			PhonebookViewEditSetupScreen();
			PhonebookSetViewEditTable(FORM_VIEW_EDIT, TABLE_VIEW_EDIT);
			PhonebookViewEditTableSetScrollbar(TABLE_VIEW_EDIT, SCROLLBAR_VIEW_EDIT);
			FormGetObjectPointer(TABLE_VIEW_EDIT, &object_type, (void **)&addr);
			//before repaint, clean up
			ob.xcoord = 0;
			ob.width = 160;
			ob.ycoord = (KeyboardCheckKeyboardStatus()) ? ((Table*)addr)->bounds.ycoord : 151;
			ob.height = (KeyboardCheckKeyboardStatus()) ? (99 - ((Table*)addr)->bounds.ycoord) : 6;
			LcdEraseRegion(&ob);
			TableDrawTable(TABLE_VIEW_EDIT);
			ScrollbarDrawScrollbar(SCROLLBAR_VIEW_EDIT);
			if(KeyboardCheckKeyboardStatus()==FALSE)
			{
				BitmapDrawBitmap(BITMAP_NOTES);
				char_pos[8] = 0;
			}
			else
				char_pos[8] = 1;
			UpdateInsertionPoint();
			SaveViewEditTopRowNum();
			return TRUE;
		case EVT_KEY:
			if (Event->eventID == SOFT_KEY && app_status.status == EDIT && (Event->para2 & 0x300) == 0)
			{             
				FormGetActiveObject(FORM_VIEW_EDIT,&tempID);
				switch(tempID)
				{
				case FIELD_ROW0:
					if(app_status.company && (Event->para1 == 0x0d))
						return TRUE;
				case FIELD_ROW1:
					if(app_status.home && (Event->para1 == 0x0d))
						return TRUE;
				case FIELD_ROW2:
				case FIELD_ROW3:
				case FIELD_ROW4:
				case FIELD_ROW5:
				case FIELD_ROW6:
				case FIELD_ROW7:
				case FIELD_ROW8:
				case FIELD_ROW9:
				case FIELD_ROW10:
				case FIELD_ROW11:
					FieldAddKeyInChar(tempID, (BYTE)(Event->para1));
					break;
				}
				return TRUE;
			}
			break;
		case EVT_CONTROL_SELECT:
			if (Event->eventID == BUTTON_DEL_HOME_COMPANY)
			{
				FormPopupForm(FORM_ADD_ERASE);
				return TRUE;
			}
			else if ((Event->eventID == PUSHBUTTON_HINFO)||(Event->eventID == PUSHBUTTON_CINFO))
			{
				if(((app_status.home==TRUE)&&(Event->eventID == PUSHBUTTON_HINFO))||
					((app_status.company==TRUE)&&(Event->eventID == PUSHBUTTON_CINFO)))
					return TRUE;
				PhonebookFieldToFieldBuffer();
				SetStatus(EDIT, (Event->eventID == PUSHBUTTON_CINFO), (Event->eventID == PUSHBUTTON_HINFO),app_status.rec_id,app_status.new_record);
				RestoreViewEditTopRowNum();
				PhonebookFieldBuffersToField();
				PhonebookViewEditSetupScreen();
				PhonebookViewEditTableSetScrollbar(TABLE_VIEW_EDIT, SCROLLBAR_VIEW_EDIT);
				PhonebookPrepareChangeInfo();
				KeyboardSetKeyboardVisible();
				PhonebookSetViewEditTable(FORM_VIEW_EDIT, TABLE_VIEW_EDIT);
				FormDrawForm(FORM_VIEW_EDIT);
				if (KeyboardCheckKeyboardStatus())
					KeyboardDrawKeyboard();
				UpdateInsertionPoint();
				return TRUE;
			}
			else if (Event->eventID == BUTTON_VIEW_COMPANY)
			{
				if((app_status.company==TRUE)&&(app_status.status==VIEW))
					return TRUE;
				SetStatus(VIEW, TRUE, FALSE, app_status.rec_id,FALSE);
				SwitchViewViews();
				return TRUE;
			}
			else if (Event->eventID == BUTTON_VIEW_HOME)
			{
				if((app_status.home==TRUE)&&(app_status.status==VIEW))
					return TRUE;
				SetStatus(VIEW, FALSE, TRUE, app_status.rec_id,FALSE);
				SwitchViewViews();
				return TRUE;
			}
			break;
		case EVT_INLAY_SELECT:
			if (app_status.status == VIEW)
			{
				if ((Event->para1 == INLAY_OK) || (Event->para1 == INLAY_EXIT))
				{
					PhonebookReturnToTelList();
					return TRUE;
				}
			}
			else if (app_status.status == EDIT)
			{
                PhonebookFieldToFieldBuffer();
				if (Event->para1 == INLAY_OK)
				{
					if(PhonebookReturnSaveToTelList()==FALSE)
					{
						FormPopupForm(FORM_ALERT);
					}
					return TRUE;
				}
				else if (Event->para1 == INLAY_EXIT)
				{
					//if new record and all fields are empty then skip
					if(((PhonebookViewEditCheckEmptyFields()==FALSE)||(app_status.new_record==FALSE))&&(edit_dirty!=0))
					{
						PhonebookFieldToFieldBuffer();
						FormPopupForm(FORM_SAVE_CHANGES);
					}
					else
						PhonebookReturnToTelList();
					
					return TRUE;
				}
			}
			break;
		case EVT_FORM_OPEN:
			PhonebookSetViewEditTable(FORM_VIEW_EDIT, TABLE_VIEW_EDIT);
			PhonebookViewEditTableSetScrollbar(TABLE_VIEW_EDIT, SCROLLBAR_VIEW_EDIT);
			
			if(app_status.status==EDIT)
			{
				if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, temp_cate, &item_num) == TRUE) 
				{
					ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
				}
				if(app_status.company)
					FormSetControlGroupSelection(FORM_VIEW_EDIT, PUSHBUTTON_CINFO);
				PhonebookGotoEditMode();
				UpdateInsertionPoint();
			}
			else if(app_status.status==VIEW)
			{
				if(app_status.company)
					FormSetControlGroupSelection(FORM_VIEW_EDIT, BUTTON_VIEW_COMPANY);
				RestoreViewEditTopRowNum();
				PhonebookViewEditTableSetScrollbar(TABLE_VIEW_EDIT, SCROLLBAR_VIEW_EDIT);
				FormDrawForm(FORM_VIEW_EDIT);
			}
			else  //NOTES_VIEW or NOTES_EDIT
			{
				FormPopupForm(FORM_NOTES);
			}
			
			return TRUE;
		case EVT_BITMAP_SELECT:
			PhonebookFieldToFieldBuffer();
			app_status.status = (app_status.status==EDIT) ? NOTES_EDIT : NOTES_VIEW;
			FormPopupForm(FORM_NOTES);
			return TRUE;
		default: 
			return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	PhonebookAddErase
* Purpose: 	This function is the event handler for the ADDRESS ERASE
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookAddErase(EvtType *Event)
{
	BOOLEAN control_value;
	USHORT item_num;
	BYTE object_type;
	void *addr;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_ADD_ERASE_YES;
                Event->evtPBP       = NULL;
            }
            else if (Event->para1 == LLETTER_NO || Event->para1 == LLETTER_NO)
            {
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_ADD_ERASE_NO;
                Event->evtPBP       = NULL;
            }            	            
        }       
    }                    
	
	
	switch(Event->eventType)
	{
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_ADD_ERASE_YES)
		{
			gTopNum = 0;
			gSelNum = -1;
			FormGetControlValue(CHECKBOX_ADD_ERASE, &control_value);
			DataCloseRecord(pb_dbid,app_status.rec_id);
			DataDeleteRecord(pb_dbid,app_status.rec_id, control_value);
			ListSetSelectedItem(LIST_NAME, -1);
			ListSetSelectedItem(LIST_PHONENUM, -1);
			FormGetObjectPointer(POPUP_TRIGGER_CATE, &object_type, (void **)&addr);
			((Control*)addr)->control_attr.control_visible = TRUE;
			((Control*)addr)->control_attr.control_enable = TRUE;
			PhonebookCateNameToPopupTrigger(pb_dbid);
			if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate, &item_num) == TRUE) 
				ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
			else
			{
				item_num = 0;
				ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
			}
			PhonebookPopupCateActions(item_num);
			PhonebookChangeFontSize(FORM_TEL_LIST, font_size);
			FormPopupForm(FORM_TEL_LIST);
			return TRUE;
		}
		else if (Event->eventID == BUTTON_ADD_ERASE_NO)
		{
			PhonebookChangeFontSize(FORM_VIEW_EDIT, font_size);
			FormPopupForm(FORM_VIEW_EDIT);
			return TRUE;
		}
		break;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_ADD_ERASE);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	PhonebookSaveChanges
* Purpose: 	This function is the event handler for the SAVE CHANGES
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookSaveChanges(EvtType *Event)
{
	BYTE        object_type;
	USHORT      item_num;
	void        *addr;
	BYTE        *starting_string = NULL;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_SAVE_CHANGES_YES;
                Event->evtPBP     = NULL;
            }
            else if (Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
            {
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID        = BUTTON_SAVE_CHANGES_NO;
                Event->evtPBP     = NULL;
            }            	            
            else if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
            {
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = BITMAP_X;
                Event->evtPBP       = NULL;
            }            	            
        }
    }                    
	
	switch(Event->eventType)
	{
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_SAVE_CHANGES_YES)
		{
			if(PhonebookReturnSaveToTelList()==FALSE)
				FormPopupForm(FORM_ALERT);
		}
		else
			PhonebookReturnToTelList();
		break;
	case EVT_BITMAP_SELECT:
		FormPopupForm(FORM_VIEW_EDIT);
		break;
	case EVT_FORM_OPEN:
		PhonebookSetXBitmap(141,50);
		FormDrawForm(FORM_SAVE_CHANGES);
		break;
	default: 
		return FALSE;
	}
	return TRUE;
}

/********************************************************
* Function:	PhonebookLowMemoryHandle
* Purpose: 	This function is the event handler for the FORM_PB_LOW_MEMORY
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookLowMemoryHandle(EvtType* Event)
{
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;
            }
        }
    }                    
	
    
	switch (Event->eventType)
	{
	case EVT_BITMAP_SELECT:	
		switch (low_memory_form_id)
		{
		case FORM_VIEW_EDIT:
			FormPopupForm(FORM_VIEW_EDIT);            				
			break;
		case FORM_TEL_LIST:
			FormPopupForm(FORM_TEL_LIST);								
			break;				
		case FORM_EDIT_CATE:				
			FormPopupForm(FORM_EDIT_CATE);				
			break;
		case FORM_NOTES:             
			FormPopupForm(FORM_NOTES);           
			break;
		default:
			break;				
		}			
		break;
		case EVT_INLAY_SELECT:
			if (Event->para1 == INLAY_OK || Event->para2 == INLAY_EXIT)
			{
                switch (low_memory_form_id)
                {
				case FORM_VIEW_EDIT:
					FormPopupForm(FORM_VIEW_EDIT);            				
					break;
				case FORM_TEL_LIST:
					FormPopupForm(FORM_TEL_LIST);            
					break;           
				case FORM_EDIT_CATE:             
					FormPopupForm(FORM_EDIT_CATE);				                    
					break;
				case FORM_NOTES:             
					FormPopupForm(FORM_NOTES);           
					break;
				default:
					break;
                }
			}
			break;					
		case EVT_FORM_OPEN:
			PhonebookSetXBitmap(141,55);
			FormDrawForm(FORM_PB_LOW_MEMORY);
			break;
		default:
			break;			
	}				
	return TRUE;
}

/********************************************************
* Function:	PhonebookDiscardChangesHandle
* Purpose: 	This function is the event handler for the FORM_PB_DISCARD_CHANGES
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookDiscardChangesHandle(EvtType *Event)
{
    USHORT        item_num;
    ObjectID      tempID;
	
    if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_PB_DISCARD_CHANGES_YES;
                Event->evtPBP       = NULL;
            }
			else if (Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_PB_DISCARD_CHANGES_NO;
                Event->evtPBP       = NULL;
            }            
			else if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = BITMAP_X;
                Event->evtPBP       = NULL;
            }                        
        }
    }                    
	
    switch (Event->eventType)
    {
	case EVT_BITMAP_SELECT:
		FormPopupForm(gf_in_form_id);
		break;
	case EVT_FORM_OPEN:
		PhonebookSetXBitmap(141,41);
		FormDrawForm(FORM_PB_DISCARD_CHANGES);
		break;    
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			FormPopupForm(gf_in_form_id);
		return TRUE;
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_PB_DISCARD_CHANGES_YES)
		{
			switch (gf_in_form_id)
			{
			case FORM_NOTES:
			case FORM_VIEW_EDIT:
				gf_entry = FALSE;
				SetStatus(EDIT,(app_status.company),(app_status.home),app_status.rec_id,app_status.new_record);
				PhonebookFieldBuffersToField();
				TableSetTopRowNum(TABLE_VIEW_EDIT, 0);
				for (tempID = FIELD_ROW0; tempID <= FIELD_ROW11; tempID ++)
					FieldSetTopLineNum(tempID, 0);
				PhonebookViewEditSetupScreen();
				PhonebookPrepareChangeInfo();
				PhonebookSetViewEditTable(FORM_VIEW_EDIT, TABLE_VIEW_EDIT);
				PhonebookViewEditTableSetScrollbar(TABLE_VIEW_EDIT, SCROLLBAR_VIEW_EDIT);
				char_pos[0] = char_pos[2] = FIELD_ROW0;
				char_pos[1] = char_pos[3] = 0;
				char_pos[4] = char_pos[5] = 0;
				char_pos[6] = char_pos[7] = 0;
				char_pos[8] = 0;
				if (gf_in_form_id == FORM_VIEW_EDIT)
				{
					if (KeyboardCheckKeyboardStatus() == FALSE)
					{
						PhonebookChangeFontSize(FORM_VIEW_EDIT, font_size);
						FormPopupForm(FORM_VIEW_EDIT);
					}
					else 
					{
						PhonebookRedrawWithKeyboard();
						FormSetActiveForm(FORM_VIEW_EDIT);
						FormSetEventHandler(FORM_VIEW_EDIT,(void**)&FormDispatchEvent, (void*)PhonebookViewEdit);                        
					}         			    
				}
				else
				{
					app_status.status = NOTES_EDIT;
					PhonebookNotesSetupScreen();
					FormPopupForm(FORM_NOTES);						                	                        	
				}							
				KeyboardSetKeyboardVisible();
				break;
			case FORM_TEL_LIST:
				gf_entry = FALSE;
				
				PhonebookInitFieldBuffers();
				SetStatus(EDIT,FALSE,FALSE,0,TRUE);
				FormInitAllFormObjects(FORM_VIEW_EDIT);
				PhonebookCateNameToPopupTrigger(pb_dbid);
				ControlPopupDeleteItem(POPUP_TRIGGER_CATE,0);
				if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate, &item_num) == TRUE) 
					ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
				else
					ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
				
				PhonebookViewEditSetupScreen();
				if (save_cate != NULL)
					qfree(save_cate);
				save_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
				strcpy (save_cate, PBALL);
				PhonebookChangeFontSize(FORM_VIEW_EDIT, font_size);
				FormPopupForm(FORM_VIEW_EDIT);
				break;           
			default:
				break;
			}
		}
		else
		{
			switch (gf_in_form_id)
			{
			case FORM_NOTES:
			case FORM_VIEW_EDIT:                        
			case FORM_TEL_LIST:
				gf_entry = FALSE;
				PhonebookGlobalFindReentranceRestore();
				break;
			default:
				return FALSE;
			}                               
		}    
		return TRUE;
	default: 
		return FALSE;
    }
    return FALSE;                                     
}

/********************************************************
* Function:	PhonebookAlertEventHandler
* Purpose: 	This function is the event handler for the FORM_ALERT
dialog of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookAlertEventHandler(EvtType *Event)
{
	BOOLEAN control_value;
	USHORT item_num;
	BYTE object_type;
	void *addr;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_ALERT_CLOSE || Event->para1 == SLETTER_ALERT_CLOSE || Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BITMAP_X;
                Event->evtPBP       = NULL;
            }
        }       
    }                    
	
	switch(Event->eventType)
	{
	case EVT_BITMAP_SELECT:
		switch(Event->eventID)
		{
		case BITMAP_X:
			FormPopupForm(FORM_VIEW_EDIT);
			break;
		default:
			return FALSE;
		}
		break;
		case EVT_CONTROL_SELECT:
			switch(Event->eventID)
			{
			case BUTTON_ALERT:
				FormPopupForm(FORM_VIEW_EDIT);
				break;
			default:
				return FALSE;
			}
			break;
			case EVT_FORM_OPEN:
				PhonebookSetXBitmap(141,41);
				FormDrawForm(FORM_ALERT);
				break;
			default: 
				return FALSE;
	}
	return TRUE;
}

BOOLEAN PhonebookSortEventHandler(EvtType *Event)
{
	BYTE	*item_text;
	SHORT	item_num_sort;
	SHORT	item_num_show;
	ObjectBounds ob;
	
	
	switch (Event->eventType)
	{
	case EVT_FORM_OPEN:
		PhonebookSetXBitmap(141,52);
		switch(sort_mode)
		{
		case 2:
			item_num_sort = 0;
			break;
		case 29:
			item_num_sort = 2;
			break;
		case 30:
			item_num_sort = 1;
			break;
		}
		StringInitString(STRING_R_COL);
		FormGetObjectBounds(STRING_R_COL,&ob);
		ob.ycoord = PB_YCOORD1;
		ob.xcoord = PB_XCOORD1;
		FormSetObjectBounds(STRING_R_COL,ob);
		StringSetText(STRING_R_COL,PB_F_RIGHTCOL);
		
		ControlInitControl(POPUP_TRIGGER_SHOW);
		FormGetObjectBounds(POPUP_TRIGGER_SHOW,&ob);
		ob.ycoord = PB_YCOORD2;
		ob.xcoord = PB_XCOORD2;
		FormSetObjectBounds(POPUP_TRIGGER_SHOW,ob);
		item_num_show = show_mode;
		ControlPopupSetSelectedItem(POPUP_TRIGGER_SHOW, item_num_show);
		ControlPopupSetSelectedItem(POPUP_TRIGGER_SORT, item_num_sort);
		FormDrawForm(FORM_SORT);
		break;
		case EVT_INLAY_SELECT:
			if ((Event->para1 == INLAY_OK)||(Event->para1 == INLAY_EXIT))
			{ 											
				ControlPopupGetSelectedItem(POPUP_TRIGGER_SHOW,&item_num_show);
				ControlPopupGetSelectedItem(POPUP_TRIGGER_SORT,&item_num_sort);
				switch(item_num_sort)
				{
				case 0:  //last,first
					sort_mode = 2;
					break;
				case 1:  //first last
					sort_mode = 30;
					break;
				case 2:  //company, last
					sort_mode = 29;
					break;
				}
				show_mode = item_num_show;
				char_start=PBCHARA;
				gSelNum = -1;
				gTopNum = 0;
				DataCloseDB(pb_dbid);
				if(DataOpenDB(pb_dbid,SORT_TEXT_MODE | sort_mode, OPEN_RW)!=TRUE)
				{
					sort_mode = 2;
					DataOpenDB(pb_dbid,SORT_TEXT_MODE | 2, OPEN_RW);
				}
				PhonebookRecordToList(pb_dbid, current_cate, char_start, NULL);
				FormPopupForm(FORM_TEL_LIST);
			}
			else if (Event->para1 == INLAY_MAIN_MENU)
				FormGotoApp(MAINMENU);
			break;
		case EVT_BITMAP_SELECT:
			FormPopupForm(FORM_TEL_LIST);
			break;
		default: 
			return TRUE;
	}
	return TRUE;
}


BOOLEAN PhonebookShowEventHandler(EvtType *Event)
{
	SHORT	item_num_show;
	ObjectBounds ob;
	
	switch (Event->eventType)
	{
	case EVT_FORM_OPEN:
		PhonebookSetXBitmap(141,52);
		StringInitString(STRING_R_COL);
		FormGetObjectBounds(STRING_R_COL,&ob);
		ob.ycoord = PB_YCOORD3;
		ob.xcoord = PB_XCOORD3;
		FormSetObjectBounds(STRING_R_COL,ob);
		StringSetText(STRING_R_COL,PB_F_DEFAULT);
		
		ControlInitControl(POPUP_TRIGGER_SHOW);
		FormGetObjectBounds(POPUP_TRIGGER_SHOW,&ob);
		ob.ycoord = PB_YCOORD4;
		ob.xcoord = PB_XCOORD4;
		FormSetObjectBounds(POPUP_TRIGGER_SHOW,ob);
		ControlPopupDeleteItem(POPUP_TRIGGER_SHOW,0);
		ControlPopupSetSelectedItem(POPUP_TRIGGER_SHOW, (SHORT)field_buffers[26][7]);
		FormDrawForm(FORM_SHOW);
		break;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK)
		{ 											
			ControlPopupGetSelectedItem(POPUP_TRIGGER_SHOW,&item_num_show);
			edit_dirty = (field_buffers[26][7] != (BYTE)item_num_show);
			field_buffers[26][7] = (BYTE)item_num_show;
			FormPopupForm(FORM_VIEW_EDIT);
		}
		else if (Event->para1 == INLAY_EXIT)
			FormPopupForm(FORM_VIEW_EDIT);
		break;
	case EVT_BITMAP_SELECT:
		FormPopupForm(FORM_VIEW_EDIT);
		break;
	default: 
		return TRUE;
	}
	return TRUE;
}

/********************************************************
* Function:	PhonebookNotesSetupScreen
* Purpose: 	This function is the event handler for the form of the attached notes
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
void PhonebookNotesSetupScreen()
{
	
	void        *addr;
	BYTE        object_type;
	
	MenuInitMenu(MENU_POPUP1);
	FormGetObjectPointer(FIELD_NOTES,&object_type,(void**)&addr);
	((Field*)addr)->field_font_id = table_font_size;
	FormSetFormActiveObject(FORM_NOTES, FIELD_NOTES);
	((Field*)addr)->field_attr.field_insert_pt_visible = (app_status.status==NOTES_EDIT);
	((Field*)addr)->field_attr.field_enable = (app_status.status==NOTES_EDIT);
	((Field*)addr)->field_attr.field_active = TRUE;
	((Field*)addr)->field_back_line = (app_status.status==NOTES_EDIT) ? GREY_LINE : NO_LINE;
	((Field*)addr)->field_attr.field_highlight = (app_status.status==NOTES_EDIT);
	((Field*)addr)->bounds.height = (KeyboardCheckKeyboardStatus()) ? 82 : 140;
	FormGetObjectPointer(SCROLLBAR_NOTES, &object_type, (void**)&addr);   	
	((Scrollbar*)addr)->bounds.height = (KeyboardCheckKeyboardStatus()) ? 80 :  138;
	FieldSetFont(FIELD_NOTES, table_font_size);
	if(app_status.status==NOTES_VIEW)
	{
		//only leave large/small font
		MenuDeleteItem(MENU_POPUP1,0);
		MenuDeleteItem(MENU_POPUP1,0);
		MenuDeleteItem(MENU_POPUP1,0);
		MenuDeleteItem(MENU_POPUP1,0);
		MenuDeleteItem(MENU_POPUP1,0);
		if(table_font_size==SMALL_FONT)
			MenuInsertItem(MENU_POPUP1, 0, PBLFONT);
		else
			MenuInsertItem(MENU_POPUP1, 0, PBSFONT);
		MenuDeleteItem(MENU_POPUP1,1);
	}
	else
	{
		MenuDeleteItem(MENU_POPUP1,4);
		if(table_font_size==SMALL_FONT)
			MenuInsertItem(MENU_POPUP1, 4, PBLFONT);
		else
			MenuInsertItem(MENU_POPUP1, 4, PBSFONT);
		MenuDeleteItem(MENU_POPUP1,5);
	}
}

/********************************************************
* Function:	PhonebookNotesSetField
* Purpose: 	
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN	PhonebookNotesSetField(ObjectID form_id, ObjectID field_id)
{
	Field	*field_ptr;
	BOOLEAN insert_pt_on = FALSE;
	BYTE	object_type, font_id;
	SHORT	line_height, acc_height = 0;
	WORD	first_visible_char, last_visible_char, count = 0;
	WORD	line_num, insert_pos;
	
	
	FormGetObjectPointer(field_id, &object_type, (void**)&field_ptr);		
	insert_pt_on = field_ptr->field_attr.field_insert_pt_visible;
	
	FieldGetFont(field_id, &font_id);
    line_height = SysGetFontHeight(font_id) + SPACE_LINE;
	
	if (insert_pt_on == TRUE)
	{
		StrAnalyzeLine(field_ptr);
		FieldGetFirstVisibleChar(field_id, &first_visible_char);
		FieldGetLastVisibleChar(field_id, &last_visible_char);
		
		for (count = 0; count < field_ptr->field_total_num_lines; count++)
		{
			if (field_ptr->field_insert_pt_char_pos >= field_ptr->field_lineinfo[count].start &&
				field_ptr->field_insert_pt_char_pos <= field_ptr->field_lineinfo[count].start + field_ptr->field_lineinfo[count].length)
				break;
		}
		
		if (field_ptr->field_insert_pt_char_pos < first_visible_char)
			field_ptr->field_top_line_num = count;
		else if (field_ptr->field_insert_pt_char_pos > last_visible_char)
			field_ptr->field_top_line_num = count - field_ptr->field_num_lines_displayed;
		
		if (field_ptr->field_num_lines_displayed < (field_ptr->bounds.height/(line_height)))
		{
			if (field_ptr->field_top_line_num > (field_ptr->field_total_num_lines - (field_ptr->bounds.height/(line_height))))
				field_ptr->field_top_line_num = (field_ptr->field_total_num_lines - (field_ptr->bounds.height/(line_height)));
			
			if (field_ptr->field_top_line_num < 0)
				field_ptr->field_top_line_num = 0;
		}
		
		StrAnalyzeLine(field_ptr);
		StrCharPosToXY(field_ptr, field_ptr->field_insert_pt_char_pos, 
			&(field_ptr->field_insert_pt_x), &(field_ptr->field_insert_pt_y));
		/* Set up the correct insert pt position when keyboard on */
		FieldGetInsertPointPosition(field_id, &insert_pos);
		FieldGetFirstVisibleChar (field_id, &first_visible_char);
		FieldGetLastVisibleChar (field_id, &last_visible_char);
		
		if(insert_pos > last_visible_char)
		{
			FieldCharPosToLineNum (field_ptr, insert_pos, &line_num);
			FieldSetTopLineNum(field_id, line_num - (field_ptr->bounds.height/(line_height)) + 1);
		}
		FieldSetInsertPointPositionByCharPos(field_id, insert_pos);
	}
	return TRUE;
}

/********************************************************
* Function:	NotesChangeFontSize
* Purpose: 	
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
void PhonebookNotesChangeFontSize()
{
	int offset;
	
	offset = (app_status.status==NOTES_VIEW) ? 0 : 4;
	table_font_size = (table_font_size==SMALL_FONT) ? MEDIUM_FONT : SMALL_FONT;
	font_size = table_font_size;
	MenuDeleteItem(MENU_POPUP1, offset);
	if(table_font_size==SMALL_FONT)
		MenuInsertItem(MENU_POPUP1, offset, PBLFONT);
	else
		MenuInsertItem(MENU_POPUP1, offset, PBSFONT);
	FieldSetFont(FIELD_NOTES, table_font_size);
	PhonebookNotesSetField(FORM_NOTES, FIELD_NOTES);
	FieldEraseField(FIELD_NOTES);
	FieldDrawField(FIELD_NOTES);
	PhonebookSetScrollbar(FIELD_NOTES, SCROLLBAR_NOTES);
}

/********************************************************
* Function:	PhonebookNotes
* Purpose: 	This function is the event handler for the form of the attached notes
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookNotesEventHandler(EvtType *Event)
{	
	BYTE* notes_temp;
    WORD wValue;
    WORD wMaxValue;
    WORD wMinValue;
    WORD wPageSize;
    WORD wTotalNumOfLine;
    WORD wLineNum;
	WORD wVisLines;
	BYTE object_type;
	BOOLEAN blnTemp;
	void* addr;
	WORD start_pos;
	WORD end_pos;
	WORD top_line;
	
    switch (Event->eventType)
	{
	case EVT_MENU_SELECT_ITEM:
		switch(Event->para1)
		{
		case MENU_ITEM_COPY:
			if(app_status.status==NOTES_VIEW)
				PhonebookNotesChangeFontSize();
			else
				KeyboardSendEvent(KEY_COPY, FALSE, FALSE, FALSE);
			break;
		case MENU_ITEM_CUT:
			KeyboardSendEvent(KEY_CUT, FALSE, FALSE, FALSE);
			break;
		case MENU_ITEM_PASTE:
			KeyboardSendEvent(KEY_PASTE, FALSE, FALSE, FALSE);
			break;
		case MENU_ITEM_UNDO:
			if (UIGetUndoStatus() != UNDO_EMPTY)
				KeyboardSendEvent(KEY_UNDO, FALSE, FALSE, FALSE);
			break;
		case MENU_ITEM_ZOOM:						
			PhonebookNotesChangeFontSize();
			//check if we need to adjust field
			if(font_size==MEDIUM_FONT)
			{
				if (KeyboardCheckKeyboardStatus())
				{
					FieldEraseField(FIELD_NOTES);
					//if selected text, adjust view accordingly
					FieldGetCurrentHighlightedSelection(FIELD_NOTES,&start_pos,&end_pos);
					if(start_pos != end_pos)
					{
						FormGetObjectPointer(FIELD_NOTES, &object_type, (void**)&addr);		
						FieldCharPosToLineNum(addr, end_pos, &start_pos);
						FieldGetTopLineNum(FIELD_NOTES,&top_line);
						if (start_pos > (top_line + 6))
							top_line = (start_pos > 6) ? start_pos - 6 : 0;
						char_pos[5] = top_line;
						FieldSetTopLineNum(FIELD_NOTES, char_pos[5]);
					}
					FieldDrawField(FIELD_NOTES);
				}
				else
				{
					FieldEraseField(FIELD_NOTES);
					//if selected text, adjust view accordingly
					FieldGetCurrentHighlightedSelection(FIELD_NOTES,&start_pos,&end_pos);
					if(start_pos != end_pos)
					{
						FormGetObjectPointer(FIELD_NOTES, &object_type, (void**)&addr);		
						FieldCharPosToLineNum(addr, end_pos, &start_pos);
						FieldGetTopLineNum(FIELD_NOTES,&top_line);
						if (start_pos > (top_line + 11))
							top_line = (start_pos > 11) ? start_pos - 11 : 0;
						char_pos[5] = top_line;
						FieldSetTopLineNum(FIELD_NOTES, char_pos[5]);
					}
					FieldDrawField(FIELD_NOTES);
				}
				
			}
			else
			{
				if (KeyboardCheckKeyboardStatus())
				{
					FieldEraseField(FIELD_NOTES);
					//if selected text, adjust view accordingly
					FieldGetCurrentHighlightedSelection(FIELD_NOTES,&start_pos,&end_pos);
					if(start_pos != end_pos)
					{
						FormGetObjectPointer(FIELD_NOTES, &object_type, (void**)&addr);		
						FieldCharPosToLineNum(addr, end_pos, &start_pos);
						FieldGetTopLineNum(FIELD_NOTES,&top_line);
						if (start_pos > (top_line + 8))
							top_line = (start_pos > 8) ? start_pos - 8 : 0;
						char_pos[5] = top_line;
						FieldSetTopLineNum(FIELD_NOTES, char_pos[5]);
					}
					FieldDrawField(FIELD_NOTES);
				}
				else
				{
					FieldEraseField(FIELD_NOTES);
					//if selected text, adjust view accordingly
					FieldGetCurrentHighlightedSelection(FIELD_NOTES,&start_pos,&end_pos);
					if(start_pos != end_pos)
					{
						FormGetObjectPointer(FIELD_NOTES, &object_type, (void**)&addr);		
						FieldCharPosToLineNum(addr, end_pos, &start_pos);
						FieldGetTopLineNum(FIELD_NOTES,&top_line);
						if (start_pos > (top_line + 14))
							top_line = (start_pos > 14) ? start_pos - 14 : 0;
						char_pos[5] = top_line;
						FieldSetTopLineNum(FIELD_NOTES, char_pos[5]);
					}
					FieldDrawField(FIELD_NOTES);
				}
			}
			break;
		default: 
			break;
		}
		return TRUE;
		case PEN_EVENT:
			
			if ((Event->eventID == PEN_DOWN) && (app_status.status==NOTES_VIEW) && ((SHORT)Event->para1 > 4 ) && ((SHORT)Event->para1 <155) && ((SHORT)Event->para2 > 15) && ((SHORT)Event->para2 < 141))
			{
				if (MemoryLow || (entry_low_memory && entry_old_edit))
				{
					low_memory_form_id = FORM_NOTES;
					FormPopupForm(FORM_PB_LOW_MEMORY);
					return TRUE;
				}			  		
				else if (gf_entry && entry_old_edit)
				{
					gf_in_form_id = FORM_NOTES;
					FormPopupForm(FORM_PB_DISCARD_CHANGES);
					return TRUE;
				}
				app_status.status = NOTES_EDIT;
				PhonebookNotesSetupScreen();
				FormDrawForm(FORM_NOTES);
			}
			return TRUE;
		case EVT_FIELD_CHANGED:
			PhonebookSetScrollbar(FIELD_NOTES, SCROLLBAR_NOTES);
			break;
		case EVT_FIELD_MODIFIED:
			FieldGetTopLineNum(FIELD_NOTES,&char_pos[5]);
			FieldGetInsertPointPosition(FIELD_NOTES,&char_pos[4]);
			edit_dirty = 1;
			break;
		case EVT_KEYBOARD_STATUS:
			PhonebookNotesSetupScreen();
			FormGetObjectPointer(FIELD_NOTES,&object_type,(void**)&addr);
			((Field*)addr)->field_attr.field_insert_pt_visible = (char_pos[4]!=-1);
			PhonebookNotesSetField(FORM_NOTES, FIELD_NOTES);
			if (KeyboardCheckKeyboardStatus() == FALSE)
			{
				char_pos[8] = 0;
				//check if we can move top line
				FieldGetTopLineNum(FIELD_NOTES,&top_line);
				FieldGetTotalNumOfLines(FIELD_NOTES,&wTotalNumOfLine);
				if(font_size == SMALL_FONT)
				{
					if(top_line > (wTotalNumOfLine - 10))
					{
						top_line = (top_line > 10) ? top_line - 10 : 0;
					}
				}
				else
				{
					if(top_line > (wTotalNumOfLine - 15))
					{
						top_line = (top_line > 15) ? top_line - 15 : 0;
						list_tel_list.top_item_num = gTopNum;
					}
				}
				char_pos[5] = top_line;
				FieldSetTopLineNum(FIELD_NOTES, char_pos[5]);
				PhonebookSetScrollbar(FIELD_NOTES, SCROLLBAR_NOTES);
				FormDrawForm(FORM_NOTES);
			}
			else
			{
				char_pos[8] = 1;
				FieldEraseField(FIELD_NOTES);
				//if selected text, adjust view accordingly
				FieldGetCurrentHighlightedSelection(FIELD_NOTES,&start_pos,&end_pos);
                if(start_pos != end_pos)
				{
					FormGetObjectPointer(FIELD_NOTES, &object_type, (void**)&addr);		
					FieldCharPosToLineNum(addr, end_pos, &start_pos);
					FieldGetTopLineNum(FIELD_NOTES,&top_line);
					if((font_size == SMALL_FONT)&&(start_pos > (top_line + 8)))
						top_line = (start_pos > 8) ? start_pos - 8 : 0;
					else if ((font_size == MEDIUM_FONT)&&(start_pos > (top_line + 6)))
						top_line = (start_pos > 6) ? start_pos - 6 : 0;
					char_pos[5] = top_line;
					FieldSetTopLineNum(FIELD_NOTES, char_pos[5]);
				}
				PhonebookSetScrollbar(FIELD_NOTES, SCROLLBAR_NOTES);
				FieldDrawField(FIELD_NOTES);
			}
			return TRUE;
		case EVT_IO_KEY_CTRL:
			if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
			{
				if (Event->para2 == IO_UP_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_NOTES, SCROLLBAR_UP_ARROW);
				else if (Event->para2 == IO_DOWN_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_NOTES, SCROLLBAR_DOWN_ARROW);
				return TRUE;
			}
			return FALSE;
		case EVT_SCROLLBAR_REPEAT:
		case EVT_SCROLLBAR_SELECT:
			ScrollbarGetScrollbar (SCROLLBAR_NOTES,&wValue,&wMaxValue,&wMinValue,&wPageSize,&wTotalNumOfLine);
			ScrollbarSetScrollbar (SCROLLBAR_NOTES,Event->para2,wMaxValue,wMinValue,wPageSize,wTotalNumOfLine);
			ScrollbarDrawScrollbar (SCROLLBAR_NOTES);
			FieldSetTopLineNum (FIELD_NOTES, wValue);
			char_pos[5] = wValue;
			//scroll insertion point accordingly
			FormSetFormActiveObject(FORM_NOTES, FIELD_NOTES);
			FieldDrawField (FIELD_NOTES);
			if(char_pos[4]!=-1)
			{
				FieldSetInsertPointPositionByCharPos(FIELD_NOTES,char_pos[4]);
				FieldSetInsertPointOn(FIELD_NOTES);
			}
			break;
		case EVT_FORM_OPEN:
			KeyboardSetKeyboardVisible();
			FieldInitField(FIELD_NOTES);
			ScrollbarInitScrollbar(SCROLLBAR_NOTES);
			FieldSetMaxNumChars(FIELD_NOTES, 32768); 
			FieldSetText(FIELD_NOTES,field_buffers[25]);
			FieldGetTotalNumOfLines (FIELD_NOTES, &wLineNum);
			PhonebookNotesSetupScreen();
			FieldSetTopLineNum(FIELD_NOTES,char_pos[5]);
			PhonebookSetScrollbar(FIELD_NOTES, SCROLLBAR_NOTES);
			FormDrawForm(FORM_NOTES);
			if(char_pos[8])
			{
				KeyboardDrawKeyboard();
				PhonebookNotesSetupScreen();
				FormGetObjectPointer(FIELD_NOTES,&object_type,(void**)&addr);
				((Field*)addr)->field_attr.field_insert_pt_visible = (char_pos[4]!=-1);
				PhonebookNotesSetField(FORM_NOTES, FIELD_NOTES);
				PhonebookSetScrollbar(FIELD_NOTES, SCROLLBAR_NOTES);
				FieldEraseField(FIELD_NOTES);
				//if selected text, adjust view accordingly
				FieldGetCurrentHighlightedSelection(FIELD_NOTES,&start_pos,&end_pos);
                if(start_pos != end_pos)
				{
					FormGetObjectPointer(FIELD_NOTES, &object_type, (void**)&addr);		
					FieldCharPosToLineNum(addr, end_pos, &start_pos);
					FieldGetTopLineNum(FIELD_NOTES,&top_line);
					if((font_size == SMALL_FONT)&&(start_pos > (top_line + 8)))
						top_line = (start_pos > 8) ? start_pos - 8 : 0;
					else if ((font_size == MEDIUM_FONT)&&(start_pos > (top_line + 6)))
						top_line = (start_pos > 6) ? start_pos - 6 : 0;
					char_pos[5] = top_line;
					FieldSetTopLineNum(FIELD_NOTES, char_pos[5]);
				}
			}
			
			if(app_status.status==NOTES_EDIT)
			{
				FormSetFormActiveObject(FORM_NOTES, FIELD_NOTES);
				if(char_pos[4]!=-1)
				{
					FormGetObjectPointer(FIELD_NOTES,&object_type,(void**)&addr);
					((Field*)addr)->field_attr.field_highlight = FALSE;
					FieldSetInsertPointPositionByCharPos(FIELD_NOTES,char_pos[4]);
					FieldSetInsertPointOn(FIELD_NOTES);
				}
			}
			FieldDrawField(FIELD_NOTES);
			break;
		case EVT_KEY:
			if (Event->eventID == SOFT_KEY)
				FieldAddKeyInChar(FIELD_NOTES,(BYTE)(Event->para1));
			break;
		case EVT_FIELD_SELECT:
			FieldGetTopLineNum(FIELD_NOTES,&char_pos[5]);
			FieldGetInsertPointPosition(FIELD_NOTES,&char_pos[4]);
			break;
		case EVT_INLAY_SELECT:
			if((Event->para1 == INLAY_OK)||(Event->para1 == INLAY_EXIT))
			{
				if (field_buffers[25] !=NULL)
					qfree(field_buffers[25]);
				FieldGetTextPointer(FIELD_NOTES, &notes_temp);
				field_buffers[25]=(BYTE*)qmalloc((strlen(notes_temp)+1)*sizeof(BYTE));
				strcpy(field_buffers[25], notes_temp);				
				app_status.status = (app_status.status==NOTES_EDIT) ? EDIT : VIEW;
				table_font_size = SMALL_FONT;
				PhonebookSelectItem(FALSE);
			}
			else if(Event->para1 == INLAY_MAIN_MENU)
				FormGotoApp(MAINMENU);
			break;
			
		default:
			return FALSE;
	}			
	return TRUE;
}
