/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   appsave.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#include "app.h"

/********************************************************
* Function:	PhonebookAppSave
* Purpose: 	This function is called to save the data in 
the application when it is called to stopped
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
void PhonebookAppSave()
{
	ObjectID 		active_form_id;
	BYTE 			application_status = -1;
	BOOLEAN 		exist = FALSE;
	BYTE 			*object_text;
	WORD 			count = 0;
    Table 			*table_ptr;
    BYTE    		object_type;  
    BYTE    		boolean_value;  
	
	application_status = app_status.status;
	
	PhonebookDatabaseChecking();
	
	DataWriteField(pb_dbid, PB_STATUS, 1, 1, &edit_dirty);
    DataWriteField(pb_dbid, PB_STATUS, 2, (strlen(find_string) + 1), find_string);
    DataWriteField(pb_dbid, PB_STATUS, 3, 1, &font_size);
    DataWriteField(pb_dbid, PB_STATUS, 4, 4, (BYTE*)&letter_bar);
    DataWriteField(pb_dbid, PB_STATUS, 5, 4, (BYTE*)&gTopNum);
    DataWriteField(pb_dbid, PB_STATUS, 6, 4, (BYTE*)&gSelNum);
    DataWriteField(pb_dbid, PB_STATUS, 7, 1, &show_mode);
    DataWriteField(pb_dbid, PB_STATUS, 8, 1, &sort_mode);
	DataWriteField(pb_dbid, PB_EDIT_INFO, 29, 9 * sizeof(WORD), (BYTE*)&char_pos);
	
	switch (application_status)
	{
	case TEL_LIST:
		DataWriteField(pb_dbid, PB_STATUS, 0, 1, &application_status);
		if (current_cate != NULL)
			DataWriteField(pb_dbid, PB_ADDR_LIST, 0, (strlen(current_cate) + 1), current_cate);
		DataWriteField(pb_dbid, PB_ADDR_LIST, 1, 1, &char_start);
		break;
	case VIEW:
	case EDIT:
	case NOTES_EDIT:
	case NOTES_VIEW:
		DataWriteField(pb_dbid, PB_STATUS, 0, 1, &application_status);
		if (current_cate != NULL)
			DataWriteField(pb_dbid, PB_ADDR_LIST, 0, (strlen(current_cate) + 1), current_cate);
		DataWriteField(pb_dbid, PB_ADDR_LIST, 1, 1, &char_start);
		PhonebookFieldToFieldBuffer();
		for (count = 0; count < 26; count++)
		{
			if (field_buffers == NULL)
				DataWriteField(pb_dbid, PB_EDIT_INFO, (USHORT)count, 1, (BYTE*)(""));
			else
				DataWriteField(pb_dbid, PB_EDIT_INFO, (USHORT)count, (strlen(field_buffers[count]) + 1), field_buffers[count]);
		}
		DataWriteField(pb_dbid, PB_EDIT_INFO, (USHORT)26, 8, field_buffers[26]);
		
		/* app_status */
		boolean_value = (BYTE)(app_status.company);
		DataWriteField(pb_dbid, PB_EDIT_INFO, 27, 1, (BYTE*)&boolean_value);			
		boolean_value = (BYTE)(app_status.home);
		DataWriteField(pb_dbid, PB_EDIT_INFO, 28, 1, (BYTE*)&boolean_value);			
		DataWriteField(pb_dbid, PB_EDIT_INFO, 30, 4, (BYTE*)&app_status.rec_id);
		boolean_value = (BYTE)(app_status.new_record);
		DataWriteField(pb_dbid, PB_EDIT_INFO, 31, 1, (BYTE*)&boolean_value);
		if (temp_cate == NULL)
			DataWriteField(pb_dbid, PB_EDIT_INFO, 32, 1, (BYTE*)(""));
		else 
			DataWriteField(pb_dbid, PB_EDIT_INFO, 32, (strlen(temp_cate) + 1), temp_cate);
		break;
	default: 
		break;
	}
    if (FormGetObjectPointer(TABLE_VIEW_EDIT, &object_type, (void**)&table_ptr) == TRUE)
        table_ptr->table_num_row = 12;   
	DataCloseDB(pb_dbid);
}

/********************************************************
* Function:	PhonebookAppRestore
* Purpose: 	This function is called to restore the data in 
the application when it is called to stopped
* Scope:		application/internal
* Input:		restart		whether the application is restart or not
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
void PhonebookAppRestore(BOOLEAN restart)
{
	BYTE 		application_status;
	BYTE 		*buffer;
	UWORD 		byte_read;
	WORD 		count;
	USHORT 		item_num;
	UBYTE       cate_num;
	
    draw_scrollbar = FALSE;
	/* global variables initialisation */
    find_string[0] = 0;
	edit_dirty = 0;
    pressed_object = 0;
    current_cate = NULL;
    char_start = PBCHARA;
    temp_cate = NULL;
    save_cate = NULL;
    save_first_letter = PBCHARA;
    SetStatus(TEL_LIST,FALSE,FALSE,0,FALSE);
    list_tel_list.list_id = LIST_NAME;
    list_find.list_id = LIST_FIND_RESULT_NAME;
    list_tel_list.dbid = list_find.dbid = 0;
    list_tel_list.max_num_items_display = list_find.max_num_items_display = 0;
    list_tel_list.num_items_display = list_find.num_items_display = 0;
    list_tel_list.total_num_items = list_find.total_num_items = 0;
    list_tel_list.top_item_num = list_find.top_item_num = 0;        
    list_tel_list.record_id_block = list_find.record_id_block = NULL;        
	
    PhonebookDatabaseChecking();
	
	list_tel_list.dbid = list_find.dbid = pb_dbid;
	if (restart == TRUE)
		application_status = -1;
	else
	{
		DataGetField(pb_dbid, PB_STATUS, 0, &buffer, &byte_read);
		application_status = *buffer;
		qfree(buffer);
	}
	
	app_status.status = application_status;
	
	/* Allocate global variable */
    DataGetField(pb_dbid, PB_STATUS, 2, &buffer, &byte_read);
    strcpy(find_string, buffer);
    qfree(buffer);
    DataGetField(pb_dbid, PB_STATUS, 3, &buffer, &byte_read);
    font_size = *buffer;
    qfree(buffer);
	DataGetField(pb_dbid, PB_STATUS, 4, &buffer, &byte_read);
    letter_bar = *(BOOLEAN*)buffer;
    qfree(buffer);
    DataGetField(pb_dbid, PB_STATUS, 5, &buffer, &byte_read);
	gTopNum = *(WORD*)buffer;
    qfree(buffer);
    DataGetField(pb_dbid, PB_STATUS, 6, &buffer, &byte_read);
	gSelNum = *(WORD*)buffer;
    qfree(buffer);
	DataGetField(pb_dbid, PB_STATUS, 7, &buffer, &byte_read);
	show_mode = *buffer;
	qfree(buffer);
	DataGetField(pb_dbid, PB_STATUS, 8, &buffer, &byte_read);
	sort_mode = *buffer;
	qfree(buffer);
	
	//set list to current cort_mode
	DataCloseDB(pb_dbid);
	if(DataOpenDB(pb_dbid,SORT_TEXT_MODE | sort_mode, OPEN_RW)!=TRUE)
	{
		sort_mode = 2;
		DataOpenDB(pb_dbid,SORT_TEXT_MODE | 2, OPEN_RW);
	}
	
	field_buffers = (BYTE**)qmalloc(27*sizeof(BYTE*));
	for (count = 0; count <27; count++)
		field_buffers[count] = NULL;
	current_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
    temp_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
	
	DataGetField(pb_dbid, PB_STATUS, 1, &buffer, &byte_read);
	edit_dirty = *buffer;
	qfree(buffer);
	
    FormInitAllFormObjects(FORM_TEL_LIST);
    FormInitAllFormObjects(FORM_VIEW_EDIT);
	
    entry_low_memory = (MemoryLow);
	entry_old_edit = (application_status != TEL_LIST);
	if (entry_low_memory && entry_old_edit)
		application_status = -1;
	
	switch(application_status)
	{
	case -1:
		char_pos[0] = char_pos[2] = FIELD_ROW0;
		char_pos[1] = char_pos[3] = 0;
		char_pos[4] = char_pos[5] = 0;
		char_pos[6] = char_pos[7] = 0;
		char_pos[8] = 0;
		app_status.status = TEL_LIST;
		strcpy(current_cate,PBALL);
		strcpy(temp_cate,PBALL);
		char_start = PBCHARA;
		PhonebookRecordToList(pb_dbid, PBALL, char_start, NULL);
		PhonebookCateNameToPopupTrigger(pb_dbid);
		ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
		FormPopupForm(FORM_TEL_LIST);
		if (entry_low_memory && entry_old_edit)
		{
			low_memory_form_id = FORM_TEL_LIST;
			FormPopupForm(FORM_PB_LOW_MEMORY);
		}								                     
		break;
	case TEL_LIST:
		DataGetField(pb_dbid, PB_EDIT_INFO, 29, &buffer, &byte_read);
		memcpy(char_pos,buffer,9 * sizeof(WORD));
		qfree(buffer);
		DataGetField(pb_dbid, PB_ADDR_LIST, 0, &buffer, &byte_read);
		strcpy(current_cate, buffer);
		strcpy(temp_cate, buffer);
		qfree(buffer);
		DataGetField(pb_dbid, PB_ADDR_LIST, 1, &buffer, &byte_read);			
		char_start = *buffer;
		qfree(buffer);
		
		if (PhonebookCateNameToNum(pb_dbid, current_cate, &cate_num) == FALSE)
			strcpy(current_cate, PBALL);
		
		PhonebookRecordToList(pb_dbid, current_cate, char_start, NULL);
		
		PhonebookSetTelListTopItemNum(char_start, 0, FALSE);
		
		PhonebookCateNameToPopupTrigger(pb_dbid);
		
		if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, current_cate, &item_num) == TRUE) 
			ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
		else
			ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
		
		PhonebookChangeFontSize(FORM_TEL_LIST, font_size);
		
		FormPopupForm(FORM_TEL_LIST);
		break;
	case VIEW:
	case EDIT:
	case NOTES_EDIT:
	case NOTES_VIEW:
		DataGetField(pb_dbid, PB_ADDR_LIST, 0, &buffer, &byte_read);
		strcpy(current_cate, buffer);
		qfree(buffer);
		DataGetField(pb_dbid, PB_ADDR_LIST, 1, &buffer, &byte_read);			
		char_start = *buffer;
		qfree(buffer);
		/* field_buffers */
		for (count = 0; count < 26; count++)
		{
			DataGetField(pb_dbid, PB_EDIT_INFO, count, &buffer, &byte_read);			
			field_buffers[count] = (BYTE*)qmalloc((strlen(buffer) + 1)*sizeof(BYTE));
			strcpy(field_buffers[count], buffer);
			qfree(buffer);
		}
		DataGetField(pb_dbid, PB_EDIT_INFO, 26, &buffer, &byte_read);
		
		//index settings
		field_buffers[26] = (BYTE*)qmalloc(8*sizeof(BYTE));
		field_buffers[26][0] = buffer[0];
		field_buffers[26][1] = buffer[1];
		field_buffers[26][2] = buffer[2];
		field_buffers[26][3] = buffer[3];
		field_buffers[26][4] = buffer[4];
		field_buffers[26][5] = buffer[5];
		field_buffers[26][6] = buffer[6];
		field_buffers[26][7] = buffer[7];
		qfree(buffer);
		
		/* app_status */
		DataGetField(pb_dbid, PB_EDIT_INFO, 27, &buffer, &byte_read);
		app_status.company = (BOOLEAN)(*buffer);
		qfree(buffer);
		DataGetField(pb_dbid, PB_EDIT_INFO, 28, &buffer, &byte_read);
		app_status.home = (BOOLEAN)(*buffer);
		qfree(buffer);
		DataGetField(pb_dbid, PB_EDIT_INFO, 29, &buffer, &byte_read);
		memcpy(char_pos,buffer,9 * sizeof(WORD));
		qfree(buffer);
		DataGetField(pb_dbid, PB_EDIT_INFO, 30, &buffer, &byte_read);
		app_status.rec_id = *(RecordID*)buffer;
		qfree(buffer);
		DataGetField(pb_dbid, PB_EDIT_INFO, 31, &buffer, &byte_read);
		app_status.new_record = (BOOLEAN)(*buffer);
		qfree(buffer);
		DataGetField(pb_dbid, PB_EDIT_INFO, 32, &buffer, &byte_read);
		strcpy(temp_cate, buffer);
		PhonebookSelectItem(FALSE);
		break;
	default: 
		break;
	}
    draw_scrollbar = TRUE;
}

/********************************************************
* Function:	PhonebookDatabaseChecking
* Purpose: 	This function is called to check whether the required database 
is already exist or not. If not, it will creat it
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void PhonebookDatabaseChecking()
{
	BYTE application_status;
	BYTE temp;
	WORD wTemp;
	
    DataFindDB(PBDB, &pb_dbid);
	
	if(DataIsDBOpen(pb_dbid, NULL, NULL) == FALSE)
		DataOpenDB(pb_dbid,SORT_TEXT_MODE | sort_mode, OPEN_RW);
	
	if (DataRecordInfo(pb_dbid, PB_STATUS, NULL, NULL, NULL, NULL, NULL) != TRUE)
	{
        DataNewRecordWithID(pb_dbid, PB_STATUS, 0, 9);
		application_status = -1;
		DataWriteField(pb_dbid, PB_STATUS, 0, 1, &application_status);
		temp = 0;
		DataWriteField(pb_dbid, PB_STATUS, 1, 1, &temp);
        DataWriteField(pb_dbid, PB_STATUS, 2, 1, (BYTE*)(""));
        temp = SMALL_FONT;
        DataWriteField(pb_dbid, PB_STATUS, 3, 1, &temp);
		wTemp = 0;
        DataWriteField(pb_dbid, PB_STATUS, 4, 4, (BYTE*)&wTemp);
		DataWriteField(pb_dbid, PB_STATUS, 5, 4, (BYTE*)&wTemp);
        wTemp = -1;
		DataWriteField(pb_dbid, PB_STATUS, 6, 4, (BYTE*)&wTemp);
        temp = 1;
		DataWriteField(pb_dbid, PB_STATUS, 7, 1, &temp);
        temp = 2; //sort_mode
		DataWriteField(pb_dbid, PB_STATUS, 8, 1, &temp);
	}
	
	if (DataRecordInfo(pb_dbid, PB_EDIT_INFO, NULL, NULL, NULL, NULL, NULL) != TRUE)
		DataNewRecordWithID(pb_dbid, PB_EDIT_INFO, 0, 33);
	
	if (DataRecordInfo(pb_dbid, PB_ADDR_LIST, NULL, NULL, NULL, NULL, NULL) != TRUE)
		DataNewRecordWithID(pb_dbid, PB_ADDR_LIST, 0, 2);
}


/********************************************************
* Function:	PhonebookGlobalFindReentranceRestore
* Purpose: 	This function is called to restore the data in 
the application when it is called to stopped
* Scope:		application/internal
* Input:		restart		whether the application is restart or not
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
void PhonebookGlobalFindReentranceRestore()
{
	BYTE 		application_status;
	BYTE 		*buffer;
	UWORD 		byte_read;
	WORD 		count;
	USHORT 		item_num;
	
    draw_scrollbar = FALSE;
	/* global variables initialisation */
    find_string[0] = 0;
	edit_dirty = 0;
    pressed_object = 0;
    char_start = PBCHARA;
    save_first_letter = PBCHARA;
    table_font_size = SMALL_FONT;
    SetStatus(TEL_LIST,FALSE,FALSE,0,FALSE);
    list_tel_list.list_id = LIST_NAME;
    list_find.list_id = LIST_FIND_RESULT_NAME;
    list_tel_list.dbid = list_find.dbid = 0;
    list_tel_list.max_num_items_display = list_find.max_num_items_display = 0;
    list_tel_list.num_items_display = list_find.num_items_display = 0;
    list_tel_list.total_num_items = list_find.total_num_items = 0;
    list_tel_list.top_item_num = list_find.top_item_num = 0;        
    list_tel_list.record_id_block = list_find.record_id_block = NULL;        
	
    PhonebookDatabaseChecking();
	list_tel_list.dbid = list_find.dbid = pb_dbid;
    DataGetField(pb_dbid, PB_STATUS, 0, &buffer, &byte_read);
    application_status = *buffer;
    qfree(buffer);
	
	for (count = 0; count <27; count++)
	{
		if (field_buffers[count])
			qfree(field_buffers[count]);        
    }		
	if (field_buffers)
		qfree(field_buffers);            
    field_buffers = (BYTE**)qmalloc(27*sizeof(BYTE*));
	for (count = 0; count <27; count++)
		field_buffers[count] = NULL;
    
	DataGetField(pb_dbid, PB_STATUS, 1, &buffer, &byte_read);
	edit_dirty = *buffer;
	qfree(buffer);
	
    FormInitAllFormObjects(FORM_TEL_LIST);
    FormInitAllFormObjects(FORM_VIEW_EDIT);
	
    entry_low_memory = (MemoryLow);
	entry_old_edit = ((application_status!=TEL_LIST)&&(application_status!=-1));
	
	if (entry_low_memory && entry_old_edit)
		application_status = -1;
	
    DataGetField(pb_dbid, PB_ADDR_LIST, 0, &buffer, &byte_read);
	strcpy(current_cate, buffer);
	qfree(buffer);
	
	DataGetField(pb_dbid, PB_ADDR_LIST, 1, &buffer, &byte_read);			
	char_start = *buffer;
	qfree(buffer);
	
	/* field_buffers */
	for (count = 0; count < 26; count++)
	{
		DataGetField(pb_dbid, PB_EDIT_INFO, count, &buffer, &byte_read);			
		field_buffers[count] = (BYTE*)qmalloc((strlen(buffer) + 1)*sizeof(BYTE));
		strcpy(field_buffers[count], buffer);
		qfree(buffer);
	}
	
	DataGetField(pb_dbid, PB_EDIT_INFO, 26, &buffer, &byte_read);
	field_buffers[26] = (BYTE*)qmalloc(8*sizeof(BYTE));
	field_buffers[26][0] = buffer[0];
	field_buffers[26][1] = buffer[1];
	field_buffers[26][2] = buffer[2];
	field_buffers[26][3] = buffer[3];
	field_buffers[26][4] = buffer[4];
	field_buffers[26][5] = buffer[5];
	field_buffers[26][6] = buffer[6];
	field_buffers[26][7] = buffer[7];
	qfree(buffer);
	
	/* app_status */
	app_status.status = EDIT;						
	DataGetField(pb_dbid, PB_EDIT_INFO, 27, &buffer, &byte_read);
	app_status.company = (BOOLEAN)(*buffer);
	qfree(buffer);
	
	DataGetField(pb_dbid, PB_EDIT_INFO, 28, &buffer, &byte_read);
	app_status.home = (BOOLEAN)(*buffer);
	qfree(buffer);
	
	DataGetField(pb_dbid, PB_EDIT_INFO, 29, &buffer, &byte_read);
	memcpy(char_pos,buffer,9 * sizeof(WORD));
	qfree(buffer);
	
	DataGetField(pb_dbid, PB_EDIT_INFO, 30, &buffer, &byte_read);
	app_status.rec_id = *(RecordID*)buffer;
	qfree(buffer);
	
	DataGetField(pb_dbid, PB_EDIT_INFO, 31, &buffer, &byte_read);
	app_status.new_record = (BOOLEAN)(*buffer);
	qfree(buffer);
	
	DataGetField(pb_dbid, PB_EDIT_INFO, 32, &buffer, &byte_read);
	strcpy(temp_cate, buffer);
	qfree(buffer);
	
	/* Setup FORM_VIEW_EDIT */
	PhonebookViewEditSetupScreen();
	PhonebookCateNameToPopupTrigger(pb_dbid);
	ControlPopupDeleteItem(POPUP_TRIGGER_CATE, 0);
	if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, temp_cate, &item_num) == TRUE) 
		ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
	else
		ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
	PhonebookFieldBuffersToField();
	if (save_cate != NULL)
		qfree(save_cate);
	save_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
	strcpy (save_cate, temp_cate);
    PhonebookSetViewEditTable(FORM_VIEW_EDIT, TABLE_VIEW_EDIT);
    PhonebookViewEditTableSetScrollbar(TABLE_VIEW_EDIT, SCROLLBAR_VIEW_EDIT);
    FormSetFormActiveObject(FORM_VIEW_EDIT, FIELD_ROW0);
    FieldSetInsertPointOn(FIELD_ROW0);
    FieldSetInsertPointPositionByCharPos(FIELD_ROW0, 0);
    PhonebookChangeFontSize(FORM_VIEW_EDIT, font_size);
    draw_scrollbar = TRUE;
	FormPopupForm(FORM_VIEW_EDIT);
}
