/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   editcate.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#include "app.h"

/********************************************************
* Function:	DeleteCate
* Purpose: 	This function is used to check the deleting category mode
1) the category being deleted has records attached
2) there is no record attached to the category
* Scope:		application/internal
* Input:		selected_item		the item number in the list object
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN DeleteCateCheck(SHORT selected_item)
{
	BYTE *list_text, *cate_name;
	UBYTE num_cate, cate[256];
	SHORT i = 0;
	UWORD j= 0;
	UWORD total_num_rec;
	RecordID rec_id;
	UBYTE cat;
	BOOLEAN found = FALSE;
	
	cate_name = (BYTE*)qmalloc(30*sizeof(BYTE));
	DataTotalRecord(pb_dbid, &total_num_rec);
	ListGetListItem(LIST_CATE, (USHORT)(selected_item), &list_text);
	num_cate = DataCategorySort(pb_dbid, cate);
	for (i = 0; i<num_cate; i++)
	{
		DataCategoryName(pb_dbid,cate[i],cate_name);
		if (PhonebookCompareTwoStrings(cate_name,list_text) == SAME)
		{
			DataTotalRecord(pb_dbid, &total_num_rec);
			for (j = 0; j<total_num_rec; j++)
			{
				DataNumtoRecID(pb_dbid,j, &rec_id);
				DataRecordInfo(pb_dbid,rec_id,NULL,&cat,NULL,NULL,NULL);
				if (cat == cate[i])
				{
					FormPopupForm(FORM_REMOVE_CATE);
					qfree(cate_name);
					return TRUE;
				}
			}
			FormPopupForm(FORM_ERASE_CATE);
			qfree(cate_name);
			return TRUE;
		}
	}
	qfree(cate_name);
	return TRUE;
}

/********************************************************
* Function:	DeleteCate
* Purpose: 	This function is used to delete the category and 
move all records from the previous category to unfiled
* Scope:		application/internal
* Input:		selected_item		the item number in the list object
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN DeleteCate(SHORT selected_item)
{
	
	BYTE *list_text, *cate_name;
	UBYTE num_cate, cate[256];
	SHORT i = 0;
	
	cate_name = (BYTE*)qmalloc(30*sizeof(BYTE));
	ListGetListItem(LIST_CATE, (USHORT)(selected_item), &list_text);
	
	num_cate = DataCategorySort(pb_dbid, cate);
	for (i = 0; i<num_cate; i++)
	{
		DataCategoryName(pb_dbid,cate[i],cate_name);
		if (PhonebookCompareTwoStrings(cate_name,list_text) == SAME)
		{
			ListDeleteItem(LIST_CATE,selected_item);
			DataCategorySetName(pb_dbid,cate[i],(BYTE*)(""));
			ListDrawList(LIST_CATE);
			DataMoveCat(pb_dbid,cate[i],0);
			if(strcmp(temp_cate,cate_name)==0)
				strcpy(temp_cate,PBUNFILED);
			qfree(cate_name);
			return TRUE;
		}
	}
	return FALSE;
}

/********************************************************
* Function:	PhonebookEditCateSetScrollbar
* Purpose: 	This function is called in order to set the values for a scrollbar		
* Scope:		application
* Input:		None 
* Output:		None
* Return:		TRUE		scrollbar is erased
FALSE		scrollbar is drawn
* Comment: 	If a scrollbar is not required, then the scrollbar will be erased 
If a scrollbar is required, the scrollbar will be displayed accordingly 
*********************************************************/
BOOLEAN PhonebookEditCateSetScrollbar()
{
	USHORT total_num_items;
	USHORT max_num_items_display;
	USHORT top_item_num;
	USHORT current_num_items_display;
	WORD max_value, min_value, pagesize, total_num_lines;
	BYTE object_type;
	Scrollbar *scroll_ptr;
	
	ListRecalculateMaxNumItemsDisplay(LIST_CATE);
	ListGetMaxNumItemsDisplay(LIST_CATE, &max_num_items_display);
	ListGetTotalItems(LIST_CATE, &total_num_items);
	ListGetTopItemNum(LIST_CATE, &top_item_num);
	ListGetNumItemsDisplay (LIST_CATE, &current_num_items_display);
	
	total_num_lines = total_num_items;
	pagesize = max_num_items_display;
	min_value = 0;
	max_value = total_num_lines - pagesize;	
	
	if (total_num_items > max_num_items_display)
		ScrollbarSetScrollbarVisible(SCROLLBAR_CATE, TRUE);
	else
	{
		ScrollbarSetScrollbarVisible(SCROLLBAR_CATE,FALSE);
		ScrollbarEraseScrollbar(SCROLLBAR_CATE);
		return FALSE;
	}
	
	ScrollbarSetScrollbar(SCROLLBAR_CATE, top_item_num, max_value, min_value,
		pagesize, total_num_lines);
	FormGetObjectPointer(SCROLLBAR_CATE, &object_type, (void**)&scroll_ptr);
    scroll_ptr->scrollbar_draw_pagesize = max_num_items_display;
	ScrollbarDrawScrollbar(SCROLLBAR_CATE);
	return TRUE;
	
}

/********************************************************
* Function:	PhonebookScrollbarSetEditCate
* Purpose: 	This function is called to set the edit cate list object
when the scrollbar is moved.
* Scope:		application
* Input:		Event		
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void PhonebookScrollbarSetEditCate(EvtType *Event)
{
	
	WORD max,min,value,pagesize;
	WORD scroll_total_lines;
	
	ScrollbarGetScrollbar(SCROLLBAR_CATE, &value, &max, &min, &pagesize, &scroll_total_lines);
	if ((Event->para2 - Event->para1) >= pagesize)
		ScrollbarSetScrollbar(SCROLLBAR_CATE, (Event->para2 - 1), max, min, pagesize, scroll_total_lines);
	else if ((Event->para1 - Event->para2) >= pagesize)
		ScrollbarSetScrollbar(SCROLLBAR_CATE, (Event->para2 + 1), max, min, pagesize, scroll_total_lines);
	else ScrollbarSetScrollbar(SCROLLBAR_CATE, Event->para2, max, min, pagesize, scroll_total_lines);
	
	
	ListSetTopItemNum(LIST_CATE,(USHORT)(Event->para2));
	
    if (Event->eventType == EVT_SCROLLBAR_SELECT ||
        (Event->eventType == EVT_SCROLLBAR_REPEAT))
        ListDrawList(LIST_CATE);
	
	ScrollbarDrawScrollbar(SCROLLBAR_CATE);		
}
