/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   findin.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#include "app.h"

/********************************************************
* Function:	InputFindCharInCheck
* Purpose:		to check the input catergory
* Scope:		internal
* Input:       Event 		received event
* Output:		None
* Return:		TRUE handled
FALSE if not handled
* Comment:     None
*********************************************************/
BOOLEAN InputFindCharInCheck()
{
	WORD textbox_num_chars;
	BYTE *textbox_string, *buffer;
	BYTE *string, *string1;
	UWORD i,j;
	BOOLEAN found = FALSE;
	UWORD total_num_rec;
	RecordID rec_id;
	UWORD byte_read;
	USHORT max_num_items = 0;
	BYTE *temp;
	BYTE object_type;
	Scrollbar *scroll_ptr;
    BYTE *first_name, *last_name, out_string[200];
    List *list_ptr;
	
	TextboxGetNumOfChars(TEXTBOX_FIND_INPUT,&textbox_num_chars);
	TextboxGetTextPointer(TEXTBOX_FIND_INPUT,&textbox_string);
	
    strcpy(find_string, textbox_string);
	
	DataTotalRecord(pb_dbid, &total_num_rec);
	
	FormInitAllFormObjects(FORM_FIND_RESULT);
	ListDeleteAllItems(LIST_FIND_RESULT_NAME);
	ListDeleteAllItems(LIST_FIND_RESULT_PHONE);
	ListDisplayDeleteAllRecordID(&list_find);
	temp = (BYTE*)qmalloc((strlen(textbox_string)+1)*sizeof(BYTE));
	strcpy(temp,textbox_string);
	for (i = 0; i < strlen(textbox_string);i++)
	{
		if (temp[i] >= 'a' && temp[i] <= 122)
			temp[i] -= 32;
	}
	if (textbox_num_chars == 0)
	{
		FormEraseForm(FORM_FIND_INPUT);
		FormPopupForm(FORM_NOT_FOUND);
		return TRUE;
	}
	for (i = 0; i < total_num_rec; i++)
	{
		DataOpenRecord(pb_dbid, i, &rec_id, NULL);
		DataGetField(pb_dbid, rec_id, 0, &first_name, &byte_read);
		DataGetField(pb_dbid, rec_id, 1, &last_name, &byte_read);
		PhonebookPrepareFirstLastName(first_name, last_name, out_string);
		for (j = 0; j < strlen(out_string);j++)
		{
			if (out_string[j] >= 'a' && out_string[j] <= 122)
				out_string[j] -= 32;
		}
		
		if (PhonebookSearchForText(temp, out_string) == TRUE)
		{
			found = TRUE;
			ListDisplayInsertRecordID(&list_find, rec_id);
		}
		
		qfree(first_name);
		qfree(last_name);
		
	}
	if (found == TRUE)
	{
		FormGetObjectPointer(LIST_FIND_RESULT_NAME, &object_type, (void**)&list_ptr);
		if (font_size == SMALL_FONT)
			list_ptr->list_text_font = MEDIUM_FONT;
		else
			list_ptr->list_text_font = SMALL_FONT;
		
		string = (BYTE*)qmalloc((textbox_num_chars + 14 + 1)*sizeof(BYTE));		
		string1 = string;
		strcpy(string, PB_STR1);
		string +=13;
		strcpy(string, (BYTE*)(textbox_string));
		string += textbox_num_chars;
		strcpy(string,(BYTE*)("\"\0"));
		StringSetText(STRING_FIND_RESULT,string1);
		qfree(string1);
		list_find.top_item_num = 0;
		//ListDisplayDraw(&list_find);
		if (KeyboardCheckKeyboardStatus() == TRUE)
		{
			KeyboardRestoreBitBehind();
			KeyboardSetKeyboardStatus(FALSE);
		}
		FormEraseForm(FORM_FIND_INPUT);
        PhonebookChangeFontSize(FORM_FIND_RESULT, font_size);
		FormPopupForm(FORM_FIND_RESULT);
		qfree(temp);
		return TRUE;
	}
	else
	{
		if (KeyboardCheckKeyboardStatus() == TRUE)
		{
			KeyboardRestoreBitBehind();
			KeyboardSetKeyboardStatus(FALSE);
		}
		FormEraseForm(FORM_FIND_INPUT);
		FormPopupForm(FORM_NOT_FOUND);
		qfree(temp);
		return TRUE;
	}
}

/********************************************************
* Function:	PhonebookScrollbarSetFindResult
* Purpose:		This funtion is called in order to change the list objects in 
FIND RESULT screen of the application when the scrollbar is moved
* Scope:		internal
* Input:       Event 		received event
* Output:		None
* Return:		TRUE handled
FALSE if not handled
* Comment:     None
*********************************************************/
BOOLEAN PhonebookScrollbarSetFindResult(EvtType *Event)
{
	USHORT num_items_display;
	USHORT total_num_items;
	BYTE object_type;
	Scrollbar *scroll_ptr;
	
	FormGetObjectPointer(SCROLLBAR_FIND_RESULT, &object_type, (void**)&scroll_ptr);
	num_items_display = list_find.num_items_display;
	scroll_ptr->scrollbar_draw_pagesize = num_items_display;
	total_num_items = list_find.total_num_items;
	if ((Event->para2 - Event->para1) >= (WORD)num_items_display)
	{
		ScrollbarSetScrollbar(SCROLLBAR_FIND_RESULT, (WORD)(Event->para2) - 1,
			(WORD)(total_num_items - num_items_display), 0,
			(WORD)(num_items_display),(WORD)(total_num_items));
		ListDisplaySetTopItemNum(&list_find, (USHORT)(Event->para2) - 1);
	}
	else if ((Event->para1 - Event->para2) >= (WORD)num_items_display)
	{
		ScrollbarSetScrollbar(SCROLLBAR_FIND_RESULT, (WORD)(Event->para2) + 1,
			(WORD)(total_num_items - num_items_display), 0,
			(WORD)(num_items_display),(WORD)(total_num_items));
		ListDisplaySetTopItemNum(&list_find, (USHORT)(Event->para2) + 1);
	}
	else
	{	
		ScrollbarSetScrollbar(SCROLLBAR_FIND_RESULT, (WORD)(Event->para2),
			(WORD)(total_num_items - num_items_display), 0,
			(WORD)(num_items_display),(WORD)(total_num_items));
		ListDisplaySetTopItemNum(&list_find, (USHORT)(Event->para2));
	}
	
	ScrollbarDrawScrollbar(SCROLLBAR_FIND_RESULT);
	ListDisplayDraw(&list_find);
	
	
    if (Event->eventType == EVT_SCROLLBAR_SELECT ||
        (Event->eventType == EVT_SCROLLBAR_REPEAT))
    {
        ListDrawList(LIST_FIND_RESULT_NAME);
        ListDrawList(LIST_FIND_RESULT_PHONE);
    }
	return TRUE;
}
