/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   inputcat.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#include "app.h"

/********************************************************
* Function:	InputCatCheckCharIn
* Purpose:		to check the input catergory
* Scope:		internal
* Input:       Event 		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment:     None
*********************************************************/
BOOLEAN InputCatCheckCharIn()
{
	WORD textbox_num_chars;
	BYTE *textbox_string,*list_string;
    USHORT num_items,num_items1;
    USHORT i;
	UBYTE next_free_cate_location;
	BOOLEAN found = FALSE, added = FALSE;
	UBYTE num_cat, cate[256];
	BYTE *cate_name, *delete_string;
	SHORT selected_item;
	USHORT max_num_items;
	USHORT total_num_items;
	
	TextboxGetNumOfChars(TEXTBOX_INPUT_CATE,&textbox_num_chars);
	TextboxGetTextPointer(TEXTBOX_INPUT_CATE,&textbox_string);		
    if (textbox_num_chars == 0)
	{
		FormPopupForm(FORM_EDIT_CATE);
		return TRUE;
	}
    else if (PhonebookCompareTwoStrings(textbox_string, PBALL) == SAME ||
		PhonebookCompareTwoStrings(textbox_string, PBUNFILED) == SAME ||
		PhonebookCompareTwoStrings(textbox_string, PBEDITCAT) == SAME)
	{
		FormPopupForm(FORM_EDIT_CATE);
		FormPopupForm(FORM_CATE_NAME_EXISTS);
		return TRUE;
	}
	
	if (pressed_object == BUTTON_CATE_NEW)
	{
        ListGetNumOfItems(LIST_CATE,&num_items);
		num_items1 = num_items;
		if (num_items > 0)
		{
			num_items--;
            while (num_items >=0)
			{
				ListGetListItem(LIST_CATE, num_items, &list_string);
				if (PhonebookCompareTwoStrings(textbox_string, list_string) == SAME)
				{
					FormPopupForm(FORM_EDIT_CATE);
					FormPopupForm(FORM_CATE_NAME_EXISTS);
					return TRUE;
				}
				if (num_items == 0)
					break;
				num_items--;
			}
		}
		DataCategoryNextFree(pb_dbid, &next_free_cate_location);
		DataCategorySetName(pb_dbid,next_free_cate_location,textbox_string);
		for (i = 0; i <num_items1; i++)
		{
			ListGetListItem(LIST_CATE, i, &list_string);
			if (PhonebookCompareTwoStrings(textbox_string, list_string) == FIRST)
			{
				ListInsertItem(LIST_CATE, i, textbox_string);
				PhonebookEditCateSetScrollbar();
				FormPopupForm(FORM_EDIT_CATE);
                pressed_object = 0;
				added = TRUE;
				break;
			}
		}
		if (added == FALSE) ListInsertItem(LIST_CATE, num_items1, textbox_string);
		ListGetNumOfItems(LIST_CATE, &total_num_items);
		ListGetMaxNumItemsDisplay (LIST_CATE, &max_num_items);
		if (added == FALSE || (added == TRUE && i >= (total_num_items - max_num_items)))
			ListSetTopItemNum(LIST_CATE, (USHORT)(total_num_items - max_num_items));
		else if (i < max_num_items)
			ListSetTopItemNum(LIST_CATE, 0);
        else ListSetTopItemNum(LIST_CATE, (USHORT)i);
        ListSetHighlightedItem(LIST_CATE, i);
		PhonebookEditCateSetScrollbar();
		FormPopupForm(FORM_EDIT_CATE);
        pressed_object = 0;
		return TRUE;
	}
	else if (pressed_object == BUTTON_CATE_RENAME)
	{
		ListGetNumOfItems(LIST_CATE,&num_items);
        ListGetSelectedItem(LIST_CATE,&selected_item);
		for (i =  0; i <num_items; i++)
		{
            if (i == selected_item)
                continue;
			ListGetListItem(LIST_CATE, i, &list_string);
			if (PhonebookCompareTwoStrings(textbox_string, list_string) == SAME)
			{
				found = TRUE;
				break;
			}
		}
		if (found == FALSE)
		{
			found = FALSE;
			ListGetSelectedItem(LIST_CATE,&selected_item);
			ListGetListItem(LIST_CATE, (USHORT)selected_item, &delete_string);
			num_cat = DataCategorySort(pb_dbid, cate);
			cate_name = (BYTE*)qmalloc(30*sizeof(BYTE));
			for (i = 0; i<num_cat; i++)
			{
				DataCategoryName(pb_dbid, cate[i], cate_name);
				if (PhonebookCompareTwoStrings(delete_string, cate_name) == SAME)
				{	
					DataCategorySetName(pb_dbid, cate[i],textbox_string);
					break;
				}
			}	
			ListDeleteItem(LIST_CATE,(USHORT)selected_item);
			ListGetNumOfItems(LIST_CATE,&num_items);
			found = FALSE;
			for (i = 0; i <num_items; i++)
			{
				ListGetListItem(LIST_CATE, i, &list_string);
				if (PhonebookCompareTwoStrings(textbox_string, list_string) == FIRST)
				{	
					ListInsertItem(LIST_CATE, i, textbox_string);
					found = TRUE;
					break;
				}
			}			
			if (found == FALSE)
				ListInsertItem(LIST_CATE, num_items, textbox_string);
			ListGetNumOfItems(LIST_CATE, &total_num_items);
			ListGetMaxNumItemsDisplay (LIST_CATE, &max_num_items);
			if (found == FALSE || (found == TRUE && i >= (total_num_items - max_num_items)))
				ListSetTopItemNum(LIST_CATE, (USHORT)(total_num_items - max_num_items));
			else if (i < max_num_items)
				ListSetTopItemNum(LIST_CATE, 0);
			else ListSetTopItemNum(LIST_CATE, (USHORT)i);
            ListSetHighlightedItem(LIST_CATE, i);
			PhonebookEditCateSetScrollbar();
			FormPopupForm(FORM_EDIT_CATE);
            pressed_object = 0;
			qfree(cate_name);
			return TRUE;
		}
		else
		{
			FormPopupForm(FORM_CATE_NAME_EXISTS);
			return TRUE;
		}
	}
	return FALSE;
}
