/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   main.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#include "app.h"

/* ==================================================================== */
/* ========================= Function Prototypes ====================== */
/* ==================================================================== */
void EventLoop();
static BOOLEAN ApplicationHandleEvent(EvtType *Event);

BOOLEAN (*FormDispatchEvent)(EvtType *Event);

/* ==================================================================== */
/* ========================= Global Variables ========================= */
/* ==================================================================== */
AppID app_id;
DatabaseID pb_dbid;
extern UBYTE res_data []; 
UBYTE sysres_data[1];
WORD cmd;
void *cmd_ptr;

/********************************************************
* Function:	ApplicationHandleEvent
* Purpose: 	This function is used to load the specific data of
form and set event handler of the form
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
static BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
	Form *form_ptr;
	ObjectID form_id;
	BYTE object_type;
	Err Error;
	
    if (Event->eventType == EVT_FORM_LOAD)
	{
		form_id = (ObjectID)Event->eventID;
		Error = UISearchForAddress(form_id,&object_type,(void**)&form_ptr);
		if (Event->para1 == 1 || Error != TRUE)
			FormInitForm(form_id);
		
		if (!UISearchForAddress(form_id,&object_type,(void**)&form_ptr)) return FALSE;
		
		switch (form_id)
		{
		case FORM_TEL_LIST:   FormSetEventHandler(FORM_TEL_LIST,(void**)&FormDispatchEvent, (void*)PhonebookTelList);
			break;
		case FORM_EDIT_CATE:  FormSetEventHandler(FORM_EDIT_CATE,(void**)&FormDispatchEvent, (void*)PhonebookEditCate);
			break;
		case FORM_INPUT_CATE: FormSetEventHandler(FORM_INPUT_CATE,(void**)&FormDispatchEvent, (void*)PhonebookInputCate);
			break;
		case FORM_NO_CATE:    FormSetEventHandler(FORM_NO_CATE,(void**)&FormDispatchEvent, (void*)PhonebookNoCate);
			break;
		case FORM_CATE_NAME_EXISTS:    
			FormSetEventHandler(FORM_CATE_NAME_EXISTS,(void**)&FormDispatchEvent, (void*)PhonebookNameExists);
			break;
		case FORM_ERASE_CATE: FormSetEventHandler(FORM_ERASE_CATE,(void**)&FormDispatchEvent, (void*)PhonebookEraseCate);
			break;
		case FORM_REMOVE_CATE:
			FormSetEventHandler(FORM_REMOVE_CATE,(void**)&FormDispatchEvent, (void*)PhonebookRemoveCate);
			break;
		case FORM_CATE_FULL:  FormSetEventHandler(FORM_CATE_FULL,(void**)&FormDispatchEvent, (void*)PhonebookCateFull);
			break;
		case FORM_FIND_BACKGROUND:  
			FormSetEventHandler(FORM_FIND_BACKGROUND,(void**)&FormDispatchEvent, (void*)PhonebookFindBackground);
			break;
		case FORM_FIND_INPUT: FormSetEventHandler(FORM_FIND_INPUT,(void**)&FormDispatchEvent, (void*)PhonebookFindInput);
			break;
		case FORM_NOT_FOUND:  FormSetEventHandler(FORM_NOT_FOUND,(void**)&FormDispatchEvent, (void*)PhonebookNotFound);
			break;
		case FORM_FIND_RESULT:
			FormSetEventHandler(FORM_FIND_RESULT,(void**)&FormDispatchEvent, (void*)PhonebookFindResult);
			break;
		case FORM_VIEW_EDIT:
			FormSetEventHandler(FORM_VIEW_EDIT,(void**)&FormDispatchEvent, (void*)PhonebookViewEdit);
			break;
		case FORM_ADD_ERASE:
			FormSetEventHandler(FORM_ADD_ERASE,(void**)&FormDispatchEvent, (void*)PhonebookAddErase);
			break;
		case FORM_SAVE_CHANGES:
			FormSetEventHandler(FORM_SAVE_CHANGES,(void**)&FormDispatchEvent, (void*)PhonebookSaveChanges);
			break;
		case FORM_PB_LOW_MEMORY:
			FormSetEventHandler(FORM_PB_LOW_MEMORY,(void**)&FormDispatchEvent, (void*)PhonebookLowMemoryHandle);
			break;
		case FORM_PB_DISCARD_CHANGES:
			FormSetEventHandler(FORM_PB_DISCARD_CHANGES,(void**)&FormDispatchEvent, (void*)PhonebookDiscardChangesHandle);
			break;								  
		case FORM_ALERT:
			FormSetEventHandler(FORM_ALERT,(void**)&FormDispatchEvent, (void*)PhonebookAlertEventHandler);
			break;
		case FORM_SORT:
			FormSetEventHandler(FORM_SORT,(void**)&FormDispatchEvent, (void*)PhonebookSortEventHandler);
			break;
		case FORM_SHOW:
			FormSetEventHandler(FORM_SHOW,(void**)&FormDispatchEvent, (void*)PhonebookShowEventHandler);
			break;
		case FORM_NOTES:
			FormSetEventHandler(FORM_NOTES,(void**)&FormDispatchEvent, (void*)PhonebookNotesEventHandler);
			break;
		}
		FormSetActiveForm(form_id);
		return TRUE;
	}
	return FALSE;
}

/********************************************************
* Function:	EventLoop
* Purpose: 	This function is a loop to get events from event
manager and then passes the event to different
event handler
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EventLoop(void)
{
	EvtType event;
	while(1)
	{
		EvtGetEvent (&event);
		
		if(SystemHandleEvent(&event))
			continue;
		if(MenuHandleEvent(&event))
			continue;
		if(ApplicationHandleEvent(&event))
			continue;
		FormDispatchEvent(&event);
		
		if(event.eventType==EVT_APP_STOP)
			break;
	}
}
/********************************************************
* Function:	main
* Purpose: 	main procedure of the application
* Scope:		Application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
__main(WORD cmd, void *cmd_ptr)
{
    PhonebookAppLaunch(cmd, (void*)cmd_ptr);
}
