/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   aplaunch.c
Author(s)   :   Kenny Ng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#include "stdafx.h"
#include "app.h"
#include "system.h"
#include "pdasync.h"
#include "syncfx.h"

extern WORD hport;
extern BYTE install_revert;
extern UWORD en_timer;
extern BYTE need_del;
extern BYTE set_ann_alm;
extern BYTE set_sch_alm;
extern BYTE set_todo_alm;
extern WORD is_sync;

void DisTmr();
void DeleteFailRecord();
void SetAnnAlarm();
void SetToDoAlarm();
void SetSchAlarm();
extern UWORD timeout_byte_count;


static void StartApplication(void)
{
	en_timer = 0;
	need_del = 0;
	set_todo_alm = 0;
	set_ann_alm = 0;
	set_sch_alm = 0;
	FormPopupForm(FORM_PC_SYNC);
	FormPopupForm(FORM_SYNC_LOG);
	SetTimeOutFct(NULL);
	SyncInitPort();
	SetWaitReturnFct(NULL);
	SetComHandleEvent(NULL);        
}

void PCReqSync(UBYTE x )
{
    SetWaitReturnFct(NULL);
    EvtAppendEvt(EVT_SYNC_START, 0, 0, 0, NULL);
}


void SetAlm()
{
	//        SysEnableDebug();
	SetToDoAlarm();
	SetAnnAlarm();
	SetSchAlarm();
}

/********************************************************
* Function:    SyncAppLaunch
* Purpose:     This function is called to launch the 
calculator application
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SyncAppLaunch(WORD cmd, void *cmd_ptr)
{
	switch(cmd)
	{
	case LAUNCH_CMD_NORMAL_LAUNCH:
		SysDisableDebug();
		timeout_byte_count = 0;
		is_sync = 0;
		UIApplicationInit();
		StartApplication();
		SetWaitReturnFct(PCReqSync);
		PortWaitForChar(ST_FLG, ST_FLG, ST_FLG, TRUE);    			 
		EventLoop();
		DisTmr();
		DisTimeOutTmr();
		DisBufTmr();
		SysEnableHotSyncButton();
		if(install_revert)
			UndoInstall();
		if(need_del)
			DeleteFailRecord();
		SetAlm();
		//AlarmMgrEnable(TRUE);
		UIDeleteAllAppObjects();
		ComClosePort(hport);
		return TRUE;
	case LAUNCH_CMD_FIND:
		pfree(cmd_ptr);
		return TRUE;
	case LAUNCH_CMD_GOTO_REC:
		return TRUE;
	case LAUNCH_CMD_ALARM_HIT:
		return TRUE;
	case LAUNCH_CMD_SYNC_START:
		SysDisableDebug();
		timeout_byte_count = 0;
		is_sync = 0;
		UIApplicationInit();
		StartApplication();
		EvtAppendEvt(EVT_SYNC_START, 0, 0, 0, NULL);
		EventLoop();
		DisTmr();
		DisTimeOutTmr();
		DisBufTmr();
		SysEnableHotSyncButton();
		if(install_revert)
			UndoInstall();
		if(need_del)
			DeleteFailRecord();
		SetAlm();
		//AlarmMgrEnable(TRUE);
		UIDeleteAllAppObjects();
		ComClosePort(hport);
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}
