/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   app.c
Author(s)   :   Kenny Ng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              




#include "stdafx.h"
#include "App.h"
#include "ioconmsg.h"
#include "syncfx.h"
#include "pdasync.h"
#include "uartmgr.h"
#include "dev_pwr.h"
#include "system.h"
//#define DEBUG


//#define DEBUG_MODEM

BYTE os_upgrade;
extern WORD hport;
#ifdef DEBUG_MODEM
extern int modem_hook;
#endif

extern UWORD timeout_byte_count;
extern WORD is_sync;

/********************************************************
* Function:	PCSyncMain
* Purpose: 	This function is the event handler for the FORM_PC_SYNC
screen of the PC SYNC application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PCSyncMain(EvtType *Event)
{
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_PC_SYNC);
		return TRUE;
	default: return FALSE;
	}
}


int  ClearUartBuffer(int port)
{
	BYTE data;
	BYTE i;
	
}

void PrepareUpgrade()
{
	UWORD del = 0xffff;
	register UWORD  *ptr;
	void  (*func_call) ();
	
#define UPGRADE_VECTOR ((int*)0x9fc00050)
	
	del = 0xfff;
	while(del--);
	
	CpuChangeSpeed(CPU_CLK_37M);
	
	del = 0xfff;
	while(del--);
	
	DIS_GBL_INT;
	
	del = 0xfff;
	while(del--);
	
#ifdef xxxxxxxxxxx
	__asm("li $1, 0x9fc00050");
	__asm("nop");
	__asm(jr $1);
	
	*(fct);
#endif
	
	ptr      = UPGRADE_VECTOR;
	func_call= (void*)ptr;
	
	func_call();
	
}



/********************************************************
* Function:	PCSyncLog
* Purpose: 	This function is the event handler for the FORM_SYNC_LOG
screen of the PC SYNC application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN PCSyncLog(EvtType *Event)
{
	static UBYTE init = 0;
	BYTE buf[20];
	BYTE *p;
	AppID app_id;
	USHORT d = 0xff;
	UWORD i;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		
		FormDrawForm(FORM_SYNC_LOG);
		if(!init){
			while(d--);
			ListInsertItem(LIST_SYNC_LOG, 0, SYNCSTR5);
			PCSyncListSetScrollbar();
			AlarmMgrEnable(FALSE);
			p = qmalloc(50*1024);  /* pre-alloc 50k to prevent dm append page,  -> last page should append by MemoryInstallApp()*/
			if(p)
				qfree(p);
			else
			{
				p = qmalloc(20 * 1024);
				if(p)
					qfree(p);
			}
			os_upgrade = 0;
			init = 1;
#ifdef DEBUG_MODEM
			modem_hook = 0;
#endif
			
		}
		ListDrawList(LIST_SYNC_LOG);
		
		return TRUE;
		
	case EVT_INLAY_SELECT:
		switch(Event->para1)
		{
		case INLAY_OK:
			if(!is_sync)
			{
				EvtAppendEvt(EVT_SYNC_START, 0, 0, 0, NULL);
			}
			return TRUE;
		case INLAY_EXIT:
			SysGetAppID(MAINMENU, &app_id);
			EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
			EvtAppendEvt(EVT_APP_LAUNCH, app_id, 0, 0, NULL);
			return TRUE;
		}
		case EVT_BITMAP_SELECT:
			return TRUE;
			
		case POWER_EVENT:
			
			if (Event->eventID == BAT_MAIN_LOW)
			{
				
			}
			else
				if(os_upgrade)
				{
					UBYTE battery_level;
					battery_level = (UBYTE) Event->para2;
					if(battery_level < 7)  /* at least 2.8V to upgrade */
					{
						PortSendChar(NAK);
						PortSendChar(battery_level);
						DispStr(SYNCSTR6);
					}
					else
					{
						d = 0x1ff;
						while(d--);
						PortSendChar(ACK);
						//  DispStr("Press reset to abort ...");
						PrepareUpgrade();
					}
				}
				return TRUE;
				
		case EVT_SYNC_START:
			SyncStart();
			return TRUE;
		case EVT_UART_GET_CHAR:
			BufferAddChar((UBYTE)Event->para1);
			timeout_byte_count++;
			if(ComFctPtr)
				(*ComFctPtr)((UBYTE)Event->para1);
			return TRUE;
		case EVT_UART_GET_BUFFER:
			if(BufferDoneFct)
				(*BufferDoneFct)(0);
			return TRUE;
		case EVT_IO_KEY_CTRL:
			if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
			{
				if (Event->para2 == IO_UP_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_SYNC_LOG, SCROLLBAR_UP_ARROW);
				else if (Event->para2 == IO_DOWN_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_SYNC_LOG, SCROLLBAR_DOWN_ARROW);
				return TRUE;
			}
			return FALSE;
		case EVT_SCROLLBAR_SELECT:
		case EVT_SCROLLBAR_REPEAT:
			PCSyncScrollbarSetList(Event);
			return TRUE;
		case 0x80001001:
			printf("\nGet char from Modem %c ", Event->eventID);
			return TRUE;
			
		default: return FALSE;
	}
}

void SetBitmapVisible(ObjectID idon, ObjectID idoff)
{
	BYTE type;
	Bitmap *ptr;
#ifdef DEBUG
	return;
#endif
	
	FormGetObjectPointer(idoff, &type, (void**) &ptr);
	ptr->bitmap_attr.bitmap_visible = FALSE;
	FormGetObjectPointer(idon, &type, (void**) &ptr);
	ptr->bitmap_attr.bitmap_visible = TRUE;
	//BitmapDrawBitmap(idon);
}

void SetBitmapInvisible(ObjectID id)
{
	
	BYTE type;
	Bitmap *ptr;
#ifdef DEBUG
	return;
#endif
	
	FormGetObjectPointer(id, &type, (void**) &ptr);
	
	ptr->bitmap_attr.bitmap_visible = FALSE;
	//        BitmapEraseBitmap(id);
}


void DispStateReady()
{
	SetBitmapVisible(BITMAP_PC_SYNC_0_OFF, BITMAP_PC_SYNC_0_ON);
	SetBitmapVisible(BITMAP_PC_SYNC_1_OFF, BITMAP_PC_SYNC_1_ON);
	SetBitmapVisible(BITMAP_PC_SYNC_2_OFF, BITMAP_PC_SYNC_2_ON);    
}

void DispState1()
{
	SetBitmapVisible(BITMAP_PC_SYNC_0_ON, BITMAP_PC_SYNC_0_OFF);
    SetBitmapVisible(BITMAP_PC_SYNC_1_OFF, BITMAP_PC_SYNC_1_ON);
    SetBitmapVisible(BITMAP_PC_SYNC_2_OFF, BITMAP_PC_SYNC_2_ON);    
}

void DispState2()
{
	SetBitmapVisible(BITMAP_PC_SYNC_0_OFF, BITMAP_PC_SYNC_0_ON);
    SetBitmapVisible(BITMAP_PC_SYNC_1_ON, BITMAP_PC_SYNC_1_OFF);
    SetBitmapVisible(BITMAP_PC_SYNC_2_OFF, BITMAP_PC_SYNC_2_ON);
}

void DispState3()
{
	SetBitmapVisible(BITMAP_PC_SYNC_0_OFF, BITMAP_PC_SYNC_0_ON);
    SetBitmapVisible(BITMAP_PC_SYNC_1_OFF, BITMAP_PC_SYNC_1_ON);
    SetBitmapVisible(BITMAP_PC_SYNC_2_ON, BITMAP_PC_SYNC_2_OFF);
}


/********************************************************
* Function:	PCSyncListSetScrollbar
* Purpose: 	This fucntion is called to set the settings of scrollbar
* Scope:		application
* Input:		BYTE				the starting_char
* Output:		None
* Return:		TRUE		scrollbar is erased
FALSE		scrollbar is drawn
* Comment: 	If a scrollbar is not required, then the scrollbar will be erased 
If a scrollbar is required, the scrollbar will be displayed accordingly 
*********************************************************/
BOOLEAN PCSyncListSetScrollbar()
{
	WORD 			max_value, min_value, pagesize, total_num_lines;
	BYTE 			object_type;
	Scrollbar 		*scroll_ptr;
	List 			*list_ptr;
#ifdef DEBUG
	return TRUE;
#endif
	
    FormGetObjectPointer(SCROLLBAR_SYNC_LOG, &object_type, (void**)&scroll_ptr);
    FormGetObjectPointer(LIST_SYNC_LOG, &object_type, (void**)&list_ptr);
	
	total_num_lines = list_ptr->list_total_num_items;
	pagesize = list_ptr->list_max_num_items_on_display;
	min_value = 0;
	max_value = list_ptr->list_total_num_items - pagesize;	
	
	if (list_ptr->list_total_num_items > list_ptr->list_max_num_items_on_display)
		ScrollbarSetScrollbarVisible(SCROLLBAR_SYNC_LOG,TRUE);
	else
	{
		ScrollbarSetScrollbarVisible(SCROLLBAR_SYNC_LOG,FALSE);
		ScrollbarEraseScrollbar(SCROLLBAR_SYNC_LOG);
		return FALSE;
	}
	
	if (list_ptr->list_top_item_num > (list_ptr->list_total_num_items - list_ptr->list_max_num_items_on_display))
		ScrollbarSetScrollbar(SCROLLBAR_SYNC_LOG, max_value, max_value, min_value,
		pagesize, list_ptr->list_total_num_items);
	else
        ScrollbarSetScrollbar(SCROLLBAR_SYNC_LOG, list_ptr->list_top_item_num, max_value, min_value,
		pagesize, list_ptr->list_total_num_items);
	scroll_ptr->scrollbar_draw_pagesize = pagesize;
	ScrollbarDrawScrollbar(SCROLLBAR_SYNC_LOG);
	return TRUE;
}

/********************************************************
* Function:	PCSyncScrollbarSetList
* Purpose: 	This function is called to set the list 
when the scrollbar is moved.
* Scope:		application
* Input:		Event		
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void PCSyncScrollbarSetList(EvtType *Event)
{
	
	WORD max,min,value,pagesize;
	WORD scroll_total_lines;
	BYTE *list_text;
	BYTE object_type;
	Scrollbar *scroll_ptr;
	List *list_ptr;
#ifdef DEBUG
	return;
#endif
	
	ScrollbarGetScrollbar(SCROLLBAR_SYNC_LOG, &value, &max, &min, &pagesize, &scroll_total_lines);
	ScrollbarSetScrollbar(SCROLLBAR_SYNC_LOG, Event->para2, max, min, pagesize, scroll_total_lines);
	
	FormGetObjectPointer(SCROLLBAR_SYNC_LOG, &object_type, (void**)&scroll_ptr);    
	FormGetObjectPointer(LIST_SYNC_LOG, &object_type, (void**)&list_ptr);
	
	list_ptr->list_attr.list_visible = TRUE;
	list_ptr->list_top_item_num = Event->para2;
	ListDrawList(LIST_SYNC_LOG);
	
	scroll_ptr->scrollbar_draw_pagesize = pagesize;
	ScrollbarDrawScrollbar(SCROLLBAR_SYNC_LOG);
}

