/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   combuf.c
Author(s)   :   Kenny Ng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "datatype.h"
#include "combuf.h"
#include "print.h"

UBYTE sync_buf[SYNC_BUF_SIZE];
UWORD sync_buf_len = 0;

UWORD BufferGetLength()
{
	return sync_buf_len;
}

void BufferEmpty()
{
	sync_buf_len = 0;
}

void BufferRemove(UWORD len)
{
	UWORD i;
	if (sync_buf_len <=len)
		sync_buf_len = 0;      /* remove all */
	else if(len)                   /* len != 0 */
	{
		for(i=0;i<sync_buf_len - len;i++)
			sync_buf[i] = sync_buf[i+len];
		sync_buf_len -= len;
	}
}

void BufferAddChar(UBYTE x)
{
	sync_buf[sync_buf_len ++] = x;
}

/* find char in buffer, base index = 1 */
/* return 0 if not found */
UWORD BufferFindChar(UBYTE x)
{
	UWORD i;
	
	for(i=0;i<sync_buf_len;i++)
        if(sync_buf[i]==x)
			break;
		return i;
}
