#include "software.h"
#include "softtype.h"
#include "smcmd.h"

NVRAMConfiguration nvram;
typedef Boolean (*CommandHandlerPtr)(modemCommandStruct*);
//volatile CommandHandlerPtr CommandHandler = &SoftModemCommandHandler;
volatile CommandHandlerPtr CommandHandler = (CommandHandlerPtr) 0x3000066c;
extern void SmStatusHandler(modemStatusStruct *status);
//int PrintOption = 0;

void StartATModeCmd()
{
    modemCommandStruct sm_cmd;
    sm_cmd.command = kStartATModeCmd;
    sm_cmd.param.nvramConfigurationPtr = &nvram;
    SoftModemCommandHandler(&sm_cmd);
}

void IdleCmd()
{
    modemCommandStruct sm_cmd;
    sm_cmd.command = kIdleCmd;
    SoftModemCommandHandler(&sm_cmd);
}

void V24CircuitChangeCmd()
{
    modemCommandStruct sm_cmd;
    sm_cmd.command = kV24CircuitChangeCmd;
    sm_cmd.param.v24Circuit.code = 108;
    sm_cmd.param.v24Circuit.value = 1;
    SoftModemCommandHandler(&sm_cmd);
}

void SetStatusHandlerCmd()
{
    modemCommandStruct sm_cmd;
    sm_cmd.command = kSetStatusHandlerCmd;
    sm_cmd.param.handlerSpec.statusHandlerPtr = SmStatusHandler;
    SoftModemCommandHandler(&sm_cmd);
}

void RingIndicatorCmd(int is_ring_on)
{
	modemCommandStruct sm_cmd;
	sm_cmd.command = kRingIndicatorCmd;
	sm_cmd.param.state = is_ring_on;
	SoftModemCommandHandler(&sm_cmd);
}

void RingFrequencyCmd()
{
	modemCommandStruct sm_cmd;
	sm_cmd.command = kRingFrequencyCmd;
	sm_cmd.param.state = 25;
	SoftModemCommandHandler(&sm_cmd);
}

#ifdef xxxxxxxxxx
void SmStatusHandler(modemStatusStruct *status)
{
    char temp[12];
    char statusString[256];
    extern void StatusParser(modemStatusStruct *status, char *dst);
    extern void ATPrintf(uchar *format, void *arg1, void *arg2, void *arg3);
	
    printf(" H ");
	
	if (PrintOption)
	{
        StatusParser(status, statusString);
		if (statusString[0])
			ATPrintf("%s\n", statusString, nil, nil);
	}
	/*
	StatusParser(status, statusString);
	if (statusString[0])
	printf("%s\n", statusString);
	*/
	
    switch(status->code)
    {
	case kSetSampleRate:
		break;
	case kHookStateChange:
		if (status->param.value)
		{
			TelOnHook();
		}
		else
		{
			TelOffHook();
		}
		break;
	case kSpeakerStatus:
		//                        if (status->param.speakerStatus.enabled)
		//                                CPU->REG_SIB_CTRL |= ENSND;
		//                        else
		//                                CPU->REG_SIB_CTRL &= ~ENSND;
		break;
	case kATDebugStatus:
		switch (status->param.value)
		{
		case 1:
			PrintOption = !PrintOption;
			break;
		case 2:
			RingIndicatorCmd(true);
			break;
		case 3:
			RingIndicatorCmd(false);
		default:
			break;
		}
		break;
        case kV24CircuitStatusChange:
			switch (status->param.v24Circuit.code)
			{
				//                        case V24_CD:
				//        			if(status->param.v24Circuit.value) ppp_status |= MODEM_ONLINE;
				//        			else ppp_status &= ~MODEM_ONLINE;
				//                                break;
			default:
				break;
			}
			break;
			default:
				break;
    }
}

#endif
