/* Program File	: Syscall.s
 * Company		: VTech Info-Tech Ltd.
 * Project		: PDA
 * Programmer	: Thomas Cheng
 * Date			: Dec 28, 1998
 * Revision		: 1.0
 * Comment		: SYSCALL
 * Note			: Please report to Thomas immediately if some changes are needed
 */

#include "pr3910.h"

#define SYSCALLHOOKED(name,number)    \
	.globl	name;				\
	.ent	name;				\
name:;							\
	.set	noat;				\
/*        subu            sp,40;                   \
        sw              a0,36(sp);              \
        sw              ra,32(sp);                   \
        li              a0,number;               \
        jal             SysLoadSyscallPageTable;    \
        lw              a0,36(sp);                      \
*/        li              v0,number;                      \
	syscall;					\
/*        lw              ra,32(sp);                      \
        addu            sp,40;                          \
*/        j               ra;                                     \
	.set	at;					\
	.end	name;				\

	.text

SYSCALLHOOKED(SoftModemHookInit                         ,0x80000000)
SYSCALLHOOKED(SoftModemUnHook                           ,0x80000001)
SYSCALLHOOKED(SoftModemGetMemorySize                    ,0x80000002)
SYSCALLHOOKED(SoftModemSetMemoryPtr                     ,0x80000003)
SYSCALLHOOKED(SoftModemInit                             ,0x80000004)
SYSCALLHOOKED(SoftModemLineHandler                      ,0x80000005)
SYSCALLHOOKED(SoftModemCommandHandler                   ,0x80000006)
SYSCALLHOOKED(SoftModemWrite                            ,0x80000007)
SYSCALLHOOKED(SoftModemWriteFrame                       ,0x80000008)
SYSCALLHOOKED(SoftModemRead                             ,0x80000009)
SYSCALLHOOKED(SoftModemReadFrame                        ,0x8000000a)
SYSCALLHOOKED(SoftModemCountWritePending                ,0x8000000b)
SYSCALLHOOKED(SoftModemCountReadPending                 ,0x8000000c)
SYSCALLHOOKED(SoftModemWriteFlush                       ,0x8000000d)
SYSCALLHOOKED(SoftModemReadFlush                        ,0x8000000e)
SYSCALLHOOKED(StatusParser                              ,0x8000000f)
SYSCALLHOOKED(ATPrintf                                  ,0x80000010)


SYSCALLHOOKED(TestA1                                  ,0x80000020)
SYSCALLHOOKED(TestA2                                  ,0x80000021)
SYSCALLHOOKED(TestA3                                  ,0x80000022)
SYSCALLHOOKED(TestB1                                  ,0x80000030)
SYSCALLHOOKED(TestB2                                  ,0x80000031)
SYSCALLHOOKED(TestB3                                  ,0x80000032)
SYSCALLHOOKED(TestC1                                  ,0x80000040)
SYSCALLHOOKED(TestC2                                  ,0x80000041)
SYSCALLHOOKED(TestC3                                  ,0x80000042)

