#ifndef __TDLANN_H_
#define __TDLANN_H_

#include "mmu.h"

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
extern DatabaseID	ann_dbid;
extern DatabaseID	tdl_dbid;

#define	NO_ACTIVITY							-1
#define	NO_ALARM							0
#define	TONE_ALARM							1
#define	VOICE_ALARM							2

/*======================= To Do List Database ==============*/
#define TDL_STATUS							0x80001000
#define TDL_EDIT_INFO						0x80001001

/*======================= Anniversaries Database ==============*/
#define ANN_STATUS							0x80001002
#define ANN_EDIT_INFO						0x80001003

//======================= To Do List Status Define (Close Application) ========================
#define RESTART_TO_DO_LIST					0	
#define RESTART_TO_DO_VIEWING				1
#define RESTART_TO_DO_NEW					2
#define	RESTART_TO_DO_DATE					3

//======================= Anniversaries Status Define (Close Application) ========================
#define RESTART_ANNIVER						0
#define RESTART_ANN_VIEWING					1
#define RESTART_ANN_NEW						2
#define	RESTART_ANN_WEEK_SETTINGS			3


#define	TO_DO_LIST_NUM_FIELD				13
#define NO_REPEAT							0
#define	YEARLY_REPEAT						1
#define	INCOMPLETED							0

#ifdef	PR31700
#define ANN_NUM_FIELD                       11
#define	OUT_OF_YEAR_BOUNDARY				-1
#define YEAR_FIND_BY_WEEK_NUMBER			1
#define	YEAR_ROUNDUP						2
#define YEAR_ROUNDUP_FROM_LAST_YEAR			3
#define YEAR_ROUNDUP_FROM_NEXT_YEAR			6
#define YEAR_FIND_BY_NEXT_YEAR_ROUNDUP		7
#endif
#define YEAR_FIND_BY_WEEK_AND_LAST_YEAR		4
#define	YEAR_FIND_BY_WEEK_AND_NEXT_YEAR		5

void ToDoAnnGetEventDate(SHORT search_year, SHORT search_month, SHORT search_day, RecordID *tdl_recid, RecordID *ann_recid,
						 BYTE *tdl_alarm, BYTE *ann_alarm, BYTE *todo_hit, BYTE *ann_hit);
void ToDoAnnGetEventMonth(SHORT search_year, SHORT search_month, BYTE *month_state, USHORT *num_days);
USHORT ToDoAnnFindDate2(SHORT search_year, RecordID	rec_id);
void ToDoDatabaseInit();
void ToDoListDatabaseChecking();

#ifdef	PR31700
void AnnDatabaseInit();
void AnnDatabaseChecking();
#endif

#endif
