/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   schdate.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"
#include "appfunc.h"
#include "sysetup.h"
#include "tdlann.h"

//#define DEBUG_PURGE
//#define DEBUG

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
ObjectID	prev_form_id = FORM_SCH_DAY_VIEW;
// New add 29062000
SHORT		current_mon_num;


/*****************************************************************
* Function:	SchedulerCalculateDayViewDate
* Purpose: 	This function is used to set date in the day view page
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*****************************************************************/
void SchedulerCalculateDayViewDate(SHORT year, SHORT month, SHORT day, BYTE *sbuffer)
{
	
	//BYTE	sbuffer[13];
	SHORT	j = 0;
	CountrySettings country;
	
	SySetupGetCountrySettings(&country);
	
	switch(country.date_fmt)
	{
	case SYSETUP_YMD:
		j += sprintf((char*)sbuffer + j, "%d/", year);
		/*if (month < 10)
		j += sprintf((char*)sbuffer + j, "0%d/", month);
		else*/
		j += sprintf((char*)sbuffer + j, "%d/", month);
		if (day < 10)
			j += sprintf((char*)sbuffer + j, "0%d", day);
		else
			j += sprintf((char*)sbuffer + j, "%d", day);
		break;
		
	case SYSETUP_DMY:
		if (day < 10)
			j += sprintf((char*)sbuffer + j, "0%d/", day);
		else
			j += sprintf((char*)sbuffer + j, "%d/", day);
			/*if (month < 10)
			j += sprintf((char*)sbuffer + j, "0%d/", month);
		else*/
		j += sprintf((char*)sbuffer + j, "%d/", month);
		j += sprintf((char*)sbuffer + j, "%d", year);
		break;
		
	case SYSETUP_MDY:
	/*if (month < 10)
				j += sprintf((char*)sbuffer + j, "0%d/", month);
		else*/
		j += sprintf((char*)sbuffer + j, "%d/", month);
		if (day < 10)
			j += sprintf((char*)sbuffer + j, "0%d/", day);
		else
			j += sprintf((char*)sbuffer + j, "%d/", day);
		j += sprintf((char*)sbuffer + j, "%d", year);
		break;
		
	}
	
	//StringSetText(STRING_SCH_DAY_VIEW_DATE, sbuffer);
	
	return;
}


/*****************************************************************
* Function:	SchedulerSetDayViewDate
* Purpose: 	This function is used to set date in the day view page
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*****************************************************************/
void SchedulerSetDayViewDate(SHORT year, SHORT month, SHORT day, USHORT col_num)
{
	
	BYTE	sbuffer[13];
	//	SHORT	j = 4;
	SHORT	j = 0;
	CountrySettings country;
	
	SySetupGetCountrySettings(&country);
	
	if (country.start_of_week == SYSETUP_SUN)
	{
		switch(col_num)
		{
		case 0:
			strcpy(sbuffer, SCHSUN);
			j = strlen(SCHSUN);
			break;
		case 1:
			strcpy(sbuffer, SCHMON);
			j = strlen(SCHMON);
			break;
		case 2:
			strcpy(sbuffer, SCHTUE);
			j = strlen(SCHTUE);
			break;
		case 3:
			strcpy(sbuffer, SCHWED);
			j = strlen(SCHWED);
			break;
		case 4:
			strcpy(sbuffer, SCHTHU);
			j = strlen(SCHTHU);
			break;
		case 5:
			strcpy(sbuffer, SCHFRI);
			j = strlen(SCHFRI);
			break;
		default:
			strcpy(sbuffer, SCHSAT);
			j = strlen(SCHSAT);
			break;
		}
	}
	else
	{
		switch(col_num)
		{
		case 0:
			strcpy(sbuffer, SCHMON);
			j = strlen(SCHMON);
			break;
		case 1:
			strcpy(sbuffer, SCHTUE);
			j = strlen(SCHTUE);
			break;
		case 2:
			strcpy(sbuffer, SCHWED);
			j = strlen(SCHWED);
			break;
		case 3:
			strcpy(sbuffer, SCHTHU);
			j = strlen(SCHTHU);
			break;
		case 4:
			strcpy(sbuffer, SCHFRI);
			j = strlen(SCHFRI);
			break;
		case 5:
			strcpy(sbuffer, SCHSAT);
			j = strlen(SCHSAT);
			break;
		default:
			strcpy(sbuffer, SCHSUN);
			j = strlen(SCHSUN);
			break;
			
		}
		
	}
	
	switch(country.date_fmt)
	{
	case SYSETUP_YMD:
		j += sprintf((char*)sbuffer + j, "%d/", year);
		/*if (month < 10)
		j += sprintf((char*)sbuffer + j, "0%d/", month);
		else*/
		j += sprintf((char*)sbuffer + j, "%d/", month);
		if (day < 10)
			j += sprintf((char*)sbuffer + j, "0%d", day);
		else
			j += sprintf((char*)sbuffer + j, "%d", day);
		break;
		
	case SYSETUP_DMY:
		if (day < 10)
			j += sprintf((char*)sbuffer + j, "0%d/", day);
		else
			j += sprintf((char*)sbuffer + j, "%d/", day);
			/*if (month < 10)
			j += sprintf((char*)sbuffer + j, "0%d/", month);
		else*/
		
		j += sprintf((char*)sbuffer + j, "%d/", month);
		j += sprintf((char*)sbuffer + j, "%d", year);
		break;
		
	case SYSETUP_MDY:
	/*if (month < 10)
				j += sprintf((char*)sbuffer + j, "0%d/", month);
		else*/
		j += sprintf((char*)sbuffer + j, "%d/", month);
		if (day < 10)
			j += sprintf((char*)sbuffer + j, "0%d/", day);
		else
			j += sprintf((char*)sbuffer + j, "%d/", day);
		j += sprintf((char*)sbuffer + j, "%d", year);
		break;
		
	}
	
	StringSetText(STRING_SCH_DAY_VIEW_DATE, sbuffer);
	return;
}


/*****************************************************************
* Function:	SchedulerGetDayViewDate
* Purpose: 	This function is used to get date in the day view page
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SchedulerGetDayViewDate(UBYTE *out_buf)
{
	UBYTE	*sbuffer;
	SHORT	led, mul;
	CountrySettings	country;
	
	if (!SySetupGetCountrySettings(&country))
		return FALSE;
	
	StringGetText(STRING_SCH_DAY_VIEW_DATE, (BYTE**)&sbuffer);
	
	out_buf[0] = 0;
	out_buf[1] = 0;
	out_buf[2] = 0;
	
	led = (SHORT)(strlen(sbuffer) - 1);
	mul = 1;
	
	switch(country.date_fmt)
	{
	case SYSETUP_YMD:
		while(sbuffer[led] != '/')
		{
			out_buf[2] += (UBYTE)((SHORT)((sbuffer[led]-48)*mul));
			mul *= 10;
			led--;
		}
		led--;
		mul = 1;
		while(sbuffer[led] != '/')
		{
			out_buf[1] += (UBYTE)((SHORT)((sbuffer[led]-48)*mul));
			mul *= 10;
			led--;
		}
		led--;
		mul = 1;
		while(sbuffer[led] != ' ')
		{
			out_buf[0] += (UBYTE)((SHORT)((sbuffer[led]-48)*mul));
			mul *= 10;
			led--;
		}
		out_buf[0] -= SYSETUP_YEAR_OFFSET;
		/*
		out_buf[0] = (BYTE)((SHORT)((sbuffer[4]-48)*1000)+(SHORT)((sbuffer[5]-48)*100)+
								(SHORT)((sbuffer[6]-48)*10 )+(SHORT)(sbuffer[7]-48) - SYSETUP_YEAR_OFFSET);
								out_buf[1] = (BYTE)((SHORT)((sbuffer[9]-48)*10)+(SHORT)(sbuffer[10]-48));
								out_buf[2] = (BYTE)((SHORT)((sbuffer[12]-48)*10)+(SHORT)(sbuffer[13]-48));
		*/			
		break;
		
	case SYSETUP_DMY:
		while(sbuffer[led] != '/')
		{
			out_buf[0] += (UBYTE)((SHORT)((sbuffer[led]-48)*mul));
			mul *= 10;
			led--;
		}
		out_buf[0] -= SYSETUP_YEAR_OFFSET;
		led--;
		mul = 1;
		while(sbuffer[led] != '/')
		{
			out_buf[1] += (UBYTE)((SHORT)((sbuffer[led]-48)*mul));
			mul *= 10;
			led--;
		}
		led--;
		mul = 1;
		while(sbuffer[led] != ' ')
		{
			out_buf[2] += (UBYTE)((SHORT)((sbuffer[led]-48)*mul));
			mul *= 10;
			led--;
		}
		/*
		out_buf[0] = (BYTE)((SHORT)((sbuffer[10]-48)*1000)+(SHORT)((sbuffer[11]-48)*100)+
								(SHORT)((sbuffer[12]-48)*10 )+(SHORT)(sbuffer[13]-48) - SYSETUP_YEAR_OFFSET);
								out_buf[1] = (BYTE)((SHORT)((sbuffer[7]-48)*10)+(SHORT)(sbuffer[8]-48));
								out_buf[2] = (BYTE)((SHORT)((sbuffer[4]-48)*10)+(SHORT)(sbuffer[5]-48));
		*/
		break;
		
	case SYSETUP_MDY:
		while(sbuffer[led] != '/')
		{
			out_buf[0] += (UBYTE)((SHORT)((sbuffer[led]-48)*mul));
			mul *= 10;
			led--;
		}
		out_buf[0] -= SYSETUP_YEAR_OFFSET;
		led--;
		mul = 1;
		while(sbuffer[led] != '/')
		{
			out_buf[2] += (UBYTE)((SHORT)((sbuffer[led]-48)*mul));
			mul *= 10;
			led--;
		}
		led--;
		mul = 1;
		while(sbuffer[led] != ' ')
		{
			out_buf[1] += (UBYTE)((SHORT)((sbuffer[led]-48)*mul));
			mul *= 10;
			led--;
		}
		/*
		out_buf[0] = (BYTE)((SHORT)((sbuffer[10]-48)*1000)+(SHORT)((sbuffer[11]-48)*100)+
								(SHORT)((sbuffer[12]-48)*10 )+(SHORT)(sbuffer[13]-48) - SYSETUP_YEAR_OFFSET);
								out_buf[1] = (BYTE)((SHORT)((sbuffer[4]-48)*10)+(SHORT)(sbuffer[5]-48));
								out_buf[2] = (BYTE)((SHORT)((sbuffer[7]-48)*10)+(SHORT)(sbuffer[8]-48));
		*/
		break;
	}
	
    out_buf[3] = 0;
	return TRUE;
}

/*****************************************************************
* Function:	SchedulerGotoPopupForm
* Purpose: 	This function is used to popup the forms according to the
*				popup menu
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*****************************************************************/
void SchedulerGotoPopupForm(ObjectID form_id, BOOLEAN return_prev_form)
{
	SHORT popup_item_num;
	AppID appid;
	ObjectID active_form;
	UBYTE date[4];
	
	if (return_prev_form)
	{
		switch(prev_form_id)
		{
		case FORM_SCH_DAY_VIEW:
			ControlPopupSetSelectedItem(POPUP_TRIGGER_APP_SELECT, 1);
			// ----------------------- modified at 280300 ------------------------------------------
			FormSetControlGroupSelection(FORM_SCH_DAY_VIEW, CHECKBOX_SCH_DAY_VIEW);
			// -------------------------------------------------------------------------------------
			break;
		case FORM_SCH_WEEK:
			ControlPopupSetSelectedItem(POPUP_TRIGGER_APP_SELECT, 2);
			// ----------------------- modified at 280300 ------------------------------------------
			FormSetControlGroupSelection(FORM_SCH_WEEK, CHECKBOX_SCH_WEEK_VIEW);
			// -------------------------------------------------------------------------------------
			break;
		case FORM_SCH_MONTH:
			ControlPopupSetSelectedItem(POPUP_TRIGGER_APP_SELECT, 3);
			// ----------------------- modified at 280300 ------------------------------------------
			FormSetControlGroupSelection(FORM_SCH_MONTH, CHECKBOX_SCH_MONTH_VIEW);
			// -------------------------------------------------------------------------------------
			break;
		}
		FormPopupForm(prev_form_id);
	}
	else
	{
		ControlPopupGetSelectedItem(POPUP_TRIGGER_APP_SELECT, &popup_item_num);
		switch(popup_item_num)
		{
		case 0:
#ifdef PR31700
			SysGetAppID(TODO, &appid);
#endif
			EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
			EvtAppendEvt(EVT_APP_LAUNCH, appid, LAUNCH_CMD_NORMAL_LAUNCH, 0, NULL);
			break;
		case 2:
			// ----------------------- modified at 280300 ------------------------------------------
			FormSetControlGroupSelection(FORM_SCH_WEEK, CHECKBOX_SCH_WEEK_VIEW);
			// -------------------------------------------------------------------------------------
			FormPopupForm(FORM_SCH_WEEK);
			break;
		case 3:
			// ----------------------- modified at 280300 ------------------------------------------
			FormSetControlGroupSelection(FORM_SCH_MONTH, CHECKBOX_SCH_MONTH_VIEW);
			// -------------------------------------------------------------------------------------
			FormPopupForm(FORM_SCH_MONTH);
			break;
		case 1:
			SchedulerGetDayViewDate(date);
			SchedulerDayViewLoadAppmtDataToScreen(&virtual_table, date);
			// ----------------------- modified at 280300 ------------------------------------------
			FormSetControlGroupSelection(FORM_SCH_DAY_VIEW, CHECKBOX_SCH_DAY_VIEW);
			// -------------------------------------------------------------------------------------
			FormPopupForm(FORM_SCH_DAY_VIEW);
			break;
		case 4:
#ifdef PR31700
			SysGetAppID(ANN, &appid);
#endif
			EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
			EvtAppendEvt(EVT_APP_LAUNCH, appid, LAUNCH_CMD_NORMAL_LAUNCH, 0, NULL);
			break;
		}
	}
	prev_form_id = form_id;
	
	return;
}


/*****************************************************************
* Function:	SchedulerRestoreMonthView
* Purpose: 	This function is used to restore the month view of the scheduler
* Scope:		application
* Input:		form_id					Form ID of date settings
year_push_id			The first push button ID of year selection
* Output:		row_num					Row number of the table object in date settings
col_num					Column number of the table object in date settings
* Return:		None
* Comment: 	None
*****************************************************************/
BOOLEAN SchedulerRestoreMonthView(ObjectID form_id, ObjectID table_id, ObjectID year_push_id, 
								  USHORT *row_num, USHORT *col_num, RTM timer)
{
	ObjectID	control_id;
	BYTE		year_label[5]={0}, month_text[10];
	SHORT		first_year;
	USHORT		i = 0;
	CountrySettings	country;
	
	
	if (!SySetupGetCountrySettings(&country))
		return FALSE;
	
	// --------------------------------------------------------------------
	control_id = year_push_id;
	if (timer.year < 1907)
		first_year = 1905;
	else if(timer.year > 2093)
		first_year = 2095;
	else
		first_year = timer.year - 2;
	
	sprintf((char*)year_label, "%d", first_year);
	while(i < 5)
	{
		ControlSetLabel(control_id, year_label);
		if (first_year+i == timer.year)
			FormSetControlGroupSelection(form_id, control_id);
		i++;
		sprintf((char*)year_label, "%d", first_year+i);
		control_id++;
	}
	// --------------------------------------------------------------------
	
	switch(timer.mon)
	{
	case 0:
		strcpy(month_text, SCHJAN);
		break;
	case 1:
		strcpy(month_text, SCHFEB);
		break;
	case 2:
		strcpy(month_text, SCHMAR);
		break;
	case 3:
		strcpy(month_text, SCHAPR);
		break;
	case 4:
		strcpy(month_text, SCHMAY);
		break;
	case 5:
		strcpy(month_text, SCHJUN);
		break;
	case 6:
		strcpy(month_text, SCHJUL);
		break;
	case 7:
		strcpy(month_text, SCHAUG);
		break;
	case 8:
		strcpy(month_text, SCHSEP);
		break;
	case 9:
		strcpy(month_text, SCHOCT);
		break;
	case 10:
		strcpy(month_text, SCHNOV);
		break;
	case 11:
		strcpy(month_text, SCHDEC);
		break;
	default:	return FALSE;
	}
	// ========================================================
	// new at 29062000
	current_mon_num = timer.mon;
	// ========================================================
	StringSetText(STRING_SCH_MONTH_MONTH, month_text);
	SchedulerDateUpdateMonthTable(TABLE_SCH_MONTH, timer.year, timer.mon, country.start_of_week);
	
	return TRUE;
}




/*****************************************************************
* Function:	SchedulerGetMonthViewDate
* Purpose: 	This function is used to get the date in the month view form
* Scope:		application
* Input:		row_num
col_num
* Output:		year
month
day
* Return:		None
* Comment: 	None
*****************************************************************/
void SchedulerGetMonthViewDate(USHORT row_num, USHORT col_num, SHORT *year, SHORT *month, SHORT *day)
{
	
	ObjectID	control_id;
	BYTE		*control_label, *table_text, *string_text;
	
	ControlGetPushedPushButton(FORM_SCH_MONTH, GROUP_ID_SCH_DATE_YEAR, &control_id);
	ControlGetLabel(control_id, &control_label);
	*year = ((SHORT)(control_label[0] - 48))*1000 + ((SHORT)(control_label[1] - 48))*100 + 
		((SHORT)(control_label[2] - 48))*10 + ((SHORT)(control_label[3] - 48));
	
	// ======================================================================
	// modified at 29062000
	/*
	StringGetText(STRING_SCH_MONTH_MONTH, &string_text);
	switch(string_text[2])
	{
	case 'n':
	switch(string_text[1])
	{
	case 'a':
				*month = 0;
				break;
				case 'u':
				*month = 5;
				break;
				}
				break;
				case 'b':
				*month = 1;
				break;
				case 'r':
				switch(string_text[1])
				{
				case 'a':
				*month = 2;
				break;
				case 'p':
				*month = 3;
				break;
				}
				break;
				case 'y':
				*month = 4;
				break;	
				case 'l':
				*month = 6;
				break;
				case 'g':
				*month = 7;
				break;
				case 'p':
				*month = 8;
				break;
				case 't':
				*month = 9;
				break;
				case 'v':
				*month = 10;
				break;
				case 'c':
				*month = 11;
				break;
				
				  default:	return;
				  }
	*/
	*month = current_mon_num;
	// ==============================================================
	
	TableGetItemText(TABLE_SCH_MONTH, row_num, col_num, &table_text);
	if (table_text[1] == 0)
		*day = (SHORT)(table_text[0] - 48);
	else
		*day = (SHORT)((table_text[0] - 48)*10 + table_text[1] - 48);
	
	return;
}



/*****************************************************************
* Function:	SchedulerMonthUpdateMonthView
* Purpose: 	This function is used to update the month view in the scheduler month page
* Scope:		application
* Input:		form_id					Form ID of date settings
year_push_id			The first push button ID of year selection
* Output:		row_num					Row number of the table object in date settings
col_num					Column number of the table object in date settings
* Return:		None
* Comment: 	None
*****************************************************************/
BOOLEAN SchedulerMonthUpdateMonthView(SHORT shift_action, USHORT *row_num, USHORT *col_num)
{
	
	BYTE		month_text[10];
	SHORT		year, month, day;
	CountrySettings	country;
	
	if (!SySetupGetCountrySettings(&country))
		return FALSE;
	
	SchedulerGetMonthViewDate(*row_num, *col_num, &year, &month, &day);
	
	if (shift_action == SCH_MONTH_LEFT)
	{
		switch(month)
		{
		case 0:
			strcpy(month_text, SCHDEC);
			month = 11;
			break;
		case 1:
			strcpy(month_text, SCHJAN);
			month = 0;
			break;
		case 2:
			strcpy(month_text, SCHFEB);
			month = 1;
			break;
		case 3:
			strcpy(month_text, SCHMAR);
			month = 2;
			break;
		case 4:
			strcpy(month_text, SCHAPR);
			month = 3;
			break;
		case 5:
			strcpy(month_text, SCHMAY);
			month = 4;
			break;
		case 6:
			strcpy(month_text, SCHJUN);
			month = 5;
			break;
		case 7:
			strcpy(month_text, SCHJUL);
			month = 6;
			break;
		case 8:
			strcpy(month_text, SCHAUG);
			month = 7;
			break;
		case 9:
			strcpy(month_text, SCHSEP);
			month = 8;
			break;
		case 10:
			strcpy(month_text, SCHOCT);
			month = 9;
			break;
		case 11:
			strcpy(month_text, SCHNOV);
			month = 10;
			break;
		default:	return FALSE;
		}
	}
	else
	{
		switch(month)
		{
		case 0:
			strcpy(month_text, SCHFEB);
			month = 1;
			break;
		case 1:
			strcpy(month_text, SCHMAR);
			month = 2;
			break;
		case 2:
			strcpy(month_text, SCHAPR);
			month = 3;
			break;
		case 3:
			strcpy(month_text, SCHMAY);
			month = 4;
			break;
		case 4:
			strcpy(month_text, SCHJUN);
			month = 5;
			break;
		case 5:
			strcpy(month_text, SCHJUL);
			month = 6;
			break;
		case 6:
			strcpy(month_text, SCHAUG);
			month = 7;
			break;
		case 7:
			strcpy(month_text, SCHSEP);
			month = 8;
			break;
		case 8:
			strcpy(month_text, SCHOCT);
			month = 9;
			break;
		case 9:
			strcpy(month_text, SCHNOV);
			month = 10;
			break;
		case 10:
			strcpy(month_text, SCHDEC);
			month = 11;
			break;
		case 11:
			strcpy(month_text, SCHJAN);
			month = 0;
			break;
		default:	return FALSE;
		}
	}
	
	// ==============================================================
	// new at 29062000
	current_mon_num = month;
	// ==============================================================
	
	StringSetText(STRING_SCH_MONTH_MONTH, month_text);
	StringDrawString(STRING_SCH_MONTH_MONTH);
	
	if (!SchedulerDateUpdateMonthTable(TABLE_SCH_MONTH, year, month, country.start_of_week))
		return FALSE;;
	TableEraseTable(TABLE_SCH_MONTH);
	TableDrawTable(TABLE_SCH_MONTH);
	
	return TRUE;
}



/*****************************************************************
* Function:	SchedulerDateUpdateMonthTable
* Purpose: 	This function is used to update the month view table
*				in the scheduler page
* Scope:		application
* Input:		table_id
year
month
start_of_week
* Output:		None
* Return:		TRUE if success
*				FALSE if invalid input
* Comment: 	None
*****************************************************************/
BOOLEAN SchedulerDateUpdateMonthTable(ObjectID table_id, SHORT year, SHORT month, SHORT start_of_week)
{
	RTM			time_source;
	BYTE		day_text[3] = {0}, null_string[1] = {0}, day_in_string[3] = {0}, find_rec_string[3], led_array[31]={0};
	SHORT		wday, nth_week, days_in_month, day;
	SHORT		start_cell, end_cell, current_cell, count;
	BYTE		month_state[31];
	USHORT		num_days, i, j;
	RecordID	dummy_rec_id, rec_id;
	DatabaseID	Sch_dbid;
	UWORD		total_rec;
	BYTE		month_repeat[32]={0}, total_repeat[32]={0};
	
	find_rec_string[0] = (BYTE)(year - SYSETUP_YEAR_OFFSET);
	find_rec_string[1] = (BYTE)(month + 1);
	
	if (!DataFindDB(SCHAPPDB, &Sch_dbid))
	{
		//Check whether there are repeat records in repeat database
		if (!DataTotalRecord(sch_repeat_dbid, &total_rec));
		return FALSE;
	}
	
	DataTotalRecord(sch_repeat_dbid, &total_rec);
	
	//Michelle add 291299
	for(i = 0; i < total_rec; i++)
	{
		DataOpenRecord(sch_repeat_dbid, i, &rec_id, NULL);
		SchedulerDisplayMonthViewRepeat(year, month + 1, rec_id, month_repeat);
		for(count = 0; count <= 31; count++)
			total_repeat[count] = total_repeat[count] | month_repeat[count];
		DataCloseRecord(sch_repeat_dbid, rec_id);
	}
	
	for(i=1; i<32; i++)
	{
		find_rec_string[2] = (BYTE)(i);
		
		if (DataFindBinRecord(Sch_dbid, F_DATE, 0, find_rec_string, 3, &dummy_rec_id) == TRUE)
			led_array[i] = 1;
		else
			led_array[i] = 0;
	}
	
	ToDoAnnGetEventMonth(year, month+1, month_state, &num_days);
	
	RtcGetTime(&time_source);
	if (time_source.year == year && time_source.mon == month)
		day = time_source.mday;
	else
		day = -1;
	
	//kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
	//RtcYMDToWday1(year, month, 1, &wday, &nth_week);
	wday = Dt_Date_WDay(year, month, 1);
	//kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
	
	//kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
	//days_in_month = RtcGetDaysInMonth(year, month);
	days_in_month = Dt_DaysOfMon(year, month);
	//kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
	
	current_cell = 1;
	start_cell = wday - start_of_week;
	if (start_cell < 0)
		start_cell = 6;
	end_cell = start_cell + days_in_month + 1;
	if (day > days_in_month)
		day = days_in_month;
	day += start_cell;
	day_in_string[0] = '1';
	for(i=0; i<6; i++)
	{
		for(j=0; j<7; j++)
		{
			if ((current_cell > start_cell) && (current_cell < end_cell))
			{
				if (current_cell == day)
					TableSetHighlightCell(table_id, i, j, TRUE);
				else
					TableSetHighlightCell(table_id, i, j, FALSE);
				
				if (led_array[current_cell - start_cell] == 1 || month_state[current_cell - start_cell-1] != 0
					|| total_repeat[current_cell - start_cell] == 1)
					TableSetCellHasBitmap(table_id, i, j, TRUE);
				else
					TableSetCellHasBitmap(table_id, i, j, FALSE);
				
				if ((day_in_string[0] <= '9') && (day_in_string[1] == 0))
				{
					TableSetItemText(table_id, i, j, day_in_string);
					if (day_in_string[0] < '9')
						day_in_string[0]++;
					else
					{
						day_in_string[0] = '1';
						day_in_string[1] = '0';
					}
				}
				else if((day_in_string[0] == '1') && (day_in_string[1] <= '9'))
				{
					TableSetItemText(table_id, i, j, day_in_string);
					if (day_in_string[1] < '9')
						day_in_string[1]++;
					else
					{
						day_in_string[0] = '2';
						day_in_string[1] = '0';
					}
				}
				else if((day_in_string[0] == '2') && (day_in_string[1] <= '9'))
				{
					TableSetItemText(table_id, i, j, day_in_string);
					if (day_in_string[1] < '9')
						day_in_string[1]++;
					else
					{
						day_in_string[0] = '3';
						day_in_string[1] = '0';
					}
				}
				else
				{
					TableSetItemText(table_id, i, j, day_in_string);
					day_in_string[1]++;
				}
			}
			else
			{
				TableSetItemText(table_id, i, j, null_string);
				TableSetCellHasBitmap(table_id, i, j, FALSE);
			}
			current_cell++;
		}
	}
	return TRUE;
}

/*****************************************************************
* Function:	SchedulerSortRecordOlder
* Purpose: 	This function is used to find out the record(s) which
are older than the input date
*				in the scheduler page
* Scope:		application
* Input:		table_id
* Output:		None
* Return:		TRUE if success
*				FALSE if invalid input
* Comment: 	None
*****************************************************************/
BOOLEAN SchedulerSortRecordOlderThan(BYTE year, BYTE month, BYTE day, UWORD *output_rec_num)
{
	DatabaseID	Sch_dbid;
	UWORD		total_rec;
	WORD	        input_time_value, compare_time_value;
	RecordID	rec_id;
	BYTE		*buffer;
	UWORD		byte_read;
	
	if (!DataFindDB(SCHAPPDB, &Sch_dbid))
		return FALSE;
    if (DataTotalRecord(Sch_dbid, &total_rec)!= TRUE)
        return FALSE;
    if (total_rec < 1)
        return FALSE;       
	
	input_time_value = ((WORD)year + SYSETUP_YEAR_OFFSET)*10000 + (WORD)month*100 + (WORD)day;
	
    if (total_rec == 1)
	{
        DataOpenRecord(Sch_dbid, 0, &rec_id, NULL);
		DataGetField(Sch_dbid, rec_id, F_DATE, &buffer, &byte_read);
		
		compare_time_value = ((WORD)buffer[0] + SYSETUP_YEAR_OFFSET)*10000 + (WORD)buffer[1]*100 + (WORD)buffer[2];
        if (input_time_value >= compare_time_value)
            *output_rec_num = 0;
        else return FALSE;
    }
    else
        *output_rec_num = BiSort(Sch_dbid, input_time_value, 0, (total_rec - 1), (total_rec-1)/2);
	
	return TRUE;
}


UWORD BiSort(DatabaseID Sch_dbid, WORD input_time_value, UWORD start_rec_num, UWORD end_rec_num, WORD rec_num)
{
	RecordID	rec_id;
	BYTE		*buffer;
	UWORD		byte_read;
	WORD		compare_time_value;
	
	// --------------------------------------------------------------------
    if (end_rec_num - rec_num == 1)
	{
		DataOpenRecord(Sch_dbid, end_rec_num, &rec_id, NULL);
		DataGetField(Sch_dbid, rec_id, F_DATE, &buffer, &byte_read);
		
		compare_time_value = ((WORD)buffer[0] + SYSETUP_YEAR_OFFSET)*10000 + (WORD)buffer[1]*100 + (WORD)buffer[2];
		if (input_time_value < compare_time_value)
			return rec_num;
		else
			return end_rec_num;
    }
	// --------------------------------------------------------------------
	
	DataOpenRecord(Sch_dbid, rec_num, &rec_id, NULL);
	DataGetField(Sch_dbid, rec_id, F_DATE, &buffer, &byte_read);
	
	compare_time_value = ((WORD)buffer[0] + SYSETUP_YEAR_OFFSET)*10000 + (WORD)buffer[1]*100 + (WORD)buffer[2];
	
	
	if (input_time_value != compare_time_value)
	{
		if (input_time_value < compare_time_value)
		{
			qfree(buffer);
			return BiSort(Sch_dbid, input_time_value, start_rec_num, rec_num, start_rec_num + (rec_num - start_rec_num)/2);
		}
		else
		{
			qfree(buffer);
			return BiSort(Sch_dbid, input_time_value, rec_num, end_rec_num, rec_num + (end_rec_num - rec_num)/2);
		}
		
	}
	qfree(buffer);
	return rec_num;
}


/*****************************************************************
* Function:	SchedulerUpdateWeekViewTable
* Purpose: 	This function is used to find out the record(s) which
are older than the input date
*				in the scheduler page
* Scope:		application
* Input:		table_id
* Output:		None
* Return:		TRUE if success
*				FALSE if invalid input
* Comment: 	None
*****************************************************************/
BOOLEAN SchedulerUpdateWeekViewTable(SHORT year, SHORT week_no)
{
	BYTE		text_label[30]={0}, find_rec_string[3]={0}, start_hour, end_hour;
	SHORT		mon, mday, wday, total_week_no, pre_week_no, pre_year, pre_total_week_no, dummy, d_day;
	BYTE		*buffer, tdl_alarm, ann_alarm, todo_hit, ann_hit, object_type, set_font_led, set_end_led;
	WORD		num_appmt, i, j, k, location=1;
	UWORD		rec_num, byte_read, total_rec;
	RTM		time_source;
	RecordID	rec_id, tdl_recid, ann_recid;
	Schline		*schline;
	AppointmentDB	*appmt_rec;
	CountrySettings	country;
	RTM		pDate;
	SHORT		w_len;
	
	SchlineInitSchline(SCHLINE_SCH_WEEK);
	
	if (!SySetupGetCountrySettings(&country))
		return FALSE;
	
	if (country.time_fmt == SYSETUP_12HR_DISPLAY)
		SchlineSetHourSettings(SCHLINE_SCH_WEEK, FALSE);
	else
		SchlineSetHourSettings(SCHLINE_SCH_WEEK, TRUE);
	
	RtcGetTime(&time_source);
	
	switch(country.start_of_week)
	{
	case SYSETUP_MON:
		d_day = 31;
		do
		{
			total_week_no = Dt_Date_YWeek(year, 11, d_day, country.start_of_week, &dummy);
			d_day--;
		}while(total_week_no == 1);
		
		if (week_no == total_week_no)
		{
			pre_week_no = total_week_no;
			pre_year = year;
			d_day = 31;
			do
			{
				pre_total_week_no = Dt_Date_YWeek(year, 11, d_day, country.start_of_week, &dummy);
				d_day--;
				
			}while(pre_total_week_no == 1);
		}
		else
		{
			
			pre_week_no = week_no;
			pre_year = year;
			pre_total_week_no = total_week_no;
		}
		
		sprintf((char*)text_label, SCHMON1);
		w_len = strlen(SCHMON1);
		
		Dt_YWeek_Date(year, week_no, 1, country.start_of_week, &pDate);
		mon = pDate.mon;
		mday = pDate.mday;
		sprintf((char*)text_label+w_len, " %d", mday);
		SchlineSetLineLabel(SCHLINE_SCH_WEEK, 1, text_label);
		if (week_no == 1) mon = 0;
		sprintf((char*)text_label, SCHSTR4, week_no, year, mon+1);
		StringSetText(STRING_SCH_WEEK_WEEK, text_label);
		sprintf((char*)text_label, SCHTUE1);
		w_len = strlen(SCHTUE1);
		
		Dt_YWeek_Date(year, week_no, 2, country.start_of_week, &pDate);
		mon = pDate.mon;
		mday = pDate.mday;
		sprintf((char*)text_label+w_len, " %d", mday);
		SchlineSetLineLabel(SCHLINE_SCH_WEEK, 2, text_label);
		sprintf((char*)text_label, SCHWED1);
		w_len = strlen(SCHWED1);
		
		Dt_YWeek_Date(year, week_no, 3, country.start_of_week, &pDate);
		mon = pDate.mon;
		mday = pDate.mday;
		sprintf((char*)text_label+w_len, " %d", mday);
		SchlineSetLineLabel(SCHLINE_SCH_WEEK, 3, text_label);
		sprintf((char*)text_label, SCHTHU1);
		w_len = strlen(SCHTHU1);
		
		Dt_YWeek_Date(year, week_no, 4, country.start_of_week, &pDate);
		mon = pDate.mon;
		mday = pDate.mday;
		sprintf((char*)text_label+w_len, " %d", mday);
		SchlineSetLineLabel(SCHLINE_SCH_WEEK, 4, text_label);
		sprintf((char*)text_label, SCHFRI1);
		w_len = strlen(SCHFRI1);
		
		Dt_YWeek_Date(year, week_no, 5, country.start_of_week, &pDate);
		mon = pDate.mon;
		mday = pDate.mday;
		sprintf((char*)text_label+w_len, " %d", mday);
		SchlineSetLineLabel(SCHLINE_SCH_WEEK, 5, text_label);
		sprintf((char*)text_label, SCHSAT1);
		w_len = strlen(SCHSAT1);
		
		Dt_YWeek_Date(year, week_no, 6, country.start_of_week, &pDate);
		mon = pDate.mon;
		mday = pDate.mday;
		sprintf((char*)text_label+w_len, " %d", mday);
		SchlineSetLineLabel(SCHLINE_SCH_WEEK, 6, text_label);
		sprintf((char*)text_label, SCHSUN1);
		w_len = strlen(SCHSUN1);
		
		if (pre_week_no+1 > pre_total_week_no)
		{
			if (mday == 31)
				sprintf((char*)text_label+w_len, " %d", 1);
			else sprintf((char*)text_label+w_len, " %d", mday+1);
		}
		else
		{
			Dt_YWeek_Date(pre_year, pre_week_no, 0, country.start_of_week, &pDate);
			mon = pDate.mon;
			mday = pDate.mday;
			
			if (mday > 7 && year != pre_year && pre_week_no == 1 && mday != 31)
			{
				Dt_YWeek_Date(pre_year, ++pre_week_no, 0, country.start_of_week, &pDate);
				mon = pDate.mon;
				mday = pDate.mday;
			}
			sprintf((char*)text_label+w_len, " %d", mday);
		}
		SchlineSetLineLabel(SCHLINE_SCH_WEEK, 7, text_label);
		
		SchlineSetHighlightText(SCHLINE_SCH_WEEK, 0);
		for(i=1; i<8; i++)
		{
			if (i > 6)
			{
				if (pre_week_no+1 > pre_total_week_no)
				{
					Dt_YWeek_Date(pre_year, pre_week_no, 0, country.start_of_week, &pDate);
					mon = pDate.mon;
					mday = pDate.mday;
				}
				else
				{
					Dt_YWeek_Date(pre_year, pre_week_no, 6, country.start_of_week, &pDate);
					mon = pDate.mon;
					mday = pDate.mday;
				}
				if ((time_source.year == SchedulerUpdateYearFromBoundryDay(pre_year, pre_week_no, pre_total_week_no, mon, mday))
					&&(time_source.mon == mon)&&(time_source.mday == mday))
					SchlineSetHighlightText(SCHLINE_SCH_WEEK, 7);	
				
				ToDoAnnGetEventDate(SchedulerUpdateYearFromBoundryDay(pre_year, pre_week_no, pre_total_week_no, mon, mday)
					, mon+1, mday, &tdl_recid, &ann_recid, &tdl_alarm, &ann_alarm, &todo_hit, &ann_hit);
				
			}
			else
			{
				Dt_YWeek_Date(year, week_no, (SHORT)i, country.start_of_week, &pDate);
				mon = pDate.mon;
				mday = pDate.mday;
				if ((time_source.year == SchedulerUpdateYearFromBoundryDay(year, week_no, total_week_no, mon, mday))
					&&(time_source.mon == mon)&&(time_source.mday == mday))
					SchlineSetHighlightText(SCHLINE_SCH_WEEK, i);	
				
				ToDoAnnGetEventDate(SchedulerUpdateYearFromBoundryDay(year, week_no, total_week_no, mon, mday)
					, mon+1, mday, &tdl_recid, &ann_recid, &tdl_alarm, &ann_alarm, &todo_hit, &ann_hit);
			}
			if (todo_hit == TONE_ALARM || todo_hit == VOICE_ALARM)
			{	
				if (tdl_alarm == TONE_ALARM)
				{
					if (country.time_fmt == SYSETUP_12HR_DISPLAY)
						SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i, 1, SCHLINE_TODO_12_TONE);
					else
						SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i, 1, SCHLINE_TODO_24_TONE);
				}
				if (tdl_alarm == VOICE_ALARM)
				{
					if (country.time_fmt == SYSETUP_12HR_DISPLAY)
						SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i, 1, SCHLINE_TODO_12_VOICE);
					else
						SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i, 1, SCHLINE_TODO_24_VOICE);
				}
			}
			if (ann_hit == TONE_ALARM)
			{
				if (country.time_fmt == SYSETUP_12HR_DISPLAY)
					SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i, 3, SCHLINE_ANN_12_TONE);
				else
					SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i, 3, SCHLINE_ANN_24_VOICE);
			}
			
			if (i > 6)
				find_rec_string[0] = (BYTE)(SchedulerUpdateYearFromBoundryDay(pre_year, pre_week_no, pre_total_week_no, mon, mday)
				- SYSETUP_YEAR_OFFSET);
			else
				find_rec_string[0] = (BYTE)(SchedulerUpdateYearFromBoundryDay(year, week_no, total_week_no, mon, mday)
				- SYSETUP_YEAR_OFFSET);
			
			find_rec_string[1] = (BYTE)(mon + 1);
			find_rec_string[2] = (BYTE)mday;
			if (DataFindBinRecord(sch_appmt_dbid, F_DATE, 0, find_rec_string, 3, &rec_id) == TRUE)
			{
				DataRecIDtoNum(sch_appmt_dbid, rec_id, &rec_num);
				DataOpenRecord(sch_appmt_dbid, rec_num, &rec_id, NULL);
				DataGetField(sch_appmt_dbid, rec_id, F_ALARM, &buffer, &byte_read);
				if (*buffer == 1)
				{
					qfree(buffer);
					DataGetField(sch_appmt_dbid, rec_id, 1, &buffer, &byte_read);
					SchedulerDBGetAppmtRec(buffer, byte_read, &appmt_rec, &num_appmt);
					for(j=0; j<num_appmt; j++)
					{
						if (appmt_rec[j].alarm == TONE_ALARM)
						{
							if (country.time_fmt == SYSETUP_12HR_DISPLAY)
								SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i, 2, SCHLINE_SCH_12_TONE);
							else
								SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i, 2, SCHLINE_SCH_24_TONE);
							break;
						}
						else if (appmt_rec[j].alarm == VOICE_ALARM)
						{
							if (country.time_fmt == SYSETUP_12HR_DISPLAY)
								SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i, 2, SCHLINE_SCH_12_VOICE);			
							else
								SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i, 2, SCHLINE_SCH_24_VOICE);			
							break;
						}
					}
					qfree(buffer);
					qfree(appmt_rec);
				}
				else qfree(buffer);
			}
			//31-Jan-2001 Bug Fixed
			//Add repeat alarm to week view when StartOfWeek is set Monday
			//Add repeat alarm
			DataTotalRecord(sch_repeat_dbid, &total_rec);
			Dt_YWeek_Date(year, week_no, (SHORT)i, country.start_of_week, &pDate);
			mon = pDate.mon;
			mday = pDate.mday;
			for(j = 0; j < total_rec; j++)
			{
				DataOpenRecord(sch_repeat_dbid, (UWORD)j, &rec_id, NULL);
				if (SchedulerDisplayWeekViewRepeat(pDate.year, mon, mday, rec_id, &start_hour, &end_hour))
				{
					DataGetField(sch_repeat_dbid, rec_id, F_ALARM_FLAG, &buffer, &byte_read);
					if (*buffer == 0) qfree(buffer);
					else
					{
						qfree(buffer);
						if (country.time_fmt == SYSETUP_12HR_DISPLAY)
							SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i, 2, SCHLINE_SCH_12_TONE);
						else
							SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i, 2, SCHLINE_SCH_24_TONE);
					}
				}
			}
			}
			FormDrawForm(FORM_SCH_WEEK);
			FormGetObjectPointer(SCHLINE_SCH_WEEK, &object_type, (void**)&schline);
			for(i=1; i<8; i++)
			{
				if (i > 6)
				{				
					if (pre_week_no+1 > pre_total_week_no)
					{
						Dt_YWeek_Date(pre_year, pre_week_no, 0, country.start_of_week, &pDate);
						mon = pDate.mon;
						mday = pDate.mday;
					}
					else
					{
						Dt_YWeek_Date(pre_year, pre_week_no, 0, country.start_of_week, &pDate);
						mon = pDate.mon;
						mday = pDate.mday;
						find_rec_string[0] = (BYTE)(SchedulerUpdateYearFromBoundryDay(pre_year, pre_week_no, pre_total_week_no, mon, mday)
							- SYSETUP_YEAR_OFFSET);
					}
				}
				else
				{
					Dt_YWeek_Date(year, week_no, (SHORT)i, country.start_of_week, &pDate);
					mon = pDate.mon;
					mday = pDate.mday;
					find_rec_string[0] = (BYTE)(SchedulerUpdateYearFromBoundryDay(year, week_no, total_week_no, mon, mday)
						- SYSETUP_YEAR_OFFSET);
				}
				find_rec_string[1] = (BYTE)(mon + 1);
				find_rec_string[2] = (BYTE)mday;
				if (DataFindBinRecord(sch_appmt_dbid, F_DATE, 0, find_rec_string, 3, &rec_id) == TRUE)
				{
					DataRecIDtoNum(sch_appmt_dbid, rec_id, &rec_num);
					DataOpenRecord(sch_appmt_dbid, rec_num, &rec_id, NULL);
					DataGetField(sch_appmt_dbid, rec_id, F_DATA, &buffer, &byte_read);
					SchedulerDBGetAppmtRec(buffer, byte_read, &appmt_rec, &num_appmt);
					for(j=0; j<num_appmt; j++)
					{
						if (appmt_rec[j].appointment != -1)
						{
							start_hour = appmt_rec[j].hour;
							end_hour = appmt_rec[appmt_rec[j].appointment].hour;
							set_font_led = 0;
							set_end_led = 0;
							/* put data to scheduler object */
							if (country.time_fmt == SYSETUP_12HR_DISPLAY)
							{
								for(k=start_hour; k<=end_hour; k++)
								{
									if (k > 5)
									{
										SchlineSetLineState(SCHLINE_SCH_WEEK, (SHORT)i, (SHORT)(k - 2));
										if (k != start_hour)
											SchlineDrawSmallSector(schline, (SHORT)i, (SHORT)(k - 2));
									}
									else
									{
										if (!set_font_led)
										{
											SchlineSetLineState(SCHLINE_SCH_WEEK, (SHORT)i, 1);
											set_font_led = 1;
										}
									}
								}
							}
							else
							{
								for(k=start_hour; k<=end_hour; k++)
								{
									if (k > 6 && k < 20)
									{
										SchlineSetLineState(SCHLINE_SCH_WEEK, (SHORT)i, (SHORT)(k - 4));
										if (k != start_hour)
											SchlineDrawSmallSector(schline, (SHORT)i, (SHORT)(k - 4));
									}
									else if (k < 7)
									{
										if (!set_font_led)
										{
											SchlineSetLineState(SCHLINE_SCH_WEEK, (SHORT)i, 1);
											set_font_led = 1;
										}
									}
									else
									{
										if (!set_end_led)
										{
											SchlineSetLineState(SCHLINE_SCH_WEEK, (SHORT)i, 16);
											if (start_hour != 20)
												SchlineDrawSmallSector(schline, (SHORT)i, 16);
											set_end_led = 1;
										}
									}
								}
							}
						}
					}
					qfree(buffer);
					qfree(appmt_rec);
				}
			}
			//Michelle add 180100
			//Get the repeat record from repeat database
			if (DataTotalRecord(sch_repeat_dbid, &total_rec))
			{
				for(i = 0; i < total_rec; i++)
				{
					DataOpenRecord(sch_repeat_dbid, (UWORD)i, &rec_id, NULL);
					for(j = 1; j < 8; j++)
					{
						if (j > 6)
						{
							if (pre_week_no+1 > pre_total_week_no)
							{
								Dt_YWeek_Date(pre_year, pre_week_no, 0, country.start_of_week, &pDate);
								mon = pDate.mon;
								mday = pDate.mday;
							}
							else
							{
								Dt_YWeek_Date(pre_year, pre_week_no, 0, country.start_of_week, &pDate);
								mon = pDate.mon;
								mday = pDate.mday;
							}
						}
						else
						{
							Dt_YWeek_Date(year, week_no, (SHORT)j, country.start_of_week, &pDate);
							mon = pDate.mon;
							mday = pDate.mday;
						}
						//31-Jan-2001 Bug Fixed
						//Passing the correct year to determine this repeat record is shown on this date
						if (SchedulerDisplayWeekViewRepeat(pDate.year, mon, mday, rec_id, &start_hour, &end_hour))
						{
							set_font_led = 0;
							set_end_led = 0;
							/* put data to scheduler object */
							if (country.time_fmt == SYSETUP_12HR_DISPLAY)
							{
								for(k = start_hour; k <= end_hour; k++)
								{
									if (k > 5)
									{
										SchlineSetLineState(SCHLINE_SCH_WEEK, (SHORT)(j), (SHORT)(k - 2));
										if (k != start_hour)
											SchlineDrawSmallSector(schline, (SHORT)(j), (SHORT)(k - 2));
									}
									else
									{
										if (!set_font_led)
										{
											SchlineSetLineState(SCHLINE_SCH_WEEK, (SHORT)(j), 1);
											set_font_led = 1;
										}
									}
								}
							}
							else
							{
								for(k = start_hour; k <= end_hour; k++)
								{
									if (k > 6 && k < 20)
									{
										SchlineSetLineState(SCHLINE_SCH_WEEK, (SHORT)(j), (SHORT)(k - 4));
										if (k != start_hour)
											SchlineDrawSmallSector(schline, (SHORT)(j), (SHORT)(k - 4));
									}
									else if (k < 7)
									{
										if (!set_font_led)
										{
											SchlineSetLineState(SCHLINE_SCH_WEEK, (SHORT)(j), 1);
											set_font_led = 1;
										}
									}
									else
									{
										if (!set_end_led)
										{
											SchlineSetLineState(SCHLINE_SCH_WEEK, (SHORT)(j), 16);
											if (start_hour != 20)
												SchlineDrawSmallSector(schline, (SHORT)(j), 16);
											set_end_led = 1;
										}
									}
								}
							}
						}
					}
				}
			}
			break;
		case SYSETUP_SUN:
			d_day = 31;
			do
			{
				total_week_no = Dt_Date_YWeek(year, 11, d_day, country.start_of_week, &dummy);
				d_day--;
				
			}while(total_week_no == 1);
			
			sprintf((char*)text_label, SCHSUN1);
			w_len = strlen(SCHSUN1);
			
			Dt_YWeek_Date(year, week_no, 0, country.start_of_week, &pDate);
			mon = pDate.mon;
			mday = pDate.mday;
			sprintf((char*)text_label+w_len, " %d", mday);
			SchlineSetLineLabel(SCHLINE_SCH_WEEK, 1, text_label);
			if (week_no == 1)
				mon = 0;
			sprintf((char*)text_label, SCHSTR4, week_no, year, mon+1);
			StringSetText(STRING_SCH_WEEK_WEEK, text_label);
			sprintf((char*)text_label, SCHMON1);
			w_len = strlen(SCHMON1);
			
			Dt_YWeek_Date(year, week_no, 1, country.start_of_week, &pDate);
			mon = pDate.mon;
			mday = pDate.mday;
			sprintf((char*)text_label+w_len, " %d", mday);
			SchlineSetLineLabel(SCHLINE_SCH_WEEK, 2, text_label);
			sprintf((char*)text_label, SCHTUE1);
			w_len = strlen(SCHTUE1);
			
			Dt_YWeek_Date(year, week_no, 2, country.start_of_week, &pDate);
			mon = pDate.mon;
			mday = pDate.mday;
			sprintf((char*)text_label+w_len, " %d", mday);
			SchlineSetLineLabel(SCHLINE_SCH_WEEK, 3, text_label);
			sprintf((char*)text_label, SCHWED1);
			w_len = strlen(SCHWED1);
			
			Dt_YWeek_Date(year, week_no, 3, country.start_of_week, &pDate);
			mon = pDate.mon;
			mday = pDate.mday;
			sprintf((char*)text_label+w_len, " %d", mday);
			SchlineSetLineLabel(SCHLINE_SCH_WEEK, 4, text_label);
			sprintf((char*)text_label, SCHTHU1);
			w_len = strlen(SCHTHU1);
			
			Dt_YWeek_Date(year, week_no, 4, country.start_of_week, &pDate);
			mon = pDate.mon;
			mday = pDate.mday;
			sprintf((char*)text_label+w_len, " %d", mday);
			SchlineSetLineLabel(SCHLINE_SCH_WEEK, 5, text_label);
			sprintf((char*)text_label, SCHFRI1);
			w_len = strlen(SCHFRI1);
			
			Dt_YWeek_Date(year, week_no, 5, country.start_of_week, &pDate);
			mon = pDate.mon;
			mday = pDate.mday;
			sprintf((char*)text_label+w_len, " %d", mday);
			SchlineSetLineLabel(SCHLINE_SCH_WEEK, 6, text_label);
			sprintf((char*)text_label, SCHSAT1);
			w_len = strlen(SCHSAT1);
			
			Dt_YWeek_Date(year, week_no, 6, country.start_of_week, &pDate);
			mon = pDate.mon;
			mday = pDate.mday;
			sprintf((char*)text_label+w_len, " %d", mday);
			SchlineSetLineLabel(SCHLINE_SCH_WEEK, 7, text_label);
			SchlineSetHighlightText(SCHLINE_SCH_WEEK, 0);
			for(i = 0; i < 7; i++)
			{
				Dt_YWeek_Date(year, week_no, (SHORT)i, country.start_of_week, &pDate);
				mon = pDate.mon;
				mday = pDate.mday;
				
				if ((time_source.year == SchedulerUpdateYearFromBoundryDay(year, week_no, total_week_no, mon, mday))
					&&(time_source.mon == mon)&&(time_source.mday == mday))
					SchlineSetHighlightText(SCHLINE_SCH_WEEK, i+1);
				
				ToDoAnnGetEventDate(SchedulerUpdateYearFromBoundryDay(year, week_no, total_week_no, mon, mday)
					, mon+1, mday, &tdl_recid, &ann_recid, &tdl_alarm, &ann_alarm, &todo_hit, &ann_hit);
				if (todo_hit == TONE_ALARM || todo_hit == VOICE_ALARM)
				{
					if (tdl_alarm == TONE_ALARM)
					{
						if (country.time_fmt == SYSETUP_12HR_DISPLAY)
							SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i+1, 1, SCHLINE_TODO_12_TONE);
						else
							SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i+1, 1, SCHLINE_TODO_24_TONE);
					}
					if (tdl_alarm == VOICE_ALARM)
					{
						if (country.time_fmt == SYSETUP_12HR_DISPLAY)
							SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i+1, 1, SCHLINE_TODO_12_VOICE);
						else
							SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i+1, 1, SCHLINE_TODO_24_VOICE);
					}
				}
				if (ann_hit == TONE_ALARM)
				{
					if (country.time_fmt == SYSETUP_12HR_DISPLAY)
						SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i+1, 3, SCHLINE_ANN_12_TONE);
					else
						SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i+1, 3, SCHLINE_ANN_24_VOICE);
				}
				find_rec_string[0] = (BYTE)(SchedulerUpdateYearFromBoundryDay(year, week_no, total_week_no, mon, mday)
					- SYSETUP_YEAR_OFFSET);
				find_rec_string[1] = (BYTE)(mon + 1);
				find_rec_string[2] = (BYTE)mday;
				
				if (DataFindBinRecord(sch_appmt_dbid, F_DATE, 0, find_rec_string, 3, &rec_id) == TRUE)
				{
					DataRecIDtoNum(sch_appmt_dbid, rec_id, &rec_num);
					DataOpenRecord(sch_appmt_dbid, rec_num, &rec_id, NULL);
					DataGetField(sch_appmt_dbid, rec_id, F_ALARM, &buffer, &byte_read);
					if (*buffer == 1)
					{
						qfree(buffer);
						DataGetField(sch_appmt_dbid, rec_id, 1, &buffer, &byte_read);
						SchedulerDBGetAppmtRec(buffer, byte_read, &appmt_rec, &num_appmt);
						for(j=0; j<num_appmt; j++)
						{
							if (appmt_rec[j].alarm == TONE_ALARM)
							{
								if (country.time_fmt == SYSETUP_12HR_DISPLAY)
									SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i+1, 2, SCHLINE_SCH_12_TONE);
								else
									SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i+1, 2, SCHLINE_SCH_24_TONE);
								break;
							}
							else if (appmt_rec[j].alarm == VOICE_ALARM)
							{
								if (country.time_fmt == SYSETUP_12HR_DISPLAY)
									SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i+1, 2, SCHLINE_SCH_12_VOICE);
								else
									SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i+1, 2, SCHLINE_SCH_24_VOICE);
								break;
							}
						}
						qfree(buffer);
						qfree(appmt_rec);
					}
					else qfree(buffer);
				}
				//Add repeat alarm
				DataTotalRecord(sch_repeat_dbid, &total_rec);
				Dt_YWeek_Date(year, week_no, (SHORT)i, country.start_of_week, &pDate);
				mon = pDate.mon;
				mday = pDate.mday;
				for(j = 0; j < total_rec; j++)
				{
					DataOpenRecord(sch_repeat_dbid, (UWORD)j, &rec_id, NULL);
					//31-Jan-2001 Bug Fixed
					//Passing the correct year to determine this repeat record is shown on this date
					if (SchedulerDisplayWeekViewRepeat(pDate.year, mon, mday, rec_id, &start_hour, &end_hour))
					{
						DataGetField(sch_repeat_dbid, rec_id, F_ALARM_FLAG, &buffer, &byte_read);
						if (*buffer == 0) qfree(buffer);
						else
						{
							qfree(buffer);
							if (country.time_fmt == SYSETUP_12HR_DISPLAY)
								SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i+1, 2, SCHLINE_SCH_12_TONE);
							else
								SchlineSetLineBitmap(SCHLINE_SCH_WEEK, i+1, 2, SCHLINE_SCH_24_TONE);
						}
					}
				}
			}
			FormDrawForm(FORM_SCH_WEEK);
			FormGetObjectPointer(SCHLINE_SCH_WEEK, &object_type, (void**)&schline);
			for(i=0; i<7; i++)
			{
				Dt_YWeek_Date(year, week_no, (SHORT)i, country.start_of_week, &pDate);
				mon = pDate.mon;
				mday = pDate.mday;
				find_rec_string[0] = (BYTE)(SchedulerUpdateYearFromBoundryDay(year, week_no, total_week_no, mon, mday)
					- SYSETUP_YEAR_OFFSET);
				find_rec_string[1] = (BYTE)(mon + 1);
				find_rec_string[2] = (BYTE)mday;
				if (DataFindBinRecord(sch_appmt_dbid, F_DATE, 0, find_rec_string, 3, &rec_id) == TRUE)
				{
					DataRecIDtoNum(sch_appmt_dbid, rec_id, &rec_num);
					DataOpenRecord(sch_appmt_dbid, rec_num, &rec_id, NULL);
					DataGetField(sch_appmt_dbid, rec_id, F_DATA, &buffer, &byte_read);
					SchedulerDBGetAppmtRec(buffer, byte_read, &appmt_rec, &num_appmt);
					for(j=0; j<num_appmt; j++)
					{
						if (appmt_rec[j].appointment != -1)
						{
							start_hour = appmt_rec[j].hour;
							end_hour = appmt_rec[appmt_rec[j].appointment].hour;
							set_font_led = 0;
							set_end_led = 0;
							/* put data to scheduler object */
							if (country.time_fmt == SYSETUP_12HR_DISPLAY)
							{
								for(k=start_hour; k<=end_hour; k++)
								{
									if (k > 5)
									{
										SchlineSetLineState(SCHLINE_SCH_WEEK, (SHORT)(i+1), (SHORT)(k - 2));
										if (k != start_hour)
											SchlineDrawSmallSector(schline, (SHORT)(i+1), (SHORT)(k - 2));
									}
									else
									{
										if (!set_font_led)
										{
											SchlineSetLineState(SCHLINE_SCH_WEEK, (SHORT)(i+1), 1);
											set_font_led = 1;
										}
									}
								}
							}
							else
							{
								for(k=start_hour; k<=end_hour; k++)
								{
									if (k > 6 && k < 20)
									{
										SchlineSetLineState(SCHLINE_SCH_WEEK, (SHORT)(i+1), (SHORT)(k - 4));
										if (k != start_hour)
											SchlineDrawSmallSector(schline, (SHORT)(i+1), (SHORT)(k - 4));
									}
									else if (k < 7)
									{
										if (!set_font_led)
										{
											SchlineSetLineState(SCHLINE_SCH_WEEK, (SHORT)(i+1), 1);
											set_font_led = 1;
										}
									}
									else
									{
										if (!set_end_led)
										{
											SchlineSetLineState(SCHLINE_SCH_WEEK, (SHORT)(i+1), 16);
											if (start_hour != 20)
												SchlineDrawSmallSector(schline, (SHORT)(i+1), 16);
											set_end_led = 1;
										}
									}
								}
							}
						}
					}
					qfree(buffer);
					qfree(appmt_rec);
				}
			}
			//Michelle add 030100
			//Get the repeat record from repeat database
			if (DataTotalRecord(sch_repeat_dbid, &total_rec))
			{
				for(i = 0; i < total_rec; i++)
				{
					DataOpenRecord(sch_repeat_dbid, (UWORD)i, &rec_id, NULL);
					for(j = 0; j < 7; j++)
					{
						Dt_YWeek_Date(year, week_no, (SHORT)j, country.start_of_week, &pDate);
						mon = pDate.mon;
						mday = pDate.mday;
						
						//31-Jan-2001 Bug Fixed
						//Passing the correct year to determine this repeat record is shown on this date
						if (SchedulerDisplayWeekViewRepeat(pDate.year, mon, mday, rec_id, &start_hour, &end_hour))
						{
							set_font_led = 0;
							set_end_led = 0;
							/* put data to scheduler object */
							if (country.time_fmt == SYSETUP_12HR_DISPLAY)
							{
								for(k=start_hour; k<=end_hour; k++)
								{
									if (k > 5)
									{
										SchlineSetLineState(SCHLINE_SCH_WEEK, (SHORT)(j+1), (SHORT)(k - 2));
										if (k != start_hour)
											SchlineDrawSmallSector(schline, (SHORT)(j+1), (SHORT)(k - 2));
									}
									else
									{
										if (!set_font_led)
										{
											SchlineSetLineState(SCHLINE_SCH_WEEK, (SHORT)(j+1), 1);
											set_font_led = 1;
										}
									}
								}
							}
							else
							{
								for(k=start_hour; k<=end_hour; k++)
								{
									if (k > 6 && k < 20)
									{
										SchlineSetLineState(SCHLINE_SCH_WEEK, (SHORT)(j+1), (SHORT)(k - 4));
										if (k != start_hour)
											SchlineDrawSmallSector(schline, (SHORT)(j+1), (SHORT)(k - 4));
									}
									else if (k < 7)
									{
										if (!set_font_led)
										{
											SchlineSetLineState(SCHLINE_SCH_WEEK, (SHORT)(j+1), 1);
											set_font_led = 1;
										}
									}
									else
									{
										if (!set_end_led)
										{
											SchlineSetLineState(SCHLINE_SCH_WEEK, (SHORT)(j+1), 16);
											if (start_hour != 20)
												SchlineDrawSmallSector(schline, (SHORT)(j+1), 16);
											set_end_led = 1;
										}
									}
								}
							}
						}
					}
				}
			}
			//end add 030100
			//	FormDrawForm(FORM_SCH_WEEK);
			break;
		default:
			return FALSE;
	}
	return TRUE;
}





/*****************************************************************
* Function:	SchedulerGetWeekViewWeekNum
* Purpose: 	This function is used to find out the record(s) which
are older than the input date
*				in the scheduler page
* Scope:		application
* Input:		table_id
* Output:		None
* Return:		TRUE if success
*				FALSE if invalid input
* Comment: 	None
*****************************************************************/
void SchedulerGetWeekViewWeekNum(SHORT shift_action, SHORT *year, SHORT *week_no)
{
	BYTE		*get_text;
	SHORT		wday, total_week_no, dummy, d_day;
	CountrySettings	country;
	
	// New
	
	SHORT		w_len;
	
	w_len = strlen(SCHWEEK);
	w_len += 2;
	
	StringGetText(STRING_SCH_WEEK_WEEK, &get_text);
	
	//printf("\n length of get_text = %ld", strlen(get_text));
	/*
	if (get_text[6] == ' ')
	{
	*week_no = get_text[5] - 48;
	*year = (get_text[8]-48)*1000 + (get_text[9]-48)*100 + (get_text[10]-48)*10 + get_text[11]-48;
	}
	else
	{
	*week_no = (get_text[5] - 48)*10 + get_text[6] - 48;
	*year = (get_text[9]-48)*1000 + (get_text[10]-48)*100 + (get_text[11]-48)*10 + get_text[12]-48;
	}
	*/
	// =====================================================================
	// modified at 24062000
	
	if (get_text[w_len] == ' ')
	{
		*week_no = get_text[w_len-1] - 48;
		*year = (get_text[w_len+2]-48)*1000 + (get_text[w_len+3]-48)*100 + (get_text[w_len+4]-48)*10 + get_text[w_len+5]-48;
	}
	else
	{
		*week_no = (get_text[w_len-1] - 48)*10 + get_text[w_len] - 48;
		*year = (get_text[w_len+3]-48)*1000 + (get_text[w_len+4]-48)*100 + (get_text[w_len+5]-48)*10 + get_text[w_len+6]-48;
	}
	// ======================================================================
	
	
	//kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
	//RtcYMDToWday3(year, 11, 31, &wday, &total_week_no);
	SySetupGetCountrySettings(&country);
	//total_week_no = Dt_Date_YWeek(*year, 11, 31, country.start_of_week, &dummy);
	d_day = 31;
	do
	{
		total_week_no = Dt_Date_YWeek(*year, 11, d_day, country.start_of_week, &dummy);
		d_day--;
		
	}while(total_week_no == 1);
	
	//kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
	if ((*week_no == 1) && (shift_action == -1))
	{
		*year -= 1;
		//kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
		//RtcYMDToWday3(*year, 11, 31, &wday, &total_week_no);
		//total_week_no = Dt_Date_YWeek(*year, 11, 31, country.start_of_week, &dummy);
		d_day = 31;
		do
		{
			total_week_no = Dt_Date_YWeek(*year, 11, d_day, country.start_of_week, &dummy);
			d_day--;
			
		}while(total_week_no == 1);
		
		//kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
		*week_no = total_week_no;
	}
	else if((*week_no == total_week_no) && (shift_action == 1))
	{
		*year += 1;
		*week_no = 1;
	}
	else
		*week_no += shift_action;
	
	
	return;
}

/*****************************************************************
* Function:	SchedulerRestoreDateSettings
* Purpose: 	This function is used to restore the date settings
*				from the timer
* Scope:		application
* Input:		form_id					Form ID of date settings
year_push_id			The first push button ID of year selection
month_push_id			The first push button ID of month selection	
* Output:		row_num					Row number of the table object in date settings
col_num					Column number of the table object in date settings
* Return:		None
* Comment: 	None
*****************************************************************/
void SchedulerRestoreDateSettings(ObjectID form_id, ObjectID table_id, ObjectID year_push_id, 
								  ObjectID month_push_id, USHORT *row_num, USHORT *col_num)
{
	ObjectID	control_id;
	BYTE		year_label[5]={0};
	UBYTE		out_buf[4];
	SHORT		first_year;
	USHORT		i = 0;
	RTM			timer;
	CountrySettings	country;
	
	
	SchedulerGetDayViewDate(out_buf);
	timer.year = (SHORT)out_buf[0] + SYSETUP_YEAR_OFFSET;
	timer.mon  = (SHORT)out_buf[1] - 1;
	timer.mday = (SHORT)out_buf[2];
	
	SySetupGetCountrySettings(&country);
	//----------------------------------------------
	control_id = year_push_id;
	if (timer.year < 1907)
		first_year = 1905;
	else if(timer.year > 2093)
		first_year = 2095;
	else
		first_year = timer.year - 2;
	
	sprintf((char*)year_label, "%d", first_year);
	while(i < 5)
	{
		ControlSetLabel(control_id, year_label);
		if (first_year+i == timer.year)
			FormSetControlGroupSelection(form_id, control_id);
		i++;
		sprintf((char*)year_label, "%d", first_year+i);
		control_id++;
	}
	//-----------------------------------------------------------------------
	FormSetControlGroupSelection(form_id, (ObjectID)(timer.mon + month_push_id));
	
	SySetupDateUpdateTable(table_id, timer.year, timer.mon, timer.mday,
		country.start_of_week, row_num, col_num);
	
	return;
}

/*****************************************************************
* Function:	SchedulerUpdateYearFromBoundryDay
* Purpose: 	This function is used to correct the year error due to the 
day boundary
*				in the scheduler page
* Scope:		application
* Input:		year				input year
week_no				input week num
total_week_no		total number of week
mon					input month
mday				input month of day
* Output:		None
* Return:		The correct year
* Comment: 	None
*****************************************************************/
SHORT SchedulerUpdateYearFromBoundryDay(SHORT year, SHORT week_no, SHORT total_week_no, SHORT mon, SHORT mday)
{
	
	if ((week_no == 1)&&(mon == 11))
		year--;
	else if((week_no == total_week_no)&&(mon == 0))
		year++;
	
	
	return year;
}
