/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   schdayv.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"
#include "appfunc.h"
#include "tdlann.h"

/********************************************************
* Function:	SchedulerDayViewSetScreen
* Purpose: 	This function is called to set the screen layout
* Scope:	application/internal
* Input:	vt	The pointer to virtual table object
* Output:	None
* Return:	None
* Comment: 	This function is called whenever the screen is
required to re-setup again when something happens
*********************************************************/
void SchedulerDayViewSetScreen(VirtualTable *vt)
{
	Table *table_ptr;
	Scrollbar *scroll_ptr;
	BYTE object_type;
	BYTE layer_num = 0;
	ObjectID count_id;
	Field *field_ptr;
	USHORT row_num;
	BYTE max_layer_num = -1;
	WORD start, end;
	
	FormGetObjectPointer(TABLE_SCH_DAY_VIEW, &object_type, (void**)&table_ptr);
	FormGetObjectPointer(SCROLLBAR_SCH_DAY_VIEW, &object_type, (void**)&scroll_ptr);
	
	if (KeyboardCheckKeyboardStatus() == TRUE)
	{	
		table_ptr->bounds.height = 66;
		vt->vt_bounds.height = 66;
		scroll_ptr->bounds.height = 66;
	}
	else 
	{
		table_ptr->bounds.height = 108;
		vt->vt_bounds.height = 108;
		scroll_ptr->bounds.height = 108;
	}
	
	/* check max nubmer of layer */
	for (row_num = 0; row_num < vt->vt_num_rows; row_num++)
	{
		start = (WORD)row_num;
		end = (WORD)(vt->vt_items[row_num]->appointment);
		if (end > 0)
		{
			layer_num = SchedulerDayViewSearchOverlapTime(vt, TABLE_SCH_DAY_VIEW,
				start, end);
			if (layer_num > max_layer_num)
				max_layer_num = layer_num;
		}
	}
	layer_num = max_layer_num;
	if (layer_num != 0) layer_num --;
	if (table_ptr->bounds.xcoord != (8 + (layer_num * 2)))
	{
		table_ptr->bounds.xcoord = (8 + (layer_num * 2));
		table_ptr->bounds.width =  (139 - (layer_num * 2));
		table_ptr->table_column_width[1] = 103 - (layer_num * 2);
		vt->vt_bounds = table_ptr->bounds;
		VTSetTableColumnWidth(vt, 1, (103 - (layer_num * 2)));
		for (count_id = FIELD_SCH_DAY_VIEW_0; count_id <= FIELD_SCH_DAY_VIEW_11; count_id++)
		{
			FormGetObjectPointer(count_id, &object_type, (void**)&field_ptr);
			field_ptr->bounds.width = 103 - (layer_num * 2);
			field_ptr->screen_bounds.width = 103 - (layer_num * 2);
		}
	}
}

/********************************************************
* Function:	SchedulerDayViewHighlightString
* Purpose: 	This function is called to highlight the 
string objects in the Real table				
* Scope:	application/internal
* Input:	string_id
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void SchedulerDayViewHighlightString(ObjectID string_id)
{
	BYTE object_type;
	String *string_ptr;
	
	FormGetObjectPointer(string_id, &object_type, (void**)&string_ptr);
	string_ptr->string_color = COLOR_WHITE;
	string_ptr->string_bg_color = COLOR_BLACK;
}

/********************************************************
* Function:	SchedulerDayViewNotHighlightString
* Purpose: 	This function is called not to highlight the 
string objects in the Real table				
* Scope:	application/internal
* Input:	string_id
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void SchedulerDayViewNotHighlightString(ObjectID string_id)
{
	BYTE object_type;
	String *string_ptr;
	
	FormGetObjectPointer(string_id, &object_type, (void**)&string_ptr);
	string_ptr->string_color = COLOR_BLACK;
	string_ptr->string_bg_color = COLOR_WHITE;
}

/********************************************************
* Function:	SchedulerDayViewDrawAppointmentLine
* Purpose: 	This function is called to draw an appointment line 
on the screen
* Scope:	application/internal
* Input:	vt			The pointer to virtual table
table_id		The ID value of the real table object on 
the display
start_row_num		The start row number
end_row_num		The end row_number
layer_num
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void SchedulerDayViewDrawAppointmentLine(VirtualTable *vt, 
										 ObjectID table_id,
										 WORD start_row_num,
										 WORD end_row_num,
										 BYTE layer_num)
{
	Table *table_ptr;
	BYTE object_type;
	ObjectBounds start_cell_bounds, end_cell_bounds;
	SHORT start_xcoord = 4;				
	
	FormGetObjectPointer(table_id, &object_type, (void**)&table_ptr);
	
	if (start_row_num >= (vt->vt_top_row_num + vt->vt_num_rows_displayed))
		return;
	
	if (start_row_num < vt->vt_top_row_num)
	{
		TableGetCellBounds(table_id, (USHORT)(vt->vt_top_row_num), 0, &start_cell_bounds);
		start_row_num = -1;
	}
	else if (start_row_num != -1)
		TableGetCellBounds(table_id, (USHORT)(start_row_num - vt->vt_top_row_num), 0, &start_cell_bounds);
	
	if (end_row_num >= (vt->vt_top_row_num + vt->vt_num_rows_displayed))
		end_row_num = -1;
	
	if (end_row_num != -1)
		TableGetCellBounds(table_id, (USHORT)(end_row_num - vt->vt_top_row_num), 0, &end_cell_bounds);
	
	start_xcoord = start_xcoord + (layer_num * 2);	
	if (start_row_num == -1 && end_row_num != -1)
	{
		LcdDrawLine(start_xcoord, (end_cell_bounds.ycoord + 3), 
			(start_xcoord + 1), (end_cell_bounds.ycoord + 3),
			1, NON_DOTTED_LINE,COLOR_BLACK,COLOR_BLACK);
		LcdDrawLine(start_xcoord, table_ptr->bounds.ycoord, 
			start_xcoord, (end_cell_bounds.ycoord + 3),
			1, NON_DOTTED_LINE,COLOR_BLACK,COLOR_BLACK);
	}
	else if (end_row_num == -1 && start_row_num != -1)
	{
		LcdDrawLine(start_xcoord, (start_cell_bounds.ycoord + 5), 
			(start_xcoord + 1), (start_cell_bounds.ycoord + 5),
			1, NON_DOTTED_LINE,COLOR_BLACK,COLOR_BLACK);
		LcdDrawLine(start_xcoord, (start_cell_bounds.ycoord + 5), 
			start_xcoord, (table_ptr->bounds.ycoord + table_ptr->bounds.height - 1),
			1, NON_DOTTED_LINE,COLOR_BLACK,COLOR_BLACK);
	}
	else if (end_row_num != -1 && start_row_num != -1)
	{
		LcdDrawLine(start_xcoord, (start_cell_bounds.ycoord + 5), 
			(start_xcoord + 1), (start_cell_bounds.ycoord + 5),
			1, NON_DOTTED_LINE,COLOR_BLACK,COLOR_BLACK);
		LcdDrawLine(start_xcoord, (end_cell_bounds.ycoord + 3), 
			(start_xcoord + 1), (end_cell_bounds.ycoord + 3),
			1, NON_DOTTED_LINE,COLOR_BLACK,COLOR_BLACK);
		LcdDrawLine(start_xcoord, (start_cell_bounds.ycoord + 5), 
			start_xcoord, (end_cell_bounds.ycoord + 3),
			1, NON_DOTTED_LINE,COLOR_BLACK,COLOR_BLACK);
	}
	else if (start_row_num == -1 && end_row_num == -1)
	{
		LcdDrawLine(start_xcoord, table_ptr->bounds.ycoord, 
			start_xcoord, (table_ptr->bounds.ycoord + table_ptr->bounds.height - 1),
			1, NON_DOTTED_LINE,COLOR_BLACK,COLOR_BLACK);
	}
	
}

/********************************************************
* Function:	SchedulerDayViewSearchOverLapTime
* Purpose: 	This function is called to check whether the 
range of rows is overlapped by other ranges
* Scope:	application/internal
* Input:	vt		The pointer to virtual table object
table_id	The ID value of the real table object on 
the display
start_row_num	The start row number
end_row_num	The end row_number
* Output:	None
* Return:	num_layers
* Comment: 	None
*********************************************************/
BYTE SchedulerDayViewSearchOverlapTime(VirtualTable *vt, ObjectID table_id,
									   WORD start_row_num, WORD end_row_num)
{
	BYTE object_type;
	Table *table_ptr;
	WORD vt_start_row_num, vt_end_row_num, count;
	BYTE num_layers = -1;
	
	FormGetObjectPointer(table_id, &object_type, (void**)&table_ptr);	
	
	vt_start_row_num = (USHORT)(start_row_num);
	vt_end_row_num	 = (USHORT)(end_row_num);
	
	for (count  = vt_start_row_num; count >= 0; count--)
	{
		if (vt->vt_items[count]->appointment == -1)
			continue;
		else if (vt->vt_items[count]->appointment > vt_start_row_num)
		{
			vt_start_row_num = count;
			vt_end_row_num = vt->vt_items[count]->appointment;
			num_layers ++;
		}
		if (!count) break;
	}
	return num_layers;
	
}

/********************************************************
* Function:	SchedulerDayViewDrawAppointmentColumn
* Purpose: 	This function is called to draw ALL appointment line 
on the screen
* Scope:	application/internal
* Input:	vt		The pointer to virtual table object
table_id	The ID value of the real table object on 
the display
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void SchedulerDayViewDrawAppointmentColumn(VirtualTable *vt, ObjectID table_id)
{
	Table *table_ptr;
	BYTE object_type;
	ObjectBounds bounds;
	WORD start, end;
	USHORT row_num, i, j;
	BYTE layer_num;
	WORD *temp;
	USHORT difference_0;
	USHORT difference_1;
	
	FormGetObjectPointer(table_id, &object_type, (void**)&table_ptr);
	bounds.xcoord = 3;
	bounds.ycoord = table_ptr->bounds.ycoord;
	bounds.width = table_ptr->bounds.xcoord - 1;
	bounds.height = table_ptr->bounds.height;
	LcdEraseRegion(&bounds);
	
	/* sorting */
	temp = (WORD*)qmalloc(vt->vt_num_rows*sizeof(WORD));
	for (row_num = 0; row_num < vt->vt_num_rows; row_num++)
		temp[row_num] = -1;
	
	for (row_num = 0; row_num < vt->vt_num_rows; row_num++)
	{
		if (vt->vt_items[row_num]->appointment == -1)
			continue;
		i = 0;
		while (i < vt->vt_num_rows)
		{
			if (temp[i] == -1)
			{
				temp[i] = row_num;
				break;
			}
			else
			{
				difference_0 = (USHORT)(vt->vt_items[row_num]->appointment - row_num);
				difference_1 = (USHORT)(vt->vt_items[temp[i]]->appointment - temp[i]);
				if (difference_0 >= difference_1)
				{
					j = vt->vt_num_rows - 1;
					while (j > i)
					{
						temp[j] = temp[j-1];
						j--;
					}
					temp[i] = row_num;
					break;
				}
			}
			i++;
		}
	}
	
	for (row_num = 0; row_num < vt->vt_num_rows; row_num++)
	{
		if (temp[row_num] == -1)
			break;
		start = (WORD)temp[row_num];
		end = (WORD)(vt->vt_items[temp[row_num]]->appointment);
		if (end > 0)
		{
			layer_num = SchedulerDayViewSearchOverlapTime(vt, TABLE_SCH_DAY_VIEW,
				start, end);
			if (layer_num >=0)
			{
				if (end < vt->vt_top_row_num)
					continue;
				SchedulerDayViewDrawAppointmentLine(vt, TABLE_SCH_DAY_VIEW, start,
					end, layer_num);
			}
		}
	}
	qfree(temp);
}

/********************************************************
* Function:	SchedulerHourMinuteToString
* Purpose: 	This function is to change hour and minute data
to a string
* Scope:	application/internal
* Input:	hour
minute
string			
am_pm			whether am or pm word should be added to 
the final string
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void SchedulerHourMinuteToString(BYTE hour, BYTE minute, BYTE *string, BOOLEAN am_pm)
{
	CountrySettings country;
	USHORT length;
	BYTE temp[10];
	
	if (hour == -1 && minute == -1)
	{
		strcpy(string, (BYTE*)(""));
		return;
	}
	SySetupGetCountrySettings(&country);
	if (country.time_fmt == SYSETUP_12HR_DISPLAY)
	{
		if (am_pm == TRUE)
		{
			if (hour >= 12)
				strcpy(temp, SCHPM);
			else
				strcpy(temp, SCHAM);
		}
		if (hour > 12 && hour <= 23)
			hour -= 12;
		if (hour == 0)
			hour = 12;
	}
	
	sprintf((char*)(string), "%d", hour);
	length = strlen(string);		
	string[length] = ':';
	if (minute < 10)
	{
		string[length + 1] = '0';
		string[length + 2] = '\0';
	}
	else string[length + 1] = '\0';
	
	sprintf((char*)(string + strlen(string)), "%d", minute);
	if (am_pm && country.time_fmt == SYSETUP_12HR_DISPLAY)
		sprintf((char*)(string + strlen(string)), "%s", temp);
}

/********************************************************
* Function:	SchedulerDayViewTapFieldNewAppointment
* Purpose: 	This function is called to change the layout of the display 
when a field object is tapped. 
* Scope:	application/internal
* Input:	vt		The pointer to virtual table object
table_id	The ID value of the real table object on 
the display
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerDayViewTapFieldNewAppointment(VirtualTable *vt, ObjectID table_id)
{
	BYTE	hour;
	BYTE	minute;
	BYTE	time[20];
	USHORT	table_num_rows_displaying = 0;
	WORD	max_num_lines = 0;
	WORD	count;
	WORD	num_lines_displayed = 0, total_num_lines = 0;
	
	if (vt->vt_active_row == -1) return FALSE;
	if (vt->vt_items[vt->vt_active_row]->appointment != -1) return FALSE;
	if (new_appointment == TRUE) return FALSE;
	
	new_appointment = TRUE;
	vt->vt_items[vt->vt_active_row]->appointment = vt->vt_active_row + 1;
	if (vt->vt_active_row == (vt->vt_num_rows - 1))
	{
		
		VTGetRowHourMinute(vt, (USHORT)vt->vt_active_row, &hour, &minute);
		if (hour <= 22)
			hour ++;
		else if (hour == 23)
			minute = 55;
		SchedulerHourMinuteToString(hour, minute, time, FALSE);		
		VTInsertRow(vt, vt->vt_num_rows, hour, minute, NO_ALARM, NO_ALARM, 0,
			-1, 0, FALSE, 0, 255, 0, 0, sch_voice_dbid, 0, time, (BYTE*)(""));
		vt->vt_items[vt->vt_active_row]->appointment = vt->vt_active_row + 1;
		
		TableGetNumOfRowsDisplayed(TABLE_SCH_DAY_VIEW, &table_num_rows_displaying);
		VTGetTableMaxNumLines(vt, &max_num_lines);
		
		for (count = 0; count < table_num_rows_displaying; count++)
		{
			FieldGetNumOfLinesDisplayed((ObjectID)(count + FIELD_SCH_DAY_VIEW_0), &num_lines_displayed);
			total_num_lines += num_lines_displayed;
			if (total_num_lines >= max_num_lines)
				break;
		}
		
		if (total_num_lines >= max_num_lines)
			vt->vt_top_row_num ++;
	}
	
	//VTECH
    if (!KeyboardCheckKeyboardStatus())
    {
        SchedulerTimeSettingsDeleteAllEmptyAppmts(&virtual_table);
        SchedulerTimeSettingsAddAppmts(&virtual_table);
    }
	SchedulerDayViewSetScreen(&virtual_table);
	VTSetVirtualTableLayout(&virtual_table);
	VTVirtualTableSetScrollbar(&virtual_table);
	VTTransferAllToRT(&virtual_table, TABLE_SCH_DAY_VIEW);
	TableDrawTable(TABLE_SCH_DAY_VIEW);
	SchedulerDayViewDrawAppointmentColumn(&virtual_table, TABLE_SCH_DAY_VIEW);
	return TRUE;
}

/********************************************************
* Function:	SchedulerDayViewNormal
* Purpose: 	This function is called to change the new appointment 
back to normal
* Scope:	application/internal
* Input:	vt		The pointer to virtual table object
table_id	The ID value of the real table object on 
the display
* Output:	start_row
end_row
* Return:	None
* Comment: 	None
*********************************************************/
BYTE SchedulerDayViewNormal(VirtualTable *vt, ObjectID table_id, USHORT *start_row, USHORT *end_row,
							BOOLEAN *start_deleted, BOOLEAN *end_deleted)
{
	BYTE	*field_text;
	BOOLEAN delete_row = TRUE;
	USHORT	i = 0;
	BYTE	output = VT_TABLE_NOT_CHANGED;
	WORD	temp_be_appointment = -1, temp_be_appointment1 = -1;
	
    new_appointment = FALSE;
	if (vt->vt_active_row == -1) 
		return VT_TABLE_NOT_CHANGED;
	
	*start_row = (USHORT)(vt->vt_active_row);
	*end_row = (USHORT)(vt->vt_items[vt->vt_active_row]->appointment);
	*start_deleted = FALSE;
	*end_deleted = FALSE;
	
	while (i < vt->vt_num_rows)
	{
		if ((vt->vt_items[i]->appointment == vt->vt_items[vt->vt_active_row]->appointment && (vt->vt_items[i]->alarm != NO_ALARM ||
			strlen(vt->vt_items[i]->ptr->field_string) != 0)) ||
			(SchedulerDayViewCheckRowNumCovered(vt, (USHORT)(vt->vt_items[vt->vt_active_row]->appointment)) <= 1 &&
			vt->vt_items[vt->vt_items[vt->vt_active_row]->appointment]->minute == 0 &&
			vt->vt_items[vt->vt_items[vt->vt_active_row]->appointment]->hour >= 8 &&
			vt->vt_items[vt->vt_items[vt->vt_active_row]->appointment]->hour <= 19))
		{	
			delete_row = FALSE;
			break;
		}
		i++;
	}
	
	if (vt->vt_items[vt->vt_items[vt->vt_active_row]->appointment]->appointment == -1 && delete_row == TRUE &&
		vt->vt_items[vt->vt_items[vt->vt_active_row]->appointment]->alarm == NO_ALARM)
	{
		VTDeleteRow(vt, (USHORT)(vt->vt_items[vt->vt_active_row]->appointment));
		*end_deleted = TRUE;
		output = VT_TABLE_CHANGED;
	}
	
	
	delete_row = TRUE;
	i = 0;
	while (i < vt->vt_num_rows)
	{
		if ((vt->vt_items[i]->appointment == vt->vt_active_row) ||
			(SchedulerDayViewCheckRowNumCovered(vt, (USHORT)(vt->vt_active_row)) == 0 &&
			vt->vt_items[vt->vt_active_row]->minute == 0 &&
			vt->vt_items[vt->vt_active_row]->hour >= 8 &&
			vt->vt_items[vt->vt_active_row]->hour <= 19))
		{	
			delete_row = FALSE;
			break;
		}
		i++;
	}
	
	field_text = vt->vt_items[vt->vt_active_row]->ptr->field_string;
	if (strlen(field_text) == 0 && vt->vt_items[vt->vt_active_row]->alarm == NO_ALARM)
	{
		vt->vt_items[vt->vt_active_row]->appointment	= -1;
		vt->vt_items[vt->vt_active_row]->appmt_num		= 0;
		output = VT_TABLE_CHANGED;
	}
	
	if (vt->vt_items[vt->vt_active_row]->appointment == -1 && delete_row == TRUE &&
		vt->vt_items[vt->vt_active_row]->alarm == NO_ALARM)
	{
		VTDeleteRow(vt, (USHORT)(vt->vt_active_row));
		*start_deleted = TRUE;
		output = VT_TABLE_CHANGED;
	}
	
	return output;
}

/********************************************************
* Function:	SchedulerStringHandleEvent
* Purpose:	to handle the event that has occured in the string object
in FORM_SCH_DAY_VIEW
* Scope:	application/internal
* Input:       Event 		received event
* Output:	None
* Return:	TRUE if handled
FALSE if not handled
* Comment:     None
*********************************************************/
BOOLEAN SchedulerStringHandleEvent(EvtType *Event)
{
	Table *table_ptr;
	String *string_ptr;
	BYTE object_type;
	ObjectID count_id;
	BYTE output;
	BOOLEAN done= FALSE;
	USHORT start_row, end_row;
	BOOLEAN start_deleted, end_deleted;
	
	FormGetObjectPointer(TABLE_SCH_DAY_VIEW, &object_type, (void**)&table_ptr);
	switch (Event->eventType)
	{
	case PEN_EVENT:
		switch (Event->eventID)
		{
		case PEN_UP:
			switch (day_view_old_event.eventType)
			{
			case EVT_DAY_VIEW_STRING_ENTER:
				EvtAppendEvt(EVT_DAY_VIEW_STRING_SELECT, day_view_old_event.eventID,
					day_view_old_event.para1, 0, day_view_old_event.evtPBP);
				//Bug Fixed 5-Feb-2001
				//--------------------------------------------------- Adding Codes
				//				if ((virtual_table.vt_top_row_num + (count_id - STRING_SCH_DAY_VIEW_0)) == virtual_table.vt_active_row)
				if ((virtual_table.vt_top_row_num + (day_view_old_event.eventID - STRING_SCH_DAY_VIEW_0)) == virtual_table.vt_active_row)
					return TRUE;
				//--------------------------------------------------- Adding Codes
				if (virtual_table.vt_active_row != -1)
				{
					SchedulerDayViewNotHighlightString((ObjectID)(virtual_table.vt_active_row - 
						virtual_table.vt_top_row_num +
						STRING_SCH_DAY_VIEW_0));
					// Modified at 07072000
					if ((virtual_table.vt_active_row > virtual_table.vt_top_row_num) &&
						(virtual_table.vt_active_row < (virtual_table.vt_top_row_num + virtual_table.vt_num_rows_displayed)))
						StringDrawString((ObjectID)(virtual_table.vt_active_row - virtual_table.vt_top_row_num + STRING_SCH_DAY_VIEW_0));
				}
				//Bug Fixed 5-Feb-2001
				//Dont remark the codes
				output = SchedulerDayViewNormal(&virtual_table, TABLE_SCH_DAY_VIEW, &start_row,
					&end_row, &start_deleted, &end_deleted);
				
				if (output == VT_TABLE_CHANGED)
				{
					virtual_table.vt_active_row = (Event->eventID - FIELD_SCH_DAY_VIEW_0) + virtual_table.vt_top_row_num;
					if (virtual_table.vt_active_row == virtual_table.vt_num_rows)
					{
						virtual_table.vt_active_row = -1;
						if (virtual_table.vt_top_row_num != 0)
							virtual_table.vt_top_row_num --;
						LcdEnableInsertPt(FALSE, 0, 0, SMALL_FONT);
						done = TRUE;
					}
					virtual_table.vt_active_row = -1;
					SchedulerDayViewSetScreen(&virtual_table);
					VTSetVirtualTableLayout(&virtual_table);
					VTVirtualTableSetScrollbar(&virtual_table);
					VTTransferAllToRT(&virtual_table, TABLE_SCH_DAY_VIEW);
					TableDrawTable(TABLE_SCH_DAY_VIEW);
					SchedulerDayViewDrawAppointmentColumn(&virtual_table, TABLE_SCH_DAY_VIEW);
				}
				else
					VTTransferFieldToVT(&virtual_table, TABLE_SCH_DAY_VIEW);
				day_view_old_event.eventType = NULL_EVENT;
				return TRUE;
			case EVT_DAY_VIEW_STRING_EXIT:
				//Bug Fixed 5-Feb-2001
				//--------------------------------------------------- Adding Codes
				//				if ((virtual_table.vt_top_row_num + (count_id - STRING_SCH_DAY_VIEW_0)) == virtual_table.vt_active_row)
				if ((virtual_table.vt_top_row_num + (day_view_old_event.eventID - STRING_SCH_DAY_VIEW_0)) == virtual_table.vt_active_row)
					return TRUE;
				//--------------------------------------------------- Adding Codes
				if (virtual_table.vt_active_row != -1)
				{
					SchedulerDayViewNotHighlightString((ObjectID)(virtual_table.vt_active_row - 
						virtual_table.vt_top_row_num +
						STRING_SCH_DAY_VIEW_0));
					if ((virtual_table.vt_active_row > virtual_table.vt_top_row_num) &&
						(virtual_table.vt_active_row < (virtual_table.vt_top_row_num + virtual_table.vt_num_rows_displayed)))
						StringDrawString((ObjectID)(virtual_table.vt_active_row - virtual_table.vt_top_row_num + STRING_SCH_DAY_VIEW_0));
				}
				//Bug Fixed 5-Feb-2001
				//Dont remark the codes
				output = SchedulerDayViewNormal(&virtual_table, TABLE_SCH_DAY_VIEW, &start_row,
					&end_row, &start_deleted, &end_deleted);
				if (output == VT_TABLE_CHANGED)
				{
					virtual_table.vt_active_row = (Event->eventID - FIELD_SCH_DAY_VIEW_0) + virtual_table.vt_top_row_num;
					if (virtual_table.vt_active_row == virtual_table.vt_num_rows)
					{
						virtual_table.vt_active_row = -1;
						if (virtual_table.vt_top_row_num != 0)
							virtual_table.vt_top_row_num --;
						LcdEnableInsertPt(FALSE, 0, 0, SMALL_FONT);
						done = TRUE;
					}
					virtual_table.vt_active_row = -1;
					SchedulerDayViewSetScreen(&virtual_table);
					VTSetVirtualTableLayout(&virtual_table);
					VTVirtualTableSetScrollbar(&virtual_table);
					VTTransferAllToRT(&virtual_table, TABLE_SCH_DAY_VIEW);
					TableDrawTable(TABLE_SCH_DAY_VIEW);
					SchedulerDayViewDrawAppointmentColumn(&virtual_table, TABLE_SCH_DAY_VIEW);
				}
				else
					VTTransferFieldToVT(&virtual_table, TABLE_SCH_DAY_VIEW);
				day_view_old_event.eventType = NULL_EVENT;
				virtual_table.vt_active_row = -1;
				return TRUE;
			default: return FALSE;
			}
			case PEN_DOWN:
				for (count_id = STRING_SCH_DAY_VIEW_0; count_id < (table_ptr->table_num_row_display + STRING_SCH_DAY_VIEW_0); count_id++)
				{
					FormGetObjectPointer(count_id, &object_type, (void**)&string_ptr);
					if (Event->para1 >= string_ptr->screen_bounds.xcoord &&
						Event->para1 < (string_ptr->screen_bounds.xcoord + string_ptr->screen_bounds.width) &&
						Event->para2 >= string_ptr->screen_bounds.ycoord &&
						Event->para2 < (string_ptr->screen_bounds.ycoord + string_ptr->screen_bounds.height))
					{
						//Bug Fixed 20-Feb-2001
						//To block the case if the end row of a new appointment is clicked
						//-------------------------------------------------------- Adding Codes
						if (virtual_table.vt_active_row != -1)
						{
							if ((virtual_table.vt_top_row_num + (count_id - STRING_SCH_DAY_VIEW_0)) == virtual_table.vt_items[virtual_table.vt_active_row]->appointment)
							{
								if (new_appointment == TRUE &&
									virtual_table.vt_items[virtual_table.vt_items[virtual_table.vt_active_row]->appointment]->appointment == -1)
									return FALSE;
							}
						}
						//-------------------------------------------------------- Adding Codes					
						EvtAppendEvt(EVT_DAY_VIEW_STRING_ENTER, count_id,
							(virtual_table.vt_top_row_num + (count_id - STRING_SCH_DAY_VIEW_0)), 0, (void*)string_ptr);
						FieldSetInsertPointOff(STRING_SCH_DAY_VIEW_0 + 12);
						LcdEnableInsertPt(FALSE, 0 , 0, SMALL_FONT);
						
						/* deactivate */
						if (virtual_table.vt_active_row != -1)
						{
							SchedulerDayViewNotHighlightString((ObjectID)(virtual_table.vt_active_row - virtual_table.vt_top_row_num + STRING_SCH_DAY_VIEW_0));
							// Modified at 07072000
							if ((virtual_table.vt_active_row > virtual_table.vt_top_row_num) &&
								(virtual_table.vt_active_row < (virtual_table.vt_top_row_num + virtual_table.vt_num_rows_displayed)))
								StringDrawString((ObjectID)(virtual_table.vt_active_row - virtual_table.vt_top_row_num + STRING_SCH_DAY_VIEW_0));
						}
						return TRUE;
					}
				}
				day_view_old_event.eventType = NULL_EVENT;
				return FALSE;
			case PEN_MOVE:
				switch (day_view_old_event.eventType)
				{
				case EVT_DAY_VIEW_STRING_ENTER:
					FormGetObjectPointer((ObjectID)(day_view_old_event.eventID), &object_type, (void**)&string_ptr);
					if (Event->para1 < string_ptr->screen_bounds.xcoord ||
						Event->para1 >= (string_ptr->screen_bounds.xcoord + string_ptr->screen_bounds.width) ||
						Event->para2 < string_ptr->screen_bounds.ycoord ||
						Event->para2 >= (string_ptr->screen_bounds.ycoord + string_ptr->screen_bounds.height))
						EvtAppendEvt(EVT_DAY_VIEW_STRING_EXIT, (ObjectID)(day_view_old_event.eventID),
						(virtual_table.vt_top_row_num + (day_view_old_event.eventID - STRING_SCH_DAY_VIEW_0)), 0, (void*)string_ptr);
					return TRUE;
				case EVT_DAY_VIEW_STRING_EXIT:
					FormGetObjectPointer((ObjectID)(day_view_old_event.eventID), &object_type, (void**)&string_ptr);
					if (Event->para1 >= string_ptr->screen_bounds.xcoord &&
						Event->para1 < (string_ptr->screen_bounds.xcoord + string_ptr->screen_bounds.width) &&
						Event->para2 >= string_ptr->screen_bounds.ycoord &&
						Event->para2 < (string_ptr->screen_bounds.ycoord + string_ptr->screen_bounds.height))
						EvtAppendEvt(EVT_DAY_VIEW_STRING_ENTER, (ObjectID)(day_view_old_event.eventID), 
						virtual_table.vt_top_row_num + (day_view_old_event.eventID - STRING_SCH_DAY_VIEW_0), 0, (void*)string_ptr);
					return TRUE;
				default: return FALSE;
				}
				default: return FALSE;
		}
		case EVT_DAY_VIEW_STRING_ENTER:
			day_view_old_event = *Event;		    
			SchedulerDayViewHighlightString((ObjectID)(Event->eventID));
			StringDrawString((ObjectID)(Event->eventID));
			return TRUE;
		case EVT_DAY_VIEW_STRING_EXIT:
			day_view_old_event = *Event;
			SchedulerDayViewNotHighlightString((ObjectID)(Event->eventID));
			StringDrawString((ObjectID)(Event->eventID));
			return TRUE;
		default: return FALSE;
	}
}

/********************************************************
* Function:	SchedulerDayViewSelectString
* Purpose:	This function is called to setup the time_settings variable
when a string in the FORM_SCH_DAY_VIEW is selected
* Scope:	application/internal
* Input:       vt		The pointer to virtual table object
selected_row_num
* Output:	None
* Return:	None
* Comment:     None
*********************************************************/
void SchedulerDayViewSelectString(VirtualTable *vt, USHORT selected_row_num)
{
	RecordID rec_id;
	BYTE repeat_no[5];
	UWORD rec_num, byte_read;
	AlarmAttr *alarm_attr;
	
	time_settings.row_num = (WORD)selected_row_num;
	time_settings.hour_start = vt->vt_items[selected_row_num]->hour;
	time_settings.minute_start = vt->vt_items[selected_row_num]->minute;
	if ((vt->vt_items[selected_row_num]->repeat) && (vt->vt_items[selected_row_num]->alarm != NO_ALARM))
	{
		*((UWORD*)repeat_no) = vt->vt_items[selected_row_num]->repeat_num;
		repeat_no[4] = 0;
		DataFindBinRecord(sch_repeat_dbid, F_REPEAT_NUM, 0, repeat_no, 4, &rec_id);
		DataRecIDtoNum(sch_repeat_dbid, rec_id, &rec_num);
		DataOpenRecord(sch_repeat_dbid, rec_num, &rec_id, NULL);
		DataGetField(sch_repeat_dbid, rec_id, F_ALARM_SETTINGS, (BYTE**)&alarm_attr, &byte_read);
		time_settings.alarm = alarm_attr->type;
		time_settings.alarm_time = alarm_attr->time;
        //        time_settings.dbid = sch_repeat_dbid;
		DataCloseRecord(sch_repeat_dbid, rec_id);
	}
	else
	{
		time_settings.alarm = vt->vt_items[selected_row_num]->alarm;
		time_settings.alarm_time = vt->vt_items[selected_row_num]->alarm_time;
		//       time_settings.dbid = sch_appmt_dbid;
	}
	time_settings.alarm_num = vt->vt_items[selected_row_num]->alarm_num;
	time_settings.dbid = vt->vt_items[selected_row_num]->dbid;
	time_settings.recid = vt->vt_items[selected_row_num]->recid;
	
	if (new_appointment == TRUE) 
	{
		time_settings.new_appointment = TRUE;
		time_settings.new_appointment_with_time = TRUE;
		time_settings.hour_end = vt->vt_items[vt->vt_items[selected_row_num]->appointment]->hour; 			
		time_settings.minute_end = vt->vt_items[vt->vt_items[selected_row_num]->appointment]->minute; 
	}
	else
	{
		if (vt->vt_items[selected_row_num]->appointment != -1)
		{
			time_settings.new_appointment = FALSE;
			time_settings.new_appointment_with_time = TRUE;
			time_settings.hour_end = vt->vt_items[vt->vt_items[selected_row_num]->appointment]->hour; 			
			time_settings.minute_end = vt->vt_items[vt->vt_items[selected_row_num]->appointment]->minute; 
		}
		else
		{
			time_settings.new_appointment = FALSE;
			time_settings.new_appointment_with_time = TRUE;
			time_settings.hour_end = -1;
			time_settings.minute_end = -1;
		}
		
	}
}

/********************************************************
* Function:	SchedulerDayViewFindRowNum
* Purpose: 	This function is called to find the corresponding row num
with the same input hour and input minute
* Scope:	application/internal
* Input:	vt		The pointer to virtual table object
hour
minute		
* Output:	row_num		The best fit row number
num_rows		
* Return:	TRUE		found
FALSE		can't find
* Comment: 	if row number cannot be found, then 
the best fit number will be found out.
A new row can be worked out correspondingly.
*********************************************************/
BOOLEAN SchedulerDayViewFindRowNum(VirtualTable *vt, BYTE hour, BYTE minute, USHORT **row_num, USHORT *num_rows)
{
	USHORT count;
	BYTE row_hour, row_minute;
	BOOLEAN result = FALSE;
	*num_rows = 0;
	
	*row_num = (USHORT*)qmalloc((vt->vt_num_rows) * sizeof (USHORT));
	for (count = 0; count < (vt->vt_num_rows); count ++)
	{
		row_hour = vt->vt_items[count]->hour;
		row_minute = vt->vt_items[count]->minute;
		if (row_hour == hour && row_minute == minute)
		{
            (*row_num)[*num_rows] = count;
			(*num_rows) ++;
			result = TRUE;
			continue;
		}
		else if (row_hour > hour || (row_hour == hour && row_minute > minute))
		{
			if (result == FALSE)
			{
                (*row_num)[*num_rows] = count;
				(*num_rows) ++;
				return FALSE;
			}
		}
	}
	if (*num_rows == 0)
	{
        (*row_num)[*num_rows] = vt->vt_num_rows;
		(*num_rows) ++;
		return FALSE;
	}
	return result;
}

/********************************************************
* Function:	SchedulerDayViewCheckRowNumCovered
* Purpose: 	Thsi function is called to check whether an input 
row number is overlapped by other appointment
* Scope:	application/internal
* Input:	vt		The pointer to virtual table object
row_num
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
USHORT SchedulerDayViewCheckRowNumCovered(VirtualTable *vt, USHORT row_num)
{
	USHORT count;
	USHORT count1 = 0;
	
	for (count = 0; count < vt->vt_num_rows; count++)
	{
		if (count < row_num && vt->vt_items[count]->appointment >= row_num)
			count1 ++;
	}
	return count1;
}

/********************************************************
* Function:	SchedulerDayViewSaveAppmtData
* Purpose: 	This function is called to save all appointment data
on the screen to a specified date in the database
* Scope:	application/internal
* Input:	vt		The pointer to virtual table object
date		in 3 bytes-format yy, mm, dd with null-terminated
* Output:	None
* Return:	TRUE		new record
FALSE		old record
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerDayViewSaveAppmtData(VirtualTable *vt, UBYTE *date)
{
	RecordID rec_id = 0;
	UWORD rec_num;
	BOOLEAN new_record = FALSE;
	BOOLEAN repeat = FALSE;
	AppointmentDB *appmt_rec;
	BYTE **field_string;
	BYTE *appmt_rec_buf;
	BYTE *appmt_string_buf;
	USHORT row_num;
	WORD num_bytes_appmt;
	WORD num_bytes_string;
	BOOLEAN any_appmt = FALSE;
	BOOLEAN any_alarm = FALSE;
	BOOLEAN save_repeat_row = FALSE;
	BYTE alarm;
	WORD active_row = -1, active_next_row = -1;
	USHORT offset = 0;
	USHORT acc_num_rows;
	BYTE *buffer;
	UWORD byte_read;
	BYTE font_size, *menu_text;
	USHORT *repeat_row;
	USHORT total_repeat_row;
	SHORT i, count;
	
	//Bug Fixed 5-Feb-2001
	//-------------------------- Adding Codes
	SHORT		j;
	WORD		restore_row = -1;
	//-------------------------- Adding Codes
	
	for (row_num = 0; row_num < vt->vt_num_rows; row_num++)
	{
		if (vt->vt_items[row_num]->repeat == FALSE)
		{
			if ((vt->vt_items[row_num]->appointment != -1 && new_appointment == FALSE &&
				(strlen(vt->vt_items[row_num]->ptr->field_string) || vt->vt_items[row_num]->alarm != NO_ALARM)) ||
				(vt->vt_items[row_num]->appointment != -1 && new_appointment == TRUE && vt->vt_active_row != row_num))
			{
				any_appmt = TRUE;
				break;
			}
		}
	}
	
	repeat_row = (USHORT*)qmalloc(vt->vt_num_rows * sizeof(USHORT));
	count = 0;
	for (row_num = 0; row_num < vt->vt_num_rows; row_num++)
	{
		if (vt->vt_items[row_num]->repeat == TRUE)
		{
			save_repeat_row = TRUE;
			// check whether the start row of the repeat appmt is pointing
			// by another appointment
			for (i = 0; i < vt->vt_num_rows; i++)
			{
				if (vt->vt_items[i]->appointment == row_num)
				{
					if (vt->vt_items[i]->repeat == FALSE)
					{
						save_repeat_row = FALSE;
						break;
					}
				}
			}
			if (save_repeat_row)
			{
				repeat_row[count] = row_num;
				count++;
			}
		}
	}
	total_repeat_row = count;
	for (i = 0; i < total_repeat_row; i++)
	{
		save_repeat_row = TRUE;
		for (row_num = 0; row_num < vt->vt_num_rows; row_num++)
		{
			if (vt->vt_items[repeat_row[i]]->appointment  == vt->vt_items[row_num]->appointment)
			{
				if (vt->vt_items[row_num]->repeat == FALSE)
				{
					save_repeat_row = FALSE;
					break;
				}
			}
		}
		for (row_num = 0; row_num < total_repeat_row; row_num++)
		{
			if (vt->vt_items[repeat_row[i]]->appointment == repeat_row[row_num])
			{
				save_repeat_row = FALSE;
				break;
			}
		}
		if (vt->vt_items[repeat_row[i]]->appointment != -1) save_repeat_row = FALSE;
		if (save_repeat_row)
		{
			repeat_row[count] = vt->vt_items[repeat_row[i]]->appointment;
			count++;
		}
	}
	total_repeat_row = count;
	
	if (DataFindBinRecord(sch_appmt_dbid, F_DATE, 0, (BYTE*)date, 3, &rec_id) != TRUE && any_appmt == TRUE)
		new_record = TRUE;
	else if (DataFindBinRecord(sch_appmt_dbid, F_DATE, 0, (BYTE*)date, 3, &rec_id) == TRUE && any_appmt == FALSE)
	{
		DataCloseRecord(sch_appmt_dbid, rec_id);
		DataDeleteRecord(sch_appmt_dbid, rec_id, FALSE);
		qfree(repeat_row);
		return FALSE;
	}
	else if (DataFindBinRecord(sch_appmt_dbid, F_DATE, 0, (BYTE*)date, 3, &rec_id) != TRUE && any_appmt == FALSE)
	{
		qfree(repeat_row);
		return FALSE;
	}
	
	if (new_record == TRUE)
	{
		DataNewRecord(sch_appmt_dbid, 0, 5, &rec_id);
		DataWriteField(sch_appmt_dbid, rec_id, F_DATE, 3, (BYTE*)date);
	}
	else
	{
		DataRecIDtoNum(sch_appmt_dbid, rec_id, &rec_num);
		DataOpenRecord(sch_appmt_dbid, rec_num, &rec_id, NULL);
	}
	//Bug Fixed 5-Feb-2001
	//Remark the following codes
	/*
	if (new_appointment == TRUE && vt->vt_active_row != -1)
	{
	if (vt->vt_items[vt->vt_active_row]->alarm == NO_ALARM &&
	strlen(vt->vt_items[vt->vt_active_row]->ptr->field_string) == 0)
	active_row = vt->vt_active_row;
	for (row_num = 0; row_num < vt->vt_num_rows; row_num++)
	{
	if (vt->vt_items[row_num]->appointment == vt->vt_active_row)
	{
				active_row = -1;
				break;
				}
				}
				if (vt->vt_items[vt->vt_items[vt->vt_active_row]->appointment]->appointment == -1)
				active_next_row = vt->vt_items[vt->vt_active_row]->appointment;
				for (row_num = 0; row_num < vt->vt_num_rows; row_num++)
				{
				if (vt->vt_items[row_num]->appointment == vt->vt_items[vt->vt_active_row]->appointment &&
				row_num != vt->vt_active_row)
				{
				active_next_row = -1;
				break;
				}
				}
				}
	*/
	//------------------------------------------------- Adding Codes
	if (new_appointment == TRUE)
	{
		if  (vt->vt_active_row != -1)
		{
			if (vt->vt_items[vt->vt_active_row]->alarm == NO_ALARM &&
				strlen(vt->vt_items[vt->vt_active_row]->ptr->field_string) == 0)
				active_row = vt->vt_active_row;
			for (row_num = 0; row_num < vt->vt_num_rows; row_num++)
			{
				if (vt->vt_items[row_num]->appointment == vt->vt_active_row)
				{
					restore_row = active_row;
					active_row = -1;
					break;
				}
			}
			if (vt->vt_items[vt->vt_items[vt->vt_active_row]->appointment]->appointment == -1)
				active_next_row = vt->vt_items[vt->vt_active_row]->appointment;
			for (row_num = 0; row_num < vt->vt_num_rows; row_num++)
			{
				if (vt->vt_items[row_num]->appointment == vt->vt_items[vt->vt_active_row]->appointment &&
					row_num != vt->vt_active_row)
				{
					active_next_row = -1;
					break;
				}
			}
		}
	}
	else
	{
		if ((vt->vt_active_row != -1) && (strlen(vt->vt_items[vt->vt_active_row]->ptr->field_string) == 0) && (vt->vt_items[vt->vt_active_row]->alarm == NO_ALARM))
		{
			active_row = vt->vt_active_row;
			for (row_num = 0; row_num < vt->vt_num_rows; row_num++)
			{
				if (vt->vt_items[row_num]->appointment == vt->vt_active_row)
				{
					restore_row = active_row;
					active_row = -1;
					break;
				}
			}
			if (vt->vt_items[vt->vt_items[vt->vt_active_row]->appointment]->appointment == -1)
				active_next_row = vt->vt_items[vt->vt_active_row]->appointment;
			for (row_num = 0; row_num < vt->vt_num_rows; row_num++)
			{
				if (vt->vt_items[row_num]->appointment == vt->vt_items[vt->vt_active_row]->appointment &&
					row_num != vt->vt_active_row)
				{
					active_next_row = -1;
					break;
				}
			}
		}
	}
	//------------------------------------------------- Adding Codes
	acc_num_rows = vt->vt_num_rows;
	if (active_row != -1)
		acc_num_rows --;
	if (active_next_row != -1) 
		acc_num_rows --;
	
	appmt_rec = (AppointmentDB*)qmalloc(acc_num_rows * sizeof(AppointmentDB));
	field_string = (BYTE**)qmalloc(acc_num_rows * sizeof(BYTE*));
	offset = 0;
	for (row_num = 0; row_num < vt->vt_num_rows; row_num++)
	{
		if (row_num == active_row || row_num == active_next_row)
		{
			offset ++;
			continue;
		}
		
		for (i = 0; i < total_repeat_row; i++)
		{
			if (row_num == repeat_row[i])
			{
				offset ++;
				acc_num_rows --;
				repeat = TRUE;
				break;
			}
		}
		if (repeat)
		{
			repeat = FALSE;
			continue;
		}
		if (vt->vt_items[row_num]->appointment != -1 &&
			strlen(vt->vt_items[row_num]->ptr->field_string) == 0 &&
			vt->vt_items[row_num]->alarm == NO_ALARM)
		{
			//Bug Fixed 5-Feb-2001
			//Prevent deleting the appointment row of active row
			//Remark codes
			/*
			offset ++;
			acc_num_rows --;
			continue;
			*/
			//----------------------------------------------------- Adding Codes
			if (row_num != restore_row)
			{
				offset ++;
				acc_num_rows --;
				continue;
			}
			//----------------------------------------------------- Adding Codes
		}
		appmt_rec[row_num - offset].hour = vt->vt_items[row_num]->hour;
		appmt_rec[row_num - offset].minute = vt->vt_items[row_num]->minute;
		appmt_rec[row_num - offset].alarm = vt->vt_items[row_num]->alarm;
		if (appmt_rec[row_num-offset].alarm != NO_ALARM &&
			appmt_rec[row_num-offset].alarm != VOICE_NOT_ALARM)
			any_alarm = TRUE;
		appmt_rec[row_num - offset].alarm_time = vt->vt_items[row_num]->alarm_time;
		appmt_rec[row_num - offset].alarm_num = vt->vt_items[row_num]->alarm_num;
		if (vt->vt_items[row_num]->appointment == active_row ||
			vt->vt_items[row_num]->appointment == active_next_row)
			appmt_rec[row_num - offset].appointment = -1;
		else appmt_rec[row_num - offset].appointment = vt->vt_items[row_num]->appointment;
		//Bug Fixed 5-Feb-2001
		//If active_row isnt deleted, save its appointment to -1
		//-------------------------------- Adding codes
		if (row_num == restore_row)
			appmt_rec[row_num - offset].appointment = -1;
		//-------------------------------- Adding codes
		if (vt->vt_items[row_num]->appointment > active_row && active_row != -1)
			appmt_rec[row_num - offset].appointment --;
		if (vt->vt_items[row_num]->appointment > active_next_row && active_next_row != -1)
			appmt_rec[row_num - offset].appointment --;
		
		for (i = 0; i < total_repeat_row; i++)
		{
			if (vt->vt_items[row_num]->appointment > repeat_row[i])
			{
				//Bug Fixed 5-Feb-2001
				//Add protection
				if (appmt_rec[row_num - offset].appointment != -1)
					appmt_rec[row_num - offset].appointment--;
			}
		}
		
		appmt_rec[row_num - offset].appmt_num = vt->vt_items[row_num]->appmt_num;
		appmt_rec[row_num - offset].dbid = vt->vt_items[row_num]->dbid;
		appmt_rec[row_num - offset].recid = vt->vt_items[row_num]->recid;
		field_string[row_num - offset] = (BYTE*)qmalloc((strlen(vt->vt_items[row_num]->ptr->field_string) + 1) * sizeof(BYTE));
		strcpy(field_string[row_num - offset], vt->vt_items[row_num]->ptr->field_string);
		if /*(*/(vt->vt_items[row_num]->repeat == TRUE)/* && (vt->vt_items[vt->vt_items[row_num]->appointment]->appointment != -1))*/
		{
			appmt_rec[row_num - offset].appointment = -1;
			field_string[row_num - offset] = (BYTE*)qmalloc(sizeof(BYTE));
			strcpy(field_string[row_num - offset], "");
		}
	}
	
	SchedulerDBAppmtToBuffer(appmt_rec, field_string, acc_num_rows,
							 &appmt_rec_buf, &appmt_string_buf, &num_bytes_appmt,
							 &num_bytes_string);
	
	DataWriteField(sch_appmt_dbid, rec_id, F_DATA, num_bytes_appmt, appmt_rec_buf);
	DataWriteField(sch_appmt_dbid, rec_id, F_STRING , num_bytes_string, appmt_string_buf);
	
	if (any_alarm == TRUE)
		alarm = 1;
	else alarm = 0;
	DataWriteField(sch_appmt_dbid, rec_id, F_ALARM , 1, (BYTE*)&alarm);
	
	qfree(appmt_rec);
	qfree(appmt_rec_buf);
	for (row_num = 0; row_num < acc_num_rows; row_num++)
		qfree(field_string[row_num]);
	qfree(field_string);
	qfree(appmt_string_buf);
    DataGetField(sch_appmt_dbid, rec_id, F_DATE, &buffer, &byte_read);
	qfree(buffer);
	
	DataCloseRecord(sch_appmt_dbid, rec_id);
	if (SchedulerCheckEarliestDayWithAlarm(date) == TRUE)
		SchedulerSetAppmtWholeDayAlarm(date);
	
    MenuGetMenuItem(MENU_SCH_DAY_VIEW, MENU_ITEM_ZOOM, &menu_text);
    if (menu_text[0] == SCHLFONT_INT)
        font_size = SMALL_FONT;
    else font_size = MEDIUM_FONT;
    DataWriteField(sch_appmt_dbid, SCH_STATUS, 1, 1, (BYTE*)&font_size);
	return new_record;
}

/********************************************************
* Function:	SchedulerDayViewLoadAppmtDataToScreen
* Purpose: 	This function is called to load all appointment data
*		from a specified date in the database to screen
* Scope:	application/internal
* Input:	vt	The pointer to virtual table object
*		date	in 3 bytes-format yy, mm, dd with null-terminated
* Output:	None
* Return:	TRUE	loaded old record successfully
*		FALSE	can't find old record
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerDayViewLoadAppmtDataToScreen(VirtualTable *vt, UBYTE *date)
{
	BOOLEAN found_old_rec = FALSE;
	Table *table_ptr;
	BYTE object_type;
	BYTE *buffer, **string;
	AppointmentDB *appmt_rec;
	WORD num_appmt;
	UWORD byte_read;
	WORD count, count1;
	RecordID rec_id;
	UWORD rec_num;
	BOOLEAN     empty = TRUE;
	BYTE font_size;
	WORD temp_appointment= -1, temp_be_appointment1 = -1, temp_be_appointment2 = -1;
	BYTE temp_hour = -1;
	BYTE temp_minute = -1;
	WORD *rec_to_be_deleted;
	UWORD total_rec;
	SHORT i;
	BYTE temp_date[8];
	USHORT *row_num;
	USHORT num_rows, num_length;
	UWORD target_start_row = -1;
	UWORD target_end_row = -1;
	BYTE *repeat_str, time[20];
	BOOLEAN output;
	
	
	TableInitTable(TABLE_SCH_DAY_VIEW);
	FormGetObjectPointer(TABLE_SCH_DAY_VIEW, &object_type, (void**)&table_ptr);
	VTDeleteAllRowItems(vt);
	
	DataGetField(sch_appmt_dbid, SCH_STATUS, 1, &buffer, &byte_read);
	font_size = *buffer;
	qfree(buffer);
	
	if (DataFindBinRecord(sch_appmt_dbid, F_DATE, 0, (BYTE*)date, 3, &rec_id) == TRUE)
		found_old_rec = TRUE;
	
	if (found_old_rec == FALSE)
	{
		DataTotalRecord(sch_repeat_dbid, &total_rec);
		if (total_rec != 0) font_size = virtual_table.vt_font_size;
		VTInit(vt, table_ptr->bounds, table_ptr->table_num_row,
			table_ptr->table_num_column, table_ptr->table_top_row_num,
			table_ptr->table_row_height, table_ptr->table_column_width,
			1, SCROLLBAR_SCH_DAY_VIEW);
		//	if (total_rec != 0) virtual_table.vt_font_size = font_size;
		TableUpdateNumRowDisplay(TABLE_SCH_DAY_VIEW, 1);
		for(count = 0; count < table_ptr->table_num_row; count++)
		{
			VTSetRowHourMinute(vt, (USHORT)count, (BYTE)(8 + count), 0);
			VTSetFieldTextPointer(vt, (USHORT)count, (BYTE*)(""));
			VTSetRowAlarm(vt, (USHORT)count, NO_ALARM, NO_ALARM, 0);
			VTSetRowAppointment(vt, (USHORT)count, -1);
		}
		VTChangeStringFormat(vt);      
	}
	else
	{
		DataRecIDtoNum(sch_appmt_dbid, rec_id, &rec_num);
		DataOpenRecord(sch_appmt_dbid, rec_num, &rec_id, NULL);
		DataGetField(sch_appmt_dbid, rec_id, F_DATA, &buffer, &byte_read);
		SchedulerDBGetAppmtRec(buffer, byte_read, &appmt_rec, &num_appmt);
		qfree(buffer);
		DataGetField(sch_appmt_dbid, rec_id, F_STRING, &buffer, &byte_read);
		SchedulerDBGetAppmtString(buffer, byte_read, &string, &num_appmt);
		qfree(buffer);
		
#ifdef DEBUG_H
		printf("\n ===== Print out Appointment =====");
		for (temp_temp = 0; temp_temp < num_appmt; temp_temp ++)
			printf("\n Row %ld appointment = %ld", temp_temp, appmt_rec[temp_temp].appointment);           
#endif
		
		VTInit(vt, table_ptr->bounds, (USHORT)num_appmt,
			table_ptr->table_num_column, 0,
			table_ptr->table_row_height, table_ptr->table_column_width,
			1, SCROLLBAR_SCH_DAY_VIEW);
        
		if (num_appmt > 12)
			table_ptr->table_num_row = 12;
		else table_ptr->table_num_row = (USHORT)num_appmt;
        
		TableUpdateNumRowDisplay(TABLE_SCH_DAY_VIEW, 1);
		VTTransferStringToVT(vt, TABLE_SCH_DAY_VIEW);
		rec_to_be_deleted = (WORD*)qmalloc(num_appmt * sizeof(WORD));
		for (count = 0; count < num_appmt; count++)
		{
			vt->vt_items[count]->hour = appmt_rec[count].hour;
			vt->vt_items[count]->minute = appmt_rec[count].minute;
			vt->vt_items[count]->appointment = appmt_rec[count].appointment;
			if (vt->vt_items[count]->appointment != -1)
				empty = FALSE;
			
			temp_be_appointment2 = -1;
			for (count1 =0 ; count1< num_appmt; count1++)
			{
				if (count1 == count)
					continue;
				if (vt->vt_items[count1]->appointment == count)
				{
					temp_be_appointment2 = count1;
					break;
				}
			}
			
			if (appmt_rec[count].hour == temp_hour &&
				appmt_rec[count].minute == temp_minute)
			{
				if ((temp_be_appointment1 >= 0 || temp_appointment >= 0) &&
					(appmt_rec[count].appointment == -1 && temp_be_appointment2 == -1))
					rec_to_be_deleted[count] = 1;
				else if ((temp_be_appointment1 == -1 && temp_appointment == -1) && 
					(appmt_rec[count].appointment >=0 || temp_be_appointment2 >= 0))
					rec_to_be_deleted[count - 1] = 1;
				else if ((temp_be_appointment1 >= 0 ||temp_appointment >=0) && 
					(appmt_rec[count].appointment >=0 || temp_be_appointment1 >= 0))
					rec_to_be_deleted[count] = 0;
				
				else if (temp_be_appointment1 == -1 && temp_appointment == -1 &&
					appmt_rec[count].appointment == -1 && temp_be_appointment2 == -1)
					rec_to_be_deleted[count - 1] = 1;
			}
			else
			{
				if (count > 0)
					rec_to_be_deleted[count - 1] = 0;
			}
			
			temp_hour = appmt_rec[count].hour;
			temp_minute = appmt_rec[count].minute;
			temp_appointment = appmt_rec[count].appointment;
			
			temp_be_appointment1 = -1;
			for (count1 =0 ; count1< num_appmt; count1++)
			{
				if (count1 == count)
					continue;
				if (vt->vt_items[count1]->appointment == count)
				{
					temp_be_appointment1 = count1;
					break;
				}
			}
			
			vt->vt_items[count]->alarm = appmt_rec[count].alarm;
			vt->vt_items[count]->alarm_time = appmt_rec[count].alarm_time;
			vt->vt_items[count]->alarm_num = appmt_rec[count].alarm_num;
			vt->vt_items[count]->appmt_num = appmt_rec[count].appmt_num;
			vt->vt_items[count]->dbid = appmt_rec[count].dbid;
			vt->vt_items[count]->recid = appmt_rec[count].recid;
			VTSetFieldTextPointer(vt, (USHORT)count, string[count]);
			qfree(string[count]);
			
			vt->vt_items[count]->repeat = FALSE;
			vt->vt_items[count]->repeat_num = 0;
			vt->vt_items[count]->repeat_method = 255;
			vt->vt_items[count]->repeat_every_info = 0;
			vt->vt_items[count]->repeat_every_data = 0;
		}
		if (num_appmt != 0) qfree(appmt_rec);
		if (num_appmt != 0) qfree(string);
		VTChangeStringFormat(vt);
		DataCloseRecord(sch_appmt_dbid, rec_id);
		rec_num = 0;
		for (count = 0; count < num_appmt; count++)
		{
			if (rec_to_be_deleted[count] == 1)
			{
				VTDeleteRow(vt, (USHORT)(count - rec_num));
				rec_num ++;
			}
		}
		qfree(rec_to_be_deleted);
	}
	virtual_table.vt_active_row = -1;
	
	// Michelle add 171299
	// Load repeat records to day view
	if (DataTotalRecord(sch_repeat_dbid, &total_rec))
	{
		for(i = 0; i < total_rec; i++)
		{
			target_start_row = -1;
			target_end_row = -1;
			DataOpenRecord(sch_repeat_dbid, i, &rec_id, NULL);
			SchedulerGetDayViewDate(temp_date);
			time_settings.dbid = sch_voice_dbid;
			time_settings.recid = 0;
			// The repeat record is in the view date
			if (SchedulerDisplayDayViewRepeat(temp_date, rec_id, &repeat_str))
			{
				// to find the row num of start time whether exists
				output = SchedulerDayViewFindRowNum(vt, repeat_settings.start_date[3],
					repeat_settings.start_date[4], &row_num, &num_rows);
				
				if (output == TRUE)
				{
					for (count = 0; count < num_rows; count++)
					{
						if (vt->vt_items[row_num[count]]->appointment == -1)
						{
							target_start_row = row_num[count];
							num_length = strlen(repeat_str) + 1;
							vt->vt_items[row_num[count]]->ptr->field_string = (BYTE*)qmalloc(num_length * sizeof(BYTE));
							strcpy(vt->vt_items[row_num[count]]->ptr->field_string, repeat_str);
							vt->vt_items[row_num[count]]->repeat = TRUE;
							vt->vt_items[row_num[count]]->repeat_every_data = repeat_settings.every_data;
							vt->vt_items[row_num[count]]->repeat_method = repeat_settings.method;
							vt->vt_items[row_num[count]]->repeat_every_info = repeat_settings.every_info;
							vt->vt_items[row_num[count]]->repeat_num = repeat_settings.repeat_num;
							vt->vt_items[row_num[count]]->alarm = repeat_settings.alarm;
							vt->vt_items[row_num[count]]->alarm_num = repeat_settings.alarm_num;
							vt->vt_items[row_num[count]]->alarm_time = repeat_settings.alarm_time;
							vt->vt_items[row_num[count]]->dbid = sch_voice_dbid;
							vt->vt_items[row_num[count]]->recid = repeat_settings.voice_recid;
							break;
						}
					}
					if (target_start_row == -1)
					{
						target_start_row = row_num[num_rows - 1] + 1;
						SchedulerHourMinuteToString(repeat_settings.start_date[3],
							repeat_settings.start_date[4], time, FALSE);
						VTInsertRow(vt,(row_num[num_rows - 1] + 1), repeat_settings.start_date[3],
							repeat_settings.start_date[4], repeat_settings.alarm, repeat_settings.alarm_time,
							repeat_settings.alarm_num, -1, 0, 1, repeat_settings.repeat_num,
							repeat_settings.method, repeat_settings.every_info, repeat_settings.every_data, 
							time_settings.dbid, time_settings.recid, time, repeat_str);
					}
				}
				else
				{
					target_start_row = row_num[num_rows - 1];
					SchedulerHourMinuteToString(repeat_settings.start_date[3],  repeat_settings.start_date[4], time, FALSE);
					VTInsertRow(vt, row_num[num_rows - 1], repeat_settings.start_date[3],
						repeat_settings.start_date[4], repeat_settings.alarm, repeat_settings.alarm_time,
						repeat_settings.alarm_num, -1, 0, 1, repeat_settings.repeat_num,
						repeat_settings.method, repeat_settings.every_info, repeat_settings.every_data,
						time_settings.dbid,	time_settings.recid, time, repeat_str);
				}
				qfree(row_num);
				output = SchedulerDayViewFindRowNum(vt, repeat_settings.end_date[3], repeat_settings.end_date[4], &row_num, &num_rows);
				if (output == TRUE)
				{
					for (count = 0; count < num_rows; count++)
					{
						if (row_num[count] > target_start_row)
						{
							target_end_row = row_num[count];
							break;
						}
					}
					if (target_end_row == -1)
					{
						target_end_row = row_num[num_rows - 1] + 1;
						SchedulerHourMinuteToString(repeat_settings.end_date[3], repeat_settings.end_date[4], time, FALSE);
						VTInsertRow(vt, (row_num[num_rows - 1] + 1), repeat_settings.end_date[3], repeat_settings.end_date[4], NO_ALARM, 
							NO_ALARM, 0, -1, 0, FALSE, 0, 255, 0, 0, time_settings.dbid,
							time_settings.recid, time, (BYTE*)(""));
					}
				}
				else
				{
					target_end_row = row_num[num_rows - 1];
					SchedulerHourMinuteToString(repeat_settings.end_date[3], repeat_settings.end_date[4], time, FALSE);
					VTInsertRow(vt, row_num[num_rows - 1], repeat_settings.end_date[3], 
						repeat_settings.end_date[4], NO_ALARM, NO_ALARM, 0, -1, 0, FALSE, 
						0, 255, 0, 0, time_settings.dbid, time_settings.recid, time, (BYTE*)(""));
				}
				qfree(row_num);
				vt->vt_items[target_start_row]->appointment = target_end_row;
				found_old_rec = TRUE;
				empty = FALSE;
				qfree(repeat_str);
			}
			DataCloseRecord(sch_repeat_dbid, rec_id);
		}
	}
	
	if (font_size == SMALL_FONT)
		VTSetTableFontSize(&virtual_table, SMALL_FONT);
	else VTSetTableFontSize(&virtual_table, MEDIUM_FONT);
	
	if ((found_old_rec == FALSE && font_size != SMALL_FONT) ||
		(found_old_rec == TRUE  && !empty))
	{
		SchedulerTimeSettingsDeleteAllEmptyAppmts(vt);
		SchedulerTimeSettingsAddAppmts(vt);
	}
	
	if (virtual_table.vt_font_size == SMALL_FONT)
	{
		MenuDeleteItem(MENU_SCH_DAY_VIEW, MENU_ITEM_ZOOM);
		MenuInsertItem(MENU_SCH_DAY_VIEW, MENU_ITEM_ZOOM, SCHLFONT);
	}
	else
	{
		MenuDeleteItem(MENU_SCH_DAY_VIEW, MENU_ITEM_ZOOM);
		MenuInsertItem(MENU_SCH_DAY_VIEW, MENU_ITEM_ZOOM, SCHSFONT);
	}
	return found_old_rec;
}

/********************************************************
* Function:	SchedulerDayViewLoadAppmtDataToScreen1
* Purpose: 	This function is called to load all appointment data
*		from a specified date in the database to screen
* Scope:	application/internal
* Input:	vt		The pointer to virtual table object
*		date		in 3 bytes-format yy, mm, dd with null-terminated
* Output:	field_num	The field number of the appointment record displayed on screen
* Return:	TRUE	loaded old record successfully
*		FALSE	can't find old record
* Comment: 	This function is used by GOTO_REC application launch
*********************************************************/
BOOLEAN SchedulerDayViewLoadAppmtDataToScreen1(VirtualTable *vt, UBYTE *date, USHORT *field_num)
{
	BOOLEAN found_old_rec = FALSE;
	Table *table_ptr;
	BYTE object_type;
	BYTE *buffer, **string;
	AppointmentDB *appmt_rec;
	WORD num_appmt;
	UWORD byte_read;
	WORD count, count1;
	RecordID rec_id;
	UWORD rec_num;
	BOOLEAN     empty = TRUE;
	BYTE font_size;
	WORD temp_appointment= -1, temp_be_appointment1 = -1, temp_be_appointment2 = -1;
	BYTE temp_hour = -1;
	BYTE temp_minute = -1;
	WORD *rec_to_be_deleted;
	UWORD total_rec;
	SHORT i;
	UBYTE temp_date[8];
	USHORT *row_num;
	USHORT num_rows, num_length;
	UWORD target_start_row = -1;
	UWORD target_end_row = -1;
	BYTE *repeat_str, time[20];
	BOOLEAN output;
	
	
	TableInitTable(TABLE_SCH_DAY_VIEW);
	FormGetObjectPointer(TABLE_SCH_DAY_VIEW, &object_type, (void**)&table_ptr);
	VTDeleteAllRowItems(vt);
	
	DataGetField(sch_appmt_dbid, SCH_STATUS, 1, &buffer, &byte_read);
	font_size = *buffer;
	qfree(buffer);
	
	if (DataFindBinRecord(sch_appmt_dbid, F_DATE, 0, (BYTE*)date, 3, &rec_id) == TRUE)
		found_old_rec = TRUE;
	
	if (found_old_rec == FALSE)
	{
		VTInit(vt, table_ptr->bounds, table_ptr->table_num_row,
			table_ptr->table_num_column, table_ptr->table_top_row_num,
			table_ptr->table_row_height, table_ptr->table_column_width,
			1, SCROLLBAR_SCH_DAY_VIEW);
		TableUpdateNumRowDisplay(TABLE_SCH_DAY_VIEW, 1);
		for(count = 0; count < table_ptr->table_num_row; count++)
		{
			VTSetRowHourMinute(vt, (USHORT)count, (BYTE)(8 + count), 0);
			VTSetFieldTextPointer(vt, (USHORT)count, (BYTE*)(""));
			VTSetRowAlarm(vt, (USHORT)count, NO_ALARM, NO_ALARM, 0);
			VTSetRowAppointment(vt, (USHORT)count, -1);
		}
		VTChangeStringFormat(vt);      
	}
	else
	{
		DataRecIDtoNum(sch_appmt_dbid, rec_id, &rec_num);
		DataOpenRecord(sch_appmt_dbid, rec_num, &rec_id, NULL);
		DataGetField(sch_appmt_dbid, rec_id, F_DATA, &buffer, &byte_read);
		SchedulerDBGetAppmtRec(buffer, byte_read, &appmt_rec, &num_appmt);
		qfree(buffer);
		DataGetField(sch_appmt_dbid, rec_id, F_STRING, &buffer, &byte_read);
		SchedulerDBGetAppmtString(buffer, byte_read, &string, &num_appmt);
		qfree(buffer);
		
#ifdef DEBUG_H
		printf("\n ===== Print out Appointment =====");
		for (temp_temp = 0; temp_temp < num_appmt; temp_temp ++)
			printf("\n Row %ld appointment = %ld", temp_temp, appmt_rec[temp_temp].appointment);           
#endif
		
		VTInit(vt, table_ptr->bounds, (USHORT)num_appmt,
			table_ptr->table_num_column, 0,
			table_ptr->table_row_height, table_ptr->table_column_width,
			1, SCROLLBAR_SCH_DAY_VIEW);
        
		if (num_appmt > 12)
			table_ptr->table_num_row = 12;
		else table_ptr->table_num_row = (USHORT)num_appmt;
        
		TableUpdateNumRowDisplay(TABLE_SCH_DAY_VIEW, 1);
		VTTransferStringToVT(vt, TABLE_SCH_DAY_VIEW);
		rec_to_be_deleted = (WORD*)qmalloc(num_appmt * sizeof(WORD));
		for (count = 0; count < num_appmt; count++)
		{
			vt->vt_items[count]->hour = appmt_rec[count].hour;
			vt->vt_items[count]->minute = appmt_rec[count].minute;
			vt->vt_items[count]->appointment = appmt_rec[count].appointment;
			if (vt->vt_items[count]->appointment != -1)
				empty = FALSE;
			
			temp_be_appointment2 = -1;
			for (count1 =0 ; count1< num_appmt; count1++)
			{
				if (count1 == count)
					continue;
				if (vt->vt_items[count1]->appointment == count)
				{
					temp_be_appointment2 = count1;
					break;
				}
			}
			
			if (appmt_rec[count].hour == temp_hour &&
				appmt_rec[count].minute == temp_minute)
			{
				if ((temp_be_appointment1 >= 0 || temp_appointment >= 0) &&
					(appmt_rec[count].appointment == -1 && temp_be_appointment2 == -1))
					rec_to_be_deleted[count] = 1;
				else if ((temp_be_appointment1 == -1 && temp_appointment == -1) && 
					(appmt_rec[count].appointment >=0 || temp_be_appointment2 >= 0))
					rec_to_be_deleted[count - 1] = 1;
				else if ((temp_be_appointment1 >= 0 ||temp_appointment >=0) && 
					(appmt_rec[count].appointment >=0 || temp_be_appointment1 >= 0))
					rec_to_be_deleted[count] = 0;
				
				else if (temp_be_appointment1 == -1 && temp_appointment == -1 &&
					appmt_rec[count].appointment == -1 && temp_be_appointment2 == -1)
					rec_to_be_deleted[count - 1] = 1;
			}
			else
			{
				if (count > 0)
					rec_to_be_deleted[count - 1] = 0;
			}
			
			temp_hour = appmt_rec[count].hour;
			temp_minute = appmt_rec[count].minute;
			temp_appointment = appmt_rec[count].appointment;
			
			temp_be_appointment1 = -1;
			for (count1 =0 ; count1< num_appmt; count1++)
			{
				if (count1 == count)
					continue;
				if (vt->vt_items[count1]->appointment == count)
				{
					temp_be_appointment1 = count1;
					break;
				}
			}
			
			vt->vt_items[count]->alarm = appmt_rec[count].alarm;
			vt->vt_items[count]->alarm_time = appmt_rec[count].alarm_time;
			vt->vt_items[count]->alarm_num = appmt_rec[count].alarm_num;
			vt->vt_items[count]->appmt_num = appmt_rec[count].appmt_num;
			vt->vt_items[count]->dbid = appmt_rec[count].dbid;
			vt->vt_items[count]->recid = appmt_rec[count].recid;
			VTSetFieldTextPointer(vt, (USHORT)count, string[count]);
			qfree(string[count]);
			
			vt->vt_items[count]->repeat = FALSE;
			vt->vt_items[count]->repeat_num = 0;
			vt->vt_items[count]->repeat_method = 255;
			vt->vt_items[count]->repeat_every_info = 0;
			vt->vt_items[count]->repeat_every_data = 0;
		}
		if (num_appmt != 0) qfree(appmt_rec);
		if (num_appmt != 0) qfree(string);
		VTChangeStringFormat(vt);
		DataCloseRecord(sch_appmt_dbid, rec_id);
		rec_num = 0;
		for (count = 0; count < num_appmt; count++)
		{
			if (rec_to_be_deleted[count] == 1)
			{
				VTDeleteRow(vt, (USHORT)(count - rec_num));
				rec_num ++;
			}
		}
		qfree(rec_to_be_deleted);
	}
	virtual_table.vt_active_row = -1;
	
	// Michelle add 171299
	// Load repeat records to day view
	if (DataTotalRecord(sch_repeat_dbid, &total_rec))
	{
		for(i = 0; i < total_rec; i++)
		{
			DataOpenRecord(sch_repeat_dbid, i, &rec_id, NULL);
			SchedulerGetDayViewDate(temp_date);
			time_settings.dbid = sch_voice_dbid;
			time_settings.recid = 0;
			// The repeat record is in the view date
			if (SchedulerDisplayDayViewRepeat(temp_date, rec_id, &repeat_str))
			{
				// to find the row num of start time whether exists
				output = SchedulerDayViewFindRowNum(vt, repeat_settings.start_date[3],
					repeat_settings.start_date[4], &row_num, &num_rows);
				
				if (output == TRUE)
				{
					for (count = 0; count < num_rows; count++)
					{
						if (vt->vt_items[row_num[count]]->appointment == -1)
						{
							target_start_row = row_num[count];
							num_length = strlen(repeat_str) + 1;
							vt->vt_items[row_num[count]]->ptr->field_string = (BYTE*)qmalloc(num_length * sizeof(BYTE));
							strcpy(vt->vt_items[row_num[count]]->ptr->field_string, repeat_str);
							vt->vt_items[row_num[count]]->repeat = TRUE;
							vt->vt_items[row_num[count]]->repeat_every_data = repeat_settings.every_data;
							vt->vt_items[row_num[count]]->repeat_method = repeat_settings.method;
							vt->vt_items[row_num[count]]->repeat_every_info = repeat_settings.every_info;
							vt->vt_items[row_num[count]]->repeat_num = repeat_settings.repeat_num;
							vt->vt_items[row_num[count]]->alarm = repeat_settings.alarm;
							vt->vt_items[row_num[count]]->alarm_num = repeat_settings.alarm_num;
							vt->vt_items[row_num[count]]->alarm_time = repeat_settings.alarm_time;
							break;
						}
					}
					if (target_start_row == -1)
					{
						target_start_row = row_num[num_rows - 1] + 1;
						//Michelle add 240100						
						if (target_start_row <= *field_num) (*field_num)++;
						//end add 240100						
						SchedulerHourMinuteToString(repeat_settings.start_date[3],
							repeat_settings.start_date[4], time, FALSE);
						VTInsertRow(vt,(row_num[num_rows - 1] + 1), repeat_settings.start_date[3],
							repeat_settings.start_date[4], repeat_settings.alarm, repeat_settings.alarm_time,
							repeat_settings.alarm_num, -1, 0, 1, repeat_settings.repeat_num,
							repeat_settings.method, repeat_settings.every_info, repeat_settings.every_data, 
							time_settings.dbid, repeat_settings.voice_recid, time, repeat_str);
					}
				}
				else
				{
					target_start_row = row_num[num_rows - 1];
					//Michelle add 240100					
					if (target_start_row <= *field_num) (*field_num)++;
					//end add 240100					
					SchedulerHourMinuteToString(repeat_settings.start_date[3],  repeat_settings.start_date[4], time, FALSE);
					VTInsertRow(vt, row_num[num_rows - 1], repeat_settings.start_date[3],
						repeat_settings.start_date[4], repeat_settings.alarm, repeat_settings.alarm_time,
						repeat_settings.alarm_num, -1, 0, 1, repeat_settings.repeat_num,
						repeat_settings.method, repeat_settings.every_info, repeat_settings.every_data,
						time_settings.dbid, repeat_settings.voice_recid, time, repeat_str);
				}
				qfree(row_num);
				output = SchedulerDayViewFindRowNum(vt, repeat_settings.end_date[3], repeat_settings.end_date[4], &row_num, &num_rows);
				if (output == TRUE)
				{
					for (count = 0; count < num_rows; count++)
					{
						if (row_num[count] > target_start_row)
						{
							target_end_row = row_num[count];
							break;
						}
					}
					if (target_end_row == -1)
					{
						target_end_row = row_num[num_rows - 1] + 1;
						//Michelle add 240100						
						if (target_end_row <= *field_num) (*field_num)++;
						//end add 240100
						SchedulerHourMinuteToString(repeat_settings.end_date[3], repeat_settings.end_date[4], time, FALSE);
						VTInsertRow(vt, (row_num[num_rows - 1] + 1), repeat_settings.end_date[3], repeat_settings.end_date[4], NO_ALARM, 
							NO_ALARM, 0, -1, 0, FALSE, 0, 255, 0, 0, time_settings.dbid,
							time_settings.recid, time, (BYTE*)(""));
					}
				}
				else
				{
					target_end_row = row_num[num_rows - 1];
					//Michelle add 240100
					if (target_end_row <= *field_num) (*field_num)++;
					//end add 240100
					SchedulerHourMinuteToString(repeat_settings.end_date[3], repeat_settings.end_date[4], time, FALSE);
					VTInsertRow(vt, row_num[num_rows - 1], repeat_settings.end_date[3], 
						repeat_settings.end_date[4], NO_ALARM, NO_ALARM, 0, -1, 0, FALSE, 
						0, 255, 0, 0, time_settings.dbid, time_settings.recid, time, (BYTE*)(""));
				}
				qfree(row_num);
				vt->vt_items[target_start_row]->appointment = target_end_row;
				found_old_rec = TRUE;
				empty = FALSE;
				qfree(repeat_str);
			}
			DataCloseRecord(sch_repeat_dbid, rec_id);
		}
	}
	
	if (font_size == SMALL_FONT)
		VTSetTableFontSize(&virtual_table, SMALL_FONT);
	else VTSetTableFontSize(&virtual_table, MEDIUM_FONT);
	
	if ((found_old_rec == FALSE && font_size != SMALL_FONT) ||
		(found_old_rec == TRUE  && !empty))
	{
		SchedulerTimeSettingsDeleteAllEmptyAppmts(vt);
		SchedulerTimeSettingsAddAppmts(vt);
	}
	
	if (virtual_table.vt_font_size == SMALL_FONT)
	{
		MenuDeleteItem(MENU_SCH_DAY_VIEW, MENU_ITEM_ZOOM);
		MenuInsertItem(MENU_SCH_DAY_VIEW, MENU_ITEM_ZOOM, SCHLFONT);
	}
	else
	{
		MenuDeleteItem(MENU_SCH_DAY_VIEW, MENU_ITEM_ZOOM);
		MenuInsertItem(MENU_SCH_DAY_VIEW, MENU_ITEM_ZOOM, SCHSFONT);
	}
	return found_old_rec;
}

/********************************************************
* Function:	SchedulerDayViewDelAppointment
* Purpose: 	This function is called to delete an appointment in 
a day if the DEL button in the day view form is pressed
* Scope:	application/internal
* Input:	vt		The pointer to virtual table object				
* Output:	None
* Return:	TRUE		Deleted successfully
FALSE		unsuccessfully
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerDayViewDelAppointment(VirtualTable *vt)
{
	BYTE *buffer;
	UWORD byte_read;
	AlarmEvent evtAlarm;
	RecordID rec_id;
	AppointmentDB *appmt_rec;
	WORD num_appmt;
	UBYTE date[4];
	WORD row_num;
	UWORD rec_num;
	USHORT start_row, end_row;
	BOOLEAN start_deleted, end_deleted;
	UWORD	count;
	
    evtAlarm.type = 0;
	if ((vt->vt_active_row == -1) || (vt->vt_active_row != -1 && vt->vt_items[vt->vt_active_row]->appointment == -1))
		return FALSE;
	
	SchedulerGetDayViewDate(date);
	if (SchedulerCheckEarliestDayWithAlarm(date) == TRUE)
	{
		evtAlarm.app = SysGetActiveAppID();
		AlarmSetEventClass((&evtAlarm), ALARM_ONTIME);
		DataFindBinRecord(sch_appmt_dbid, F_DATE, 0, (BYTE*)date, 3, &rec_id);
		DataRecIDtoNum(sch_appmt_dbid, rec_id, &rec_num);
		DataOpenRecord(sch_appmt_dbid, rec_num, &rec_id, NULL);
		DataGetField(sch_appmt_dbid, rec_id, F_DATA, &buffer, &byte_read);
		SchedulerDBGetAppmtRec(buffer, byte_read, &appmt_rec, &num_appmt);
		qfree(buffer);
		evtAlarm.rec_id = rec_id;
		for (row_num = 0; row_num < num_appmt; row_num++)
		{
            if (appmt_rec[row_num].alarm != NO_ALARM &&
                appmt_rec[row_num].alarm != VOICE_NOT_ALARM)
			{
				evtAlarm.reference = appmt_rec[row_num].alarm_num;
				AlarmDelEvent(evtAlarm);
			}
		}
		qfree(appmt_rec);		
	}
	
	SchedulerDayViewNotHighlightString((ObjectID)(virtual_table.vt_active_row - 
		virtual_table.vt_top_row_num +
		STRING_SCH_DAY_VIEW_0));
	StringDrawString((ObjectID)(virtual_table.vt_active_row - 
		virtual_table.vt_top_row_num +
		STRING_SCH_DAY_VIEW_0));
	
	strcpy(vt->vt_items[vt->vt_active_row]->ptr->field_string, (BYTE*)(""));
	
    if (vt->vt_items[vt->vt_active_row]->alarm == VOICE_ALARM ||
        vt->vt_items[vt->vt_active_row]->alarm == VOICE_NOT_ALARM)
	{
		DataRecIDtoNum(sch_voice_dbid, vt->vt_items[vt->vt_active_row]->recid, &rec_num);
		DataOpenRecord(sch_voice_dbid, rec_num, &rec_id, NULL);
		DataGetField(sch_voice_dbid, vt->vt_items[vt->vt_active_row]->recid, 2, &buffer, &byte_read);
		count = *((UWORD*)buffer);
		qfree(buffer);
		if (count == 1)                  
		{				
			DataCloseRecord(sch_voice_dbid, vt->vt_items[vt->vt_active_row]->recid);
			DataDeleteRecord(sch_voice_dbid, vt->vt_items[vt->vt_active_row]->recid, FALSE);
		}
        else
        {
            count --;
            DataWriteField(sch_voice_dbid, vt->vt_items[vt->vt_active_row]->recid, 2, sizeof(UWORD), (BYTE*)&count);
            DataCloseRecord(sch_voice_dbid, vt->vt_items[vt->vt_active_row]->recid);
        }
	}
	vt->vt_items[vt->vt_active_row]->alarm		= NO_ALARM;
	vt->vt_items[vt->vt_active_row]->alarm_time = NO_ALARM;
	vt->vt_items[vt->vt_active_row]->alarm_num	= 0;
	vt->vt_items[vt->vt_active_row]->appmt_num	= 0;
	
	// Michelle add 141299
	vt->vt_items[vt->vt_active_row]->repeat = FALSE;
	vt->vt_items[vt->vt_active_row]->repeat_num = 0;
	vt->vt_items[vt->vt_active_row]->repeat_method = 255;
	vt->vt_items[vt->vt_active_row]->repeat_every_info = 0;
	vt->vt_items[vt->vt_active_row]->repeat_every_data = 0;
	// end add 141299
	
	SchedulerDayViewNormal(&virtual_table, TABLE_SCH_DAY_VIEW, &start_row,
		&end_row, &start_deleted, &end_deleted);
	vt->vt_active_row = -1;
	LcdEnableInsertPt(FALSE, 0, 0, SMALL_FONT);
	if (vt->vt_top_row_num == vt->vt_num_rows)
		vt->vt_top_row_num --;
	
	SchedulerDayViewDrawAppointmentColumn(&virtual_table, TABLE_SCH_DAY_VIEW);
	SchedulerDayViewSaveAppmtData(&virtual_table, date);
	if (SchedulerCheckEarliestDayWithAlarm(date) == TRUE)
		SchedulerSetAppmtWholeDayAlarm(date);
	return TRUE;
}


/********************************************************
* Function:	SchedulerDayViewChangeDate
* Purpose: 	This function is called to process the LEFT and RIGTH
button
* Scope:	application/internal
* Input:	direction		RIGHT or LEFT
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void SchedulerDayViewChangeDate(VirtualTable *vt, BYTE direction)
{
	UBYTE date[4];
	SHORT year, mon, mday, wday, nth_week;
	WORD row_num;
	AppointmentDB *appmt_rec;
	WORD num_appmt;
	UWORD rec_num;
	RecordID rec_id;
	AlarmEvent evtAlarm;
	BYTE *buffer;
	UWORD byte_read;
	CountrySettings country;
	USHORT count;
	Err found;
	
	//Bug Fixed 5-Feb-2001
	//Deletel all the codes added in "// 31-Jan-2001 Bug fixed"
	
	evtAlarm.type = 0;
	SySetupGetCountrySettings(&country);
	
	SchedulerGetDayViewDate(date);
	year = (SHORT)(date[0] + SYSETUP_YEAR_OFFSET);
	mon = (SHORT)(date[1]);
	mday = (SHORT)(date[2]);
	
	mon --;
	if (direction == TO_LEFT)
	{
		RtcDaysShift(&year, &mon, &mday, -1);
		wday = Dt_Date_WDay(year, mon, mday);
		mon ++;
	}
	else
	{
		RtcDaysShift(&year, &mon, &mday, 1);
		wday = Dt_Date_WDay(year, mon, mday);
		mon ++;
	}
	
	if (year > 2099)
		return;
	if (year < 1905)
		return;
	
	if (country.start_of_week == SYSETUP_SUN)
		SchedulerSetDayViewDate(year, mon, mday, wday);
	else if (country.start_of_week == SYSETUP_MON)
	{
		if (wday == 0) wday = 6;
		else wday --;
		SchedulerSetDayViewDate(year, mon, mday, wday);
	}
	
	if (SchedulerCheckEarliestDayWithAlarm(date) == TRUE)
	{
		evtAlarm.app = SysGetActiveAppID();
		AlarmSetEventClass((&evtAlarm), ALARM_ONTIME);
		found = DataFindBinRecord(sch_appmt_dbid, F_DATE, 0, date, 3, &rec_id);
		if (found == TRUE)
		{
			DataRecIDtoNum(sch_appmt_dbid, rec_id, &rec_num);
			DataOpenRecord(sch_appmt_dbid, rec_num, &rec_id, NULL);
			DataGetField(sch_appmt_dbid, rec_id, F_DATA, &buffer, &byte_read);
			SchedulerDBGetAppmtRec(buffer, byte_read, &appmt_rec, &num_appmt);
			qfree(buffer);
			evtAlarm.rec_id = rec_id;
			for (row_num = 0; row_num < num_appmt; row_num++)
			{
				if (appmt_rec[row_num].alarm != NO_ALARM &&
					appmt_rec[row_num].alarm != VOICE_NOT_ALARM)
				{
					evtAlarm.reference = appmt_rec[row_num].alarm_num;
					AlarmDelEvent(evtAlarm);
				}
			}
			qfree(appmt_rec);		
		}
	}
	//Bug Fixed 5-Feb-2001
	//Deletel all the codes added in "// 31-Jan-2001 Bug fixed"
	
	SchedulerDayViewSaveAppmtData(vt, date);
	if (SchedulerCheckEarliestDayWithAlarm(date) == TRUE)
		SchedulerSetAppmtWholeDayAlarm(date);	
	date[0] = (BYTE)(year - SYSETUP_YEAR_OFFSET);
	date[1] = (BYTE)(mon);
	date[2] = (BYTE)(mday);
	date[3] = '\0';
	
	SchedulerDayViewLoadAppmtDataToScreen(vt, date);
	
	//VTECH
	if (KeyboardCheckKeyboardStatus())
	{
        KeyboardRestoreBitBehind();
        KeyboardSetKeyboardStatus(FALSE);
    }
	
	SchedulerDayViewSetScreen(&virtual_table);
	for (count = 0; count < virtual_table.vt_num_rows; count++)
	{
		virtual_table.vt_items[count]->ptr->bounds.height = 9;
		virtual_table.vt_items[count]->ptr->screen_bounds.height = 9;
		virtual_table.vt_row_height[count] = 9; 
	}
	VTSetVirtualTableLayout(&virtual_table);
	VTVirtualTableSetScrollbar(&virtual_table);
	VTTransferAllToRT(&virtual_table, TABLE_SCH_DAY_VIEW);
	SchedulerGetDayViewDate(date);
	SchedulerDayViewSetToDoAnn(date);
	
    StringDrawString(STRING_SCH_DAY_VIEW_DATE);
    SchedulerDayViewSetToDoAnn(date);
    TableDrawTable(TABLE_SCH_DAY_VIEW);
    SchedulerDayViewDrawAppointmentColumn(&virtual_table, TABLE_SCH_DAY_VIEW);
}

/********************************************************
* Function:	SchedulerDayViewPurge
* Purpose: 	This function is called to handle the clicking of button
Purge
* Scope:	application/internal
* Input:	vt		The pointer to virtual table object				
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void SchedulerDayViewPurge(VirtualTable *vt)
{
	BOOLEAN archive = FALSE, done = FALSE;
	BOOLEAN current_edit_page = FALSE;
	SHORT popup_item_num, i, j;
	BYTE object_type;
	Control *control_ptr;
	UWORD upto_rec_num, rec_num;
	UBYTE date[4], temp_date[4], purge_date[7];
	AlarmEvent evtAlarm;
	UWORD count1;
	SHORT year, mon, mday;
	AppointmentDB *appmt_rec;
	RecordID rec_id, temp_rec_id;
	BYTE *buffer, *temp;
	UWORD byte_read, total_num_rec, repeat_num;
	WORD num_appmt, row_num;
	Table *table_ptr;
	USHORT count;
	RTM time;
	
	evtAlarm.type = 0;
	FormGetObjectPointer(CHECKBOX_SCH_PURGE, &object_type, (void**)&control_ptr);
	if (((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value == TRUE)
		archive = TRUE;
	else archive = FALSE;
	
	ControlPopupGetSelectedItem(POPUP_TRIGGER_SCH_PURGE, &popup_item_num);
	SchedulerGetDayViewDate(date);
	RtcGetTime(&time);
	
	year	= time.year;
	mon		= time.mon;
	mday	= time.mday;
	
	if (popup_item_num == 0)
		RtcDaysShift(&year, &mon, &mday, -7);
	else if (popup_item_num == 1)
		RtcDaysShift(&year, &mon, &mday, -14);
	else if (popup_item_num == 2)
		RtcDaysShift(&year, &mon, &mday, -21);
	else if (popup_item_num == 3)
		RtcDaysShift(&year, &mon, &mday, -31);
	mon ++;
	
	purge_date[0] = (BYTE)(year - SYSETUP_YEAR_OFFSET);
	purge_date[1] = (BYTE)(mon);
	purge_date[2] = (BYTE)(mday);
	
	DataTotalRecord(sch_appmt_dbid, &total_num_rec);
	if (total_num_rec > 0)
	{
		done = TRUE;
		DataOpenRecord(sch_appmt_dbid, 0, &rec_id, NULL);
		DataGetField(sch_appmt_dbid, rec_id, F_DATE, &buffer, &byte_read);
		temp_date[0] = (BYTE)(year - SYSETUP_YEAR_OFFSET);
		temp_date[1] = (BYTE)(mon);
		temp_date[2] = (BYTE)(mday);
		temp_date[3] = 0;
		
		if (SchedulerCompareDate((UBYTE*)buffer, temp_date) == 0)
		{
			qfree(buffer);
			DataCloseRecord(sch_appmt_dbid, rec_id); 
			return;
		}
		qfree(buffer);
		DataCloseRecord(sch_appmt_dbid, rec_id);
		
		if (SchedulerSortRecordOlderThan((BYTE)(year - SYSETUP_YEAR_OFFSET), (BYTE)(mon), (BYTE)(mday), &upto_rec_num) == FALSE)
			return;
		
		evtAlarm.app = SysGetActiveAppID();
		evtAlarm.extra_info = NULL;
		AlarmSetEventClass((&evtAlarm), ALARM_ONTIME);
		
		rec_num = 0;
		upto_rec_num ++;
		
		while (upto_rec_num)
		{
			DataOpenRecord(sch_appmt_dbid, rec_num, &rec_id, NULL);
			DataGetField(sch_appmt_dbid, rec_id, F_DATA, &buffer, &byte_read);
			SchedulerDBGetAppmtRec(buffer, byte_read, &appmt_rec, &num_appmt);
			qfree(buffer);
			DataGetField(sch_appmt_dbid, rec_id, F_DATE, &buffer, &byte_read);
			temp_date[0] = buffer[0];
			temp_date[1] = buffer[1];
			temp_date[2] = buffer[2];
			temp_date[3] = '\0';
			qfree(buffer);
			if (temp_date[0] == date[0] &&
				temp_date[1] == date[1] &&
				temp_date[2] == date[2])
				current_edit_page = TRUE;
			
			evtAlarm.rec_id = rec_id;
			for (row_num = 0; row_num < num_appmt; row_num++)
			{
				if (appmt_rec[row_num].alarm != NO_ALARM &&
					appmt_rec[row_num].alarm != VOICE_NOT_ALARM)
				{
					evtAlarm.reference = appmt_rec[row_num].alarm_num;
					AlarmDelEvent(evtAlarm);
				}
				if (appmt_rec[row_num].alarm == VOICE_ALARM ||
					appmt_rec[row_num].alarm == VOICE_NOT_ALARM)
				{
					DataRecIDtoNum(sch_voice_dbid, appmt_rec[row_num].recid, &rec_num);
					DataOpenRecord(sch_voice_dbid, rec_num, &rec_id, NULL);
					DataGetField(sch_voice_dbid, appmt_rec[row_num].recid, 2, &buffer, &byte_read);
					count1 = *((UWORD*)buffer);
					qfree(buffer);
					if (count1 == 1)                  
					{            
						DataCloseRecord(sch_voice_dbid, appmt_rec[row_num].recid);
						DataDeleteRecord(sch_voice_dbid, appmt_rec[row_num].recid, FALSE);
					}
					else
					{
						count1 --;
						DataWriteField(sch_voice_dbid, appmt_rec[row_num].recid, 2, sizeof(UWORD), (BYTE*)&count1);
						DataCloseRecord(sch_voice_dbid, appmt_rec[row_num].recid);
					}
				}
			}
			DataCloseRecord(sch_appmt_dbid, rec_id);
			DataDeleteRecord(sch_appmt_dbid, rec_id, archive);
			upto_rec_num --;
		}
		qfree(appmt_rec);
		
		if (current_edit_page == TRUE)
		{
			FormGetObjectPointer(TABLE_SCH_DAY_VIEW, &object_type, (void**)&table_ptr);
			VTInit(vt, table_ptr->bounds, table_ptr->table_num_row,
				table_ptr->table_num_column, table_ptr->table_top_row_num,
				table_ptr->table_row_height, table_ptr->table_column_width,
				1, SCROLLBAR_SCH_DAY_VIEW);
			TableUpdateNumRowDisplay(TABLE_SCH_DAY_VIEW, 1);
			for(count = 0; count < table_ptr->table_num_row; count++)
			{
				VTSetRowHourMinute(vt, (USHORT)count, (BYTE)(8 + count), 0);
				VTSetFieldTextPointer(vt, (USHORT)count, (BYTE*)(""));
				VTSetRowAlarm(vt, (USHORT)count, NO_ALARM, NO_ALARM, 0);
				VTSetRowAppointment(vt, (USHORT)count, -1);
			}
			VTChangeStringFormat(vt);
			vt->vt_active_row = -1;
			vt->vt_top_row_num = 0;
		}
	}
	DataTotalRecord(sch_repeat_dbid, &total_num_rec);
	if (total_num_rec > 0)
	{
		done = TRUE;
		for(i = 0; i < total_num_rec; i++)
		{
			DataOpenRecord(sch_repeat_dbid, (UWORD)i, &rec_id, NULL);
			DataGetField(sch_repeat_dbid, rec_id, F_START_TIME, &buffer, &byte_read);
			if (SchedulerCompareDate((UBYTE*)buffer, purge_date) == 2)
			{
				DataGetField(sch_repeat_dbid, rec_id, F_END_TIME, &temp, &byte_read);
				if ((BYTE)temp[1] != -1 && (BYTE)temp[2] != -1)
				{
					if (SchedulerCompareDate((UBYTE*)temp, purge_date) == 2)
					{
						qfree(temp);
						DataGetField(sch_repeat_dbid, rec_id, F_EXCEPT_FLAG, &temp, &byte_read);
						if (*temp == 1)
						{
							qfree(temp);
							DataGetField(sch_repeat_dbid, rec_id, F_REPEAT_NUM, &temp, &byte_read);
							DataFindBinRecord(sch_except_dbid, F_REPEAT_NUM, 0, temp, 4, &temp_rec_id);
							DataDeleteRecord(sch_except_dbid, temp_rec_id, archive);
							qfree(temp);
						}
						else qfree(temp);
						DataCloseRecord(sch_repeat_dbid, rec_id);
						DataDeleteRecord(sch_repeat_dbid, rec_id, archive);
					}
				}
				else
				{
					qfree(temp);
					for(j = 3; j < 7; j++)
						purge_date[j] = (UBYTE)buffer[j];
				}
				qfree(buffer);
				DataWriteField(sch_repeat_dbid, rec_id, F_START_TIME, 7, (BYTE*)purge_date);
			}
			DataCloseRecord(sch_repeat_dbid, rec_id);
		}
	}
	if (done)
	{
		RtcGetTime(&time);
		date[0]    = (BYTE)(time.year - SYSETUP_YEAR_OFFSET);
		date[1]    = (BYTE)(time.mon + 1);
		date[2]    = (BYTE)(time.mday);
		
		SchedulerGetDayViewDate(temp_date);
		SchedulerDayViewLoadAppmtDataToScreen(&virtual_table, temp_date);
		if (SchedulerCheckEarliestDayWithAlarm(date) == TRUE)
			SchedulerSetAppmtWholeDayAlarm(date);
	}
}

/********************************************************
* Function:	SchedulerDayViewSetToDoAnn
* Purpose: 	This function is called to set the ToDo and Ann
icon 
* Scope:	application/internal
* Input:	date
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void SchedulerDayViewSetToDoAnn(UBYTE *date)
{
	RecordID tdl_rec_id;
	RecordID ann_rec_id;
	BYTE tdl_alarm;
	BYTE ann_alarm;
	BYTE todo_hit;
	BYTE ann_hit;
	Bitmap *todo_bitmap_ptr, *todo_bitmap_ptr1;
	Bitmap *ann_bitmap_ptr, *ann_bitmap_ptr1;
	BYTE object_type;
	
	
	ToDoAnnGetEventDate((SHORT)(date[0] + SYSETUP_YEAR_OFFSET), (SHORT)(date[1]), (SHORT)(date[2]), &tdl_rec_id, &ann_rec_id,
		&tdl_alarm, &ann_alarm, &todo_hit, &ann_hit);
	FormGetObjectPointer(BITMAP_SCH_DAY_VIEW_TODO_ON, &object_type, (void**)&todo_bitmap_ptr);
	FormGetObjectPointer(BITMAP_SCH_DAY_VIEW_TODO_OFF, &object_type, (void**)&todo_bitmap_ptr1);
	FormGetObjectPointer(BITMAP_SCH_DAY_VIEW_ANN_ON, &object_type, (void**)&ann_bitmap_ptr);
	FormGetObjectPointer(BITMAP_SCH_DAY_VIEW_ANN_OFF, &object_type, (void**)&ann_bitmap_ptr1);
	
	
	if (todo_hit == 1)
	{	
		todo_bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
		BitmapDrawBitmap(BITMAP_SCH_DAY_VIEW_TODO_ON);		
		
		todo_bitmap_ptr1->bitmap_attr.bitmap_visible = FALSE;
		todo_bitmap_ptr1->bitmap_attr.bitmap_drawn = FALSE;				
	}	
	else
	{
		todo_bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
		BitmapEraseBitmap(BITMAP_SCH_DAY_VIEW_TODO_ON);
        
        todo_bitmap_ptr1->bitmap_attr.bitmap_visible = FALSE;
		todo_bitmap_ptr1->bitmap_attr.bitmap_drawn = FALSE;        
	}	
	
	if (ann_hit == 1)
	{
		ann_bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
		BitmapDrawBitmap(BITMAP_SCH_DAY_VIEW_ANN_ON);				
		
		ann_bitmap_ptr1->bitmap_attr.bitmap_visible = FALSE;
		ann_bitmap_ptr1->bitmap_attr.bitmap_drawn = FALSE;		
	}	
	else
	{
		ann_bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
        BitmapEraseBitmap(BITMAP_SCH_DAY_VIEW_ANN_ON);		
		
        ann_bitmap_ptr1->bitmap_attr.bitmap_visible = FALSE;
	}	
}
