/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   schdb.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"
#include "appfunc.h"

/********************************************************
* Function:	SchedulerAppointmentDBInit
* Purpose: 	This function is used to simulate and initialse the 
the datebase in the PDA.Try to preset some records in 
the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	This function should be called in the StartApplication() function.
*********************************************************/
void SchedulerAppointmentDBInit()
{
	
}

/********************************************************
* Function:	SchedulerDBAppmtToBuffer
* Purpose: 	This function is called to convert appointment 
data to buffers				
* Scope:		application
* Input:		appmt_rec			Array of appointment records
string				Collective string
num_appmt
* Output:		appmt_rec_buf
string_buf
num_bytes_appmt
num_bytes_string
* Return:		None
* Comment: 	This function should be called in the StartApplication() function.
*********************************************************/
void SchedulerDBAppmtToBuffer(AppointmentDB *appmt_rec, BYTE **string, WORD num_appmt, 
							  BYTE **appmt_rec_buf, BYTE **string_buf, WORD *num_bytes_appmt,
							  WORD *num_bytes_string)
{
	USHORT num;
	BYTE *temp, *temp1;
	
	*num_bytes_appmt = 0;
	*num_bytes_string = 0;
	
	for (num = 0; num < num_appmt; num++)
		*num_bytes_string += strlen(string[num]);
	*num_bytes_string += num_appmt;
	*num_bytes_appmt = sizeof(AppointmentDB) * num_appmt;
	
	*appmt_rec_buf = (BYTE*)qmalloc(*num_bytes_appmt *sizeof(BYTE));
	*string_buf = (BYTE*)qmalloc(*num_bytes_string *sizeof(BYTE));
	
	temp = *appmt_rec_buf;
	temp1 = *string_buf;
	
	for (num = 0; num < num_appmt; num++)
	{
		*((AppointmentDB*)temp) = appmt_rec[num];
		temp += sizeof(AppointmentDB);
		strcpy(temp1, string[num]);
		temp1 += strlen(string[num]) + 1;
	}
}

/********************************************************
* Function:	SchedulerDBGetAppmtDate
* Purpose: 	This function is called to get the appointment data
of a record in Scheduler Database				
* Scope:		application
* Input:		date_buffer			from the record	
* Output:		year
month
day
* Return:		None
* Comment: 	None
*********************************************************/
void SchedulerDBGetAppmtDate(BYTE *date_buffer, BYTE *year, BYTE *month, BYTE *day)
{
	
	
}


/********************************************************
* Function:	SchedulerDBGetAppmtString
* Purpose: 	This function is called to get the appointment data
of a record in Scheduler Database				
* Scope:		application
* Input:		string_buffer		from the record
num_bytes			num_bytes
* Output:		string				reference pointer to string
num_appmt			number of string
* Return:		None
* Comment: 	None
*********************************************************/
void SchedulerDBGetAppmtString(BYTE *string_buffer, UWORD num_bytes, BYTE ***string, WORD *num_appmt)
{
	BYTE *temp_ptr, *temp_ptr1;
	BYTE **result_string;
	UWORD count = 0;
	WORD acc_num_appmt;
	
	*num_appmt = 0;
	
	if (num_bytes == 0)
	{
		*string = NULL;
		return;
	}
	
	temp_ptr = string_buffer;
	temp_ptr1 = string_buffer;
	for (count = 0; count < num_bytes; count++)
	{
		if (string_buffer[count] == '\0')
			(*num_appmt) ++;
	}
	
	result_string = (BYTE**)qmalloc(*num_appmt * sizeof(BYTE*));
	*string = result_string;
	
	acc_num_appmt = 0;
	for (count = 0; count < num_bytes; count++)
	{
		if (string_buffer[count] == '\0')
		{
			temp_ptr1 = string_buffer + count + 1; 
			(*string)[acc_num_appmt] = (BYTE*)qmalloc((temp_ptr1 - temp_ptr) * sizeof(BYTE));
			strcpy((*string)[acc_num_appmt], temp_ptr);
			acc_num_appmt ++;
			temp_ptr = string_buffer + count + 1;
		}
	}
}

/********************************************************
* Function:	SchedulerDBGetAppmtRec
* Purpose: 	This function is called to get the appointment record
of a record in Scheduler Database				
* Scope:		application
* Input:		string_buffer		from the record
num_bytes			num_bytes
* Output:		appmt_rec			reference pointer to string
num_appmt			number of string
* Return:		None
* Comment: 	None
*********************************************************/
void SchedulerDBGetAppmtRec(BYTE *string_buffer, UWORD num_bytes, AppointmentDB **appmt_rec, WORD *num_appmt)
{
	BYTE *temp_ptr;
	WORD acc_num_appmt = 0;
	WORD count;
	
	*num_appmt = num_bytes/sizeof(AppointmentDB);
	if (*num_appmt == 0)
	{
		*appmt_rec = NULL;
		return;
	}
	
	temp_ptr = string_buffer;
	
	*appmt_rec = (AppointmentDB *)qmalloc(*num_appmt * sizeof(AppointmentDB));
	acc_num_appmt = 0;
	for (count = 0; count < *num_appmt; count++)
	{
		(*appmt_rec)[count] = *((AppointmentDB*)(temp_ptr));
		temp_ptr += sizeof(AppointmentDB);
	}
}
